# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BastionArgs', 'Bastion']

@pulumi.input_type
class BastionArgs:
    def __init__(__self__, *,
                 bastion_type: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 target_subnet_id: pulumi.Input[str],
                 client_cidr_block_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 dns_proxy_status: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_session_ttl_in_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phone_book_entry: Optional[pulumi.Input[str]] = None,
                 static_jump_host_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Bastion resource.
        :param pulumi.Input[str] bastion_type: The type of bastion. Use `standard`.
        :param pulumi.Input[str] compartment_id: (Updatable) The unique identifier (OCID) of the compartment where the bastion is located.
        :param pulumi.Input[str] target_subnet_id: The unique identifier (OCID) of the subnet that the bastion connects to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_cidr_block_allow_lists: (Updatable) A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] dns_proxy_status: Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] max_session_ttl_in_seconds: (Updatable) The maximum amount of time that any session on the bastion can remain active.
        :param pulumi.Input[str] name: The name of the bastion, which can't be changed after creation.
        :param pulumi.Input[str] phone_book_entry: The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_jump_host_ip_addresses: (Updatable) A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        """
        pulumi.set(__self__, "bastion_type", bastion_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "target_subnet_id", target_subnet_id)
        if client_cidr_block_allow_lists is not None:
            pulumi.set(__self__, "client_cidr_block_allow_lists", client_cidr_block_allow_lists)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dns_proxy_status is not None:
            pulumi.set(__self__, "dns_proxy_status", dns_proxy_status)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if max_session_ttl_in_seconds is not None:
            pulumi.set(__self__, "max_session_ttl_in_seconds", max_session_ttl_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone_book_entry is not None:
            pulumi.set(__self__, "phone_book_entry", phone_book_entry)
        if static_jump_host_ip_addresses is not None:
            pulumi.set(__self__, "static_jump_host_ip_addresses", static_jump_host_ip_addresses)

    @property
    @pulumi.getter(name="bastionType")
    def bastion_type(self) -> pulumi.Input[str]:
        """
        The type of bastion. Use `standard`.
        """
        return pulumi.get(self, "bastion_type")

    @bastion_type.setter
    def bastion_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "bastion_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The unique identifier (OCID) of the compartment where the bastion is located.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="targetSubnetId")
    def target_subnet_id(self) -> pulumi.Input[str]:
        """
        The unique identifier (OCID) of the subnet that the bastion connects to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_subnet_id")

    @target_subnet_id.setter
    def target_subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_subnet_id", value)

    @property
    @pulumi.getter(name="clientCidrBlockAllowLists")
    def client_cidr_block_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        """
        return pulumi.get(self, "client_cidr_block_allow_lists")

    @client_cidr_block_allow_lists.setter
    def client_cidr_block_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_cidr_block_allow_lists", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="dnsProxyStatus")
    def dns_proxy_status(self) -> Optional[pulumi.Input[str]]:
        """
        Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        """
        return pulumi.get(self, "dns_proxy_status")

    @dns_proxy_status.setter
    def dns_proxy_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_proxy_status", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="maxSessionTtlInSeconds")
    def max_session_ttl_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum amount of time that any session on the bastion can remain active.
        """
        return pulumi.get(self, "max_session_ttl_in_seconds")

    @max_session_ttl_in_seconds.setter
    def max_session_ttl_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_session_ttl_in_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bastion, which can't be changed after creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneBookEntry")
    def phone_book_entry(self) -> Optional[pulumi.Input[str]]:
        """
        The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "phone_book_entry")

    @phone_book_entry.setter
    def phone_book_entry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_book_entry", value)

    @property
    @pulumi.getter(name="staticJumpHostIpAddresses")
    def static_jump_host_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "static_jump_host_ip_addresses")

    @static_jump_host_ip_addresses.setter
    def static_jump_host_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "static_jump_host_ip_addresses", value)


@pulumi.input_type
class _BastionState:
    def __init__(__self__, *,
                 bastion_type: Optional[pulumi.Input[str]] = None,
                 client_cidr_block_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 dns_proxy_status: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 max_session_ttl_in_seconds: Optional[pulumi.Input[int]] = None,
                 max_sessions_allowed: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phone_book_entry: Optional[pulumi.Input[str]] = None,
                 private_endpoint_ip_address: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 static_jump_host_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_subnet_id: Optional[pulumi.Input[str]] = None,
                 target_vcn_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Bastion resources.
        :param pulumi.Input[str] bastion_type: The type of bastion. Use `standard`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_cidr_block_allow_lists: (Updatable) A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        :param pulumi.Input[str] compartment_id: (Updatable) The unique identifier (OCID) of the compartment where the bastion is located.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] dns_proxy_status: Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail.
        :param pulumi.Input[int] max_session_ttl_in_seconds: (Updatable) The maximum amount of time that any session on the bastion can remain active.
        :param pulumi.Input[int] max_sessions_allowed: The maximum number of active sessions allowed on the bastion.
        :param pulumi.Input[str] name: The name of the bastion, which can't be changed after creation.
        :param pulumi.Input[str] phone_book_entry: The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        :param pulumi.Input[str] private_endpoint_ip_address: The private IP address of the created private endpoint.
        :param pulumi.Input[str] state: The current state of the bastion.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_jump_host_ip_addresses: (Updatable) A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_subnet_id: The unique identifier (OCID) of the subnet that the bastion connects to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] target_vcn_id: The unique identifier (OCID) of the virtual cloud network (VCN) that the bastion connects to.
        :param pulumi.Input[str] time_created: The time the bastion was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The time the bastion was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        if bastion_type is not None:
            pulumi.set(__self__, "bastion_type", bastion_type)
        if client_cidr_block_allow_lists is not None:
            pulumi.set(__self__, "client_cidr_block_allow_lists", client_cidr_block_allow_lists)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dns_proxy_status is not None:
            pulumi.set(__self__, "dns_proxy_status", dns_proxy_status)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_session_ttl_in_seconds is not None:
            pulumi.set(__self__, "max_session_ttl_in_seconds", max_session_ttl_in_seconds)
        if max_sessions_allowed is not None:
            pulumi.set(__self__, "max_sessions_allowed", max_sessions_allowed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone_book_entry is not None:
            pulumi.set(__self__, "phone_book_entry", phone_book_entry)
        if private_endpoint_ip_address is not None:
            pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if static_jump_host_ip_addresses is not None:
            pulumi.set(__self__, "static_jump_host_ip_addresses", static_jump_host_ip_addresses)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_subnet_id is not None:
            pulumi.set(__self__, "target_subnet_id", target_subnet_id)
        if target_vcn_id is not None:
            pulumi.set(__self__, "target_vcn_id", target_vcn_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="bastionType")
    def bastion_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of bastion. Use `standard`.
        """
        return pulumi.get(self, "bastion_type")

    @bastion_type.setter
    def bastion_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bastion_type", value)

    @property
    @pulumi.getter(name="clientCidrBlockAllowLists")
    def client_cidr_block_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        """
        return pulumi.get(self, "client_cidr_block_allow_lists")

    @client_cidr_block_allow_lists.setter
    def client_cidr_block_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_cidr_block_allow_lists", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unique identifier (OCID) of the compartment where the bastion is located.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="dnsProxyStatus")
    def dns_proxy_status(self) -> Optional[pulumi.Input[str]]:
        """
        Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        """
        return pulumi.get(self, "dns_proxy_status")

    @dns_proxy_status.setter
    def dns_proxy_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_proxy_status", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maxSessionTtlInSeconds")
    def max_session_ttl_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The maximum amount of time that any session on the bastion can remain active.
        """
        return pulumi.get(self, "max_session_ttl_in_seconds")

    @max_session_ttl_in_seconds.setter
    def max_session_ttl_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_session_ttl_in_seconds", value)

    @property
    @pulumi.getter(name="maxSessionsAllowed")
    def max_sessions_allowed(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of active sessions allowed on the bastion.
        """
        return pulumi.get(self, "max_sessions_allowed")

    @max_sessions_allowed.setter
    def max_sessions_allowed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_sessions_allowed", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bastion, which can't be changed after creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneBookEntry")
    def phone_book_entry(self) -> Optional[pulumi.Input[str]]:
        """
        The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "phone_book_entry")

    @phone_book_entry.setter
    def phone_book_entry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_book_entry", value)

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of the created private endpoint.
        """
        return pulumi.get(self, "private_endpoint_ip_address")

    @private_endpoint_ip_address.setter
    def private_endpoint_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_ip_address", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the bastion.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="staticJumpHostIpAddresses")
    def static_jump_host_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "static_jump_host_ip_addresses")

    @static_jump_host_ip_addresses.setter
    def static_jump_host_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "static_jump_host_ip_addresses", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetSubnetId")
    def target_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier (OCID) of the subnet that the bastion connects to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_subnet_id")

    @target_subnet_id.setter
    def target_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_subnet_id", value)

    @property
    @pulumi.getter(name="targetVcnId")
    def target_vcn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier (OCID) of the virtual cloud network (VCN) that the bastion connects to.
        """
        return pulumi.get(self, "target_vcn_id")

    @target_vcn_id.setter
    def target_vcn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_vcn_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the bastion was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the bastion was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class Bastion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bastion_type: Optional[pulumi.Input[str]] = None,
                 client_cidr_block_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 dns_proxy_status: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_session_ttl_in_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phone_book_entry: Optional[pulumi.Input[str]] = None,
                 static_jump_host_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Bastion resource in Oracle Cloud Infrastructure Bastion service.

        Creates a new bastion. A bastion provides secured, public access to target resources in the cloud that you cannot otherwise reach from the internet. A bastion resides in a public subnet and establishes the network infrastructure needed to connect a user to a target resource in a private subnet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bastion = oci.bastion.Bastion("testBastion",
            bastion_type=var["bastion_bastion_type"],
            compartment_id=var["compartment_id"],
            target_subnet_id=oci_core_subnet["test_subnet"]["id"],
            client_cidr_block_allow_lists=var["bastion_client_cidr_block_allow_list"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            dns_proxy_status=var["bastion_dns_proxy_status"],
            freeform_tags={
                "bar-key": "value",
            },
            max_session_ttl_in_seconds=var["bastion_max_session_ttl_in_seconds"],
            phone_book_entry=var["bastion_phone_book_entry"],
            static_jump_host_ip_addresses=var["bastion_static_jump_host_ip_addresses"])
        ```

        ## Import

        Bastions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Bastion/bastion:Bastion test_bastion "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bastion_type: The type of bastion. Use `standard`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_cidr_block_allow_lists: (Updatable) A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        :param pulumi.Input[str] compartment_id: (Updatable) The unique identifier (OCID) of the compartment where the bastion is located.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] dns_proxy_status: Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] max_session_ttl_in_seconds: (Updatable) The maximum amount of time that any session on the bastion can remain active.
        :param pulumi.Input[str] name: The name of the bastion, which can't be changed after creation.
        :param pulumi.Input[str] phone_book_entry: The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_jump_host_ip_addresses: (Updatable) A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        :param pulumi.Input[str] target_subnet_id: The unique identifier (OCID) of the subnet that the bastion connects to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BastionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Bastion resource in Oracle Cloud Infrastructure Bastion service.

        Creates a new bastion. A bastion provides secured, public access to target resources in the cloud that you cannot otherwise reach from the internet. A bastion resides in a public subnet and establishes the network infrastructure needed to connect a user to a target resource in a private subnet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bastion = oci.bastion.Bastion("testBastion",
            bastion_type=var["bastion_bastion_type"],
            compartment_id=var["compartment_id"],
            target_subnet_id=oci_core_subnet["test_subnet"]["id"],
            client_cidr_block_allow_lists=var["bastion_client_cidr_block_allow_list"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            dns_proxy_status=var["bastion_dns_proxy_status"],
            freeform_tags={
                "bar-key": "value",
            },
            max_session_ttl_in_seconds=var["bastion_max_session_ttl_in_seconds"],
            phone_book_entry=var["bastion_phone_book_entry"],
            static_jump_host_ip_addresses=var["bastion_static_jump_host_ip_addresses"])
        ```

        ## Import

        Bastions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Bastion/bastion:Bastion test_bastion "id"
        ```

        :param str resource_name: The name of the resource.
        :param BastionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BastionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bastion_type: Optional[pulumi.Input[str]] = None,
                 client_cidr_block_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 dns_proxy_status: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_session_ttl_in_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phone_book_entry: Optional[pulumi.Input[str]] = None,
                 static_jump_host_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BastionArgs.__new__(BastionArgs)

            if bastion_type is None and not opts.urn:
                raise TypeError("Missing required property 'bastion_type'")
            __props__.__dict__["bastion_type"] = bastion_type
            __props__.__dict__["client_cidr_block_allow_lists"] = client_cidr_block_allow_lists
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["dns_proxy_status"] = dns_proxy_status
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["max_session_ttl_in_seconds"] = max_session_ttl_in_seconds
            __props__.__dict__["name"] = name
            __props__.__dict__["phone_book_entry"] = phone_book_entry
            __props__.__dict__["static_jump_host_ip_addresses"] = static_jump_host_ip_addresses
            if target_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_subnet_id'")
            __props__.__dict__["target_subnet_id"] = target_subnet_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["max_sessions_allowed"] = None
            __props__.__dict__["private_endpoint_ip_address"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_vcn_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Bastion, __self__).__init__(
            'oci:Bastion/bastion:Bastion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bastion_type: Optional[pulumi.Input[str]] = None,
            client_cidr_block_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            dns_proxy_status: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            max_session_ttl_in_seconds: Optional[pulumi.Input[int]] = None,
            max_sessions_allowed: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            phone_book_entry: Optional[pulumi.Input[str]] = None,
            private_endpoint_ip_address: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            static_jump_host_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_subnet_id: Optional[pulumi.Input[str]] = None,
            target_vcn_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'Bastion':
        """
        Get an existing Bastion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bastion_type: The type of bastion. Use `standard`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_cidr_block_allow_lists: (Updatable) A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        :param pulumi.Input[str] compartment_id: (Updatable) The unique identifier (OCID) of the compartment where the bastion is located.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] dns_proxy_status: Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail.
        :param pulumi.Input[int] max_session_ttl_in_seconds: (Updatable) The maximum amount of time that any session on the bastion can remain active.
        :param pulumi.Input[int] max_sessions_allowed: The maximum number of active sessions allowed on the bastion.
        :param pulumi.Input[str] name: The name of the bastion, which can't be changed after creation.
        :param pulumi.Input[str] phone_book_entry: The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        :param pulumi.Input[str] private_endpoint_ip_address: The private IP address of the created private endpoint.
        :param pulumi.Input[str] state: The current state of the bastion.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_jump_host_ip_addresses: (Updatable) A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_subnet_id: The unique identifier (OCID) of the subnet that the bastion connects to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] target_vcn_id: The unique identifier (OCID) of the virtual cloud network (VCN) that the bastion connects to.
        :param pulumi.Input[str] time_created: The time the bastion was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The time the bastion was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BastionState.__new__(_BastionState)

        __props__.__dict__["bastion_type"] = bastion_type
        __props__.__dict__["client_cidr_block_allow_lists"] = client_cidr_block_allow_lists
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["dns_proxy_status"] = dns_proxy_status
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["max_session_ttl_in_seconds"] = max_session_ttl_in_seconds
        __props__.__dict__["max_sessions_allowed"] = max_sessions_allowed
        __props__.__dict__["name"] = name
        __props__.__dict__["phone_book_entry"] = phone_book_entry
        __props__.__dict__["private_endpoint_ip_address"] = private_endpoint_ip_address
        __props__.__dict__["state"] = state
        __props__.__dict__["static_jump_host_ip_addresses"] = static_jump_host_ip_addresses
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_subnet_id"] = target_subnet_id
        __props__.__dict__["target_vcn_id"] = target_vcn_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Bastion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bastionType")
    def bastion_type(self) -> pulumi.Output[str]:
        """
        The type of bastion. Use `standard`.
        """
        return pulumi.get(self, "bastion_type")

    @property
    @pulumi.getter(name="clientCidrBlockAllowLists")
    def client_cidr_block_allow_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        """
        return pulumi.get(self, "client_cidr_block_allow_lists")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The unique identifier (OCID) of the compartment where the bastion is located.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="dnsProxyStatus")
    def dns_proxy_status(self) -> pulumi.Output[str]:
        """
        Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        """
        return pulumi.get(self, "dns_proxy_status")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxSessionTtlInSeconds")
    def max_session_ttl_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) The maximum amount of time that any session on the bastion can remain active.
        """
        return pulumi.get(self, "max_session_ttl_in_seconds")

    @property
    @pulumi.getter(name="maxSessionsAllowed")
    def max_sessions_allowed(self) -> pulumi.Output[int]:
        """
        The maximum number of active sessions allowed on the bastion.
        """
        return pulumi.get(self, "max_sessions_allowed")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the bastion, which can't be changed after creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phoneBookEntry")
    def phone_book_entry(self) -> pulumi.Output[str]:
        """
        The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "phone_book_entry")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> pulumi.Output[str]:
        """
        The private IP address of the created private endpoint.
        """
        return pulumi.get(self, "private_endpoint_ip_address")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the bastion.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="staticJumpHostIpAddresses")
    def static_jump_host_ip_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "static_jump_host_ip_addresses")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetSubnetId")
    def target_subnet_id(self) -> pulumi.Output[str]:
        """
        The unique identifier (OCID) of the subnet that the bastion connects to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_subnet_id")

    @property
    @pulumi.getter(name="targetVcnId")
    def target_vcn_id(self) -> pulumi.Output[str]:
        """
        The unique identifier (OCID) of the virtual cloud network (VCN) that the bastion connects to.
        """
        return pulumi.get(self, "target_vcn_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the bastion was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the bastion was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

