# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalExadataStorageConnectorResult',
    'AwaitableGetExternalExadataStorageConnectorResult',
    'get_external_exadata_storage_connector',
    'get_external_exadata_storage_connector_output',
]

@pulumi.output_type
class GetExternalExadataStorageConnectorResult:
    """
    A collection of values returned by getExternalExadataStorageConnector.
    """
    def __init__(__self__, additional_details=None, agent_id=None, connection_uri=None, connector_name=None, credential_infos=None, display_name=None, exadata_infrastructure_id=None, external_exadata_storage_connector_id=None, id=None, internal_id=None, lifecycle_details=None, state=None, status=None, storage_server_id=None, time_created=None, time_updated=None, version=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if connection_uri and not isinstance(connection_uri, str):
            raise TypeError("Expected argument 'connection_uri' to be a str")
        pulumi.set(__self__, "connection_uri", connection_uri)
        if connector_name and not isinstance(connector_name, str):
            raise TypeError("Expected argument 'connector_name' to be a str")
        pulumi.set(__self__, "connector_name", connector_name)
        if credential_infos and not isinstance(credential_infos, list):
            raise TypeError("Expected argument 'credential_infos' to be a list")
        pulumi.set(__self__, "credential_infos", credential_infos)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if external_exadata_storage_connector_id and not isinstance(external_exadata_storage_connector_id, str):
            raise TypeError("Expected argument 'external_exadata_storage_connector_id' to be a str")
        pulumi.set(__self__, "external_exadata_storage_connector_id", external_exadata_storage_connector_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_id and not isinstance(internal_id, str):
            raise TypeError("Expected argument 'internal_id' to be a str")
        pulumi.set(__self__, "internal_id", internal_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if storage_server_id and not isinstance(storage_server_id, str):
            raise TypeError("Expected argument 'storage_server_id' to be a str")
        pulumi.set(__self__, "storage_server_id", storage_server_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, Any]:
        """
        The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the agent for the Exadata storage server.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="connectionUri")
    def connection_uri(self) -> str:
        """
        The unique string of the connection. For example, "https://<storage-server-name>/MS/RESTService/".
        """
        return pulumi.get(self, "connection_uri")

    @property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> str:
        return pulumi.get(self, "connector_name")

    @property
    @pulumi.getter(name="credentialInfos")
    def credential_infos(self) -> Sequence['outputs.GetExternalExadataStorageConnectorCredentialInfoResult']:
        return pulumi.get(self, "credential_infos")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="externalExadataStorageConnectorId")
    def external_exadata_storage_connector_id(self) -> str:
        return pulumi.get(self, "external_exadata_storage_connector_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> str:
        """
        The internal ID of the Exadata resource.
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The details of the lifecycle state of the Exadata resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Exadata resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageServerId")
    def storage_server_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        """
        return pulumi.get(self, "storage_server_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The timestamp of the creation of the Exadata resource.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The timestamp of the last update of the Exadata resource.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the Exadata resource.
        """
        return pulumi.get(self, "version")


class AwaitableGetExternalExadataStorageConnectorResult(GetExternalExadataStorageConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalExadataStorageConnectorResult(
            additional_details=self.additional_details,
            agent_id=self.agent_id,
            connection_uri=self.connection_uri,
            connector_name=self.connector_name,
            credential_infos=self.credential_infos,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            external_exadata_storage_connector_id=self.external_exadata_storage_connector_id,
            id=self.id,
            internal_id=self.internal_id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            status=self.status,
            storage_server_id=self.storage_server_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            version=self.version)


def get_external_exadata_storage_connector(external_exadata_storage_connector_id: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalExadataStorageConnectorResult:
    """
    This data source provides details about a specific External Exadata Storage Connector resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Exadata storage server connector specified by exadataStorageConnectorId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_connector = oci.DatabaseManagement.get_external_exadata_storage_connector(external_exadata_storage_connector_id=oci_database_management_external_exadata_storage_connector["test_external_exadata_storage_connector"]["id"])
    ```


    :param str external_exadata_storage_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connector to the Exadata storage server.
    """
    __args__ = dict()
    __args__['externalExadataStorageConnectorId'] = external_exadata_storage_connector_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalExadataStorageConnector:getExternalExadataStorageConnector', __args__, opts=opts, typ=GetExternalExadataStorageConnectorResult).value

    return AwaitableGetExternalExadataStorageConnectorResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        agent_id=pulumi.get(__ret__, 'agent_id'),
        connection_uri=pulumi.get(__ret__, 'connection_uri'),
        connector_name=pulumi.get(__ret__, 'connector_name'),
        credential_infos=pulumi.get(__ret__, 'credential_infos'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        external_exadata_storage_connector_id=pulumi.get(__ret__, 'external_exadata_storage_connector_id'),
        id=pulumi.get(__ret__, 'id'),
        internal_id=pulumi.get(__ret__, 'internal_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        storage_server_id=pulumi.get(__ret__, 'storage_server_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_external_exadata_storage_connector)
def get_external_exadata_storage_connector_output(external_exadata_storage_connector_id: Optional[pulumi.Input[str]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalExadataStorageConnectorResult]:
    """
    This data source provides details about a specific External Exadata Storage Connector resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Exadata storage server connector specified by exadataStorageConnectorId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_connector = oci.DatabaseManagement.get_external_exadata_storage_connector(external_exadata_storage_connector_id=oci_database_management_external_exadata_storage_connector["test_external_exadata_storage_connector"]["id"])
    ```


    :param str external_exadata_storage_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connector to the Exadata storage server.
    """
    ...
