# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetManagedMySqlDatabaseResult',
    'AwaitableGetManagedMySqlDatabaseResult',
    'get_managed_my_sql_database',
    'get_managed_my_sql_database_output',
]

@pulumi.output_type
class GetManagedMySqlDatabaseResult:
    """
    A collection of values returned by getManagedMySqlDatabase.
    """
    def __init__(__self__, compartment_id=None, db_name=None, db_version=None, id=None, managed_my_sql_database_id=None, name=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_my_sql_database_id and not isinstance(managed_my_sql_database_id, str):
            raise TypeError("Expected argument 'managed_my_sql_database_id' to be a str")
        pulumi.set(__self__, "managed_my_sql_database_id", managed_my_sql_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> str:
        """
        MySQL Database Name
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        MySQL Database Version
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedMySqlDatabaseId")
    def managed_my_sql_database_id(self) -> str:
        return pulumi.get(self, "managed_my_sql_database_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Managed MySQL Database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Managed Database was created.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetManagedMySqlDatabaseResult(GetManagedMySqlDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedMySqlDatabaseResult(
            compartment_id=self.compartment_id,
            db_name=self.db_name,
            db_version=self.db_version,
            id=self.id,
            managed_my_sql_database_id=self.managed_my_sql_database_id,
            name=self.name,
            time_created=self.time_created)


def get_managed_my_sql_database(managed_my_sql_database_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedMySqlDatabaseResult:
    """
    This data source provides details about a specific Managed My Sql Database resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves General Information for given MySQL Instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_database = oci.DatabaseManagement.get_managed_my_sql_database(managed_my_sql_database_id=oci_database_management_managed_my_sql_database["test_managed_my_sql_database"]["id"])
    ```


    :param str managed_my_sql_database_id: The OCID of ManagedMySqlDatabase.
    """
    __args__ = dict()
    __args__['managedMySqlDatabaseId'] = managed_my_sql_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedMySqlDatabase:getManagedMySqlDatabase', __args__, opts=opts, typ=GetManagedMySqlDatabaseResult).value

    return AwaitableGetManagedMySqlDatabaseResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_name=pulumi.get(__ret__, 'db_name'),
        db_version=pulumi.get(__ret__, 'db_version'),
        id=pulumi.get(__ret__, 'id'),
        managed_my_sql_database_id=pulumi.get(__ret__, 'managed_my_sql_database_id'),
        name=pulumi.get(__ret__, 'name'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_managed_my_sql_database)
def get_managed_my_sql_database_output(managed_my_sql_database_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedMySqlDatabaseResult]:
    """
    This data source provides details about a specific Managed My Sql Database resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves General Information for given MySQL Instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_database = oci.DatabaseManagement.get_managed_my_sql_database(managed_my_sql_database_id=oci_database_management_managed_my_sql_database["test_managed_my_sql_database"]["id"])
    ```


    :param str managed_my_sql_database_id: The OCID of ManagedMySqlDatabase.
    """
    ...
