# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAuditPolicyResult',
    'AwaitableGetAuditPolicyResult',
    'get_audit_policy',
    'get_audit_policy_output',
]

@pulumi.output_type
class GetAuditPolicyResult:
    """
    A collection of values returned by getAuditPolicy.
    """
    def __init__(__self__, audit_conditions=None, audit_policy_id=None, audit_specifications=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_data_safe_service_account_excluded=None, lifecycle_details=None, provision_trigger=None, retrieve_from_target_trigger=None, state=None, system_tags=None, target_id=None, time_created=None, time_last_provisioned=None, time_last_retrieved=None, time_updated=None):
        if audit_conditions and not isinstance(audit_conditions, list):
            raise TypeError("Expected argument 'audit_conditions' to be a list")
        pulumi.set(__self__, "audit_conditions", audit_conditions)
        if audit_policy_id and not isinstance(audit_policy_id, str):
            raise TypeError("Expected argument 'audit_policy_id' to be a str")
        pulumi.set(__self__, "audit_policy_id", audit_policy_id)
        if audit_specifications and not isinstance(audit_specifications, list):
            raise TypeError("Expected argument 'audit_specifications' to be a list")
        pulumi.set(__self__, "audit_specifications", audit_specifications)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_data_safe_service_account_excluded and not isinstance(is_data_safe_service_account_excluded, bool):
            raise TypeError("Expected argument 'is_data_safe_service_account_excluded' to be a bool")
        pulumi.set(__self__, "is_data_safe_service_account_excluded", is_data_safe_service_account_excluded)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if provision_trigger and not isinstance(provision_trigger, int):
            raise TypeError("Expected argument 'provision_trigger' to be a int")
        pulumi.set(__self__, "provision_trigger", provision_trigger)
        if retrieve_from_target_trigger and not isinstance(retrieve_from_target_trigger, int):
            raise TypeError("Expected argument 'retrieve_from_target_trigger' to be a int")
        pulumi.set(__self__, "retrieve_from_target_trigger", retrieve_from_target_trigger)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_provisioned and not isinstance(time_last_provisioned, str):
            raise TypeError("Expected argument 'time_last_provisioned' to be a str")
        pulumi.set(__self__, "time_last_provisioned", time_last_provisioned)
        if time_last_retrieved and not isinstance(time_last_retrieved, str):
            raise TypeError("Expected argument 'time_last_retrieved' to be a str")
        pulumi.set(__self__, "time_last_retrieved", time_last_retrieved)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="auditConditions")
    def audit_conditions(self) -> Sequence['outputs.GetAuditPolicyAuditConditionResult']:
        """
        Lists the audit policy provisioning conditions for the target database.
        """
        return pulumi.get(self, "audit_conditions")

    @property
    @pulumi.getter(name="auditPolicyId")
    def audit_policy_id(self) -> str:
        return pulumi.get(self, "audit_policy_id")

    @property
    @pulumi.getter(name="auditSpecifications")
    def audit_specifications(self) -> Sequence['outputs.GetAuditPolicyAuditSpecificationResult']:
        """
        Represents all available audit policy specifications relevant for the target database. For more details on available audit polcies, refer to [documentation](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/audit-policies.html#GUID-361A9A9A-7C21-4F5A-8945-9B3A0C472827).
        """
        return pulumi.get(self, "audit_specifications")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the audit policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the audit policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the audit policy.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the audit policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDataSafeServiceAccountExcluded")
    def is_data_safe_service_account_excluded(self) -> bool:
        """
        Option provided to users at the target to indicate whether the Data Safe service account has to be excluded while provisioning the audit policies.
        """
        return pulumi.get(self, "is_data_safe_service_account_excluded")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the current state of the audit policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="provisionTrigger")
    def provision_trigger(self) -> int:
        return pulumi.get(self, "provision_trigger")

    @property
    @pulumi.getter(name="retrieveFromTargetTrigger")
    def retrieve_from_target_trigger(self) -> int:
        return pulumi.get(self, "retrieve_from_target_trigger")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the audit policy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target for which the audit policy is created.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the audit policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastProvisioned")
    def time_last_provisioned(self) -> str:
        """
        Indicates the last provisioning time of audit policies on the target, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_provisioned")

    @property
    @pulumi.getter(name="timeLastRetrieved")
    def time_last_retrieved(self) -> str:
        """
        The time when the audit policies was last retrieved from this target, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_retrieved")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The last date and time the audit policy was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAuditPolicyResult(GetAuditPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditPolicyResult(
            audit_conditions=self.audit_conditions,
            audit_policy_id=self.audit_policy_id,
            audit_specifications=self.audit_specifications,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_data_safe_service_account_excluded=self.is_data_safe_service_account_excluded,
            lifecycle_details=self.lifecycle_details,
            provision_trigger=self.provision_trigger,
            retrieve_from_target_trigger=self.retrieve_from_target_trigger,
            state=self.state,
            system_tags=self.system_tags,
            target_id=self.target_id,
            time_created=self.time_created,
            time_last_provisioned=self.time_last_provisioned,
            time_last_retrieved=self.time_last_retrieved,
            time_updated=self.time_updated)


def get_audit_policy(audit_policy_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditPolicyResult:
    """
    This data source provides details about a specific Audit Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a audit policy by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_policy = oci.DataSafe.get_audit_policy(audit_policy_id=oci_data_safe_audit_policy["test_audit_policy"]["id"])
    ```


    :param str audit_policy_id: Unique audit policy identifier.
    """
    __args__ = dict()
    __args__['auditPolicyId'] = audit_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditPolicy:getAuditPolicy', __args__, opts=opts, typ=GetAuditPolicyResult).value

    return AwaitableGetAuditPolicyResult(
        audit_conditions=pulumi.get(__ret__, 'audit_conditions'),
        audit_policy_id=pulumi.get(__ret__, 'audit_policy_id'),
        audit_specifications=pulumi.get(__ret__, 'audit_specifications'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_data_safe_service_account_excluded=pulumi.get(__ret__, 'is_data_safe_service_account_excluded'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        provision_trigger=pulumi.get(__ret__, 'provision_trigger'),
        retrieve_from_target_trigger=pulumi.get(__ret__, 'retrieve_from_target_trigger'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_provisioned=pulumi.get(__ret__, 'time_last_provisioned'),
        time_last_retrieved=pulumi.get(__ret__, 'time_last_retrieved'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_audit_policy)
def get_audit_policy_output(audit_policy_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuditPolicyResult]:
    """
    This data source provides details about a specific Audit Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a audit policy by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_policy = oci.DataSafe.get_audit_policy(audit_policy_id=oci_data_safe_audit_policy["test_audit_policy"]["id"])
    ```


    :param str audit_policy_id: Unique audit policy identifier.
    """
    ...
