# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetCryptoAnalysisResultsResult',
    'AwaitableGetFleetCryptoAnalysisResultsResult',
    'get_fleet_crypto_analysis_results',
    'get_fleet_crypto_analysis_results_output',
]

@pulumi.output_type
class GetFleetCryptoAnalysisResultsResult:
    """
    A collection of values returned by getFleetCryptoAnalysisResults.
    """
    def __init__(__self__, aggregation_mode=None, crypto_analysis_result_collections=None, filters=None, fleet_id=None, id=None, managed_instance_id=None, time_end=None, time_start=None):
        if aggregation_mode and not isinstance(aggregation_mode, str):
            raise TypeError("Expected argument 'aggregation_mode' to be a str")
        pulumi.set(__self__, "aggregation_mode", aggregation_mode)
        if crypto_analysis_result_collections and not isinstance(crypto_analysis_result_collections, list):
            raise TypeError("Expected argument 'crypto_analysis_result_collections' to be a list")
        pulumi.set(__self__, "crypto_analysis_result_collections", crypto_analysis_result_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="aggregationMode")
    def aggregation_mode(self) -> Optional[str]:
        """
        The result aggregation mode
        """
        return pulumi.get(self, "aggregation_mode")

    @property
    @pulumi.getter(name="cryptoAnalysisResultCollections")
    def crypto_analysis_result_collections(self) -> Sequence['outputs.GetFleetCryptoAnalysisResultsCryptoAnalysisResultCollectionResult']:
        """
        The list of crypto_analysis_result_collection.
        """
        return pulumi.get(self, "crypto_analysis_result_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetCryptoAnalysisResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        """
        The fleet OCID.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[str]:
        """
        The managed instance OCID.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[str]:
        return pulumi.get(self, "time_start")


class AwaitableGetFleetCryptoAnalysisResultsResult(GetFleetCryptoAnalysisResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetCryptoAnalysisResultsResult(
            aggregation_mode=self.aggregation_mode,
            crypto_analysis_result_collections=self.crypto_analysis_result_collections,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            time_end=self.time_end,
            time_start=self.time_start)


def get_fleet_crypto_analysis_results(aggregation_mode: Optional[str] = None,
                                      filters: Optional[Sequence[pulumi.InputType['GetFleetCryptoAnalysisResultsFilterArgs']]] = None,
                                      fleet_id: Optional[str] = None,
                                      managed_instance_id: Optional[str] = None,
                                      time_end: Optional[str] = None,
                                      time_start: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetCryptoAnalysisResultsResult:
    """
    This data source provides the list of Fleet Crypto Analysis Results in Oracle Cloud Infrastructure Jms service.

    Lists the results of a Crypto event analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_crypto_analysis_results = oci.Jms.get_fleet_crypto_analysis_results(fleet_id=oci_jms_fleet["test_fleet"]["id"],
        aggregation_mode=var["fleet_crypto_analysis_result_aggregation_mode"],
        managed_instance_id=oci_osmanagement_managed_instance["test_managed_instance"]["id"],
        time_end=var["fleet_crypto_analysis_result_time_end"],
        time_start=var["fleet_crypto_analysis_result_time_start"])
    ```


    :param str aggregation_mode: The aggregation mode of the crypto event analysis result.
    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['aggregationMode'] = aggregation_mode
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetCryptoAnalysisResults:getFleetCryptoAnalysisResults', __args__, opts=opts, typ=GetFleetCryptoAnalysisResultsResult).value

    return AwaitableGetFleetCryptoAnalysisResultsResult(
        aggregation_mode=pulumi.get(__ret__, 'aggregation_mode'),
        crypto_analysis_result_collections=pulumi.get(__ret__, 'crypto_analysis_result_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_fleet_crypto_analysis_results)
def get_fleet_crypto_analysis_results_output(aggregation_mode: Optional[pulumi.Input[Optional[str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFleetCryptoAnalysisResultsFilterArgs']]]]] = None,
                                             fleet_id: Optional[pulumi.Input[str]] = None,
                                             managed_instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                             time_end: Optional[pulumi.Input[Optional[str]]] = None,
                                             time_start: Optional[pulumi.Input[Optional[str]]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetCryptoAnalysisResultsResult]:
    """
    This data source provides the list of Fleet Crypto Analysis Results in Oracle Cloud Infrastructure Jms service.

    Lists the results of a Crypto event analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_crypto_analysis_results = oci.Jms.get_fleet_crypto_analysis_results(fleet_id=oci_jms_fleet["test_fleet"]["id"],
        aggregation_mode=var["fleet_crypto_analysis_result_aggregation_mode"],
        managed_instance_id=oci_osmanagement_managed_instance["test_managed_instance"]["id"],
        time_end=var["fleet_crypto_analysis_result_time_end"],
        time_start=var["fleet_crypto_analysis_result_time_start"])
    ```


    :param str aggregation_mode: The aggregation mode of the crypto event analysis result.
    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    ...
