# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerRoutingPolicyArgs', 'LoadBalancerRoutingPolicy']

@pulumi.input_type
class LoadBalancerRoutingPolicyArgs:
    def __init__(__self__, *,
                 condition_language_version: pulumi.Input[str],
                 load_balancer_id: pulumi.Input[str],
                 rules: pulumi.Input[Sequence[pulumi.Input['LoadBalancerRoutingPolicyRuleArgs']]],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LoadBalancerRoutingPolicy resource.
        :param pulumi.Input[str] condition_language_version: (Updatable) The version of the language in which `condition` of `rules` are composed.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to add the routing policy rule list to.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRoutingPolicyRuleArgs']]] rules: (Updatable) The list of routing rules.
        :param pulumi.Input[str] name: (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "condition_language_version", condition_language_version)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "rules", rules)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="conditionLanguageVersion")
    def condition_language_version(self) -> pulumi.Input[str]:
        """
        (Updatable) The version of the language in which `condition` of `rules` are composed.
        """
        return pulumi.get(self, "condition_language_version")

    @condition_language_version.setter
    def condition_language_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_language_version", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to add the routing policy rule list to.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerRoutingPolicyRuleArgs']]]:
        """
        (Updatable) The list of routing rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerRoutingPolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LoadBalancerRoutingPolicyState:
    def __init__(__self__, *,
                 condition_language_version: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRoutingPolicyRuleArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerRoutingPolicy resources.
        :param pulumi.Input[str] condition_language_version: (Updatable) The version of the language in which `condition` of `rules` are composed.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to add the routing policy rule list to.
        :param pulumi.Input[str] name: (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRoutingPolicyRuleArgs']]] rules: (Updatable) The list of routing rules.
        """
        if condition_language_version is not None:
            pulumi.set(__self__, "condition_language_version", condition_language_version)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="conditionLanguageVersion")
    def condition_language_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of the language in which `condition` of `rules` are composed.
        """
        return pulumi.get(self, "condition_language_version")

    @condition_language_version.setter
    def condition_language_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_language_version", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to add the routing policy rule list to.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRoutingPolicyRuleArgs']]]]:
        """
        (Updatable) The list of routing rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRoutingPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class LoadBalancerRoutingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_language_version: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerRoutingPolicyRuleArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Load Balancer Routing Policy resource in Oracle Cloud Infrastructure Load Balancer service.

        Adds a routing policy to a load balancer. For more information, see
        [Managing Request Routing](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrequest.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_load_balancer_routing_policy = oci.load_balancer.LoadBalancerRoutingPolicy("testLoadBalancerRoutingPolicy",
            condition_language_version=var["load_balancer_routing_policy_condition_language_version"],
            load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
            rules=[oci.load_balancer.LoadBalancerRoutingPolicyRuleArgs(
                actions=[oci.load_balancer.LoadBalancerRoutingPolicyRuleActionArgs(
                    backend_set_name=oci_load_balancer_backend_set["test_backend_set"]["name"],
                    name=var["load_balancer_routing_policy_rules_actions_name"],
                )],
                condition=var["load_balancer_routing_policy_rules_condition"],
                name=var["load_balancer_routing_policy_rules_name"],
            )])
        ```

        ## Import

        LoadBalancerRoutingPolicies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:LoadBalancer/loadBalancerRoutingPolicy:LoadBalancerRoutingPolicy test_load_balancer_routing_policy "loadBalancers/{loadBalancerId}/routingPolicies/{routingPolicyName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] condition_language_version: (Updatable) The version of the language in which `condition` of `rules` are composed.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to add the routing policy rule list to.
        :param pulumi.Input[str] name: (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerRoutingPolicyRuleArgs']]]] rules: (Updatable) The list of routing rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerRoutingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Load Balancer Routing Policy resource in Oracle Cloud Infrastructure Load Balancer service.

        Adds a routing policy to a load balancer. For more information, see
        [Managing Request Routing](https://docs.cloud.oracle.com/iaas/Content/Balance/Tasks/managingrequest.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_load_balancer_routing_policy = oci.load_balancer.LoadBalancerRoutingPolicy("testLoadBalancerRoutingPolicy",
            condition_language_version=var["load_balancer_routing_policy_condition_language_version"],
            load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
            rules=[oci.load_balancer.LoadBalancerRoutingPolicyRuleArgs(
                actions=[oci.load_balancer.LoadBalancerRoutingPolicyRuleActionArgs(
                    backend_set_name=oci_load_balancer_backend_set["test_backend_set"]["name"],
                    name=var["load_balancer_routing_policy_rules_actions_name"],
                )],
                condition=var["load_balancer_routing_policy_rules_condition"],
                name=var["load_balancer_routing_policy_rules_name"],
            )])
        ```

        ## Import

        LoadBalancerRoutingPolicies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:LoadBalancer/loadBalancerRoutingPolicy:LoadBalancerRoutingPolicy test_load_balancer_routing_policy "loadBalancers/{loadBalancerId}/routingPolicies/{routingPolicyName}"
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerRoutingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerRoutingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_language_version: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerRoutingPolicyRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerRoutingPolicyArgs.__new__(LoadBalancerRoutingPolicyArgs)

            if condition_language_version is None and not opts.urn:
                raise TypeError("Missing required property 'condition_language_version'")
            __props__.__dict__["condition_language_version"] = condition_language_version
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["name"] = name
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            __props__.__dict__["state"] = None
        super(LoadBalancerRoutingPolicy, __self__).__init__(
            'oci:LoadBalancer/loadBalancerRoutingPolicy:LoadBalancerRoutingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition_language_version: Optional[pulumi.Input[str]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerRoutingPolicyRuleArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'LoadBalancerRoutingPolicy':
        """
        Get an existing LoadBalancerRoutingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] condition_language_version: (Updatable) The version of the language in which `condition` of `rules` are composed.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to add the routing policy rule list to.
        :param pulumi.Input[str] name: (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerRoutingPolicyRuleArgs']]]] rules: (Updatable) The list of routing rules.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerRoutingPolicyState.__new__(_LoadBalancerRoutingPolicyState)

        __props__.__dict__["condition_language_version"] = condition_language_version
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["rules"] = rules
        __props__.__dict__["state"] = state
        return LoadBalancerRoutingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="conditionLanguageVersion")
    def condition_language_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The version of the language in which `condition` of `rules` are composed.
        """
        return pulumi.get(self, "condition_language_version")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to add the routing policy rule list to.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) A unique name for the routing policy rule. Avoid entering confidential information. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.LoadBalancerRoutingPolicyRule']]:
        """
        (Updatable) The list of routing rules.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "state")

