# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetScheduledRunResult',
    'AwaitableGetScheduledRunResult',
    'get_scheduled_run',
    'get_scheduled_run_output',
]

@pulumi.output_type
class GetScheduledRunResult:
    """
    A collection of values returned by getScheduledRun.
    """
    def __init__(__self__, id=None, lifecycle_details=None, schedule_id=None, scheduled_run_id=None, state=None, time_created=None, time_finished=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if schedule_id and not isinstance(schedule_id, str):
            raise TypeError("Expected argument 'schedule_id' to be a str")
        pulumi.set(__self__, "schedule_id", schedule_id)
        if scheduled_run_id and not isinstance(scheduled_run_id, str):
            raise TypeError("Expected argument 'scheduled_run_id' to be a str")
        pulumi.set(__self__, "scheduled_run_id", scheduled_run_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional details about scheduled run failure
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> str:
        """
        The ocid representing unique shedule
        """
        return pulumi.get(self, "schedule_id")

    @property
    @pulumi.getter(name="scheduledRunId")
    def scheduled_run_id(self) -> str:
        return pulumi.get(self, "scheduled_run_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Specifies if the schedule job was run successfully or not.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when schedule started executing
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The time when schedule finished executing
        """
        return pulumi.get(self, "time_finished")


class AwaitableGetScheduledRunResult(GetScheduledRunResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledRunResult(
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            schedule_id=self.schedule_id,
            scheduled_run_id=self.scheduled_run_id,
            state=self.state,
            time_created=self.time_created,
            time_finished=self.time_finished)


def get_scheduled_run(scheduled_run_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledRunResult:
    """
    This data source provides details about a specific Scheduled Run resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved schedule run.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_run = oci.MeteringComputation.get_scheduled_run(scheduled_run_id=oci_metering_computation_scheduled_run["test_scheduled_run"]["id"])
    ```


    :param str scheduled_run_id: The scheduledRun unique OCID.
    """
    __args__ = dict()
    __args__['scheduledRunId'] = scheduled_run_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getScheduledRun:getScheduledRun', __args__, opts=opts, typ=GetScheduledRunResult).value

    return AwaitableGetScheduledRunResult(
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        schedule_id=pulumi.get(__ret__, 'schedule_id'),
        scheduled_run_id=pulumi.get(__ret__, 'scheduled_run_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_finished=pulumi.get(__ret__, 'time_finished'))


@_utilities.lift_output_func(get_scheduled_run)
def get_scheduled_run_output(scheduled_run_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScheduledRunResult]:
    """
    This data source provides details about a specific Scheduled Run resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved schedule run.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_run = oci.MeteringComputation.get_scheduled_run(scheduled_run_id=oci_metering_computation_scheduled_run["test_scheduled_run"]["id"])
    ```


    :param str scheduled_run_id: The scheduledRun unique OCID.
    """
    ...
