# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetReplicaResult',
    'AwaitableGetReplicaResult',
    'get_replica',
    'get_replica_output',
]

@pulumi.output_type
class GetReplicaResult:
    """
    A collection of values returned by getReplica.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, configuration_id=None, db_system_id=None, defined_tags=None, description=None, display_name=None, fault_domain=None, freeform_tags=None, id=None, ip_address=None, is_delete_protected=None, lifecycle_details=None, mysql_version=None, port=None, port_x=None, replica_id=None, replica_overrides=None, shape_name=None, state=None, time_created=None, time_updated=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_id and not isinstance(configuration_id, str):
            raise TypeError("Expected argument 'configuration_id' to be a str")
        pulumi.set(__self__, "configuration_id", configuration_id)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fault_domain and not isinstance(fault_domain, str):
            raise TypeError("Expected argument 'fault_domain' to be a str")
        pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if is_delete_protected and not isinstance(is_delete_protected, bool):
            raise TypeError("Expected argument 'is_delete_protected' to be a bool")
        pulumi.set(__self__, "is_delete_protected", is_delete_protected)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if mysql_version and not isinstance(mysql_version, str):
            raise TypeError("Expected argument 'mysql_version' to be a str")
        pulumi.set(__self__, "mysql_version", mysql_version)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if port_x and not isinstance(port_x, int):
            raise TypeError("Expected argument 'port_x' to be a int")
        pulumi.set(__self__, "port_x", port_x)
        if replica_id and not isinstance(replica_id, str):
            raise TypeError("Expected argument 'replica_id' to be a str")
        pulumi.set(__self__, "replica_id", replica_id)
        if replica_overrides and not isinstance(replica_overrides, list):
            raise TypeError("Expected argument 'replica_overrides' to be a list")
        pulumi.set(__self__, "replica_overrides", replica_overrides)
        if shape_name and not isinstance(shape_name, str):
            raise TypeError("Expected argument 'shape_name' to be a str")
        pulumi.set(__self__, "shape_name", shape_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the Availability Domain the read replica is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the read replica.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> str:
        """
        The OCID of the Configuration to be used by the read replica.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        """
        The OCID of the DB System the read replica is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User provided description of the read replica.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the read replica. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> str:
        """
        The name of the Fault Domain the read replica is located in.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the read replica.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address the read replica is configured to listen on.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="isDeleteProtected")
    def is_delete_protected(self) -> bool:
        """
        Specifies whether the read replica can be deleted. Set to true to prevent deletion, false (default) to allow. Note that if a read replica is delete protected it also prevents the entire DB System from being deleted. If the DB System is delete protected, read replicas can still be deleted individually if they are not delete  protected themselves.
        """
        return pulumi.get(self, "is_delete_protected")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the state of the read replica.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> str:
        """
        The MySQL version to be used by the read replica.
        """
        return pulumi.get(self, "mysql_version")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port the read replica is configured to listen on.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portX")
    def port_x(self) -> int:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @property
    @pulumi.getter(name="replicaId")
    def replica_id(self) -> str:
        return pulumi.get(self, "replica_id")

    @property
    @pulumi.getter(name="replicaOverrides")
    def replica_overrides(self) -> Sequence['outputs.GetReplicaReplicaOverrideResult']:
        """
        By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.  If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,  and configurationId. If you set a property value to "", then the value is inherited from its  source DB system.
        """
        return pulumi.get(self, "replica_overrides")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> str:
        """
        The shape currently in use by the read replica. The shape determines the resources allocated:  CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.  To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the read replica.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the read replica was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the read replica was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetReplicaResult(GetReplicaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicaResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            configuration_id=self.configuration_id,
            db_system_id=self.db_system_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            fault_domain=self.fault_domain,
            freeform_tags=self.freeform_tags,
            id=self.id,
            ip_address=self.ip_address,
            is_delete_protected=self.is_delete_protected,
            lifecycle_details=self.lifecycle_details,
            mysql_version=self.mysql_version,
            port=self.port,
            port_x=self.port_x,
            replica_id=self.replica_id,
            replica_overrides=self.replica_overrides,
            shape_name=self.shape_name,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_replica(replica_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicaResult:
    """
    This data source provides details about a specific Replica resource in Oracle Cloud Infrastructure MySQL Database service.

    Gets the full details of the specified read replica.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replica = oci.Mysql.get_replica(replica_id=oci_mysql_replica["test_replica"]["id"])
    ```


    :param str replica_id: The Replica [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['replicaId'] = replica_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Mysql/getReplica:getReplica', __args__, opts=opts, typ=GetReplicaResult).value

    return AwaitableGetReplicaResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration_id=pulumi.get(__ret__, 'configuration_id'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fault_domain=pulumi.get(__ret__, 'fault_domain'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        is_delete_protected=pulumi.get(__ret__, 'is_delete_protected'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        mysql_version=pulumi.get(__ret__, 'mysql_version'),
        port=pulumi.get(__ret__, 'port'),
        port_x=pulumi.get(__ret__, 'port_x'),
        replica_id=pulumi.get(__ret__, 'replica_id'),
        replica_overrides=pulumi.get(__ret__, 'replica_overrides'),
        shape_name=pulumi.get(__ret__, 'shape_name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_replica)
def get_replica_output(replica_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReplicaResult]:
    """
    This data source provides details about a specific Replica resource in Oracle Cloud Infrastructure MySQL Database service.

    Gets the full details of the specified read replica.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replica = oci.Mysql.get_replica(replica_id=oci_mysql_replica["test_replica"]["id"])
    ```


    :param str replica_id: The Replica [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
