# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerScanRecipeArgs', 'ContainerScanRecipe']

@pulumi.input_type
class ContainerScanRecipeArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 scan_settings: pulumi.Input['ContainerScanRecipeScanSettingsArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_count: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ContainerScanRecipe resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan recipe's compartment
        :param pulumi.Input['ContainerScanRecipeScanSettingsArgs'] scan_settings: (Updatable) A collection of container scan settings
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) User friendly name of container scan recipe. If not present, will be auto-generated.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] image_count: (Updatable) This field is set equal to the number of images we want to scan in the first go when the recipe is created
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "scan_settings", scan_settings)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_count is not None:
            pulumi.set(__self__, "image_count", image_count)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan recipe's compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="scanSettings")
    def scan_settings(self) -> pulumi.Input['ContainerScanRecipeScanSettingsArgs']:
        """
        (Updatable) A collection of container scan settings
        """
        return pulumi.get(self, "scan_settings")

    @scan_settings.setter
    def scan_settings(self, value: pulumi.Input['ContainerScanRecipeScanSettingsArgs']):
        pulumi.set(self, "scan_settings", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User friendly name of container scan recipe. If not present, will be auto-generated.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) This field is set equal to the number of images we want to scan in the first go when the recipe is created
        """
        return pulumi.get(self, "image_count")

    @image_count.setter
    def image_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_count", value)


@pulumi.input_type
class _ContainerScanRecipeState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_count: Optional[pulumi.Input[int]] = None,
                 scan_settings: Optional[pulumi.Input['ContainerScanRecipeScanSettingsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ContainerScanRecipe resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan recipe's compartment
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) User friendly name of container scan recipe. If not present, will be auto-generated.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] image_count: (Updatable) This field is set equal to the number of images we want to scan in the first go when the recipe is created
        :param pulumi.Input['ContainerScanRecipeScanSettingsArgs'] scan_settings: (Updatable) A collection of container scan settings
        :param pulumi.Input[str] state: The current state of the config.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[str] time_updated: Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_count is not None:
            pulumi.set(__self__, "image_count", image_count)
        if scan_settings is not None:
            pulumi.set(__self__, "scan_settings", scan_settings)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan recipe's compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User friendly name of container scan recipe. If not present, will be auto-generated.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) This field is set equal to the number of images we want to scan in the first go when the recipe is created
        """
        return pulumi.get(self, "image_count")

    @image_count.setter
    def image_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_count", value)

    @property
    @pulumi.getter(name="scanSettings")
    def scan_settings(self) -> Optional[pulumi.Input['ContainerScanRecipeScanSettingsArgs']]:
        """
        (Updatable) A collection of container scan settings
        """
        return pulumi.get(self, "scan_settings")

    @scan_settings.setter
    def scan_settings(self, value: Optional[pulumi.Input['ContainerScanRecipeScanSettingsArgs']]):
        pulumi.set(self, "scan_settings", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class ContainerScanRecipe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_count: Optional[pulumi.Input[int]] = None,
                 scan_settings: Optional[pulumi.Input[pulumi.InputType['ContainerScanRecipeScanSettingsArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Container Scan Recipe resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

        Creates a new ContainerScanRecipe. A recipe determines the types of security issues that you want scanned.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_container_scan_recipe = oci.vulnerability_scanning.ContainerScanRecipe("testContainerScanRecipe",
            compartment_id=var["compartment_id"],
            scan_settings=oci.vulnerability_scanning.ContainerScanRecipeScanSettingsArgs(
                scan_level=var["container_scan_recipe_scan_settings_scan_level"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["container_scan_recipe_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            image_count=var["container_scan_recipe_image_count"])
        ```

        ## Import

        ContainerScanRecipes can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:VulnerabilityScanning/containerScanRecipe:ContainerScanRecipe test_container_scan_recipe "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan recipe's compartment
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) User friendly name of container scan recipe. If not present, will be auto-generated.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] image_count: (Updatable) This field is set equal to the number of images we want to scan in the first go when the recipe is created
        :param pulumi.Input[pulumi.InputType['ContainerScanRecipeScanSettingsArgs']] scan_settings: (Updatable) A collection of container scan settings
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerScanRecipeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Container Scan Recipe resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

        Creates a new ContainerScanRecipe. A recipe determines the types of security issues that you want scanned.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_container_scan_recipe = oci.vulnerability_scanning.ContainerScanRecipe("testContainerScanRecipe",
            compartment_id=var["compartment_id"],
            scan_settings=oci.vulnerability_scanning.ContainerScanRecipeScanSettingsArgs(
                scan_level=var["container_scan_recipe_scan_settings_scan_level"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["container_scan_recipe_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            image_count=var["container_scan_recipe_image_count"])
        ```

        ## Import

        ContainerScanRecipes can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:VulnerabilityScanning/containerScanRecipe:ContainerScanRecipe test_container_scan_recipe "id"
        ```

        :param str resource_name: The name of the resource.
        :param ContainerScanRecipeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerScanRecipeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_count: Optional[pulumi.Input[int]] = None,
                 scan_settings: Optional[pulumi.Input[pulumi.InputType['ContainerScanRecipeScanSettingsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerScanRecipeArgs.__new__(ContainerScanRecipeArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["image_count"] = image_count
            if scan_settings is None and not opts.urn:
                raise TypeError("Missing required property 'scan_settings'")
            __props__.__dict__["scan_settings"] = scan_settings
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ContainerScanRecipe, __self__).__init__(
            'oci:VulnerabilityScanning/containerScanRecipe:ContainerScanRecipe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            image_count: Optional[pulumi.Input[int]] = None,
            scan_settings: Optional[pulumi.Input[pulumi.InputType['ContainerScanRecipeScanSettingsArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'ContainerScanRecipe':
        """
        Get an existing ContainerScanRecipe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan recipe's compartment
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) User friendly name of container scan recipe. If not present, will be auto-generated.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] image_count: (Updatable) This field is set equal to the number of images we want to scan in the first go when the recipe is created
        :param pulumi.Input[pulumi.InputType['ContainerScanRecipeScanSettingsArgs']] scan_settings: (Updatable) A collection of container scan settings
        :param pulumi.Input[str] state: The current state of the config.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[str] time_updated: Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerScanRecipeState.__new__(_ContainerScanRecipeState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image_count"] = image_count
        __props__.__dict__["scan_settings"] = scan_settings
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ContainerScanRecipe(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan recipe's compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) User friendly name of container scan recipe. If not present, will be auto-generated.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> pulumi.Output[int]:
        """
        (Updatable) This field is set equal to the number of images we want to scan in the first go when the recipe is created
        """
        return pulumi.get(self, "image_count")

    @property
    @pulumi.getter(name="scanSettings")
    def scan_settings(self) -> pulumi.Output['outputs.ContainerScanRecipeScanSettings']:
        """
        (Updatable) A collection of container scan settings
        """
        return pulumi.get(self, "scan_settings")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")

