"""
    Merge Ticketing API

    The unified API for building rich integrations with multiple Ticketing platforms.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: hello@merge.dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from MergePythonSDK.shared.api_client import ApiClient, Endpoint as _Endpoint
from MergePythonSDK.shared.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from MergePythonSDK.ticketing.model.meta_response import MetaResponse
from MergePythonSDK.shared.model.merge_paginated_response import MergePaginatedResponse
from MergePythonSDK.ticketing.model.ticket import Ticket
from MergePythonSDK.ticketing.model.user import User
from MergePythonSDK.ticketing.model.patched_ticket_endpoint_request import PatchedTicketEndpointRequest
from MergePythonSDK.ticketing.model.ticket_endpoint_request import TicketEndpointRequest
from MergePythonSDK.ticketing.model.ticket_response import TicketResponse


class TicketsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.tickets_collaborators_list_endpoint = _Endpoint(
            settings={
                'response_type': (MergePaginatedResponse(User),),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ticketing/v1/tickets/{id}/collaborators',
                'operation_id': 'tickets_collaborators_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'cursor',
                    'expand',
                    'include_remote_data',
                    'page_size',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'expand',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "TEAMS": "teams"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'cursor':
                        (str,),
                    'expand':
                        (str,),
                    'include_remote_data':
                        (bool,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'cursor': 'cursor',
                    'expand': 'expand',
                    'include_remote_data': 'include_remote_data',
                    'page_size': 'page_size',
                },
                'location_map': {
                    'id': 'path',
                    'cursor': 'query',
                    'expand': 'query',
                    'include_remote_data': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.tickets_create_endpoint = _Endpoint(
            settings={
                'response_type': (TicketResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ticketing/v1/tickets',
                'operation_id': 'tickets_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'ticket_endpoint_request',
                    'is_debug_mode',
                    'run_async',
                ],
                'required': [
                    'ticket_endpoint_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ticket_endpoint_request':
                        (TicketEndpointRequest,),
                    'is_debug_mode':
                        (bool,),
                    'run_async':
                        (bool,),
                },
                'attribute_map': {
                    'is_debug_mode': 'is_debug_mode',
                    'run_async': 'run_async',
                },
                'location_map': {
                    'ticket_endpoint_request': 'body',
                    'is_debug_mode': 'query',
                    'run_async': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.tickets_list_endpoint = _Endpoint(
            settings={
                'response_type': (MergePaginatedResponse(Ticket),),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ticketing/v1/tickets',
                'operation_id': 'tickets_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'assignee_ids',
                    'completed_after',
                    'completed_before',
                    'contact_id',
                    'created_after',
                    'created_before',
                    'cursor',
                    'due_after',
                    'due_before',
                    'expand',
                    'include_deleted_data',
                    'include_remote_data',
                    'modified_after',
                    'modified_before',
                    'page_size',
                    'parent_ticket_id',
                    'priority',
                    'project_id',
                    'remote_fields',
                    'remote_id',
                    'status',
                    'tags',
                    'ticket_type',
                ],
                'required': [],
                'nullable': [
                    'completed_after',
                    'completed_before',
                    'due_after',
                    'due_before',
                    'priority',
                    'remote_id',
                    'status',
                    'ticket_type',
                ],
                'enum': [
                    'expand',
                    'priority',
                    'remote_fields',
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "ACCOUNT": "account",
                        "ACCOUNT,CONTACT": "account,contact",
                        "ACCOUNT,CONTACT,CREATOR": "account,contact,creator",
                        "ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "account,contact,creator,parent_ticket",
                        "ACCOUNT,CONTACT,PARENT_TICKET": "account,contact,parent_ticket",
                        "ACCOUNT,CREATOR": "account,creator",
                        "ACCOUNT,CREATOR,PARENT_TICKET": "account,creator,parent_ticket",
                        "ACCOUNT,PARENT_TICKET": "account,parent_ticket",
                        "ASSIGNEES": "assignees",
                        "ASSIGNEES,ACCOUNT": "assignees,account",
                        "ASSIGNEES,ACCOUNT,CONTACT": "assignees,account,contact",
                        "ASSIGNEES,ACCOUNT,CONTACT,CREATOR": "assignees,account,contact,creator",
                        "ASSIGNEES,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "assignees,account,contact,creator,parent_ticket",
                        "ASSIGNEES,ACCOUNT,CONTACT,PARENT_TICKET": "assignees,account,contact,parent_ticket",
                        "ASSIGNEES,ACCOUNT,CREATOR": "assignees,account,creator",
                        "ASSIGNEES,ACCOUNT,CREATOR,PARENT_TICKET": "assignees,account,creator,parent_ticket",
                        "ASSIGNEES,ACCOUNT,PARENT_TICKET": "assignees,account,parent_ticket",
                        "ASSIGNEES,CONTACT": "assignees,contact",
                        "ASSIGNEES,CONTACT,CREATOR": "assignees,contact,creator",
                        "ASSIGNEES,CONTACT,CREATOR,PARENT_TICKET": "assignees,contact,creator,parent_ticket",
                        "ASSIGNEES,CONTACT,PARENT_TICKET": "assignees,contact,parent_ticket",
                        "ASSIGNEES,CREATOR": "assignees,creator",
                        "ASSIGNEES,CREATOR,PARENT_TICKET": "assignees,creator,parent_ticket",
                        "ASSIGNEES,PARENT_TICKET": "assignees,parent_ticket",
                        "ASSIGNEES,PROJECT": "assignees,project",
                        "ASSIGNEES,PROJECT,ACCOUNT": "assignees,project,account",
                        "ASSIGNEES,PROJECT,ACCOUNT,CONTACT": "assignees,project,account,contact",
                        "ASSIGNEES,PROJECT,ACCOUNT,CONTACT,CREATOR": "assignees,project,account,contact,creator",
                        "ASSIGNEES,PROJECT,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "assignees,project,account,contact,creator,parent_ticket",
                        "ASSIGNEES,PROJECT,ACCOUNT,CONTACT,PARENT_TICKET": "assignees,project,account,contact,parent_ticket",
                        "ASSIGNEES,PROJECT,ACCOUNT,CREATOR": "assignees,project,account,creator",
                        "ASSIGNEES,PROJECT,ACCOUNT,CREATOR,PARENT_TICKET": "assignees,project,account,creator,parent_ticket",
                        "ASSIGNEES,PROJECT,ACCOUNT,PARENT_TICKET": "assignees,project,account,parent_ticket",
                        "ASSIGNEES,PROJECT,CONTACT": "assignees,project,contact",
                        "ASSIGNEES,PROJECT,CONTACT,CREATOR": "assignees,project,contact,creator",
                        "ASSIGNEES,PROJECT,CONTACT,CREATOR,PARENT_TICKET": "assignees,project,contact,creator,parent_ticket",
                        "ASSIGNEES,PROJECT,CONTACT,PARENT_TICKET": "assignees,project,contact,parent_ticket",
                        "ASSIGNEES,PROJECT,CREATOR": "assignees,project,creator",
                        "ASSIGNEES,PROJECT,CREATOR,PARENT_TICKET": "assignees,project,creator,parent_ticket",
                        "ASSIGNEES,PROJECT,PARENT_TICKET": "assignees,project,parent_ticket",
                        "ATTACHMENTS": "attachments",
                        "ATTACHMENTS,ACCOUNT": "attachments,account",
                        "ATTACHMENTS,ACCOUNT,CONTACT": "attachments,account,contact",
                        "ATTACHMENTS,ACCOUNT,CONTACT,CREATOR": "attachments,account,contact,creator",
                        "ATTACHMENTS,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "attachments,account,contact,creator,parent_ticket",
                        "ATTACHMENTS,ACCOUNT,CONTACT,PARENT_TICKET": "attachments,account,contact,parent_ticket",
                        "ATTACHMENTS,ACCOUNT,CREATOR": "attachments,account,creator",
                        "ATTACHMENTS,ACCOUNT,CREATOR,PARENT_TICKET": "attachments,account,creator,parent_ticket",
                        "ATTACHMENTS,ACCOUNT,PARENT_TICKET": "attachments,account,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES": "attachments,assignees",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT": "attachments,assignees,account",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CONTACT": "attachments,assignees,account,contact",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CONTACT,CREATOR": "attachments,assignees,account,contact,creator",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "attachments,assignees,account,contact,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CONTACT,PARENT_TICKET": "attachments,assignees,account,contact,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CREATOR": "attachments,assignees,account,creator",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CREATOR,PARENT_TICKET": "attachments,assignees,account,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,PARENT_TICKET": "attachments,assignees,account,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,CONTACT": "attachments,assignees,contact",
                        "ATTACHMENTS,ASSIGNEES,CONTACT,CREATOR": "attachments,assignees,contact,creator",
                        "ATTACHMENTS,ASSIGNEES,CONTACT,CREATOR,PARENT_TICKET": "attachments,assignees,contact,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,CONTACT,PARENT_TICKET": "attachments,assignees,contact,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,CREATOR": "attachments,assignees,creator",
                        "ATTACHMENTS,ASSIGNEES,CREATOR,PARENT_TICKET": "attachments,assignees,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PARENT_TICKET": "attachments,assignees,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT": "attachments,assignees,project",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT": "attachments,assignees,project,account",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CONTACT": "attachments,assignees,project,account,contact",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CONTACT,CREATOR": "attachments,assignees,project,account,contact,creator",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "attachments,assignees,project,account,contact,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CONTACT,PARENT_TICKET": "attachments,assignees,project,account,contact,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CREATOR": "attachments,assignees,project,account,creator",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CREATOR,PARENT_TICKET": "attachments,assignees,project,account,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,PARENT_TICKET": "attachments,assignees,project,account,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CONTACT": "attachments,assignees,project,contact",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CONTACT,CREATOR": "attachments,assignees,project,contact,creator",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CONTACT,CREATOR,PARENT_TICKET": "attachments,assignees,project,contact,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CONTACT,PARENT_TICKET": "attachments,assignees,project,contact,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CREATOR": "attachments,assignees,project,creator",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CREATOR,PARENT_TICKET": "attachments,assignees,project,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,PARENT_TICKET": "attachments,assignees,project,parent_ticket",
                        "ATTACHMENTS,CONTACT": "attachments,contact",
                        "ATTACHMENTS,CONTACT,CREATOR": "attachments,contact,creator",
                        "ATTACHMENTS,CONTACT,CREATOR,PARENT_TICKET": "attachments,contact,creator,parent_ticket",
                        "ATTACHMENTS,CONTACT,PARENT_TICKET": "attachments,contact,parent_ticket",
                        "ATTACHMENTS,CREATOR": "attachments,creator",
                        "ATTACHMENTS,CREATOR,PARENT_TICKET": "attachments,creator,parent_ticket",
                        "ATTACHMENTS,PARENT_TICKET": "attachments,parent_ticket",
                        "ATTACHMENTS,PROJECT": "attachments,project",
                        "ATTACHMENTS,PROJECT,ACCOUNT": "attachments,project,account",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CONTACT": "attachments,project,account,contact",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CONTACT,CREATOR": "attachments,project,account,contact,creator",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "attachments,project,account,contact,creator,parent_ticket",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CONTACT,PARENT_TICKET": "attachments,project,account,contact,parent_ticket",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CREATOR": "attachments,project,account,creator",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CREATOR,PARENT_TICKET": "attachments,project,account,creator,parent_ticket",
                        "ATTACHMENTS,PROJECT,ACCOUNT,PARENT_TICKET": "attachments,project,account,parent_ticket",
                        "ATTACHMENTS,PROJECT,CONTACT": "attachments,project,contact",
                        "ATTACHMENTS,PROJECT,CONTACT,CREATOR": "attachments,project,contact,creator",
                        "ATTACHMENTS,PROJECT,CONTACT,CREATOR,PARENT_TICKET": "attachments,project,contact,creator,parent_ticket",
                        "ATTACHMENTS,PROJECT,CONTACT,PARENT_TICKET": "attachments,project,contact,parent_ticket",
                        "ATTACHMENTS,PROJECT,CREATOR": "attachments,project,creator",
                        "ATTACHMENTS,PROJECT,CREATOR,PARENT_TICKET": "attachments,project,creator,parent_ticket",
                        "ATTACHMENTS,PROJECT,PARENT_TICKET": "attachments,project,parent_ticket",
                        "CONTACT": "contact",
                        "CONTACT,CREATOR": "contact,creator",
                        "CONTACT,CREATOR,PARENT_TICKET": "contact,creator,parent_ticket",
                        "CONTACT,PARENT_TICKET": "contact,parent_ticket",
                        "CREATOR": "creator",
                        "CREATOR,PARENT_TICKET": "creator,parent_ticket",
                        "PARENT_TICKET": "parent_ticket",
                        "PROJECT": "project",
                        "PROJECT,ACCOUNT": "project,account",
                        "PROJECT,ACCOUNT,CONTACT": "project,account,contact",
                        "PROJECT,ACCOUNT,CONTACT,CREATOR": "project,account,contact,creator",
                        "PROJECT,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "project,account,contact,creator,parent_ticket",
                        "PROJECT,ACCOUNT,CONTACT,PARENT_TICKET": "project,account,contact,parent_ticket",
                        "PROJECT,ACCOUNT,CREATOR": "project,account,creator",
                        "PROJECT,ACCOUNT,CREATOR,PARENT_TICKET": "project,account,creator,parent_ticket",
                        "PROJECT,ACCOUNT,PARENT_TICKET": "project,account,parent_ticket",
                        "PROJECT,CONTACT": "project,contact",
                        "PROJECT,CONTACT,CREATOR": "project,contact,creator",
                        "PROJECT,CONTACT,CREATOR,PARENT_TICKET": "project,contact,creator,parent_ticket",
                        "PROJECT,CONTACT,PARENT_TICKET": "project,contact,parent_ticket",
                        "PROJECT,CREATOR": "project,creator",
                        "PROJECT,CREATOR,PARENT_TICKET": "project,creator,parent_ticket",
                        "PROJECT,PARENT_TICKET": "project,parent_ticket"
                    },
                    ('priority',): {
                        'None': None,
                        "HIGH": "HIGH",
                        "LOW": "LOW",
                        "NORMAL": "NORMAL",
                        "URGENT": "URGENT"
                    },
                    ('remote_fields',): {

                        "STATUS": "status"
                    },
                    ('status',): {
                        'None': None,
                        "CLOSED": "CLOSED",
                        "IN_PROGRESS": "IN_PROGRESS",
                        "ON_HOLD": "ON_HOLD",
                        "OPEN": "OPEN"
                    },
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'assignee_ids':
                        (str,),
                    'completed_after':
                        (datetime, none_type,),
                    'completed_before':
                        (datetime, none_type,),
                    'contact_id':
                        (str,),
                    'created_after':
                        (datetime,),
                    'created_before':
                        (datetime,),
                    'cursor':
                        (str,),
                    'due_after':
                        (datetime, none_type,),
                    'due_before':
                        (datetime, none_type,),
                    'expand':
                        (str,),
                    'include_deleted_data':
                        (bool,),
                    'include_remote_data':
                        (bool,),
                    'modified_after':
                        (datetime,),
                    'modified_before':
                        (datetime,),
                    'page_size':
                        (int,),
                    'parent_ticket_id':
                        (str,),
                    'priority':
                        (str, none_type,),
                    'project_id':
                        (str,),
                    'remote_fields':
                        (str,),
                    'remote_id':
                        (str, none_type,),
                    'status':
                        (str, none_type,),
                    'tags':
                        (str,),
                    'ticket_type':
                        (str, none_type,),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                    'assignee_ids': 'assignee_ids',
                    'completed_after': 'completed_after',
                    'completed_before': 'completed_before',
                    'contact_id': 'contact_id',
                    'created_after': 'created_after',
                    'created_before': 'created_before',
                    'cursor': 'cursor',
                    'due_after': 'due_after',
                    'due_before': 'due_before',
                    'expand': 'expand',
                    'include_deleted_data': 'include_deleted_data',
                    'include_remote_data': 'include_remote_data',
                    'modified_after': 'modified_after',
                    'modified_before': 'modified_before',
                    'page_size': 'page_size',
                    'parent_ticket_id': 'parent_ticket_id',
                    'priority': 'priority',
                    'project_id': 'project_id',
                    'remote_fields': 'remote_fields',
                    'remote_id': 'remote_id',
                    'status': 'status',
                    'tags': 'tags',
                    'ticket_type': 'ticket_type',
                },
                'location_map': {
                    'account_id': 'query',
                    'assignee_ids': 'query',
                    'completed_after': 'query',
                    'completed_before': 'query',
                    'contact_id': 'query',
                    'created_after': 'query',
                    'created_before': 'query',
                    'cursor': 'query',
                    'due_after': 'query',
                    'due_before': 'query',
                    'expand': 'query',
                    'include_deleted_data': 'query',
                    'include_remote_data': 'query',
                    'modified_after': 'query',
                    'modified_before': 'query',
                    'page_size': 'query',
                    'parent_ticket_id': 'query',
                    'priority': 'query',
                    'project_id': 'query',
                    'remote_fields': 'query',
                    'remote_id': 'query',
                    'status': 'query',
                    'tags': 'query',
                    'ticket_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.tickets_meta_patch_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (MetaResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ticketing/v1/tickets/meta/patch/{id}',
                'operation_id': 'tickets_meta_patch_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.tickets_meta_post_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (MetaResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ticketing/v1/tickets/meta/post',
                'operation_id': 'tickets_meta_post_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.tickets_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (TicketResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ticketing/v1/tickets/{id}',
                'operation_id': 'tickets_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_ticket_endpoint_request',
                    'is_debug_mode',
                    'run_async',
                ],
                'required': [
                    'id',
                    'patched_ticket_endpoint_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'patched_ticket_endpoint_request':
                        (PatchedTicketEndpointRequest,),
                    'is_debug_mode':
                        (bool,),
                    'run_async':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'is_debug_mode': 'is_debug_mode',
                    'run_async': 'run_async',
                },
                'location_map': {
                    'id': 'path',
                    'patched_ticket_endpoint_request': 'body',
                    'is_debug_mode': 'query',
                    'run_async': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.tickets_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (Ticket,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/ticketing/v1/tickets/{id}',
                'operation_id': 'tickets_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'expand',
                    'include_remote_data',
                    'remote_fields',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'expand',
                    'remote_fields',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "ACCOUNT": "account",
                        "ACCOUNT,CONTACT": "account,contact",
                        "ACCOUNT,CONTACT,CREATOR": "account,contact,creator",
                        "ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "account,contact,creator,parent_ticket",
                        "ACCOUNT,CONTACT,PARENT_TICKET": "account,contact,parent_ticket",
                        "ACCOUNT,CREATOR": "account,creator",
                        "ACCOUNT,CREATOR,PARENT_TICKET": "account,creator,parent_ticket",
                        "ACCOUNT,PARENT_TICKET": "account,parent_ticket",
                        "ASSIGNEES": "assignees",
                        "ASSIGNEES,ACCOUNT": "assignees,account",
                        "ASSIGNEES,ACCOUNT,CONTACT": "assignees,account,contact",
                        "ASSIGNEES,ACCOUNT,CONTACT,CREATOR": "assignees,account,contact,creator",
                        "ASSIGNEES,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "assignees,account,contact,creator,parent_ticket",
                        "ASSIGNEES,ACCOUNT,CONTACT,PARENT_TICKET": "assignees,account,contact,parent_ticket",
                        "ASSIGNEES,ACCOUNT,CREATOR": "assignees,account,creator",
                        "ASSIGNEES,ACCOUNT,CREATOR,PARENT_TICKET": "assignees,account,creator,parent_ticket",
                        "ASSIGNEES,ACCOUNT,PARENT_TICKET": "assignees,account,parent_ticket",
                        "ASSIGNEES,CONTACT": "assignees,contact",
                        "ASSIGNEES,CONTACT,CREATOR": "assignees,contact,creator",
                        "ASSIGNEES,CONTACT,CREATOR,PARENT_TICKET": "assignees,contact,creator,parent_ticket",
                        "ASSIGNEES,CONTACT,PARENT_TICKET": "assignees,contact,parent_ticket",
                        "ASSIGNEES,CREATOR": "assignees,creator",
                        "ASSIGNEES,CREATOR,PARENT_TICKET": "assignees,creator,parent_ticket",
                        "ASSIGNEES,PARENT_TICKET": "assignees,parent_ticket",
                        "ASSIGNEES,PROJECT": "assignees,project",
                        "ASSIGNEES,PROJECT,ACCOUNT": "assignees,project,account",
                        "ASSIGNEES,PROJECT,ACCOUNT,CONTACT": "assignees,project,account,contact",
                        "ASSIGNEES,PROJECT,ACCOUNT,CONTACT,CREATOR": "assignees,project,account,contact,creator",
                        "ASSIGNEES,PROJECT,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "assignees,project,account,contact,creator,parent_ticket",
                        "ASSIGNEES,PROJECT,ACCOUNT,CONTACT,PARENT_TICKET": "assignees,project,account,contact,parent_ticket",
                        "ASSIGNEES,PROJECT,ACCOUNT,CREATOR": "assignees,project,account,creator",
                        "ASSIGNEES,PROJECT,ACCOUNT,CREATOR,PARENT_TICKET": "assignees,project,account,creator,parent_ticket",
                        "ASSIGNEES,PROJECT,ACCOUNT,PARENT_TICKET": "assignees,project,account,parent_ticket",
                        "ASSIGNEES,PROJECT,CONTACT": "assignees,project,contact",
                        "ASSIGNEES,PROJECT,CONTACT,CREATOR": "assignees,project,contact,creator",
                        "ASSIGNEES,PROJECT,CONTACT,CREATOR,PARENT_TICKET": "assignees,project,contact,creator,parent_ticket",
                        "ASSIGNEES,PROJECT,CONTACT,PARENT_TICKET": "assignees,project,contact,parent_ticket",
                        "ASSIGNEES,PROJECT,CREATOR": "assignees,project,creator",
                        "ASSIGNEES,PROJECT,CREATOR,PARENT_TICKET": "assignees,project,creator,parent_ticket",
                        "ASSIGNEES,PROJECT,PARENT_TICKET": "assignees,project,parent_ticket",
                        "ATTACHMENTS": "attachments",
                        "ATTACHMENTS,ACCOUNT": "attachments,account",
                        "ATTACHMENTS,ACCOUNT,CONTACT": "attachments,account,contact",
                        "ATTACHMENTS,ACCOUNT,CONTACT,CREATOR": "attachments,account,contact,creator",
                        "ATTACHMENTS,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "attachments,account,contact,creator,parent_ticket",
                        "ATTACHMENTS,ACCOUNT,CONTACT,PARENT_TICKET": "attachments,account,contact,parent_ticket",
                        "ATTACHMENTS,ACCOUNT,CREATOR": "attachments,account,creator",
                        "ATTACHMENTS,ACCOUNT,CREATOR,PARENT_TICKET": "attachments,account,creator,parent_ticket",
                        "ATTACHMENTS,ACCOUNT,PARENT_TICKET": "attachments,account,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES": "attachments,assignees",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT": "attachments,assignees,account",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CONTACT": "attachments,assignees,account,contact",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CONTACT,CREATOR": "attachments,assignees,account,contact,creator",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "attachments,assignees,account,contact,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CONTACT,PARENT_TICKET": "attachments,assignees,account,contact,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CREATOR": "attachments,assignees,account,creator",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,CREATOR,PARENT_TICKET": "attachments,assignees,account,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,ACCOUNT,PARENT_TICKET": "attachments,assignees,account,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,CONTACT": "attachments,assignees,contact",
                        "ATTACHMENTS,ASSIGNEES,CONTACT,CREATOR": "attachments,assignees,contact,creator",
                        "ATTACHMENTS,ASSIGNEES,CONTACT,CREATOR,PARENT_TICKET": "attachments,assignees,contact,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,CONTACT,PARENT_TICKET": "attachments,assignees,contact,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,CREATOR": "attachments,assignees,creator",
                        "ATTACHMENTS,ASSIGNEES,CREATOR,PARENT_TICKET": "attachments,assignees,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PARENT_TICKET": "attachments,assignees,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT": "attachments,assignees,project",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT": "attachments,assignees,project,account",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CONTACT": "attachments,assignees,project,account,contact",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CONTACT,CREATOR": "attachments,assignees,project,account,contact,creator",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "attachments,assignees,project,account,contact,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CONTACT,PARENT_TICKET": "attachments,assignees,project,account,contact,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CREATOR": "attachments,assignees,project,account,creator",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,CREATOR,PARENT_TICKET": "attachments,assignees,project,account,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,ACCOUNT,PARENT_TICKET": "attachments,assignees,project,account,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CONTACT": "attachments,assignees,project,contact",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CONTACT,CREATOR": "attachments,assignees,project,contact,creator",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CONTACT,CREATOR,PARENT_TICKET": "attachments,assignees,project,contact,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CONTACT,PARENT_TICKET": "attachments,assignees,project,contact,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CREATOR": "attachments,assignees,project,creator",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,CREATOR,PARENT_TICKET": "attachments,assignees,project,creator,parent_ticket",
                        "ATTACHMENTS,ASSIGNEES,PROJECT,PARENT_TICKET": "attachments,assignees,project,parent_ticket",
                        "ATTACHMENTS,CONTACT": "attachments,contact",
                        "ATTACHMENTS,CONTACT,CREATOR": "attachments,contact,creator",
                        "ATTACHMENTS,CONTACT,CREATOR,PARENT_TICKET": "attachments,contact,creator,parent_ticket",
                        "ATTACHMENTS,CONTACT,PARENT_TICKET": "attachments,contact,parent_ticket",
                        "ATTACHMENTS,CREATOR": "attachments,creator",
                        "ATTACHMENTS,CREATOR,PARENT_TICKET": "attachments,creator,parent_ticket",
                        "ATTACHMENTS,PARENT_TICKET": "attachments,parent_ticket",
                        "ATTACHMENTS,PROJECT": "attachments,project",
                        "ATTACHMENTS,PROJECT,ACCOUNT": "attachments,project,account",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CONTACT": "attachments,project,account,contact",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CONTACT,CREATOR": "attachments,project,account,contact,creator",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "attachments,project,account,contact,creator,parent_ticket",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CONTACT,PARENT_TICKET": "attachments,project,account,contact,parent_ticket",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CREATOR": "attachments,project,account,creator",
                        "ATTACHMENTS,PROJECT,ACCOUNT,CREATOR,PARENT_TICKET": "attachments,project,account,creator,parent_ticket",
                        "ATTACHMENTS,PROJECT,ACCOUNT,PARENT_TICKET": "attachments,project,account,parent_ticket",
                        "ATTACHMENTS,PROJECT,CONTACT": "attachments,project,contact",
                        "ATTACHMENTS,PROJECT,CONTACT,CREATOR": "attachments,project,contact,creator",
                        "ATTACHMENTS,PROJECT,CONTACT,CREATOR,PARENT_TICKET": "attachments,project,contact,creator,parent_ticket",
                        "ATTACHMENTS,PROJECT,CONTACT,PARENT_TICKET": "attachments,project,contact,parent_ticket",
                        "ATTACHMENTS,PROJECT,CREATOR": "attachments,project,creator",
                        "ATTACHMENTS,PROJECT,CREATOR,PARENT_TICKET": "attachments,project,creator,parent_ticket",
                        "ATTACHMENTS,PROJECT,PARENT_TICKET": "attachments,project,parent_ticket",
                        "CONTACT": "contact",
                        "CONTACT,CREATOR": "contact,creator",
                        "CONTACT,CREATOR,PARENT_TICKET": "contact,creator,parent_ticket",
                        "CONTACT,PARENT_TICKET": "contact,parent_ticket",
                        "CREATOR": "creator",
                        "CREATOR,PARENT_TICKET": "creator,parent_ticket",
                        "PARENT_TICKET": "parent_ticket",
                        "PROJECT": "project",
                        "PROJECT,ACCOUNT": "project,account",
                        "PROJECT,ACCOUNT,CONTACT": "project,account,contact",
                        "PROJECT,ACCOUNT,CONTACT,CREATOR": "project,account,contact,creator",
                        "PROJECT,ACCOUNT,CONTACT,CREATOR,PARENT_TICKET": "project,account,contact,creator,parent_ticket",
                        "PROJECT,ACCOUNT,CONTACT,PARENT_TICKET": "project,account,contact,parent_ticket",
                        "PROJECT,ACCOUNT,CREATOR": "project,account,creator",
                        "PROJECT,ACCOUNT,CREATOR,PARENT_TICKET": "project,account,creator,parent_ticket",
                        "PROJECT,ACCOUNT,PARENT_TICKET": "project,account,parent_ticket",
                        "PROJECT,CONTACT": "project,contact",
                        "PROJECT,CONTACT,CREATOR": "project,contact,creator",
                        "PROJECT,CONTACT,CREATOR,PARENT_TICKET": "project,contact,creator,parent_ticket",
                        "PROJECT,CONTACT,PARENT_TICKET": "project,contact,parent_ticket",
                        "PROJECT,CREATOR": "project,creator",
                        "PROJECT,CREATOR,PARENT_TICKET": "project,creator,parent_ticket",
                        "PROJECT,PARENT_TICKET": "project,parent_ticket"
                    },
                    ('remote_fields',): {

                        "STATUS": "status"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'expand':
                        (str,),
                    'include_remote_data':
                        (bool,),
                    'remote_fields':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'expand': 'expand',
                    'include_remote_data': 'include_remote_data',
                    'remote_fields': 'remote_fields',
                },
                'location_map': {
                    'id': 'path',
                    'expand': 'query',
                    'include_remote_data': 'query',
                    'remote_fields': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def tickets_collaborators_list(
        self,
        id,
        **kwargs
    ) -> "MergePaginatedResponse(User)":
        """tickets_collaborators_list  # noqa: E501

        Returns a `User` object with the given `id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tickets_collaborators_list(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            cursor (str): The pagination cursor value.. [optional]
            expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional] if omitted the server will use the default value of "teams"
            include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MergePaginatedResponse(User)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.tickets_collaborators_list_endpoint.call_with_http_info(**kwargs)

    def tickets_create(
        self,
        ticket_endpoint_request,
        **kwargs
    ) -> "TicketResponse":
        """tickets_create  # noqa: E501

        Creates a `Ticket` object with the given values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tickets_create(ticket_endpoint_request, async_req=True)
        >>> result = thread.get()

        Args:
            ticket_endpoint_request (TicketEndpointRequest):

        Keyword Args:
            is_debug_mode (bool): Whether to include debug fields (such as log file links) in the response.. [optional]
            run_async (bool): Whether or not third-party updates should be run asynchronously.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TicketResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ticket_endpoint_request'] = \
            ticket_endpoint_request
        return self.tickets_create_endpoint.call_with_http_info(**kwargs)

    def tickets_list(
        self,
        **kwargs
    ) -> "MergePaginatedResponse(Ticket)":
        """tickets_list  # noqa: E501

        Returns a list of `Ticket` objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tickets_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            account_id (str): If provided, will only return tickets for this account.. [optional]
            assignee_ids (str): If provided, will only return tickets assigned to the assignee_ids; multiple assignee_ids can be separated by commas.. [optional]
            completed_after (datetime, none_type): If provided, will only return tickets completed after this datetime.. [optional]
            completed_before (datetime, none_type): If provided, will only return tickets completed before this datetime.. [optional]
            contact_id (str): If provided, will only return tickets for this contact.. [optional]
            created_after (datetime): If provided, will only return objects created after this datetime.. [optional]
            created_before (datetime): If provided, will only return objects created before this datetime.. [optional]
            cursor (str): The pagination cursor value.. [optional]
            due_after (datetime, none_type): If provided, will only return tickets due after this datetime.. [optional]
            due_before (datetime, none_type): If provided, will only return tickets due before this datetime.. [optional]
            expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional]
            include_deleted_data (bool): Whether to include data that was marked as deleted by third party webhooks.. [optional]
            include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
            modified_after (datetime): If provided, will only return objects modified after this datetime.. [optional]
            modified_before (datetime): If provided, will only return objects modified before this datetime.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            parent_ticket_id (str): If provided, will only return sub tickets of the parent_ticket_id.. [optional]
            priority (str, none_type): If provided, will only return tickets of this priority.. [optional]
            project_id (str): If provided, will only return tickets for this project.. [optional]
            remote_fields (str): Which fields should be returned in non-normalized form.. [optional] if omitted the server will use the default value of "status"
            remote_id (str, none_type): The API provider's ID for the given object.. [optional]
            status (str, none_type): If provided, will only return tickets of this status.. [optional]
            tags (str): If provided, will only return tickets matching the tags; multiple tags can be separated by commas.. [optional]
            ticket_type (str, none_type): If provided, will only return tickets of this type.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MergePaginatedResponse(Ticket)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.tickets_list_endpoint.call_with_http_info(**kwargs)

    def tickets_meta_patch_retrieve(
        self,
        id,
        **kwargs
    ) -> "MetaResponse":
        """tickets_meta_patch_retrieve  # noqa: E501

        Returns metadata for `Ticket` PATCHs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tickets_meta_patch_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MetaResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.tickets_meta_patch_retrieve_endpoint.call_with_http_info(**kwargs)

    def tickets_meta_post_retrieve(
        self,
        **kwargs
    ) -> "MetaResponse":
        """tickets_meta_post_retrieve  # noqa: E501

        Returns metadata for `Ticket` POSTs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tickets_meta_post_retrieve(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MetaResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.tickets_meta_post_retrieve_endpoint.call_with_http_info(**kwargs)

    def tickets_partial_update(
        self,
        id,
        patched_ticket_endpoint_request,
        **kwargs
    ) -> "TicketResponse":
        """tickets_partial_update  # noqa: E501

        Updates a `Ticket` object with the given `id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tickets_partial_update(id, patched_ticket_endpoint_request, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            patched_ticket_endpoint_request (PatchedTicketEndpointRequest):

        Keyword Args:
            is_debug_mode (bool): Whether to include debug fields (such as log file links) in the response.. [optional]
            run_async (bool): Whether or not third-party updates should be run asynchronously.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TicketResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['patched_ticket_endpoint_request'] = \
            patched_ticket_endpoint_request
        return self.tickets_partial_update_endpoint.call_with_http_info(**kwargs)

    def tickets_retrieve(
        self,
        id,
        **kwargs
    ) -> "Ticket":
        """tickets_retrieve  # noqa: E501

        Returns a `Ticket` object with the given `id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tickets_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional]
            include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
            remote_fields (str): Which fields should be returned in non-normalized form.. [optional] if omitted the server will use the default value of "status"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Ticket
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.tickets_retrieve_endpoint.call_with_http_info(**kwargs)

