"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'outputs can be added to the stack'(test) {
        const stack = new lib_1.Stack();
        const res = new lib_1.CfnResource(stack, 'MyResource', { type: 'R' });
        const ref = res.ref;
        new lib_1.CfnOutput(stack, 'MyOutput', {
            exportName: 'ExportName',
            value: ref,
            description: 'CfnOutput properties'
        });
        test.deepEqual(util_1.toCloudFormation(stack), { Resources: { MyResource: { Type: 'R' } },
            Outputs: { MyOutput: { Description: 'CfnOutput properties',
                    Export: { Name: 'ExportName' },
                    Value: { Ref: 'MyResource' } } } });
        test.done();
    },
    'No export is created by default'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        new lib_1.CfnOutput(stack, 'SomeOutput', { value: 'x' });
        // THEN
        test.deepEqual(util_1.toCloudFormation(stack), {
            Outputs: {
                SomeOutput: {
                    Value: 'x'
                }
            }
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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