from datalad.tests.utils import eq_

from .common import MOCKED_STUDYMINIMETA_JSONLD
from ..jsonld import JsonLdIndexer


def test_generic_json_ld_indexing():

    # Check proper indexing of generic JSON-LD description

    indexer = JsonLdIndexer("json-ld")
    generated_dict = dict(indexer.create_index(MOCKED_STUDYMINIMETA_JSONLD))
    template_dict = {
        'graph[0].CreativeWork.id': '#study',
        'graph[0].CreativeWork.name': 'A small study',
        'graph[0].CreativeWork.abstract': 'a short description of the study',
        'graph[0].CreativeWork.accountablePerson': 'a@example.com',
        'graph[0].CreativeWork.keywords[0]': 'k1',
        'graph[0].CreativeWork.keywords[1]': 'k2',
        'graph[0].CreativeWork.dateCreated': '01.01.2020',
        'graph[0].CreativeWork.description': 'end_date: 02.02.2020',
        'graph[0].CreativeWork.contributor[0].id': 'https://schema.datalad.org/person#a@example.com',
        'graph[0].CreativeWork.contributor[1].id': 'https://schema.datalad.org/person#b@example.com',
        'graph[0].CreativeWork.funder[0].Organization.id': 'https://schema.datalad.org/organization#DFG',
        'graph[0].CreativeWork.funder[0].Organization.name': 'DFG',
        'graph[0].CreativeWork.funder[1].Organization.id': 'https://schema.datalad.org/organization#NHO',
        'graph[0].CreativeWork.funder[1].Organization.name': 'NHO',
        'graph[1].Dataset.id': 'https://schema.datalad.org/datalad_dataset#id-0000--0000',
        'graph[1].Dataset.version': 'a02312398324778972389472834',
        'graph[1].Dataset.name': 'Datenddaslk',
        'graph[1].Dataset.url': 'http://dlksdfs.comom.com',
        'graph[1].Dataset.description': 'Some data I collected once upon a time, spending hours and hours in dark places.',
        'graph[1].Dataset.keywords[0]': 'd_k1',
        'graph[1].Dataset.keywords[1]': 'd_k2',
        'graph[1].Dataset.keywords[2]': 'd_k3',
        'graph[1].Dataset.author[0].id': 'https://schema.datalad.org/person#a@example.com',
        'graph[1].Dataset.author[1].id': 'https://schema.datalad.org/person#b@example.com',
        'graph[1].Dataset.funder[0].Organization.id': 'https://schema.datalad.org/organization#DFG',
        'graph[1].Dataset.funder[0].Organization.name': 'ds-funder-1',
        'graph[1].Dataset.funder[1].Organization.id': 'https://schema.datalad.org/organization#NHO',
        'graph[1].Dataset.funder[1].Organization.name': 'ds-funder-2',
        'graph[1].Dataset.hasPart.DefinedTermSet.id': '#standards',
        'graph[1].Dataset.hasPart.DefinedTermSet.hasDefinedTerm[0].DefinedTerm.id': 'https://schema.datalad.org/standard#dicom',
        'graph[1].Dataset.hasPart.DefinedTermSet.hasDefinedTerm[0].DefinedTerm.termCode': 'dicom',
        'graph[1].Dataset.hasPart.DefinedTermSet.hasDefinedTerm[1].DefinedTerm.id': 'https://schema.datalad.org/standard#ebdsi',
        'graph[1].Dataset.hasPart.DefinedTermSet.hasDefinedTerm[1].DefinedTerm.termCode': 'ebdsi',
        'graph[2].#personList[0].Person.id': 'https://schema.datalad.org/person#a@example.com',
        'graph[2].#personList[0].Person.email': 'a@example.com',
        'graph[2].#personList[0].Person.name': 'Prof. Dr.  Alex Meyer',
        'graph[2].#personList[0].Person.givenName': 'Alex',
        'graph[2].#personList[0].Person.familyName': 'Meyer',
        'graph[2].#personList[0].Person.sameAs': '0000-0001-0002-0033',
        'graph[2].#personList[0].Person.honorificSuffix': 'Prof. Dr.',
        'graph[2].#personList[0].Person.affiliation': 'Big Old University',
        'graph[2].#personList[0].Person.contactPoint.ContactPoint.id': '#contactPoint(a@example.com)',
        'graph[2].#personList[0].Person.contactPoint.ContactPoint.description': 'Corner broadway and main',
        'graph[2].#personList[1].Person.id': 'https://schema.datalad.org/person#b@example.com',
        'graph[2].#personList[1].Person.email': 'b@example.com',
        'graph[2].#personList[1].Person.name': 'MD  Bernd Muller',
        'graph[2].#personList[1].Person.givenName': 'Bernd',
        'graph[2].#personList[1].Person.familyName': 'Muller',
        'graph[2].#personList[1].Person.sameAs': '0000-0001-0002-0034',
        'graph[2].#personList[1].Person.honorificSuffix': 'MD',
        'graph[2].#personList[1].Person.affiliation': 'RRU-SSLT',
        'graph[2].#personList[1].Person.contactPoint.ContactPoint.id': '#contactPoint(b@example.com)',
        'graph[2].#personList[1].Person.contactPoint.ContactPoint.description': 'central plaza',
        'graph[2].id': '#personList',
        'graph[3].#publicationList[0].ScholarlyArticle.id': '#publication[0]',
        'graph[3].#publicationList[0].ScholarlyArticle.headline': 'Publication Numero Unos',
        'graph[3].#publicationList[0].ScholarlyArticle.datePublished': '2001',
        'graph[3].#publicationList[0].ScholarlyArticle.author[0].id': 'https://schema.datalad.org/person#a@example.com',
        'graph[3].#publicationList[0].ScholarlyArticle.author[1].id': 'https://schema.datalad.org/person#b@example.com',
        'graph[3].#publicationList[0].ScholarlyArticle.publisher.Organization.id': 'https://schema.datalad.org/publisher#Renato',
        'graph[3].#publicationList[0].ScholarlyArticle.publisher.Organization.name': 'Renato',
        'graph[3].#publicationList[0].ScholarlyArticle.isPartOf.PublicationIssue.id': '#issue(4)',
        'graph[3].#publicationList[0].ScholarlyArticle.isPartOf.PublicationIssue.issueNumber': '4',
        'graph[3].#publicationList[0].ScholarlyArticle.isPartOf.PublicationIssue.isPartOf.PublicationVolume.id': '#volume(30)',
        'graph[3].#publicationList[0].ScholarlyArticle.isPartOf.PublicationIssue.isPartOf.PublicationVolume.volumeNumber': '30',
        'graph[3].#publicationList[1].ScholarlyArticle.id': '#publication[1]',
        'graph[3].#publicationList[1].ScholarlyArticle.headline': 'Publication Numero Dos',
        'graph[3].#publicationList[1].ScholarlyArticle.datePublished': '2002',
        'graph[3].#publicationList[1].ScholarlyArticle.author[0].id': 'https://schema.datalad.org/person#a@example.com',
        'graph[3].#publicationList[1].ScholarlyArticle.author[1].id': 'https://schema.datalad.org/person#b@example.com',
        'graph[3].#publicationList[1].ScholarlyArticle.publisher.Organization.id': 'https://schema.datalad.org/publisher#Vorndran',
        'graph[3].#publicationList[1].ScholarlyArticle.publisher.Organization.name': 'Vorndran',
        'graph[3].#publicationList[1].ScholarlyArticle.isPartOf.PublicationVolume.id': '#volume(400)',
        'graph[3].#publicationList[1].ScholarlyArticle.isPartOf.PublicationVolume.volumeNumber': '400',
        'graph[3].#publicationList[2].ScholarlyArticle.id': '#publication[2]',
        'graph[3].#publicationList[2].ScholarlyArticle.headline': 'Publication Numero Tres',
        'graph[3].#publicationList[2].ScholarlyArticle.datePublished': '2003',
        'graph[3].#publicationList[2].ScholarlyArticle.author[0].id': 'https://schema.datalad.org/person#a@example.com',
        'graph[3].#publicationList[2].ScholarlyArticle.author[1].id': 'https://schema.datalad.org/person#b@example.com',
        'graph[3].#publicationList[2].ScholarlyArticle.publisher.Organization.id': 'https://schema.datalad.org/publisher#Eisenberg',
        'graph[3].#publicationList[2].ScholarlyArticle.publisher.Organization.name': 'Eisenberg',
        'graph[3].#publicationList[2].ScholarlyArticle.isPartOf.PublicationIssue.id': '#issue(500)',
        'graph[3].#publicationList[2].ScholarlyArticle.isPartOf.PublicationIssue.issueNumber': '500',
        'graph[3].#publicationList[3].ScholarlyArticle.id': '#publication[3]',
        'graph[3].#publicationList[3].ScholarlyArticle.headline': 'Publication Numero Quatro',
        'graph[3].#publicationList[3].ScholarlyArticle.datePublished': '2004',
        'graph[3].#publicationList[3].ScholarlyArticle.author[0].id': 'https://schema.datalad.org/person#a@example.com',
        'graph[3].#publicationList[3].ScholarlyArticle.author[1].id': 'https://schema.datalad.org/person#b@example.com',
        'graph[3].#publicationList[3].ScholarlyArticle.publisher.Organization.id': 'https://schema.datalad.org/publisher#Killian-Tumler',
        'graph[3].#publicationList[3].ScholarlyArticle.publisher.Organization.name': 'Killian-Tumler',
        'graph[3].id': '#publicationList'}
    eq_(generated_dict, template_dict)
