"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing
import vdp.pipeline.v1beta.connector_definition_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Connector(google.protobuf.message.Message):
    """A Connector is a type of pipeline component that queries, processes or sends
    the ingested unstructured data to a service or app. Users need to configure
    their connectors (e.g. by providing an API token to a remote service).

    For more information, see
    [Component](https://www.instill.tech/docs/latest/core/concepts/pipeline#pipeline-component)
    in the official documentation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _View:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Connector._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: Connector._View.ValueType  # 0
        """Unspecified, equivalent to BASIC."""
        VIEW_BASIC: Connector._View.ValueType  # 1
        """Default view, only includes basic information."""
        VIEW_FULL: Connector._View.ValueType  # 2
        """Full representation."""
        VIEW_CONFIGURATION: Connector._View.ValueType  # 3
        """Contains the connector configuration."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """View defines how a connector is presented."""

    VIEW_UNSPECIFIED: Connector.View.ValueType  # 0
    """Unspecified, equivalent to BASIC."""
    VIEW_BASIC: Connector.View.ValueType  # 1
    """Default view, only includes basic information."""
    VIEW_FULL: Connector.View.ValueType  # 2
    """Full representation."""
    VIEW_CONFIGURATION: Connector.View.ValueType  # 3
    """Contains the connector configuration."""

    class _State:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Connector._State.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATE_UNSPECIFIED: Connector._State.ValueType  # 0
        """Unspecified."""
        STATE_DISCONNECTED: Connector._State.ValueType  # 1
        """Disconnected."""
        STATE_CONNECTED: Connector._State.ValueType  # 2
        """Connected."""
        STATE_ERROR: Connector._State.ValueType  # 3
        """The connector suffered an error."""

    class State(_State, metaclass=_StateEnumTypeWrapper):
        """State describes the state of the connector."""

    STATE_UNSPECIFIED: Connector.State.ValueType  # 0
    """Unspecified."""
    STATE_DISCONNECTED: Connector.State.ValueType  # 1
    """Disconnected."""
    STATE_CONNECTED: Connector.State.ValueType  # 2
    """Connected."""
    STATE_ERROR: Connector.State.ValueType  # 3
    """The connector suffered an error."""

    class _Visibility:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisibilityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Connector._Visibility.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VISIBILITY_UNSPECIFIED: Connector._Visibility.ValueType  # 0
        """Unspecified, equivalent to PRIVATE."""
        VISIBILITY_PRIVATE: Connector._Visibility.ValueType  # 1
        """Only the user can see the connector."""
        VISIBILITY_PUBLIC: Connector._Visibility.ValueType  # 2
        """Other users can see the connector."""

    class Visibility(_Visibility, metaclass=_VisibilityEnumTypeWrapper):
        """Visibility defines who can access the connector."""

    VISIBILITY_UNSPECIFIED: Connector.Visibility.ValueType  # 0
    """Unspecified, equivalent to PRIVATE."""
    VISIBILITY_PRIVATE: Connector.Visibility.ValueType  # 1
    """Only the user can see the connector."""
    VISIBILITY_PUBLIC: Connector.Visibility.ValueType  # 2
    """Other users can see the connector."""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CONNECTOR_DEFINITION_NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    TOMBSTONE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    CONNECTOR_DEFINITION_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    OWNER_NAME_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the connector, defined by its ID.
    - Format: `connectors/{id}`.
    """
    uid: builtins.str
    """Connector UUID."""
    id: builtins.str
    """Connector resource ID (used in the name as the last segment). This conforms
    to RFC-1034, which restricts to letters, numbers, and hyphen, with the
    first character a letter, the last a letter or a number, and a 63
    character maximum.
    """
    connector_definition_name: builtins.str
    """ConnectorDefinition that describes the connector configuration."""
    type: vdp.pipeline.v1beta.connector_definition_pb2.ConnectorType.ValueType
    """Connector type."""
    description: builtins.str
    """Connector description."""
    @property
    def configuration(self) -> google.protobuf.struct_pb2.Struct:
        """Connector configuration in JSON format."""
    state: global___Connector.State.ValueType
    """Connector state."""
    tombstone: builtins.bool
    """Connector tombstone. If true, this configuration is permanently off.
    Otherwise, the configuration is active.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Connector creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Connector update time."""
    visibility: global___Connector.Visibility.ValueType
    """Connector visibility."""
    @property
    def connector_definition(self) -> vdp.pipeline.v1beta.connector_definition_pb2.ConnectorDefinition:
        """Embed content of the ConnectorDefinition."""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Connector deletion time."""
    owner_name: builtins.str
    """Owner name."""
    @property
    def owner(self) -> google.protobuf.struct_pb2.Struct:
        """Owner details."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        connector_definition_name: builtins.str = ...,
        type: vdp.pipeline.v1beta.connector_definition_pb2.ConnectorType.ValueType = ...,
        description: builtins.str | None = ...,
        configuration: google.protobuf.struct_pb2.Struct | None = ...,
        state: global___Connector.State.ValueType = ...,
        tombstone: builtins.bool = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        visibility: global___Connector.Visibility.ValueType = ...,
        connector_definition: vdp.pipeline.v1beta.connector_definition_pb2.ConnectorDefinition | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        owner_name: builtins.str = ...,
        owner: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "configuration", b"configuration", "connector_definition", b"connector_definition", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "owner", b"owner", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "configuration", b"configuration", "connector_definition", b"connector_definition", "connector_definition_name", b"connector_definition_name", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "id", b"id", "name", b"name", "owner", b"owner", "owner_name", b"owner_name", "state", b"state", "tombstone", b"tombstone", "type", b"type", "uid", b"uid", "update_time", b"update_time", "visibility", b"visibility"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...

global___Connector = Connector

@typing_extensions.final
class ListConnectorsRequest(google.protobuf.message.Message):
    """/////////////////////////////////////////////////////////////////////
    RPC messages
    /////////////////////////////////////////////////////////////////////

    ListConnectorsRequest represents a request to list
    connectors
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of connectors to return. The service may return fewer
    than this value. If unspecified, at most 10 connectors will be returned.
    The maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___Connector.View.ValueType
    """Connector view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list connectors"""
    show_deleted: builtins.bool
    """Return soft_deleted connectors"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Connector.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListConnectorsRequest = ListConnectorsRequest

@typing_extensions.final
class ListConnectorsResponse(google.protobuf.message.Message):
    """ListConnectorsResponse represents a response for a list of
    connectors
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTORS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def connectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Connector]:
        """A list of connectors"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of connectors"""
    def __init__(
        self,
        *,
        connectors: collections.abc.Iterable[global___Connector] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connectors", b"connectors", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListConnectorsResponse = ListConnectorsResponse

@typing_extensions.final
class LookUpConnectorRequest(google.protobuf.message.Message):
    """LookUpConnectorRequest represents a request by an admin to query a connector
    by its UID.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the connector, which allows its access by UID.
    - Format: `connectors/{uid}`.
    """
    view: global___Connector.View.ValueType
    """View allows clients to specify the desired connector view in the response."""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___Connector.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpConnectorRequest = LookUpConnectorRequest

@typing_extensions.final
class LookUpConnectorResponse(google.protobuf.message.Message):
    """LookUpConnectorResponse represents a response for a connector."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """The requested connector."""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___LookUpConnectorResponse = LookUpConnectorResponse

@typing_extensions.final
class CreateUserConnectorRequest(google.protobuf.message.Message):
    """CreateUserConnectorRequest represents a request to create a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    parent: builtins.str
    """The parent resource where this connector will be created.
    Format: users/{users}
    """
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector", "parent", b"parent"]) -> None: ...

global___CreateUserConnectorRequest = CreateUserConnectorRequest

@typing_extensions.final
class CreateUserConnectorResponse(google.protobuf.message.Message):
    """CreateUserConnectorResponse represents a response for a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___CreateUserConnectorResponse = CreateUserConnectorResponse

@typing_extensions.final
class ListUserConnectorsRequest(google.protobuf.message.Message):
    """ListUserConnectorsRequest represents a request to list
    connectors
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of connectors to return. The service may return fewer
    than this value. If unspecified, at most 10 connectors will be returned.
    The maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___Connector.View.ValueType
    """Connector view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list connectors"""
    parent: builtins.str
    """The parent resource where this connector will be created.
    Format: users/{users}
    """
    show_deleted: builtins.bool
    """Return soft_deleted connectors"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Connector.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUserConnectorsRequest = ListUserConnectorsRequest

@typing_extensions.final
class ListUserConnectorsResponse(google.protobuf.message.Message):
    """ListUserConnectorsResponse represents a response for a list of
    connectors
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTORS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def connectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Connector]:
        """A list of connectors"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of connectors"""
    def __init__(
        self,
        *,
        connectors: collections.abc.Iterable[global___Connector] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connectors", b"connectors", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListUserConnectorsResponse = ListUserConnectorsResponse

@typing_extensions.final
class GetUserConnectorRequest(google.protobuf.message.Message):
    """GetUserConnectorRequest represents a request to query a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Connectorconnector name. It must have the format of
    "connectors/*"
    """
    view: global___Connector.View.ValueType
    """Connector view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Connector.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserConnectorRequest = GetUserConnectorRequest

@typing_extensions.final
class GetUserConnectorResponse(google.protobuf.message.Message):
    """GetUserConnectorResponse represents a response for a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___GetUserConnectorResponse = GetUserConnectorResponse

@typing_extensions.final
class UpdateUserConnectorRequest(google.protobuf.message.Message):
    """UpdateUserConnectorRequest represents a request to update a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Update mask for a connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserConnectorRequest = UpdateUserConnectorRequest

@typing_extensions.final
class UpdateUserConnectorResponse(google.protobuf.message.Message):
    """UpdateUserConnectorResponse represents a response for a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___UpdateUserConnectorResponse = UpdateUserConnectorResponse

@typing_extensions.final
class DeleteUserConnectorRequest(google.protobuf.message.Message):
    """DeleteUserConnectorRequest represents a request to delete a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserConnectorRequest = DeleteUserConnectorRequest

@typing_extensions.final
class DeleteUserConnectorResponse(google.protobuf.message.Message):
    """DeleteUserConnectorResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserConnectorResponse = DeleteUserConnectorResponse

@typing_extensions.final
class ConnectUserConnectorRequest(google.protobuf.message.Message):
    """ConnectUserConnectorRequest represents a request to connect a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ConnectUserConnectorRequest = ConnectUserConnectorRequest

@typing_extensions.final
class ConnectUserConnectorResponse(google.protobuf.message.Message):
    """ConnectUserConnectorResponse represents a connected
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """A connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___ConnectUserConnectorResponse = ConnectUserConnectorResponse

@typing_extensions.final
class DisconnectUserConnectorRequest(google.protobuf.message.Message):
    """DisconnectUserConnectorRequest represents a request to disconnect a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DisconnectUserConnectorRequest = DisconnectUserConnectorRequest

@typing_extensions.final
class DisconnectUserConnectorResponse(google.protobuf.message.Message):
    """DisconnectUserConnectorResponse represents a disconnected
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """A connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___DisconnectUserConnectorResponse = DisconnectUserConnectorResponse

@typing_extensions.final
class RenameUserConnectorRequest(google.protobuf.message.Message):
    """RenameUserConnectorRequest represents a request to rename the
    connector name
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_CONNECTOR_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    new_connector_id: builtins.str
    """Connector new resource id to replace with the
    connector name to be
    "connectors/{new_connector_id}"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_connector_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_connector_id", b"new_connector_id"]) -> None: ...

global___RenameUserConnectorRequest = RenameUserConnectorRequest

@typing_extensions.final
class RenameUserConnectorResponse(google.protobuf.message.Message):
    """RenameUserConnectorResponse represents a renamed Connector
    resource
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """A connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___RenameUserConnectorResponse = RenameUserConnectorResponse

@typing_extensions.final
class ExecuteUserConnectorRequest(google.protobuf.message.Message):
    """ExecuteUserConnectorRequest represents a private request to execution
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of a connector. For example:
    "connectors/{name}"
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Inputs"""
    task: builtins.str
    """Task"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        task: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "task", b"task"]) -> None: ...

global___ExecuteUserConnectorRequest = ExecuteUserConnectorRequest

@typing_extensions.final
class ExecuteUserConnectorResponse(google.protobuf.message.Message):
    """ExecuteUserConnectorResponse represents a response for execution
    output
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Outputs"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["outputs", b"outputs"]) -> None: ...

global___ExecuteUserConnectorResponse = ExecuteUserConnectorResponse

@typing_extensions.final
class TestUserConnectorRequest(google.protobuf.message.Message):
    """TestUserConnectorRequest represents a public request to trigger check
    action on a connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___TestUserConnectorRequest = TestUserConnectorRequest

@typing_extensions.final
class TestUserConnectorResponse(google.protobuf.message.Message):
    """TestUserConnectorResponse represents a response containing a
    connector's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___Connector.State.ValueType
    """Retrieved connector state"""
    def __init__(
        self,
        *,
        state: global___Connector.State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___TestUserConnectorResponse = TestUserConnectorResponse

@typing_extensions.final
class WatchUserConnectorRequest(google.protobuf.message.Message):
    """WatchUserConnectorRequest represents a public request to query
    a connector's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchUserConnectorRequest = WatchUserConnectorRequest

@typing_extensions.final
class WatchUserConnectorResponse(google.protobuf.message.Message):
    """WatchUserConnectorResponse represents a response to fetch a
    connector's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___Connector.State.ValueType
    """Retrieved connector state"""
    def __init__(
        self,
        *,
        state: global___Connector.State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___WatchUserConnectorResponse = WatchUserConnectorResponse

@typing_extensions.final
class CreateOrganizationConnectorRequest(google.protobuf.message.Message):
    """CreateOrganizationConnectorRequest represents a request to create a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    parent: builtins.str
    """The parent resource where this connector will be created.
    Format: organizations/{organizations}
    """
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector", "parent", b"parent"]) -> None: ...

global___CreateOrganizationConnectorRequest = CreateOrganizationConnectorRequest

@typing_extensions.final
class CreateOrganizationConnectorResponse(google.protobuf.message.Message):
    """CreateOrganizationConnectorResponse represents a response for a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___CreateOrganizationConnectorResponse = CreateOrganizationConnectorResponse

@typing_extensions.final
class ListOrganizationConnectorsRequest(google.protobuf.message.Message):
    """ListOrganizationConnectorsRequest represents a request to list
    connectors
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of connectors to return. The service may return fewer
    than this value. If unspecified, at most 10 connectors will be returned.
    The maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___Connector.View.ValueType
    """Connector view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list connectors"""
    parent: builtins.str
    """The parent resource where this connector will be created.
    Format: organizations/{organizations}
    """
    show_deleted: builtins.bool
    """Return soft_deleted connectors"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Connector.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListOrganizationConnectorsRequest = ListOrganizationConnectorsRequest

@typing_extensions.final
class ListOrganizationConnectorsResponse(google.protobuf.message.Message):
    """ListOrganizationConnectorsResponse represents a response for a list of
    connectors
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTORS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def connectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Connector]:
        """A list of connectors"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of connectors"""
    def __init__(
        self,
        *,
        connectors: collections.abc.Iterable[global___Connector] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connectors", b"connectors", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationConnectorsResponse = ListOrganizationConnectorsResponse

@typing_extensions.final
class GetOrganizationConnectorRequest(google.protobuf.message.Message):
    """GetOrganizationConnectorRequest represents a request to query a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Connectorconnector name. It must have the format of
    "connectors/*"
    """
    view: global___Connector.View.ValueType
    """Connector view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Connector.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationConnectorRequest = GetOrganizationConnectorRequest

@typing_extensions.final
class GetOrganizationConnectorResponse(google.protobuf.message.Message):
    """GetOrganizationConnectorResponse represents a response for a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___GetOrganizationConnectorResponse = GetOrganizationConnectorResponse

@typing_extensions.final
class UpdateOrganizationConnectorRequest(google.protobuf.message.Message):
    """UpdateOrganizationConnectorRequest represents a request to update a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Update mask for a connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationConnectorRequest = UpdateOrganizationConnectorRequest

@typing_extensions.final
class UpdateOrganizationConnectorResponse(google.protobuf.message.Message):
    """UpdateOrganizationConnectorResponse represents a response for a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___UpdateOrganizationConnectorResponse = UpdateOrganizationConnectorResponse

@typing_extensions.final
class DeleteOrganizationConnectorRequest(google.protobuf.message.Message):
    """DeleteOrganizationConnectorRequest represents a request to delete a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationConnectorRequest = DeleteOrganizationConnectorRequest

@typing_extensions.final
class DeleteOrganizationConnectorResponse(google.protobuf.message.Message):
    """DeleteOrganizationConnectorResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationConnectorResponse = DeleteOrganizationConnectorResponse

@typing_extensions.final
class ConnectOrganizationConnectorRequest(google.protobuf.message.Message):
    """ConnectOrganizationConnectorRequest represents a request to connect a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ConnectOrganizationConnectorRequest = ConnectOrganizationConnectorRequest

@typing_extensions.final
class ConnectOrganizationConnectorResponse(google.protobuf.message.Message):
    """ConnectOrganizationConnectorResponse represents a connected
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """A connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___ConnectOrganizationConnectorResponse = ConnectOrganizationConnectorResponse

@typing_extensions.final
class DisconnectOrganizationConnectorRequest(google.protobuf.message.Message):
    """DisconnectOrganizationConnectorRequest represents a request to disconnect a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DisconnectOrganizationConnectorRequest = DisconnectOrganizationConnectorRequest

@typing_extensions.final
class DisconnectOrganizationConnectorResponse(google.protobuf.message.Message):
    """DisconnectOrganizationConnectorResponse represents a disconnected
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """A connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___DisconnectOrganizationConnectorResponse = DisconnectOrganizationConnectorResponse

@typing_extensions.final
class RenameOrganizationConnectorRequest(google.protobuf.message.Message):
    """RenameOrganizationConnectorRequest represents a request to rename the
    connector name
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_CONNECTOR_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    new_connector_id: builtins.str
    """Connector new resource id to replace with the
    connector name to be
    "connectors/{new_connector_id}"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_connector_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_connector_id", b"new_connector_id"]) -> None: ...

global___RenameOrganizationConnectorRequest = RenameOrganizationConnectorRequest

@typing_extensions.final
class RenameOrganizationConnectorResponse(google.protobuf.message.Message):
    """RenameOrganizationConnectorResponse represents a renamed Connector
    resource
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """A connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___RenameOrganizationConnectorResponse = RenameOrganizationConnectorResponse

@typing_extensions.final
class ExecuteOrganizationConnectorRequest(google.protobuf.message.Message):
    """ExecuteOrganizationConnectorRequest represents a private request to execution
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of a connector. For example:
    "connectors/{name}"
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Inputs"""
    task: builtins.str
    """Task"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        task: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "task", b"task"]) -> None: ...

global___ExecuteOrganizationConnectorRequest = ExecuteOrganizationConnectorRequest

@typing_extensions.final
class ExecuteOrganizationConnectorResponse(google.protobuf.message.Message):
    """ExecuteOrganizationConnectorResponse represents a response for execution
    output
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Outputs"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["outputs", b"outputs"]) -> None: ...

global___ExecuteOrganizationConnectorResponse = ExecuteOrganizationConnectorResponse

@typing_extensions.final
class TestOrganizationConnectorRequest(google.protobuf.message.Message):
    """TestOrganizationConnectorRequest represents a public request to trigger check
    action on a connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___TestOrganizationConnectorRequest = TestOrganizationConnectorRequest

@typing_extensions.final
class TestOrganizationConnectorResponse(google.protobuf.message.Message):
    """TestOrganizationConnectorResponse represents a response containing a
    connector's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___Connector.State.ValueType
    """Retrieved connector state"""
    def __init__(
        self,
        *,
        state: global___Connector.State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___TestOrganizationConnectorResponse = TestOrganizationConnectorResponse

@typing_extensions.final
class WatchOrganizationConnectorRequest(google.protobuf.message.Message):
    """WatchOrganizationConnectorRequest represents a public request to query
    a connector's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """connector name. It must have the format of
    "connectors/*"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchOrganizationConnectorRequest = WatchOrganizationConnectorRequest

@typing_extensions.final
class WatchOrganizationConnectorResponse(google.protobuf.message.Message):
    """WatchOrganizationConnectorResponse represents a response to fetch a
    connector's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___Connector.State.ValueType
    """Retrieved connector state"""
    def __init__(
        self,
        *,
        state: global___Connector.State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___WatchOrganizationConnectorResponse = WatchOrganizationConnectorResponse

@typing_extensions.final
class ListConnectorsAdminRequest(google.protobuf.message.Message):
    """========== Private endpoints

    ListConnectorsAdminRequest represents a request by an admin to list all
    connectors. Admin users have access to connectors from any user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of connectors to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Connector.View.ValueType
    """View allows clients to specify the desired connector view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Connector.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListConnectorsAdminRequest = ListConnectorsAdminRequest

@typing_extensions.final
class ListConnectorsAdminResponse(google.protobuf.message.Message):
    """ListConnectorsAdminResponse contains a list of connectors requested by an
    admin.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTORS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def connectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Connector]:
        """A list of connectors."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of connectors."""
    def __init__(
        self,
        *,
        connectors: collections.abc.Iterable[global___Connector] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connectors", b"connectors", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListConnectorsAdminResponse = ListConnectorsAdminResponse

@typing_extensions.final
class LookUpConnectorAdminRequest(google.protobuf.message.Message):
    """LookUpConnectorAdminRequest represents a request to query a
    connector via permalink by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a connector. For example:
    "connectors/{uid}"
    """
    view: global___Connector.View.ValueType
    """Connector view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___Connector.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpConnectorAdminRequest = LookUpConnectorAdminRequest

@typing_extensions.final
class LookUpConnectorAdminResponse(google.protobuf.message.Message):
    """LookUpConnectorAdminResponse represents a response for a
    connector
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_FIELD_NUMBER: builtins.int
    @property
    def connector(self) -> global___Connector:
        """connector"""
    def __init__(
        self,
        *,
        connector: global___Connector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector", b"connector"]) -> None: ...

global___LookUpConnectorAdminResponse = LookUpConnectorAdminResponse

@typing_extensions.final
class CheckConnectorRequest(google.protobuf.message.Message):
    """CheckConnectorRequest represents a request to check the current state of a
    connector.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the connector, which allows its access by UID.
    - Format: `connectors/{uid}`.
    """
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["permalink", b"permalink"]) -> None: ...

global___CheckConnectorRequest = CheckConnectorRequest

@typing_extensions.final
class CheckConnectorResponse(google.protobuf.message.Message):
    """CheckConnectorResponse contains the connector's current state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___Connector.State.ValueType
    """Connector state."""
    def __init__(
        self,
        *,
        state: global___Connector.State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___CheckConnectorResponse = CheckConnectorResponse
