"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.healthcheck.v1beta.healthcheck_pb2
import google.longrunning.operations_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing
import vdp.pipeline.v1beta.common_pb2
import vdp.pipeline.v1beta.connector_definition_pb2
import vdp.pipeline.v1beta.connector_pb2
import vdp.pipeline.v1beta.operator_definition_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ComponentType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ComponentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ComponentType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    COMPONENT_TYPE_UNSPECIFIED: _ComponentType.ValueType  # 0
    """TYPE_UNSPECIFIED"""
    COMPONENT_TYPE_CONNECTOR_AI: _ComponentType.ValueType  # 1
    """CONNECTOR_AI"""
    COMPONENT_TYPE_CONNECTOR_DATA: _ComponentType.ValueType  # 2
    """CONNECTOR_DATA"""
    COMPONENT_TYPE_CONNECTOR_BLOCKCHAIN: _ComponentType.ValueType  # 3
    """CONNECTOR_BLOCKCHAIN"""
    COMPONENT_TYPE_OPERATOR: _ComponentType.ValueType  # 4
    """CONNECTOR_OPERATOR"""

class ComponentType(_ComponentType, metaclass=_ComponentTypeEnumTypeWrapper):
    """ComponentType"""

COMPONENT_TYPE_UNSPECIFIED: ComponentType.ValueType  # 0
"""TYPE_UNSPECIFIED"""
COMPONENT_TYPE_CONNECTOR_AI: ComponentType.ValueType  # 1
"""CONNECTOR_AI"""
COMPONENT_TYPE_CONNECTOR_DATA: ComponentType.ValueType  # 2
"""CONNECTOR_DATA"""
COMPONENT_TYPE_CONNECTOR_BLOCKCHAIN: ComponentType.ValueType  # 3
"""CONNECTOR_BLOCKCHAIN"""
COMPONENT_TYPE_OPERATOR: ComponentType.ValueType  # 4
"""CONNECTOR_OPERATOR"""
global___ComponentType = ComponentType

class _State:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_State.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STATE_UNSPECIFIED: _State.ValueType  # 0
    """State: UNSPECIFIED"""
    STATE_INACTIVE: _State.ValueType  # 1
    """State INACTIVE indicates the pipeline is inactive"""
    STATE_ACTIVE: _State.ValueType  # 2
    """State ACTIVE indicates the pipeline is active"""
    STATE_ERROR: _State.ValueType  # 3
    """State ERROR indicates the pipeline has error"""

class State(_State, metaclass=_StateEnumTypeWrapper):
    """State enumerates the state of a pipeline"""

STATE_UNSPECIFIED: State.ValueType  # 0
"""State: UNSPECIFIED"""
STATE_INACTIVE: State.ValueType  # 1
"""State INACTIVE indicates the pipeline is inactive"""
STATE_ACTIVE: State.ValueType  # 2
"""State ACTIVE indicates the pipeline is active"""
STATE_ERROR: State.ValueType  # 3
"""State ERROR indicates the pipeline has error"""
global___State = State

@typing_extensions.final
class LivenessRequest(google.protobuf.message.Message):
    """LivenessRequest represents a request to check a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___LivenessRequest = LivenessRequest

@typing_extensions.final
class LivenessResponse(google.protobuf.message.Message):
    """LivenessResponse represents a response for a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___LivenessResponse = LivenessResponse

@typing_extensions.final
class ReadinessRequest(google.protobuf.message.Message):
    """ReadinessRequest represents a request to check a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___ReadinessRequest = ReadinessRequest

@typing_extensions.final
class ReadinessResponse(google.protobuf.message.Message):
    """ReadinessResponse represents a response for a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___ReadinessResponse = ReadinessResponse

@typing_extensions.final
class Component(google.protobuf.message.Message):
    """Represents a pipeline component"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    RESOURCE_NAME_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DEFINITION_NAME_FIELD_NUMBER: builtins.int
    OPERATOR_DEFINITION_FIELD_NUMBER: builtins.int
    CONNECTOR_DEFINITION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Component id that is given by the users"""
    resource_name: builtins.str
    """A pipeline component resource name"""
    @property
    def resource(self) -> vdp.pipeline.v1beta.connector_pb2.Connector:
        """A pipeline component resource detail"""
    @property
    def configuration(self) -> google.protobuf.struct_pb2.Struct:
        """Configuration for the pipeline component"""
    type: global___ComponentType.ValueType
    """Resource Type"""
    definition_name: builtins.str
    """A pipeline component definition name"""
    @property
    def operator_definition(self) -> vdp.pipeline.v1beta.operator_definition_pb2.OperatorDefinition:
        """operator definition detail"""
    @property
    def connector_definition(self) -> vdp.pipeline.v1beta.connector_definition_pb2.ConnectorDefinition:
        """connector definition detail"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        resource_name: builtins.str = ...,
        resource: vdp.pipeline.v1beta.connector_pb2.Connector | None = ...,
        configuration: google.protobuf.struct_pb2.Struct | None = ...,
        type: global___ComponentType.ValueType = ...,
        definition_name: builtins.str = ...,
        operator_definition: vdp.pipeline.v1beta.operator_definition_pb2.OperatorDefinition | None = ...,
        connector_definition: vdp.pipeline.v1beta.connector_definition_pb2.ConnectorDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["configuration", b"configuration", "connector_definition", b"connector_definition", "definition", b"definition", "operator_definition", b"operator_definition", "resource", b"resource"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["configuration", b"configuration", "connector_definition", b"connector_definition", "definition", b"definition", "definition_name", b"definition_name", "id", b"id", "operator_definition", b"operator_definition", "resource", b"resource", "resource_name", b"resource_name", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["definition", b"definition"]) -> typing_extensions.Literal["operator_definition", "connector_definition"] | None: ...

global___Component = Component

@typing_extensions.final
class Recipe(google.protobuf.message.Message):
    """Pipeline represents a pipeline recipe"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    COMPONENTS_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Recipe schema version"""
    @property
    def components(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Component]:
        """List of pipeline components"""
    def __init__(
        self,
        *,
        version: builtins.str = ...,
        components: collections.abc.Iterable[global___Component] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["components", b"components", "version", b"version"]) -> None: ...

global___Recipe = Recipe

@typing_extensions.final
class Pipeline(google.protobuf.message.Message):
    """A Pipeline is an end-to-end workflow that automates a sequence of components
    to process data.

    For more information, see
    [Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline) in
    the official documentation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _View:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Pipeline._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: Pipeline._View.ValueType  # 0
        """Unspecified, equivalent to BASIC."""
        VIEW_BASIC: Pipeline._View.ValueType  # 1
        """Default view, only includes basic information."""
        VIEW_FULL: Pipeline._View.ValueType  # 2
        """Full representation."""
        VIEW_RECIPE: Pipeline._View.ValueType  # 3
        """Contains the recipe of the resource."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """View defines how a Pipeline is presented."""

    VIEW_UNSPECIFIED: Pipeline.View.ValueType  # 0
    """Unspecified, equivalent to BASIC."""
    VIEW_BASIC: Pipeline.View.ValueType  # 1
    """Default view, only includes basic information."""
    VIEW_FULL: Pipeline.View.ValueType  # 2
    """Full representation."""
    VIEW_RECIPE: Pipeline.View.ValueType  # 3
    """Contains the recipe of the resource."""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RECIPE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    OPENAPI_SCHEMA_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    SHARING_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    OWNER_NAME_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    RELEASES_FIELD_NUMBER: builtins.int
    README_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the pipeline, defined by its owner and ID.
    - Format: `users/{user}/pipelines/{id}`.
    """
    uid: builtins.str
    """Pipeline UUID."""
    id: builtins.str
    """Pipeline resource ID (used in the name as the last segment). This conforms
    to RFC-1034, which restricts to letters, numbers, and hyphen, with the
    first character a letter, the last a letter or a number, and a 63
    character maximum.
    """
    description: builtins.str
    """Pipeline description."""
    @property
    def recipe(self) -> global___Recipe:
        """Recipe describes the components of a Pipeline and how they are connected."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline update time."""
    @property
    def openapi_schema(self) -> google.protobuf.struct_pb2.Struct:
        """OpenAPI schema."""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline delete time."""
    @property
    def sharing(self) -> vdp.pipeline.v1beta.common_pb2.Sharing:
        """Pipeline sharing."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Metadata: store Console-related data such as pipeline builder layout."""
    owner_name: builtins.str
    """Owner Name."""
    @property
    def owner(self) -> google.protobuf.struct_pb2.Struct:
        """Owner details."""
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """Releases."""
    readme: builtins.str
    """README."""
    @property
    def permission(self) -> vdp.pipeline.v1beta.common_pb2.Permission:
        """Permission."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        recipe: global___Recipe | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        openapi_schema: google.protobuf.struct_pb2.Struct | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        sharing: vdp.pipeline.v1beta.common_pb2.Sharing | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        owner_name: builtins.str = ...,
        owner: google.protobuf.struct_pb2.Struct | None = ...,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        readme: builtins.str = ...,
        permission: vdp.pipeline.v1beta.common_pb2.Permission | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "metadata", b"metadata", "openapi_schema", b"openapi_schema", "owner", b"owner", "permission", b"permission", "recipe", b"recipe", "sharing", b"sharing", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "id", b"id", "metadata", b"metadata", "name", b"name", "openapi_schema", b"openapi_schema", "owner", b"owner", "owner_name", b"owner_name", "permission", b"permission", "readme", b"readme", "recipe", b"recipe", "releases", b"releases", "sharing", b"sharing", "uid", b"uid", "update_time", b"update_time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...

global___Pipeline = Pipeline

@typing_extensions.final
class TriggerMetadata(google.protobuf.message.Message):
    """The metadata"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class TracesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Trace: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Trace | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRACES_FIELD_NUMBER: builtins.int
    @property
    def traces(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Trace]:
        """The traces of the pipeline inference, {component_id: Trace}"""
    def __init__(
        self,
        *,
        traces: collections.abc.Mapping[builtins.str, global___Trace] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["traces", b"traces"]) -> None: ...

global___TriggerMetadata = TriggerMetadata

@typing_extensions.final
class Trace(google.protobuf.message.Message):
    """Trace for the intermediate component"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Trace._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Trace._Status.ValueType  # 0
        """UNSPECIFIED"""
        STATUS_COMPLETED: Trace._Status.ValueType  # 1
        """COMPLETED"""
        STATUS_SKIPPED: Trace._Status.ValueType  # 2
        """SKIPPED"""
        STATUS_ERROR: Trace._Status.ValueType  # 3
        """ERROR"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status"""

    STATUS_UNSPECIFIED: Trace.Status.ValueType  # 0
    """UNSPECIFIED"""
    STATUS_COMPLETED: Trace.Status.ValueType  # 1
    """COMPLETED"""
    STATUS_SKIPPED: Trace.Status.ValueType  # 2
    """SKIPPED"""
    STATUS_ERROR: Trace.Status.ValueType  # 3
    """ERROR"""

    STATUSES_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    COMPUTE_TIME_IN_SECONDS_FIELD_NUMBER: builtins.int
    @property
    def statuses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Trace.Status.ValueType]:
        """status"""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Inputs of the component"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Outputs of the component"""
    @property
    def error(self) -> google.protobuf.struct_pb2.Struct:
        """Error of the component"""
    compute_time_in_seconds: builtins.float
    """Compute Time"""
    def __init__(
        self,
        *,
        statuses: collections.abc.Iterable[global___Trace.Status.ValueType] | None = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        error: google.protobuf.struct_pb2.Struct | None = ...,
        compute_time_in_seconds: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["error", b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["compute_time_in_seconds", b"compute_time_in_seconds", "error", b"error", "inputs", b"inputs", "outputs", b"outputs", "statuses", b"statuses"]) -> None: ...

global___Trace = Trace

@typing_extensions.final
class PipelineRelease(google.protobuf.message.Message):
    """Pipeline releases contain the version control information of a pipeline.
    This allows users to track changes in the pipeline over time.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RECIPE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    OPENAPI_SCHEMA_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    ALIAS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    README_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the release, defined by its owner and ID.
    - Format: `users/{user}/pipelines/{pipeline_id}/releases/{release_id}
    """
    uid: builtins.str
    """Release UUID."""
    id: builtins.str
    """Release resource ID (used in the name as the last segment). It must be a
    sematic version vX.Y.Z.
    """
    description: builtins.str
    """Release description."""
    @property
    def recipe(self) -> global___Recipe:
        """Recipe of the versioned pipeline."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline update time."""
    @property
    def openapi_schema(self) -> google.protobuf.struct_pb2.Struct:
        """OpenAPI schema."""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline deletion time."""
    alias: builtins.str
    """Alias."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Key-value object with console-related data such as the pipeline builder
        layout.
        """
    readme: builtins.str
    """README."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        recipe: global___Recipe | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        openapi_schema: google.protobuf.struct_pb2.Struct | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        alias: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        readme: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "metadata", b"metadata", "openapi_schema", b"openapi_schema", "recipe", b"recipe", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "alias", b"alias", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "id", b"id", "metadata", b"metadata", "name", b"name", "openapi_schema", b"openapi_schema", "readme", b"readme", "recipe", b"recipe", "uid", b"uid", "update_time", b"update_time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...

global___PipelineRelease = PipelineRelease

@typing_extensions.final
class ListPipelinesRequest(google.protobuf.message.Message):
    """ListPipelinesRequest represents a request to list pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. The service may return fewer
    than this value. If unspecified, at most 10 pipelines will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___Pipeline.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipelines"""
    show_deleted: builtins.bool
    """Return soft_deleted pipelines"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListPipelinesRequest = ListPipelinesRequest

@typing_extensions.final
class ListPipelinesResponse(google.protobuf.message.Message):
    """ListPipelinesResponse represents a response for a list of pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline resources"""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListPipelinesResponse = ListPipelinesResponse

@typing_extensions.final
class LookUpPipelineRequest(google.protobuf.message.Message):
    """LookUpPipelineRequest represents a request to query a pipeline via permalink"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a pipeline. For example:
    "pipelines/{uid}"
    """
    view: global___Pipeline.View.ValueType
    """View view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpPipelineRequest = LookUpPipelineRequest

@typing_extensions.final
class LookUpPipelineResponse(google.protobuf.message.Message):
    """LookUpPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___LookUpPipelineResponse = LookUpPipelineResponse

@typing_extensions.final
class CreateUserPipelineRequest(google.protobuf.message.Message):
    """CreateUserPipelineRequest represents a request to create a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource to create"""
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: users/{users}
    """
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "pipeline", b"pipeline"]) -> None: ...

global___CreateUserPipelineRequest = CreateUserPipelineRequest

@typing_extensions.final
class CreateUserPipelineResponse(google.protobuf.message.Message):
    """CreateUserPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The created pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___CreateUserPipelineResponse = CreateUserPipelineResponse

@typing_extensions.final
class ListUserPipelinesRequest(google.protobuf.message.Message):
    """ListUserPipelinesRequest represents a request to list pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. The service may return fewer
    than this value. If unspecified, at most 10 pipelines will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___Pipeline.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipelines"""
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: users/{users}
    """
    show_deleted: builtins.bool
    """Return soft_deleted pipeline releases"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUserPipelinesRequest = ListUserPipelinesRequest

@typing_extensions.final
class ListUserPipelinesResponse(google.protobuf.message.Message):
    """ListUserPipelinesResponse represents a response for a list of pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline resources"""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListUserPipelinesResponse = ListUserPipelinesResponse

@typing_extensions.final
class GetUserPipelineRequest(google.protobuf.message.Message):
    """GetUserPipelineRequest represents a request to query a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    view: global___Pipeline.View.ValueType
    """Pipeline resource view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserPipelineRequest = GetUserPipelineRequest

@typing_extensions.final
class GetUserPipelineResponse(google.protobuf.message.Message):
    """GetUserPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___GetUserPipelineResponse = GetUserPipelineResponse

@typing_extensions.final
class UpdateUserPipelineRequest(google.protobuf.message.Message):
    """UpdateUserPipelineRequest represents a request to update a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Update mask for a pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserPipelineRequest = UpdateUserPipelineRequest

@typing_extensions.final
class UpdateUserPipelineResponse(google.protobuf.message.Message):
    """UpdateUserPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """An updated pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___UpdateUserPipelineResponse = UpdateUserPipelineResponse

@typing_extensions.final
class DeleteUserPipelineRequest(google.protobuf.message.Message):
    """DeleteUserPipelineRequest represents a request to delete a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserPipelineRequest = DeleteUserPipelineRequest

@typing_extensions.final
class DeleteUserPipelineResponse(google.protobuf.message.Message):
    """DeleteUserPipelineResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserPipelineResponse = DeleteUserPipelineResponse

@typing_extensions.final
class ValidateUserPipelineRequest(google.protobuf.message.Message):
    """ValidatePUseripelineRequest represents a request to validate a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ValidateUserPipelineRequest = ValidateUserPipelineRequest

@typing_extensions.final
class ValidateUserPipelineResponse(google.protobuf.message.Message):
    """ValidateUserPipelineResponse represents an response of validated pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___ValidateUserPipelineResponse = ValidateUserPipelineResponse

@typing_extensions.final
class RenameUserPipelineRequest(google.protobuf.message.Message):
    """RenameUserPipelineRequest represents a request to rename the pipeline resource
    name
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    new_pipeline_id: builtins.str
    """Pipeline new resource id to replace with the pipeline resource name to be
    "users/*/pipelines/{new_pipeline_id}"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_id", b"new_pipeline_id"]) -> None: ...

global___RenameUserPipelineRequest = RenameUserPipelineRequest

@typing_extensions.final
class RenameUserPipelineResponse(google.protobuf.message.Message):
    """RenameUserPipelineResponse represents a renamed pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___RenameUserPipelineResponse = RenameUserPipelineResponse

@typing_extensions.final
class TriggerUserPipelineRequest(google.protobuf.message.Message):
    """TriggerUserPipelineRequest represents a request to trigger a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerUserPipelineRequest = TriggerUserPipelineRequest

@typing_extensions.final
class TriggerUserPipelineResponse(google.protobuf.message.Message):
    """TriggerUserPipelineResponse represents a response for the output
    of a pipeline, i.e., the multiple model inference outputs
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """The multiple model inference outputs"""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """The traces of the pipeline inference, {component_id: Trace}"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerUserPipelineResponse = TriggerUserPipelineResponse

@typing_extensions.final
class TriggerAsyncUserPipelineRequest(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineRequest represents a request to trigger a async pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*" """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerAsyncUserPipelineRequest = TriggerAsyncUserPipelineRequest

@typing_extensions.final
class TriggerAsyncUserPipelineResponse(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineResponse represents a response for the longrunning
    operation of a pipeline
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Trigger async pipeline operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncUserPipelineResponse = TriggerAsyncUserPipelineResponse

@typing_extensions.final
class CreateUserPipelineReleaseRequest(google.protobuf.message.Message):
    """CreateUserPipelineReleaseRequest represents a request to create a pipeline_release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline_release resource to create"""
    parent: builtins.str
    """The parent resource where this pipeline_release will be created.
    Format: users/{user}/pipelines/{pipeline}
    """
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "release", b"release"]) -> None: ...

global___CreateUserPipelineReleaseRequest = CreateUserPipelineReleaseRequest

@typing_extensions.final
class CreateUserPipelineReleaseResponse(google.protobuf.message.Message):
    """CreateUserPipelineReleaseResponse represents a response for a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The created pipeline_release resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___CreateUserPipelineReleaseResponse = CreateUserPipelineReleaseResponse

@typing_extensions.final
class ListUserPipelineReleasesRequest(google.protobuf.message.Message):
    """ListUserPipelineReleasesRequest represents a request to list pipeline_releases"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipeline_releases to return. The service may return fewer
    than this value. If unspecified, at most 10 pipeline_release will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___Pipeline.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipeline_releases"""
    parent: builtins.str
    """The parent resource where this pipeline_release will be created.
    Format: users/{user}/pipelines/{pipeline}
    """
    show_deleted: builtins.bool
    """Return soft_deleted pipelines"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUserPipelineReleasesRequest = ListUserPipelineReleasesRequest

@typing_extensions.final
class ListUserPipelineReleasesResponse(google.protobuf.message.Message):
    """ListUserPipelineReleasesResponse represents a response for a list of pipeline_releases"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """A list of pipeline_release resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline_release resources"""
    def __init__(
        self,
        *,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "releases", b"releases", "total_size", b"total_size"]) -> None: ...

global___ListUserPipelineReleasesResponse = ListUserPipelineReleasesResponse

@typing_extensions.final
class GetUserPipelineReleaseRequest(google.protobuf.message.Message):
    """GetUserPipelineReleaseRequest represents a request to query a pipeline_release
    Pipeline View
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """PipelineRelease resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    view: global___Pipeline.View.ValueType
    """PipelineRelease resource view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserPipelineReleaseRequest = GetUserPipelineReleaseRequest

@typing_extensions.final
class GetUserPipelineReleaseResponse(google.protobuf.message.Message):
    """GetUserPipelineReleaseResponse represents a response for a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline_release resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___GetUserPipelineReleaseResponse = GetUserPipelineReleaseResponse

@typing_extensions.final
class UpdateUserPipelineReleaseRequest(google.protobuf.message.Message):
    """UpdateUserPipelineReleaseRequest represents a request to update a pipeline release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline release resource to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Update mask for a pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserPipelineReleaseRequest = UpdateUserPipelineReleaseRequest

@typing_extensions.final
class UpdateUserPipelineReleaseResponse(google.protobuf.message.Message):
    """UpdateUserPipelineReleaseResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """An updated pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___UpdateUserPipelineReleaseResponse = UpdateUserPipelineReleaseResponse

@typing_extensions.final
class DeleteUserPipelineReleaseRequest(google.protobuf.message.Message):
    """DeleteUserPipelineReleaseRequest represents a request to delete a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """PipelineRelease resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserPipelineReleaseRequest = DeleteUserPipelineReleaseRequest

@typing_extensions.final
class DeleteUserPipelineReleaseResponse(google.protobuf.message.Message):
    """DeleteUserPipelineReleaseResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserPipelineReleaseResponse = DeleteUserPipelineReleaseResponse

@typing_extensions.final
class RestoreUserPipelineReleaseRequest(google.protobuf.message.Message):
    """RestoreUserPipelineReleaseRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___RestoreUserPipelineReleaseRequest = RestoreUserPipelineReleaseRequest

@typing_extensions.final
class RestoreUserPipelineReleaseResponse(google.protobuf.message.Message):
    """RestoreUserPipelineReleaseResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RestoreUserPipelineReleaseResponse = RestoreUserPipelineReleaseResponse

@typing_extensions.final
class RenameUserPipelineReleaseRequest(google.protobuf.message.Message):
    """RenameUserPipelineReleaseRequest represents a request to rename the pipeline release resource
    name
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_RELEASE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline release resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    new_pipeline_release_id: builtins.str
    """Pipeline new resource id to replace with the pipeline resource name to be
    "users/*/pipelines/*/releases/{new_pipeline_id}"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_release_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_release_id", b"new_pipeline_release_id"]) -> None: ...

global___RenameUserPipelineReleaseRequest = RenameUserPipelineReleaseRequest

@typing_extensions.final
class RenameUserPipelineReleaseResponse(google.protobuf.message.Message):
    """RenameUserPipelineReleaseResponse represents a renamed pipeline release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RenameUserPipelineReleaseResponse = RenameUserPipelineReleaseResponse

@typing_extensions.final
class WatchUserPipelineReleaseRequest(google.protobuf.message.Message):
    """WatchUserPipelineReleaseRequest represents a public request to query
    a pipeline's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "users/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchUserPipelineReleaseRequest = WatchUserPipelineReleaseRequest

@typing_extensions.final
class WatchUserPipelineReleaseResponse(google.protobuf.message.Message):
    """WatchUserPipelineReleaseResponse represents a response to fetch a pipeline's
    current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """Retrieved pipeline state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___WatchUserPipelineReleaseResponse = WatchUserPipelineReleaseResponse

@typing_extensions.final
class TriggerUserPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerUserPipelineReleaseRequest represents a request to trigger a pipeline_released pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name."""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerUserPipelineReleaseRequest = TriggerUserPipelineReleaseRequest

@typing_extensions.final
class TriggerUserPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerUserPipelineReleaseResponse represents a response for the output
    of a pipeline, i.e., the multiple model inference outputs
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """The multiple model inference outputs"""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """The traces of the pipeline inference, {component_id: Trace}"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerUserPipelineReleaseResponse = TriggerUserPipelineReleaseResponse

@typing_extensions.final
class TriggerAsyncUserPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineReleaseRequest represents a request to trigger a pipeline_released pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name."""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerAsyncUserPipelineReleaseRequest = TriggerAsyncUserPipelineReleaseRequest

@typing_extensions.final
class TriggerAsyncUserPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineReleaseResponse represents a response for the longrunning
    operation of a pipeline
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Trigger async pipeline operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncUserPipelineReleaseResponse = TriggerAsyncUserPipelineReleaseResponse

@typing_extensions.final
class CreateOrganizationPipelineRequest(google.protobuf.message.Message):
    """CreateOrganizationPipelineRequest represents a request to create a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource to create"""
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: organizations/{organizations}
    """
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "pipeline", b"pipeline"]) -> None: ...

global___CreateOrganizationPipelineRequest = CreateOrganizationPipelineRequest

@typing_extensions.final
class CreateOrganizationPipelineResponse(google.protobuf.message.Message):
    """CreateOrganizationPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The created pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___CreateOrganizationPipelineResponse = CreateOrganizationPipelineResponse

@typing_extensions.final
class ListOrganizationPipelinesRequest(google.protobuf.message.Message):
    """ListOrganizationPipelinesRequest represents a request to list pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. The service may return fewer
    than this value. If unspecified, at most 10 pipelines will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___Pipeline.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipelines"""
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: organizations/{organizations}
    """
    show_deleted: builtins.bool
    """Return soft_deleted pipeline releases"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListOrganizationPipelinesRequest = ListOrganizationPipelinesRequest

@typing_extensions.final
class ListOrganizationPipelinesResponse(google.protobuf.message.Message):
    """ListOrganizationPipelinesResponse represents a response for a list of pipelines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline resources"""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationPipelinesResponse = ListOrganizationPipelinesResponse

@typing_extensions.final
class GetOrganizationPipelineRequest(google.protobuf.message.Message):
    """GetOrganizationPipelineRequest represents a request to query a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*" """
    view: global___Pipeline.View.ValueType
    """Pipeline resource view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationPipelineRequest = GetOrganizationPipelineRequest

@typing_extensions.final
class GetOrganizationPipelineResponse(google.protobuf.message.Message):
    """GetOrganizationPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___GetOrganizationPipelineResponse = GetOrganizationPipelineResponse

@typing_extensions.final
class UpdateOrganizationPipelineRequest(google.protobuf.message.Message):
    """UpdateOrganizationPipelineRequest represents a request to update a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Update mask for a pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationPipelineRequest = UpdateOrganizationPipelineRequest

@typing_extensions.final
class UpdateOrganizationPipelineResponse(google.protobuf.message.Message):
    """UpdateOrganizationPipelineResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """An updated pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___UpdateOrganizationPipelineResponse = UpdateOrganizationPipelineResponse

@typing_extensions.final
class DeleteOrganizationPipelineRequest(google.protobuf.message.Message):
    """DeleteOrganizationPipelineRequest represents a request to delete a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationPipelineRequest = DeleteOrganizationPipelineRequest

@typing_extensions.final
class DeleteOrganizationPipelineResponse(google.protobuf.message.Message):
    """DeleteOrganizationPipelineResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationPipelineResponse = DeleteOrganizationPipelineResponse

@typing_extensions.final
class ValidateOrganizationPipelineRequest(google.protobuf.message.Message):
    """ValidatePOrganizationipelineRequest represents a request to validate a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ValidateOrganizationPipelineRequest = ValidateOrganizationPipelineRequest

@typing_extensions.final
class ValidateOrganizationPipelineResponse(google.protobuf.message.Message):
    """ValidateOrganizationPipelineResponse represents an response of validated pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___ValidateOrganizationPipelineResponse = ValidateOrganizationPipelineResponse

@typing_extensions.final
class RenameOrganizationPipelineRequest(google.protobuf.message.Message):
    """RenameOrganizationPipelineRequest represents a request to rename the pipeline resource
    name
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*" """
    new_pipeline_id: builtins.str
    """Pipeline new resource id to replace with the pipeline resource name to be
    "organizations/*/pipelines/{new_pipeline_id}"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_id", b"new_pipeline_id"]) -> None: ...

global___RenameOrganizationPipelineRequest = RenameOrganizationPipelineRequest

@typing_extensions.final
class RenameOrganizationPipelineResponse(google.protobuf.message.Message):
    """RenameOrganizationPipelineResponse represents a renamed pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___RenameOrganizationPipelineResponse = RenameOrganizationPipelineResponse

@typing_extensions.final
class TriggerOrganizationPipelineRequest(google.protobuf.message.Message):
    """TriggerOrganizationPipelineRequest represents a request to trigger a pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*" """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerOrganizationPipelineRequest = TriggerOrganizationPipelineRequest

@typing_extensions.final
class TriggerOrganizationPipelineResponse(google.protobuf.message.Message):
    """TriggerOrganizationPipelineResponse represents a response for the output
    of a pipeline, i.e., the multiple model inference outputs
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """The multiple model inference outputs"""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """The traces of the pipeline inference, {component_id: Trace}"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerOrganizationPipelineResponse = TriggerOrganizationPipelineResponse

@typing_extensions.final
class TriggerAsyncOrganizationPipelineRequest(google.protobuf.message.Message):
    """TriggerAsyncOrganizationPipelineRequest represents a request to trigger a async pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*" """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerAsyncOrganizationPipelineRequest = TriggerAsyncOrganizationPipelineRequest

@typing_extensions.final
class TriggerAsyncOrganizationPipelineResponse(google.protobuf.message.Message):
    """TriggerAsyncOrganizationPipelineResponse represents a response for the longrunning
    operation of a pipeline
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Trigger async pipeline operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncOrganizationPipelineResponse = TriggerAsyncOrganizationPipelineResponse

@typing_extensions.final
class CreateOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """CreateOrganizationPipelineReleaseRequest represents a request to create a pipeline_release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline_release resource to create"""
    parent: builtins.str
    """The parent resource where this pipeline_release will be created.
    Format: organizations/{organization}/pipelines/{pipeline}
    """
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "release", b"release"]) -> None: ...

global___CreateOrganizationPipelineReleaseRequest = CreateOrganizationPipelineReleaseRequest

@typing_extensions.final
class CreateOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """CreateOrganizationPipelineReleaseResponse represents a response for a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The created pipeline_release resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___CreateOrganizationPipelineReleaseResponse = CreateOrganizationPipelineReleaseResponse

@typing_extensions.final
class ListOrganizationPipelineReleasesRequest(google.protobuf.message.Message):
    """ListOrganizationPipelineReleasesRequest represents a request to list pipeline_releases"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipeline_releases to return. The service may return fewer
    than this value. If unspecified, at most 10 pipeline_release will be returned. The
    maximum value is 100; values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___Pipeline.View.ValueType
    """View view (default is VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list pipeline_releases"""
    parent: builtins.str
    """The parent resource where this pipeline_release will be created.
    Format: organizations/{organization}/pipelines/{pipeline}
    """
    show_deleted: builtins.bool
    """Return soft_deleted pipelines"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListOrganizationPipelineReleasesRequest = ListOrganizationPipelineReleasesRequest

@typing_extensions.final
class ListOrganizationPipelineReleasesResponse(google.protobuf.message.Message):
    """ListOrganizationPipelineReleasesResponse represents a response for a list of pipeline_releases"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """A list of pipeline_release resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of pipeline_release resources"""
    def __init__(
        self,
        *,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "releases", b"releases", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationPipelineReleasesResponse = ListOrganizationPipelineReleasesResponse

@typing_extensions.final
class GetOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """GetOrganizationPipelineReleaseRequest represents a request to query a pipeline_release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """PipelineRelease resource name. It must have the format of "organizations/*/pipelines/*/releases/*" """
    view: global___Pipeline.View.ValueType
    """PipelineRelease resource view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationPipelineReleaseRequest = GetOrganizationPipelineReleaseRequest

@typing_extensions.final
class GetOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """GetOrganizationPipelineReleaseResponse represents a response for a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline_release resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___GetOrganizationPipelineReleaseResponse = GetOrganizationPipelineReleaseResponse

@typing_extensions.final
class UpdateOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """UpdateOrganizationPipelineReleaseRequest represents a request to update a pipeline release"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline release resource to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Update mask for a pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationPipelineReleaseRequest = UpdateOrganizationPipelineReleaseRequest

@typing_extensions.final
class UpdateOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """UpdateOrganizationPipelineReleaseResponse represents a response for a pipeline resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """An updated pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___UpdateOrganizationPipelineReleaseResponse = UpdateOrganizationPipelineReleaseResponse

@typing_extensions.final
class DeleteOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """DeleteOrganizationPipelineReleaseRequest represents a request to delete a pipeline_release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """PipelineRelease resource name. It must have the format of "organizations/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationPipelineReleaseRequest = DeleteOrganizationPipelineReleaseRequest

@typing_extensions.final
class DeleteOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """DeleteOrganizationPipelineReleaseResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationPipelineReleaseResponse = DeleteOrganizationPipelineReleaseResponse

@typing_extensions.final
class SetDefaultOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """SetDefaultOrganizationPipelineReleaseRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___SetDefaultOrganizationPipelineReleaseRequest = SetDefaultOrganizationPipelineReleaseRequest

@typing_extensions.final
class SetDefaultOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """SetDefaultOrganizationPipelineReleaseResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___SetDefaultOrganizationPipelineReleaseResponse = SetDefaultOrganizationPipelineReleaseResponse

@typing_extensions.final
class RestoreOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """RestoreOrganizationPipelineReleaseRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___RestoreOrganizationPipelineReleaseRequest = RestoreOrganizationPipelineReleaseRequest

@typing_extensions.final
class RestoreOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """RestoreOrganizationPipelineReleaseResponse"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RestoreOrganizationPipelineReleaseResponse = RestoreOrganizationPipelineReleaseResponse

@typing_extensions.final
class RenameOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """RenameOrganizationPipelineReleaseRequest represents a request to rename the pipeline release resource
    name
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_RELEASE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline release resource name. It must have the format of "organizations/*/pipelines/*/releases/*" """
    new_pipeline_release_id: builtins.str
    """Pipeline new resource id to replace with the pipeline resource name to be
    "organizations/*/pipelines/*/releases/{new_pipeline_id}"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_release_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_release_id", b"new_pipeline_release_id"]) -> None: ...

global___RenameOrganizationPipelineReleaseRequest = RenameOrganizationPipelineReleaseRequest

@typing_extensions.final
class RenameOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """RenameOrganizationPipelineReleaseResponse represents a renamed pipeline release resource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """A pipeline resource"""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RenameOrganizationPipelineReleaseResponse = RenameOrganizationPipelineReleaseResponse

@typing_extensions.final
class WatchOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """WatchOrganizationPipelineReleaseRequest represents a public request to query
    a pipeline's current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Pipeline resource name. It must have the format of "organizations/*/pipelines/*/releases/*" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchOrganizationPipelineReleaseRequest = WatchOrganizationPipelineReleaseRequest

@typing_extensions.final
class WatchOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """WatchOrganizationPipelineReleaseResponse represents a response to fetch a pipeline's
    current state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___State.ValueType
    """Retrieved pipeline state"""
    def __init__(
        self,
        *,
        state: global___State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___WatchOrganizationPipelineReleaseResponse = WatchOrganizationPipelineReleaseResponse

@typing_extensions.final
class TriggerOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerOrganizationPipelineReleaseRequest represents a request to trigger a pipeline_released pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name."""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerOrganizationPipelineReleaseRequest = TriggerOrganizationPipelineReleaseRequest

@typing_extensions.final
class TriggerOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerOrganizationPipelineReleaseResponse represents a response for the output
    of a pipeline, i.e., the multiple model inference outputs
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """The multiple model inference outputs"""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """The traces of the pipeline inference, {component_id: Trace}"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerOrganizationPipelineReleaseResponse = TriggerOrganizationPipelineReleaseResponse

@typing_extensions.final
class TriggerAsyncOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerAsyncOrganizationPipelineReleaseRequest represents a request to trigger a pipeline_released pipeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name."""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Input to the pipeline"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name"]) -> None: ...

global___TriggerAsyncOrganizationPipelineReleaseRequest = TriggerAsyncOrganizationPipelineReleaseRequest

@typing_extensions.final
class TriggerAsyncOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerAsyncOrganizationPipelineReleaseResponse represents a response for the longrunning
    operation of a pipeline
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Trigger async pipeline operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncOrganizationPipelineReleaseResponse = TriggerAsyncOrganizationPipelineReleaseResponse

@typing_extensions.final
class GetOperationRequest(google.protobuf.message.Message):
    """GetOperationRequest represents a request to query a longrunning
    operation
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation resource."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetOperationRequest = GetOperationRequest

@typing_extensions.final
class GetOperationResponse(google.protobuf.message.Message):
    """GetOperationResponse represents a response for a longrunning
    operation
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The retrieved longrunning operation"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetOperationResponse = GetOperationResponse

@typing_extensions.final
class ListPipelinesAdminRequest(google.protobuf.message.Message):
    """========== Private endpoints

    ListPipelinesAdminRequest represents a request by an admin to list all the
    pipelines. Admin users have access to pipelines from any user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    - Example: `recipe.components.definition_name:"operator-definitions/2ac8be70-0f7a-4b61-a33d-098b8acfa6f3"`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListPipelinesAdminRequest = ListPipelinesAdminRequest

@typing_extensions.final
class ListPipelinesAdminResponse(google.protobuf.message.Message):
    """ListPipelinesAdminResponse contains a list of pipelines requested by an
    admin user.
    For the moment, the pipeline recipes will be UID-based (permalink) instead
    of name-based. This is a temporary solution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipelines."""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListPipelinesAdminResponse = ListPipelinesAdminResponse

@typing_extensions.final
class ListPipelineReleasesAdminRequest(google.protobuf.message.Message):
    """ListPipelinesReleaseAdminRequest represents a request by an admin to list
    all pipeline releases. Admin users have access to pipelines from any user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of releases to return. If this parameter is
    unspecified, at most 10 releases will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListPipelineReleasesAdminRequest = ListPipelineReleasesAdminRequest

@typing_extensions.final
class ListPipelineReleasesAdminResponse(google.protobuf.message.Message):
    """ListPipelineReleasesAdminResponse contains a list of pipeline releases
    requested by an admin user.
    For the moment, the pipeline recipes will be UID-based (permalink) instead
    of name-based. This is a temporary solution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """A list of pipeline releases."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipeline releases."""
    def __init__(
        self,
        *,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "releases", b"releases", "total_size", b"total_size"]) -> None: ...

global___ListPipelineReleasesAdminResponse = ListPipelineReleasesAdminResponse

@typing_extensions.final
class LookUpPipelineAdminRequest(google.protobuf.message.Message):
    """LookUpPipelineAdminRequest represents a request by an admin to query a
    user pipeline by its UID.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the pipeline, which allows its access by UID.
    - Format: `pipelines/{uid}`.
    """
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpPipelineAdminRequest = LookUpPipelineAdminRequest

@typing_extensions.final
class LookUpPipelineAdminResponse(google.protobuf.message.Message):
    """LookUpPipelineAdminResponse represents a response for a pipeline resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The requested pipeline."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___LookUpPipelineAdminResponse = LookUpPipelineAdminResponse
