CREATE OR REPLACE TABLE
"{dld_database}"."{dld_table}"(
        "transaction_id" String COMMENT '[PK] Unique DLD transaction identifier (format: sequence-type-year-number)',
        "trans_group_type_english" Nullable(String) COMMENT '[ENUM] Transaction category: Sales (~70%), Mortgages (~25%), Gifts (~5%)',
        "trans_group_type_arabic" Nullable(String) COMMENT '[ENUM] Transaction category in Arabic',
        "procedure_type_english" Nullable(String) COMMENT '[ENUM] Specific procedure: Sell|Buy|Mortgage Registration|Grant|Lease to Own|Transfer|etc.',
        "procedure_type_arabic" Nullable(String) COMMENT '[ENUM] Specific transaction procedure in Arabic',
        "instance_date" Nullable(Date) COMMENT '[DATE] Date when the transaction was officially executed',
        "area_name_english" Nullable(String) COMMENT '[GEO] Geographic area/district name (Top: Marsa Dubai, Al Thanyah Fifth, Al Barsha South Fourth, Burj Khalifa, Business Bay)',
        "area_name_arabic" Nullable(String) COMMENT '[GEO] Geographic area/district name in Arabic',
        "nearest_landmark_name_english" Nullable(String) COMMENT '[GEO] Closest landmark reference point for property location',
        "nearest_landmark_name_arabic" Nullable(String) COMMENT '[GEO] Closest landmark reference point in Arabic',
        "nearest_metro_name_english" Nullable(String) COMMENT '[GEO] Nearest Dubai Metro station for location reference and accessibility',
        "nearest_metro_name_arabic" Nullable(String) COMMENT '[GEO] Nearest Dubai Metro station in Arabic',
        "nearest_mall_name_english" Nullable(String) COMMENT '[GEO] Nearest shopping mall for location reference and lifestyle amenities',
        "nearest_mall_name_arabic" Nullable(String) COMMENT '[GEO] Nearest shopping mall in Arabic',
        "master_project_id" Nullable(Int128) COMMENT '[FK→dld_projects.master_project_id] Link to master development project (large communities)',
        "project_id" Nullable(Int128) COMMENT '[FK→dld_projects.project_id] Link to specific project within master project',
        "building_name" Nullable(String) COMMENT '[REF→dld_buildings.building_name] Building identifier within the project',
        "building_number" Nullable(Int128) COMMENT '[REF→dld_buildings.building_number] Numeric building identifier',
        "property_type_english" Nullable(String) COMMENT '[ENUM] Property type: Unit (~80%), Land (~9%), Villa (~9%), Building (~2%)',
        "property_type_arabic" Nullable(String) COMMENT '[ENUM] Property classification in Arabic',
        "property_sub_type_english" Nullable(String) COMMENT '[ENUM] Unit subtypes: Flat|Office|Hotel Apartment|Shop|Hotel Rooms|Workshop|Stacked Townhouses|etc.',
        "property_sub_type_arabic" Nullable(String) COMMENT '[ENUM] Detailed property subcategory in Arabic',
        "property_usage_english" Nullable(String) COMMENT '[ENUM] Property usage type (Residential|Commercial|Mixed|Industrial|etc.)',
        "property_usage_arabic" Nullable(String) COMMENT '[ENUM] Property usage type in Arabic',
        "reg_type_english" Nullable(String) COMMENT '[ENUM] Registration type for the transaction (varies by procedure)',
        "reg_type_arabic" Nullable(String) COMMENT '[ENUM] Registration type in Arabic',
        "no_of_parties_role_1" Nullable(Int128) COMMENT '[COUNT] Number of parties in primary role (typically sellers/grantors)',
        "no_of_parties_role_2" Nullable(Int128) COMMENT '[COUNT] Number of parties in secondary role (typically buyers/grantees)',
        "no_of_parties_role_3" Nullable(Int128) COMMENT '[COUNT] Number of parties in tertiary role (agents, witnesses, banks, etc.)',
        "has_parking" Nullable(Bool) COMMENT '[BOOL] Indicates if property includes parking spaces (1=yes, 0=no) - critical for property valuation',
        "rooms_type_english" Nullable(String) COMMENT '[ENUM] Room configuration: Studio|1-9 B/R|Office|Shop|Single Room|Penthouse|Health club - matches market standards',
        "rooms_type_arabic" Nullable(String) COMMENT '[ENUM] Room configuration in Arabic',
        "procedure_area" Nullable(Float32) COMMENT '[UNIT:sqft] Property area in square feet as per transaction documents',
        "actual_worth" Nullable(Float32) COMMENT '[CURRENCY:AED] Official transaction value in UAE Dirhams - key for market analysis'
) 
ENGINE = MergeTree()
PRIMARY KEY("transaction_id")
COMMENT 'Official DLD property transaction records including sales, mortgages, and gifts';