# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03_chatbot.ipynb (unless otherwise specified).

__all__ = ['ChatBot']

# Cell

from .dialog_system import DialogSystem
import logging
from unittest.mock import patch
from collections import defaultdict
from os import system
import pandas as pd

logging.basicConfig(
    #filename='example.log',
    format='%(asctime)s %(levelname)s:%(message)s',
    level=logging.ERROR,
    datefmt='%I:%M:%S'
)

logging.debug(" Debug Log Active")
logging.info("Hello! Welcome to our automated dialog system!")
logging.warning(' Warning Log Active')

# Cell
class ChatBot(DialogSystem):
    ''' This Bots implements the `DialogSystem` class methods as a form of conversation in
    a text interface. \n

    The Bot starts asking to introduce the desired question and returns a set of answers,
    After this, asks if a better answer will be provided, if yes, asks for the type of answer
    (context or FAQ), if not, returns starts again.\n

    The chatbot starts by calling the method chatbot() of an instance of the class.
    '''
    def __init__(
        self,
        context_data_file=None,
        faq_data_file=None,
        configs_faq=None,
        download_models=True
    ):
        super().__init__(
            context_data_file, faq_data_file, configs_faq, download_models
        )
        system('clear')

    def is_equal(self, string, letter='y'):
        '''Open I/O input until response is 'yes' or 'no'
        '''

        not_letter = 'y' if letter == 'n' else 'n'
        res = input(string)[0].lower()
        while True:
            if res == letter:
                return True
            elif res == not_letter:
                return False
            else:
                res = input(string)[0].lower()

    def question_answer_interface(self):
        '''Inputs question and prints responses
        '''
        question = input('Introduce your question:\n')
        self.question_answer(question)
        print(self.formatted_responses)

    def new_question_answer_interface(self):
        '''Asks for  a new question-answer pair
        '''
        if self.is_equal('Use exactly the same question[y/n]?', 'n'):
            self.question = input('Introduce the new question:\n')

        self.new_question_answer(
            question=self.question, answer=input('Introduce the answer:\n')
        )

    def new_context_interface(self):
        '''Asks for a new context
        '''
        self.new_context(
            topic=input('Introduce the topic (context title):\n'),
            context=input('Introduce the context:\n'),
        )

    def are_answers_ok(self):
        '''Asks if a better answer will be provided
        '''
        if self.is_equal('Do you want to provide a better answer[y/n]?', 'n'):
            return

        elif self.is_equal(
                'If the answer will be given as a CONTEXT type "yes", ' +
                'otherwise type "no" [yes = Context, no = FAQ]', 'n'
        ):
            self.new_question_answer_interface()
        else:
            self.new_context_interface()

        print('\n The bot has been updated. \n')

    def chatbot(self):
        ''' Chatbots logic:\n
             Asks for a question -> Gives responses -> Asks if a better answer will be provided \n
             If not starts again. \n
             If yes -> asks if it is a context or a FAQ -> asks for the response and updates the data -> starts again. \n
             The chatbot stops at any moment with the keys Ctrl+C
        '''
        while True:
            try:
                print("\n Welcome to the Chatbot. To exit press Ctrl+C.\n")
                self.question_answer_interface()
                self.are_answers_ok()
            except (KeyboardInterrupt, SystemExit):
                print('\n See you!\n')
                break
            finally:
                ...