"""
    FactSet Concordance API

    The FactSet Concordance API provides the ability to programmatically look up several types of entities by their name and other attributes. It attempts to match attributes that you supply for the entity and returns as many match candidates as it can find. The result is a \"concorded\" FactSet Entity Permanent identifier.  The Entity Identifier can then be used as input throughout FactSet's Content soultions, such as Content APIs and Standard DataFeeds.<p> There are two types of workflows supported in the API. The first workflow type follows traditional API conventions in that a request is accepted and a response is returned synchronously. The second workflow type involves a background task. With this workflow, a task is created for uploading a set of queries, and then the client polls for the task to complete. Once the task has completed, the client retrieves the concordance results throught the decisions endpoint.</p>   # noqa: E501

    The version of the OpenAPI document: 2.5.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.FactSetConcordance.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.FactSetConcordance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.FactSetConcordance.exceptions import ApiException
from fds.sdk.FactSetConcordance.model.entity_decisions_response import EntityDecisionsResponse
from fds.sdk.FactSetConcordance.model.entity_task_response import EntityTaskResponse
from fds.sdk.FactSetConcordance.model.entity_task_status_response import EntityTaskStatusResponse
from fds.sdk.FactSetConcordance.model.error_response import ErrorResponse





class EntityMatchBulkApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_entity_decisions_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EntityDecisionsResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/entity-decisions',
                'operation_id': 'get_entity_decisions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'task_id',
                    'offset',
                    'limit',
                ],
                'required': [
                    'task_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'task_id':
                        (int,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'task_id': 'taskId',
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'task_id': 'query',
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json;charset=utf-8',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_task_for_list_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EntityTaskResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/entity-task',
                'operation_id': 'get_entity_task_for_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'universe_id',
                    'task_name',
                    'input_file',
                    'client_id_column',
                    'name_column',
                    'country_column',
                    'url_column',
                    'state_column',
                    'priority_column',
                    'bic_column',
                    'bbg_ticker_column',
                    'cik_column',
                    'crd_column',
                    'cusip_column',
                    'duns_column',
                    'ein_column',
                    'rssd_column',
                    'fitch_column',
                    'isin_column',
                    'lei_column',
                    'bbg_figi_column',
                    'md_column',
                    'ticker_column',
                    'spr_column',
                    'sedol_column',
                    'ticker_exchange_column',
                    'ticker_region_column',
                    'ukch_column',
                    'valoren_column',
                    'wkn_column',
                    'include_entity_type',
                    'exclude_entity_type',
                    'include_entity_sub_type',
                    'exclude_entity_sub_type',
                ],
                'required': [
                    'universe_id',
                    'task_name',
                    'input_file',
                    'client_id_column',
                    'name_column',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'universe_id':
                        (int,),
                    'task_name':
                        (str,),
                    'input_file':
                        (file_type,),
                    'client_id_column':
                        (str,),
                    'name_column':
                        (str,),
                    'country_column':
                        (str,),
                    'url_column':
                        (str,),
                    'state_column':
                        (str,),
                    'priority_column':
                        (str,),
                    'bic_column':
                        (str,),
                    'bbg_ticker_column':
                        (str,),
                    'cik_column':
                        (str,),
                    'crd_column':
                        (str,),
                    'cusip_column':
                        (str,),
                    'duns_column':
                        (str,),
                    'ein_column':
                        (str,),
                    'rssd_column':
                        (str,),
                    'fitch_column':
                        (str,),
                    'isin_column':
                        (str,),
                    'lei_column':
                        (str,),
                    'bbg_figi_column':
                        (str,),
                    'md_column':
                        (str,),
                    'ticker_column':
                        (str,),
                    'spr_column':
                        (str,),
                    'sedol_column':
                        (str,),
                    'ticker_exchange_column':
                        (str,),
                    'ticker_region_column':
                        (str,),
                    'ukch_column':
                        (str,),
                    'valoren_column':
                        (str,),
                    'wkn_column':
                        (str,),
                    'include_entity_type':
                        ([str],),
                    'exclude_entity_type':
                        ([str],),
                    'include_entity_sub_type':
                        ([str],),
                    'exclude_entity_sub_type':
                        ([str],),
                },
                'attribute_map': {
                    'universe_id': 'universeId',
                    'task_name': 'taskName',
                    'input_file': 'inputFile',
                    'client_id_column': 'clientIdColumn',
                    'name_column': 'nameColumn',
                    'country_column': 'countryColumn',
                    'url_column': 'urlColumn',
                    'state_column': 'stateColumn',
                    'priority_column': 'priorityColumn',
                    'bic_column': 'bicColumn',
                    'bbg_ticker_column': 'bbgTickerColumn',
                    'cik_column': 'cikColumn',
                    'crd_column': 'crdColumn',
                    'cusip_column': 'cusipColumn',
                    'duns_column': 'dunsColumn',
                    'ein_column': 'einColumn',
                    'rssd_column': 'rssdColumn',
                    'fitch_column': 'fitchColumn',
                    'isin_column': 'isinColumn',
                    'lei_column': 'leiColumn',
                    'bbg_figi_column': 'bbgFigiColumn',
                    'md_column': 'mdColumn',
                    'ticker_column': 'tickerColumn',
                    'spr_column': 'sprColumn',
                    'sedol_column': 'sedolColumn',
                    'ticker_exchange_column': 'tickerExchangeColumn',
                    'ticker_region_column': 'tickerRegionColumn',
                    'ukch_column': 'ukchColumn',
                    'valoren_column': 'valorenColumn',
                    'wkn_column': 'wknColumn',
                    'include_entity_type': 'includeEntityType',
                    'exclude_entity_type': 'excludeEntityType',
                    'include_entity_sub_type': 'includeEntitySubType',
                    'exclude_entity_sub_type': 'excludeEntitySubType',
                },
                'location_map': {
                    'universe_id': 'form',
                    'task_name': 'form',
                    'input_file': 'form',
                    'client_id_column': 'form',
                    'name_column': 'form',
                    'country_column': 'form',
                    'url_column': 'form',
                    'state_column': 'form',
                    'priority_column': 'form',
                    'bic_column': 'form',
                    'bbg_ticker_column': 'form',
                    'cik_column': 'form',
                    'crd_column': 'form',
                    'cusip_column': 'form',
                    'duns_column': 'form',
                    'ein_column': 'form',
                    'rssd_column': 'form',
                    'fitch_column': 'form',
                    'isin_column': 'form',
                    'lei_column': 'form',
                    'bbg_figi_column': 'form',
                    'md_column': 'form',
                    'ticker_column': 'form',
                    'spr_column': 'form',
                    'sedol_column': 'form',
                    'ticker_exchange_column': 'form',
                    'ticker_region_column': 'form',
                    'ukch_column': 'form',
                    'valoren_column': 'form',
                    'wkn_column': 'form',
                    'include_entity_type': 'form',
                    'exclude_entity_type': 'form',
                    'include_entity_sub_type': 'form',
                    'exclude_entity_sub_type': 'form',
                },
                'collection_format_map': {
                    'include_entity_type': 'csv',
                    'exclude_entity_type': 'csv',
                    'include_entity_sub_type': 'csv',
                    'exclude_entity_sub_type': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json;charset=utf-8',
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.get_entity_task_status_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EntityTaskStatusResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/entity-task-status',
                'operation_id': 'get_entity_task_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'task_id',
                    'offset',
                    'limit',
                    'status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "PENDING": "PENDING",
                        "IN_PROGRESS": "IN_PROGRESS",
                        "SUCCESS": "SUCCESS",
                        "FAILURE": "FAILURE",
                        "BAD_REQUEST": "BAD_REQUEST",
                        "ABORTED": "ABORTED"
                    },
                },
                'openapi_types': {
                    'task_id':
                        (int,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'status':
                        ([str],),
                },
                'attribute_map': {
                    'task_id': 'taskId',
                    'offset': 'offset',
                    'limit': 'limit',
                    'status': 'status',
                },
                'location_map': {
                    'task_id': 'query',
                    'offset': 'query',
                    'limit': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                    'status': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json;charset=utf-8',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")

    def get_entity_decisions(
        self,
        task_id,
        **kwargs
    ) -> EntityDecisionsResponse:
        """Get the decisions of matches for the requested taskId.  # noqa: E501

        Retrieves the `Decision` objects for an Entity Task (taskId). The decisions do not include all candidates, but rather the results of concording the requested list of names included in the input file. Mapped entities will include a FactSet Entity Identifier (-E). Results will be saved to the `universeId` specified in the input file.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            task_id (int): Name of the column for the type Concordance Task Identifier. The taskId is created in response from the /entity-task endpoint.

        Keyword Args:
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityDecisionsResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['task_id'] = \
            task_id
        return self.get_entity_decisions_endpoint.call_with_http_info(**kwargs)

    def get_entity_decisions_with_http_info(
        self,
        task_id,
        **kwargs
    ) -> typing.Tuple[EntityDecisionsResponse, int, typing.MutableMapping]:
        """Get the decisions of matches for the requested taskId.  # noqa: E501

        Retrieves the `Decision` objects for an Entity Task (taskId). The decisions do not include all candidates, but rather the results of concording the requested list of names included in the input file. Mapped entities will include a FactSet Entity Identifier (-E). Results will be saved to the `universeId` specified in the input file.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            task_id (int): Name of the column for the type Concordance Task Identifier. The taskId is created in response from the /entity-task endpoint.

        Keyword Args:
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityDecisionsResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['task_id'] = \
            task_id
        return self.get_entity_decisions_endpoint.call_with_http_info(**kwargs)

    def get_entity_decisions_async(
        self,
        task_id,
        **kwargs
    ) -> "ApplyResult[EntityDecisionsResponse]":
        """Get the decisions of matches for the requested taskId.  # noqa: E501

        Retrieves the `Decision` objects for an Entity Task (taskId). The decisions do not include all candidates, but rather the results of concording the requested list of names included in the input file. Mapped entities will include a FactSet Entity Identifier (-E). Results will be saved to the `universeId` specified in the input file.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            task_id (int): Name of the column for the type Concordance Task Identifier. The taskId is created in response from the /entity-task endpoint.

        Keyword Args:
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EntityDecisionsResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['task_id'] = \
            task_id
        return self.get_entity_decisions_endpoint.call_with_http_info(**kwargs)

    def get_entity_decisions_with_http_info_async(
        self,
        task_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EntityDecisionsResponse, int, typing.MutableMapping]]":
        """Get the decisions of matches for the requested taskId.  # noqa: E501

        Retrieves the `Decision` objects for an Entity Task (taskId). The decisions do not include all candidates, but rather the results of concording the requested list of names included in the input file. Mapped entities will include a FactSet Entity Identifier (-E). Results will be saved to the `universeId` specified in the input file.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            task_id (int): Name of the column for the type Concordance Task Identifier. The taskId is created in response from the /entity-task endpoint.

        Keyword Args:
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EntityDecisionsResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['task_id'] = \
            task_id
        return self.get_entity_decisions_endpoint.call_with_http_info(**kwargs)

    def get_entity_task_for_list(
        self,
        universe_id,
        task_name,
        input_file,
        client_id_column,
        name_column,
        **kwargs
    ) -> EntityTaskResponse:
        """Input a file with names and attributes, creating a taskId.  # noqa: E501

        Upload a Comma-Separated List file (.csv / UTF-8 encoding) with a list of names and attributes and receive a `taskId`. The taskId is then used for reference in the */entity-task-status* and */entity-decisions* endpoints to receive results once the task is successful.<p>This is the first step in the overall \"Bulk\" workflow. Use the /entity-task-status endpoint to check the status.</p> <p> A universeId must be included in request. If you do not have a universe created, reference the `/universe` endpoint.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            universe_id (int): The id of the universe that entities should be mapped to. Reference the `/universe` endpoint to create a universe, or view available universes via `/universes`.
            task_name (str): User defined name for the task that will be used to name the output files.
            input_file (file_type): The UTF-8 encoded CSV File containing the entity names to be concorded to a FactSet Entity Identifier. The files first row **MUST** include headers as defined in the *Column parameters. Be mindful of casing and spacing in column headers. The input file is posted as a file object in the form. For this reason, the mime type of this post request must be multipart/form-data. 
            client_id_column (str): Header Name of the column in the input file that contains a unique identifier supplied by the user referred to as a \\\"clientId\\\". This clientId can be used to create custom mappings or references. 
            name_column (str): Header name of the column in the input file that contains the Entity Name to be matched. 

        Keyword Args:
            country_column (str): Header Name of the column in the input file that contains the country's ISO Code. This is used to filter the candidates before taking a match decision. . [optional]
            url_column (str): Header Name of the column in the input file that contains the Entity's URL. URL corresponding to the entity name that is used when evaluating candidates for a match. . [optional]
            state_column (str): Header Name of the column in the input file that contains the two letter State Code of the state or province where the Entity is located. Currently, only US state codes are supported. . [optional]
            priority_column (str): Header Name of the column in the inputfile that contains the priority for the client id. . [optional]
            bic_column (str): Header Name of the column in the input file for the BICCode, `bank indentification code` symbol type . [optional]
            bbg_ticker_column (str): Header Name of the column in the input file for the Bloomberg `Listing and Regional Ticker` symbol type. [optional]
            cik_column (str): Header Name of the column in the input file for the CIK, `Edgar Central Index Keys` symbol type. [optional]
            crd_column (str): Header Name of the column in the input file for the CRD, `Central Registration Depository` symbol type. [optional]
            cusip_column (str): Header Name of the column in the input file for the `CUSIP` symbol type. [optional]
            duns_column (str): Header Name of the column in the input file for the DUNS, `Dun&Bradstreet` symbol type. [optional]
            ein_column (str): Header Name of the column in the input file for the EIN, `EmployerIdentificationNumber` symbol type. [optional]
            rssd_column (str): Header Name of the column in the input file for the RSSD, `FederalReserveRSSDIdentifier` symbol type. [optional]
            fitch_column (str): Header Name of the column in the input file for the FitchCreditRating, `Fitch Ratings Identifier` symbol type. [optional]
            isin_column (str): Header Name of the column in the input file for the `ISIN`symbol type. [optional]
            lei_column (str): Header Name of the column in the input file for the LEI, `LegalEntityIdentifier` symbol type. [optional]
            bbg_figi_column (str): Header Name of the column in the input file for the `Bloomberg Listing/Regional/Security ID` symbol type. [optional]
            md_column (str): Header Name of the column in the input file for the MoodysIssuer, `Moody's Ratings Identifier` symbol type. [optional]
            ticker_column (str): Header Name of the column in the input file for the `PriceTicker` symbol type. [optional]
            spr_column (str): Header Name of the column in the input file for the S&PRating, `S&P Ratings Identifier` symbol type. [optional]
            sedol_column (str): Header Name of the column in the input file for the `SEDOL` symbol type. [optional]
            ticker_exchange_column (str): Header Name of the column in the input file for the `TickerExchange` symbol type. [optional]
            ticker_region_column (str): Header Name of the column in the input file for the `TickerRegion` symbol type. [optional]
            ukch_column (str): Header Name of the column in the input file for the `UKCompanyHouse` symbol type. [optional]
            valoren_column (str): Header Name of the column in the input file for the VALOR, `Valoren (\\\"Valor\\\") Identification` symbol type. [optional]
            wkn_column (str): Header Name of the column in the input file for the WKN, `German Securities Identification` symbol type. [optional]
            include_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Only candidates with an entity type specified will be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            exclude_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Entities with these types will be excluded from the decisions. It is a global option used to filter the candidates before taking a match decision. Candidates with an entity type specified will *not* be considered for the final match result. **Do not include within `inputFile`.** . [optional]
            include_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Only candidates with an entity subtype specified will be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            exclude_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Candidates with an entity subtype specified will *not* be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityTaskResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        kwargs['task_name'] = \
            task_name
        kwargs['input_file'] = \
            input_file
        kwargs['client_id_column'] = \
            client_id_column
        kwargs['name_column'] = \
            name_column
        return self.get_entity_task_for_list_endpoint.call_with_http_info(**kwargs)

    def get_entity_task_for_list_with_http_info(
        self,
        universe_id,
        task_name,
        input_file,
        client_id_column,
        name_column,
        **kwargs
    ) -> typing.Tuple[EntityTaskResponse, int, typing.MutableMapping]:
        """Input a file with names and attributes, creating a taskId.  # noqa: E501

        Upload a Comma-Separated List file (.csv / UTF-8 encoding) with a list of names and attributes and receive a `taskId`. The taskId is then used for reference in the */entity-task-status* and */entity-decisions* endpoints to receive results once the task is successful.<p>This is the first step in the overall \"Bulk\" workflow. Use the /entity-task-status endpoint to check the status.</p> <p> A universeId must be included in request. If you do not have a universe created, reference the `/universe` endpoint.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            universe_id (int): The id of the universe that entities should be mapped to. Reference the `/universe` endpoint to create a universe, or view available universes via `/universes`.
            task_name (str): User defined name for the task that will be used to name the output files.
            input_file (file_type): The UTF-8 encoded CSV File containing the entity names to be concorded to a FactSet Entity Identifier. The files first row **MUST** include headers as defined in the *Column parameters. Be mindful of casing and spacing in column headers. The input file is posted as a file object in the form. For this reason, the mime type of this post request must be multipart/form-data. 
            client_id_column (str): Header Name of the column in the input file that contains a unique identifier supplied by the user referred to as a \\\"clientId\\\". This clientId can be used to create custom mappings or references. 
            name_column (str): Header name of the column in the input file that contains the Entity Name to be matched. 

        Keyword Args:
            country_column (str): Header Name of the column in the input file that contains the country's ISO Code. This is used to filter the candidates before taking a match decision. . [optional]
            url_column (str): Header Name of the column in the input file that contains the Entity's URL. URL corresponding to the entity name that is used when evaluating candidates for a match. . [optional]
            state_column (str): Header Name of the column in the input file that contains the two letter State Code of the state or province where the Entity is located. Currently, only US state codes are supported. . [optional]
            priority_column (str): Header Name of the column in the inputfile that contains the priority for the client id. . [optional]
            bic_column (str): Header Name of the column in the input file for the BICCode, `bank indentification code` symbol type . [optional]
            bbg_ticker_column (str): Header Name of the column in the input file for the Bloomberg `Listing and Regional Ticker` symbol type. [optional]
            cik_column (str): Header Name of the column in the input file for the CIK, `Edgar Central Index Keys` symbol type. [optional]
            crd_column (str): Header Name of the column in the input file for the CRD, `Central Registration Depository` symbol type. [optional]
            cusip_column (str): Header Name of the column in the input file for the `CUSIP` symbol type. [optional]
            duns_column (str): Header Name of the column in the input file for the DUNS, `Dun&Bradstreet` symbol type. [optional]
            ein_column (str): Header Name of the column in the input file for the EIN, `EmployerIdentificationNumber` symbol type. [optional]
            rssd_column (str): Header Name of the column in the input file for the RSSD, `FederalReserveRSSDIdentifier` symbol type. [optional]
            fitch_column (str): Header Name of the column in the input file for the FitchCreditRating, `Fitch Ratings Identifier` symbol type. [optional]
            isin_column (str): Header Name of the column in the input file for the `ISIN`symbol type. [optional]
            lei_column (str): Header Name of the column in the input file for the LEI, `LegalEntityIdentifier` symbol type. [optional]
            bbg_figi_column (str): Header Name of the column in the input file for the `Bloomberg Listing/Regional/Security ID` symbol type. [optional]
            md_column (str): Header Name of the column in the input file for the MoodysIssuer, `Moody's Ratings Identifier` symbol type. [optional]
            ticker_column (str): Header Name of the column in the input file for the `PriceTicker` symbol type. [optional]
            spr_column (str): Header Name of the column in the input file for the S&PRating, `S&P Ratings Identifier` symbol type. [optional]
            sedol_column (str): Header Name of the column in the input file for the `SEDOL` symbol type. [optional]
            ticker_exchange_column (str): Header Name of the column in the input file for the `TickerExchange` symbol type. [optional]
            ticker_region_column (str): Header Name of the column in the input file for the `TickerRegion` symbol type. [optional]
            ukch_column (str): Header Name of the column in the input file for the `UKCompanyHouse` symbol type. [optional]
            valoren_column (str): Header Name of the column in the input file for the VALOR, `Valoren (\\\"Valor\\\") Identification` symbol type. [optional]
            wkn_column (str): Header Name of the column in the input file for the WKN, `German Securities Identification` symbol type. [optional]
            include_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Only candidates with an entity type specified will be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            exclude_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Entities with these types will be excluded from the decisions. It is a global option used to filter the candidates before taking a match decision. Candidates with an entity type specified will *not* be considered for the final match result. **Do not include within `inputFile`.** . [optional]
            include_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Only candidates with an entity subtype specified will be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            exclude_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Candidates with an entity subtype specified will *not* be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityTaskResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        kwargs['task_name'] = \
            task_name
        kwargs['input_file'] = \
            input_file
        kwargs['client_id_column'] = \
            client_id_column
        kwargs['name_column'] = \
            name_column
        return self.get_entity_task_for_list_endpoint.call_with_http_info(**kwargs)

    def get_entity_task_for_list_async(
        self,
        universe_id,
        task_name,
        input_file,
        client_id_column,
        name_column,
        **kwargs
    ) -> "ApplyResult[EntityTaskResponse]":
        """Input a file with names and attributes, creating a taskId.  # noqa: E501

        Upload a Comma-Separated List file (.csv / UTF-8 encoding) with a list of names and attributes and receive a `taskId`. The taskId is then used for reference in the */entity-task-status* and */entity-decisions* endpoints to receive results once the task is successful.<p>This is the first step in the overall \"Bulk\" workflow. Use the /entity-task-status endpoint to check the status.</p> <p> A universeId must be included in request. If you do not have a universe created, reference the `/universe` endpoint.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            universe_id (int): The id of the universe that entities should be mapped to. Reference the `/universe` endpoint to create a universe, or view available universes via `/universes`.
            task_name (str): User defined name for the task that will be used to name the output files.
            input_file (file_type): The UTF-8 encoded CSV File containing the entity names to be concorded to a FactSet Entity Identifier. The files first row **MUST** include headers as defined in the *Column parameters. Be mindful of casing and spacing in column headers. The input file is posted as a file object in the form. For this reason, the mime type of this post request must be multipart/form-data. 
            client_id_column (str): Header Name of the column in the input file that contains a unique identifier supplied by the user referred to as a \\\"clientId\\\". This clientId can be used to create custom mappings or references. 
            name_column (str): Header name of the column in the input file that contains the Entity Name to be matched. 

        Keyword Args:
            country_column (str): Header Name of the column in the input file that contains the country's ISO Code. This is used to filter the candidates before taking a match decision. . [optional]
            url_column (str): Header Name of the column in the input file that contains the Entity's URL. URL corresponding to the entity name that is used when evaluating candidates for a match. . [optional]
            state_column (str): Header Name of the column in the input file that contains the two letter State Code of the state or province where the Entity is located. Currently, only US state codes are supported. . [optional]
            priority_column (str): Header Name of the column in the inputfile that contains the priority for the client id. . [optional]
            bic_column (str): Header Name of the column in the input file for the BICCode, `bank indentification code` symbol type . [optional]
            bbg_ticker_column (str): Header Name of the column in the input file for the Bloomberg `Listing and Regional Ticker` symbol type. [optional]
            cik_column (str): Header Name of the column in the input file for the CIK, `Edgar Central Index Keys` symbol type. [optional]
            crd_column (str): Header Name of the column in the input file for the CRD, `Central Registration Depository` symbol type. [optional]
            cusip_column (str): Header Name of the column in the input file for the `CUSIP` symbol type. [optional]
            duns_column (str): Header Name of the column in the input file for the DUNS, `Dun&Bradstreet` symbol type. [optional]
            ein_column (str): Header Name of the column in the input file for the EIN, `EmployerIdentificationNumber` symbol type. [optional]
            rssd_column (str): Header Name of the column in the input file for the RSSD, `FederalReserveRSSDIdentifier` symbol type. [optional]
            fitch_column (str): Header Name of the column in the input file for the FitchCreditRating, `Fitch Ratings Identifier` symbol type. [optional]
            isin_column (str): Header Name of the column in the input file for the `ISIN`symbol type. [optional]
            lei_column (str): Header Name of the column in the input file for the LEI, `LegalEntityIdentifier` symbol type. [optional]
            bbg_figi_column (str): Header Name of the column in the input file for the `Bloomberg Listing/Regional/Security ID` symbol type. [optional]
            md_column (str): Header Name of the column in the input file for the MoodysIssuer, `Moody's Ratings Identifier` symbol type. [optional]
            ticker_column (str): Header Name of the column in the input file for the `PriceTicker` symbol type. [optional]
            spr_column (str): Header Name of the column in the input file for the S&PRating, `S&P Ratings Identifier` symbol type. [optional]
            sedol_column (str): Header Name of the column in the input file for the `SEDOL` symbol type. [optional]
            ticker_exchange_column (str): Header Name of the column in the input file for the `TickerExchange` symbol type. [optional]
            ticker_region_column (str): Header Name of the column in the input file for the `TickerRegion` symbol type. [optional]
            ukch_column (str): Header Name of the column in the input file for the `UKCompanyHouse` symbol type. [optional]
            valoren_column (str): Header Name of the column in the input file for the VALOR, `Valoren (\\\"Valor\\\") Identification` symbol type. [optional]
            wkn_column (str): Header Name of the column in the input file for the WKN, `German Securities Identification` symbol type. [optional]
            include_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Only candidates with an entity type specified will be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            exclude_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Entities with these types will be excluded from the decisions. It is a global option used to filter the candidates before taking a match decision. Candidates with an entity type specified will *not* be considered for the final match result. **Do not include within `inputFile`.** . [optional]
            include_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Only candidates with an entity subtype specified will be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            exclude_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Candidates with an entity subtype specified will *not* be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EntityTaskResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        kwargs['task_name'] = \
            task_name
        kwargs['input_file'] = \
            input_file
        kwargs['client_id_column'] = \
            client_id_column
        kwargs['name_column'] = \
            name_column
        return self.get_entity_task_for_list_endpoint.call_with_http_info(**kwargs)

    def get_entity_task_for_list_with_http_info_async(
        self,
        universe_id,
        task_name,
        input_file,
        client_id_column,
        name_column,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EntityTaskResponse, int, typing.MutableMapping]]":
        """Input a file with names and attributes, creating a taskId.  # noqa: E501

        Upload a Comma-Separated List file (.csv / UTF-8 encoding) with a list of names and attributes and receive a `taskId`. The taskId is then used for reference in the */entity-task-status* and */entity-decisions* endpoints to receive results once the task is successful.<p>This is the first step in the overall \"Bulk\" workflow. Use the /entity-task-status endpoint to check the status.</p> <p> A universeId must be included in request. If you do not have a universe created, reference the `/universe` endpoint.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            universe_id (int): The id of the universe that entities should be mapped to. Reference the `/universe` endpoint to create a universe, or view available universes via `/universes`.
            task_name (str): User defined name for the task that will be used to name the output files.
            input_file (file_type): The UTF-8 encoded CSV File containing the entity names to be concorded to a FactSet Entity Identifier. The files first row **MUST** include headers as defined in the *Column parameters. Be mindful of casing and spacing in column headers. The input file is posted as a file object in the form. For this reason, the mime type of this post request must be multipart/form-data. 
            client_id_column (str): Header Name of the column in the input file that contains a unique identifier supplied by the user referred to as a \\\"clientId\\\". This clientId can be used to create custom mappings or references. 
            name_column (str): Header name of the column in the input file that contains the Entity Name to be matched. 

        Keyword Args:
            country_column (str): Header Name of the column in the input file that contains the country's ISO Code. This is used to filter the candidates before taking a match decision. . [optional]
            url_column (str): Header Name of the column in the input file that contains the Entity's URL. URL corresponding to the entity name that is used when evaluating candidates for a match. . [optional]
            state_column (str): Header Name of the column in the input file that contains the two letter State Code of the state or province where the Entity is located. Currently, only US state codes are supported. . [optional]
            priority_column (str): Header Name of the column in the inputfile that contains the priority for the client id. . [optional]
            bic_column (str): Header Name of the column in the input file for the BICCode, `bank indentification code` symbol type . [optional]
            bbg_ticker_column (str): Header Name of the column in the input file for the Bloomberg `Listing and Regional Ticker` symbol type. [optional]
            cik_column (str): Header Name of the column in the input file for the CIK, `Edgar Central Index Keys` symbol type. [optional]
            crd_column (str): Header Name of the column in the input file for the CRD, `Central Registration Depository` symbol type. [optional]
            cusip_column (str): Header Name of the column in the input file for the `CUSIP` symbol type. [optional]
            duns_column (str): Header Name of the column in the input file for the DUNS, `Dun&Bradstreet` symbol type. [optional]
            ein_column (str): Header Name of the column in the input file for the EIN, `EmployerIdentificationNumber` symbol type. [optional]
            rssd_column (str): Header Name of the column in the input file for the RSSD, `FederalReserveRSSDIdentifier` symbol type. [optional]
            fitch_column (str): Header Name of the column in the input file for the FitchCreditRating, `Fitch Ratings Identifier` symbol type. [optional]
            isin_column (str): Header Name of the column in the input file for the `ISIN`symbol type. [optional]
            lei_column (str): Header Name of the column in the input file for the LEI, `LegalEntityIdentifier` symbol type. [optional]
            bbg_figi_column (str): Header Name of the column in the input file for the `Bloomberg Listing/Regional/Security ID` symbol type. [optional]
            md_column (str): Header Name of the column in the input file for the MoodysIssuer, `Moody's Ratings Identifier` symbol type. [optional]
            ticker_column (str): Header Name of the column in the input file for the `PriceTicker` symbol type. [optional]
            spr_column (str): Header Name of the column in the input file for the S&PRating, `S&P Ratings Identifier` symbol type. [optional]
            sedol_column (str): Header Name of the column in the input file for the `SEDOL` symbol type. [optional]
            ticker_exchange_column (str): Header Name of the column in the input file for the `TickerExchange` symbol type. [optional]
            ticker_region_column (str): Header Name of the column in the input file for the `TickerRegion` symbol type. [optional]
            ukch_column (str): Header Name of the column in the input file for the `UKCompanyHouse` symbol type. [optional]
            valoren_column (str): Header Name of the column in the input file for the VALOR, `Valoren (\\\"Valor\\\") Identification` symbol type. [optional]
            wkn_column (str): Header Name of the column in the input file for the WKN, `German Securities Identification` symbol type. [optional]
            include_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Only candidates with an entity type specified will be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            exclude_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Entities with these types will be excluded from the decisions. It is a global option used to filter the candidates before taking a match decision. Candidates with an entity type specified will *not* be considered for the final match result. **Do not include within `inputFile`.** . [optional]
            include_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Only candidates with an entity subtype specified will be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            exclude_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Candidates with an entity subtype specified will *not* be considered for the final match result. Multiple types can be entered separated by commas. **Do not include within `inputFile`.** . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EntityTaskResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        kwargs['task_name'] = \
            task_name
        kwargs['input_file'] = \
            input_file
        kwargs['client_id_column'] = \
            client_id_column
        kwargs['name_column'] = \
            name_column
        return self.get_entity_task_for_list_endpoint.call_with_http_info(**kwargs)

    def get_entity_task_status(
        self,
        **kwargs
    ) -> EntityTaskStatusResponse:
        """Gets the status of the requested taskId or all tasks for a User  # noqa: E501

        Pulls the **status** for ALL the Entity Tasks submitted by a client within the last 30 days, and related details such as task duration and decision rates. Specific Tasks can also be retrieved by using the _taskId_ parameter.<p>Status types include -   * PENDING - The task has not yet started.   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            task_id (int): Name of the column for the type Concordance Task Identifier. The taskId is created in response from the /entity-task endpoint.. [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            status ([str]): Filter on the status of the Concordance Tasks. Default is no filter.   * PENDING - The task has not yet started   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityTaskStatusResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_entity_task_status_endpoint.call_with_http_info(**kwargs)

    def get_entity_task_status_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[EntityTaskStatusResponse, int, typing.MutableMapping]:
        """Gets the status of the requested taskId or all tasks for a User  # noqa: E501

        Pulls the **status** for ALL the Entity Tasks submitted by a client within the last 30 days, and related details such as task duration and decision rates. Specific Tasks can also be retrieved by using the _taskId_ parameter.<p>Status types include -   * PENDING - The task has not yet started.   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            task_id (int): Name of the column for the type Concordance Task Identifier. The taskId is created in response from the /entity-task endpoint.. [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            status ([str]): Filter on the status of the Concordance Tasks. Default is no filter.   * PENDING - The task has not yet started   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityTaskStatusResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_entity_task_status_endpoint.call_with_http_info(**kwargs)

    def get_entity_task_status_async(
        self,
        **kwargs
    ) -> "ApplyResult[EntityTaskStatusResponse]":
        """Gets the status of the requested taskId or all tasks for a User  # noqa: E501

        Pulls the **status** for ALL the Entity Tasks submitted by a client within the last 30 days, and related details such as task duration and decision rates. Specific Tasks can also be retrieved by using the _taskId_ parameter.<p>Status types include -   * PENDING - The task has not yet started.   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            task_id (int): Name of the column for the type Concordance Task Identifier. The taskId is created in response from the /entity-task endpoint.. [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            status ([str]): Filter on the status of the Concordance Tasks. Default is no filter.   * PENDING - The task has not yet started   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EntityTaskStatusResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_entity_task_status_endpoint.call_with_http_info(**kwargs)

    def get_entity_task_status_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EntityTaskStatusResponse, int, typing.MutableMapping]]":
        """Gets the status of the requested taskId or all tasks for a User  # noqa: E501

        Pulls the **status** for ALL the Entity Tasks submitted by a client within the last 30 days, and related details such as task duration and decision rates. Specific Tasks can also be retrieved by using the _taskId_ parameter.<p>Status types include -   * PENDING - The task has not yet started.   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            task_id (int): Name of the column for the type Concordance Task Identifier. The taskId is created in response from the /entity-task endpoint.. [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            status ([str]): Filter on the status of the Concordance Tasks. Default is no filter.   * PENDING - The task has not yet started   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EntityTaskStatusResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_entity_task_status_endpoint.call_with_http_info(**kwargs)

