"""
    FactSet Concordance API

    The FactSet Concordance API provides the ability to programmatically look up several types of entities by their name and other attributes. It attempts to match attributes that you supply for the entity and returns as many match candidates as it can find. The result is a \"concorded\" FactSet Entity Permanent identifier.  The Entity Identifier can then be used as input throughout FactSet's Content soultions, such as Content APIs and Standard DataFeeds.<p> There are two types of workflows supported in the API. The first workflow type follows traditional API conventions in that a request is accepted and a response is returned synchronously. The second workflow type involves a background task. With this workflow, a task is created for uploading a set of queries, and then the client polls for the task to complete. Once the task has completed, the client retrieves the concordance results throught the decisions endpoint.</p>   # noqa: E501

    The version of the OpenAPI document: 2.5.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.FactSetConcordance.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.FactSetConcordance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.FactSetConcordance.exceptions import ApiException
from fds.sdk.FactSetConcordance.model.entity_match_request import EntityMatchRequest
from fds.sdk.FactSetConcordance.model.entity_matches_response import EntityMatchesResponse
from fds.sdk.FactSetConcordance.model.error_response import ErrorResponse





class EntityMatchApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_entity_match_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EntityMatchesResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/entity-match',
                'operation_id': 'get_entity_match',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'country',
                    'state',
                    'url',
                    'include_entity_type',
                    'exclude_entity_type',
                    'include_entity_sub_type',
                    'exclude_entity_sub_type',
                    'include_parent',
                    'bic',
                    'bbg_ticker',
                    'cik',
                    'crd',
                    'cusip',
                    'duns',
                    'ein',
                    'rssd',
                    'fitch',
                    'isin',
                    'lei',
                    'bbg_figi',
                    'md',
                    'ticker',
                    'spr',
                    'sedol',
                    'ticker_exchange',
                    'ticker_region',
                    'ukch',
                    'valoren',
                    'wkn',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'country',
                    'state',
                ]
            },
            root_map={
                'validations': {
                    ('country',): {
                        'max_length': 2,
                        'min_length': 2,
                    },
                    ('state',): {
                        'max_length': 2,
                        'min_length': 2,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'country':
                        (str,),
                    'state':
                        (str,),
                    'url':
                        (str,),
                    'include_entity_type':
                        ([str],),
                    'exclude_entity_type':
                        ([str],),
                    'include_entity_sub_type':
                        ([str],),
                    'exclude_entity_sub_type':
                        ([str],),
                    'include_parent':
                        (bool,),
                    'bic':
                        (str,),
                    'bbg_ticker':
                        (str,),
                    'cik':
                        (str,),
                    'crd':
                        (str,),
                    'cusip':
                        (str,),
                    'duns':
                        (str,),
                    'ein':
                        (str,),
                    'rssd':
                        (str,),
                    'fitch':
                        (str,),
                    'isin':
                        (str,),
                    'lei':
                        (str,),
                    'bbg_figi':
                        (str,),
                    'md':
                        (str,),
                    'ticker':
                        (str,),
                    'spr':
                        (str,),
                    'sedol':
                        (str,),
                    'ticker_exchange':
                        (str,),
                    'ticker_region':
                        (str,),
                    'ukch':
                        (str,),
                    'valoren':
                        (str,),
                    'wkn':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'country': 'country',
                    'state': 'state',
                    'url': 'url',
                    'include_entity_type': 'includeEntityType',
                    'exclude_entity_type': 'excludeEntityType',
                    'include_entity_sub_type': 'includeEntitySubType',
                    'exclude_entity_sub_type': 'excludeEntitySubType',
                    'include_parent': 'includeParent',
                    'bic': 'bic',
                    'bbg_ticker': 'bbgTicker',
                    'cik': 'cik',
                    'crd': 'crd',
                    'cusip': 'cusip',
                    'duns': 'duns',
                    'ein': 'ein',
                    'rssd': 'rssd',
                    'fitch': 'fitch',
                    'isin': 'isin',
                    'lei': 'lei',
                    'bbg_figi': 'bbgFigi',
                    'md': 'md',
                    'ticker': 'ticker',
                    'spr': 'spr',
                    'sedol': 'sedol',
                    'ticker_exchange': 'tickerExchange',
                    'ticker_region': 'tickerRegion',
                    'ukch': 'ukch',
                    'valoren': 'valoren',
                    'wkn': 'wkn',
                },
                'location_map': {
                    'name': 'query',
                    'country': 'query',
                    'state': 'query',
                    'url': 'query',
                    'include_entity_type': 'query',
                    'exclude_entity_type': 'query',
                    'include_entity_sub_type': 'query',
                    'exclude_entity_sub_type': 'query',
                    'include_parent': 'query',
                    'bic': 'query',
                    'bbg_ticker': 'query',
                    'cik': 'query',
                    'crd': 'query',
                    'cusip': 'query',
                    'duns': 'query',
                    'ein': 'query',
                    'rssd': 'query',
                    'fitch': 'query',
                    'isin': 'query',
                    'lei': 'query',
                    'bbg_figi': 'query',
                    'md': 'query',
                    'ticker': 'query',
                    'spr': 'query',
                    'sedol': 'query',
                    'ticker_exchange': 'query',
                    'ticker_region': 'query',
                    'ukch': 'query',
                    'valoren': 'query',
                    'wkn': 'query',
                },
                'collection_format_map': {
                    'include_entity_type': 'multi',
                    'exclude_entity_type': 'multi',
                    'include_entity_sub_type': 'multi',
                    'exclude_entity_sub_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json;charset=utf-8',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_match_for_list_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EntityMatchesResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/entity-match',
                'operation_id': 'get_entity_match_for_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'entity_match_request',
                ],
                'required': [
                    'entity_match_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'entity_match_request':
                        (EntityMatchRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'entity_match_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json;charset=utf-8',
                    'application/json'
                ],
                'content_type': [
                    'application/json;charset=utf-8'
                ]
            },
            api_client=api_client
        )

    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")

    def get_entity_match(
        self,
        name,
        **kwargs
    ) -> EntityMatchesResponse:
        """Get Entity Candidates and Matches for a single name and attributes.  # noqa: E501

        Finds the best candidate entities matching the given entity name. Additional attributes can be supplied to narrow the search, such as State, URL, and Entity Types. <p>**Max of 1 Name permitted in a single GET request.** Use the POST method for /entity-match to fetch up to 25 names. Otherwise, use the \"Entity Match - Bulk\" workflow to submit larger universes of names to be concorded via a file.</p><p>   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            name (str): Name of Entity to match.

        Keyword Args:
            country (str): ISO2 country code corresponding to the entity name that is used when evaluating candidates for a match. For a list of ISO2 Country codes, visit [OA 8754](https://my.apps.factset.com/oa/pages/8754).. [optional]
            state (str): Two-character state code corresponding to the entity name that is used when evaluating candidates for a match. Currently, only US state codes are supported.. [optional]
            url (str): URL corresponding to the entity name that is used when evaluating candidates for a match.. [optional]
            include_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Only candidates with an entity type specified will be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Type Code|Entity Type Description|Entity Type Code|Entity Type Description|   |---|---|---|---|   |ABS|Asset-Backed||MED|Broadcast Call Sign|   |BAS|Business Association (JP)||MUC|Mutual Fd-Closed End|   |CAC|Consolidated Accounting||MUE|Mutual Fd-ETF|   |CMD|Commodity||MUT|Mutual Fd-Open End|   |COL|College/University||NPO|Non-Profit Organization|   |CUR|Currency||OPD|Operating Division|   |ESP|Emp Stk Ownership Plan||OTH|Other|   |EXT|Extinct||PEF|Pension Fund|   |FAF|Family of Fds (VC/Pvt EQ)||PRO|Real Property|   |FND|Foundation/Endowment||PUB|Public Company|   |FNS|Financing Subsidiary/SPE||PVF|Private Eq Fd/Alt Invt|   |FRX|ForEx||PVT|Private Company|   |GOV|Government||SOV|Sovereign Wealth Fund|   |HED|Hedge Fund||SUB|Subsidiary|   |HOL|Holding Company||TRU|Trust/Trustee|   |IDX|Index||UMB|Umbrella Fund|   |VEN|Venture Capital Fund||JVT|Joint Venture| . [optional]
            exclude_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Candidates with an entity type specified will *not* be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Type Code|Entity Type Description|Entity Type Code|Entity Type Description|   |---|---|---|---| |ABS|Asset-Backed||MED|Broadcast Call Sign| |BAS|Business Association (JP)||MUC|Mutual Fd-Closed End| |CAC|Consolidated Accounting||MUE|Mutual Fd-ETF| |CMD|Commodity||MUT|Mutual Fd-Open End| |COL|College/University||NPO|Non-Profit Organization| |CUR|Currency||OPD|Operating Division| |ESP|Emp Stk Ownership Plan||OTH|Other| |EXT|Extinct||PEF|Pension Fund| |FAF|Family of Fds (VC/Pvt EQ)||PRO|Real Property| |FND|Foundation/Endowment||PUB|Public Company| |FNS|Financing Subsidiary/SPE||PVF|Private Eq Fd/Alt Invt| |FRX|ForEx||PVT|Private Company| |GOV|Government||SOV|Sovereign Wealth Fund| |HED|Hedge Fund||SUB|Subsidiary| |HOL|Holding Company||TRU|Trust/Trustee| |IDX|Index||UMB|Umbrella Fund| |VEN|Venture Capital Fund||JVT|Joint Venture| . [optional]
            include_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Only candidates with an entity subtype specified will be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Subtype Code|Entity Subtype Description|Entity Subtype Code|Entity Subtype Description|   |---|---|---|---|   |AR|Arbitrage|IC|Investment Company|   |BM|Bank Investment Division|IN|Insurance Company|   |BR|Broker|MF|Mutual Fund Manager|   |CP|Corporate|ML|Master Ltd Part|   |CU|Custodial|MM|Market Maker|   |FF|Fund of Funds Manager|PB|Private Banking/Wealth Mgmt|   |FH|Fund of Hedge Funds Manager|PF|Pension Fund Manager|   |FO|Foundation/Endowment Manager|PP|Real Estate Manager|   |FS|Fund Distributor|RE|Research Firm|   |FU|Fund|SB|Subsidiary Branch|   |FY|Family Office|ST|Stock Borrowing/Lending|   |GV|Govt (Fed/Local/Agency)|SV|Sovereign Wealth Manager|   |HF|Hedge Fund Manager|VC|Venture Capital/Pvt Equity|   |IA|Investment Adviser|   |IB|Investment Banking| . [optional]
            exclude_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Candidates with an entity subtype specified will not be considered for the final match result. Multiple types can be entered separated by commas. |Entity Subtype Code|Entity Subtype Description|Entity Subtype Code|Entity Subtype Description| |---|---|---|---| |AR|Arbitrage|IC|Investment Company| |BM|Bank Investment Division|IN|Insurance Company| |BR|Broker|MF|Mutual Fund Manager| |CP|Corporate|ML|Master Ltd Part| |CU|Custodial|MM|Market Maker| |FF|Fund of Funds Manager|PB|Private Banking/Wealth Mgmt| |FH|Fund of Hedge Funds Manager|PF|Pension Fund Manager| |FO|Foundation/Endowment Manager|PP|Real Estate Manager| |FS|Fund Distributor|RE|Research Firm| |FU|Fund|SB|Subsidiary Branch| |FY|Family Office|ST|Stock Borrowing/Lending| |GV|Govt (Fed/Local/Agency)|SV|Sovereign Wealth Manager| |HF|Hedge Fund Manager|VC|Venture Capital/Pvt Equity| |IA|Investment Adviser| |IB|Investment Banking| . [optional]
            include_parent (bool): Flag to include parent entities in the list of candidates. This parameter does not influence the match result.. [optional] if omitted the server will use the default value of False
            bic (str): Input identifiers for the BICCode - Bank Indentification Code symbol Type.. [optional]
            bbg_ticker (str): Input identifiers for the Bloomberg Listing and Regional Ticker symbol Type. [optional]
            cik (str): Input identifiers for the CIK - Edgar Central Index Keys symbol type. [optional]
            crd (str): Input identifiers for the CRD - Central Registration Depository symbol type. [optional]
            cusip (str): Input identifiers for the CUSIP symbol type. [optional]
            duns (str): Input identifiers for the DUNS - Dun & Bradstreet Data Universal Numbering System symbol type. [optional]
            ein (str): Input identifiers for the EIN - Employer Identification Number symbol type. [optional]
            rssd (str): Input identifiers for the RSSD - Federal Reserve RSSD symbol type. [optional]
            fitch (str): Input identifiers for the Fitch - Fitch Ratings symbol type. [optional]
            isin (str): Input identifiers for the ISIN - International Securities Identification Number symbol type. [optional]
            lei (str): Input identifiers for the LEI - Legal Entity Identifier symbol type. [optional]
            bbg_figi (str): Input identifiers for the Bloomberg Listing/Regional/Security ID symbol type. [optional]
            md (str): Input identifiers for the Moody's Ratings Identifier type. [optional]
            ticker (str): Input identifiers for the Price Ticker symbol type. [optional]
            spr (str): Input identifiers for the S&PRating - S&P Ratings Identifier symbol type. [optional]
            sedol (str): Input identifiers for the SEDOL symbol type. [optional]
            ticker_exchange (str): Input identifiers for the TickerExchange. [optional]
            ticker_region (str): Input identifiers for the TickerRegion.. [optional]
            ukch (str): Input identifiers for the UKCH - UK Company House symbol type. [optional]
            valoren (str): Input identifiers for the Valoren (\"Valor\") symbol type. [optional]
            wkn (str): Input identifiers for the WKN - German Securities symbol type. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityMatchesResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['name'] = \
            name
        return self.get_entity_match_endpoint.call_with_http_info(**kwargs)

    def get_entity_match_with_http_info(
        self,
        name,
        **kwargs
    ) -> typing.Tuple[EntityMatchesResponse, int, typing.MutableMapping]:
        """Get Entity Candidates and Matches for a single name and attributes.  # noqa: E501

        Finds the best candidate entities matching the given entity name. Additional attributes can be supplied to narrow the search, such as State, URL, and Entity Types. <p>**Max of 1 Name permitted in a single GET request.** Use the POST method for /entity-match to fetch up to 25 names. Otherwise, use the \"Entity Match - Bulk\" workflow to submit larger universes of names to be concorded via a file.</p><p>   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            name (str): Name of Entity to match.

        Keyword Args:
            country (str): ISO2 country code corresponding to the entity name that is used when evaluating candidates for a match. For a list of ISO2 Country codes, visit [OA 8754](https://my.apps.factset.com/oa/pages/8754).. [optional]
            state (str): Two-character state code corresponding to the entity name that is used when evaluating candidates for a match. Currently, only US state codes are supported.. [optional]
            url (str): URL corresponding to the entity name that is used when evaluating candidates for a match.. [optional]
            include_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Only candidates with an entity type specified will be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Type Code|Entity Type Description|Entity Type Code|Entity Type Description|   |---|---|---|---|   |ABS|Asset-Backed||MED|Broadcast Call Sign|   |BAS|Business Association (JP)||MUC|Mutual Fd-Closed End|   |CAC|Consolidated Accounting||MUE|Mutual Fd-ETF|   |CMD|Commodity||MUT|Mutual Fd-Open End|   |COL|College/University||NPO|Non-Profit Organization|   |CUR|Currency||OPD|Operating Division|   |ESP|Emp Stk Ownership Plan||OTH|Other|   |EXT|Extinct||PEF|Pension Fund|   |FAF|Family of Fds (VC/Pvt EQ)||PRO|Real Property|   |FND|Foundation/Endowment||PUB|Public Company|   |FNS|Financing Subsidiary/SPE||PVF|Private Eq Fd/Alt Invt|   |FRX|ForEx||PVT|Private Company|   |GOV|Government||SOV|Sovereign Wealth Fund|   |HED|Hedge Fund||SUB|Subsidiary|   |HOL|Holding Company||TRU|Trust/Trustee|   |IDX|Index||UMB|Umbrella Fund|   |VEN|Venture Capital Fund||JVT|Joint Venture| . [optional]
            exclude_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Candidates with an entity type specified will *not* be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Type Code|Entity Type Description|Entity Type Code|Entity Type Description|   |---|---|---|---| |ABS|Asset-Backed||MED|Broadcast Call Sign| |BAS|Business Association (JP)||MUC|Mutual Fd-Closed End| |CAC|Consolidated Accounting||MUE|Mutual Fd-ETF| |CMD|Commodity||MUT|Mutual Fd-Open End| |COL|College/University||NPO|Non-Profit Organization| |CUR|Currency||OPD|Operating Division| |ESP|Emp Stk Ownership Plan||OTH|Other| |EXT|Extinct||PEF|Pension Fund| |FAF|Family of Fds (VC/Pvt EQ)||PRO|Real Property| |FND|Foundation/Endowment||PUB|Public Company| |FNS|Financing Subsidiary/SPE||PVF|Private Eq Fd/Alt Invt| |FRX|ForEx||PVT|Private Company| |GOV|Government||SOV|Sovereign Wealth Fund| |HED|Hedge Fund||SUB|Subsidiary| |HOL|Holding Company||TRU|Trust/Trustee| |IDX|Index||UMB|Umbrella Fund| |VEN|Venture Capital Fund||JVT|Joint Venture| . [optional]
            include_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Only candidates with an entity subtype specified will be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Subtype Code|Entity Subtype Description|Entity Subtype Code|Entity Subtype Description|   |---|---|---|---|   |AR|Arbitrage|IC|Investment Company|   |BM|Bank Investment Division|IN|Insurance Company|   |BR|Broker|MF|Mutual Fund Manager|   |CP|Corporate|ML|Master Ltd Part|   |CU|Custodial|MM|Market Maker|   |FF|Fund of Funds Manager|PB|Private Banking/Wealth Mgmt|   |FH|Fund of Hedge Funds Manager|PF|Pension Fund Manager|   |FO|Foundation/Endowment Manager|PP|Real Estate Manager|   |FS|Fund Distributor|RE|Research Firm|   |FU|Fund|SB|Subsidiary Branch|   |FY|Family Office|ST|Stock Borrowing/Lending|   |GV|Govt (Fed/Local/Agency)|SV|Sovereign Wealth Manager|   |HF|Hedge Fund Manager|VC|Venture Capital/Pvt Equity|   |IA|Investment Adviser|   |IB|Investment Banking| . [optional]
            exclude_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Candidates with an entity subtype specified will not be considered for the final match result. Multiple types can be entered separated by commas. |Entity Subtype Code|Entity Subtype Description|Entity Subtype Code|Entity Subtype Description| |---|---|---|---| |AR|Arbitrage|IC|Investment Company| |BM|Bank Investment Division|IN|Insurance Company| |BR|Broker|MF|Mutual Fund Manager| |CP|Corporate|ML|Master Ltd Part| |CU|Custodial|MM|Market Maker| |FF|Fund of Funds Manager|PB|Private Banking/Wealth Mgmt| |FH|Fund of Hedge Funds Manager|PF|Pension Fund Manager| |FO|Foundation/Endowment Manager|PP|Real Estate Manager| |FS|Fund Distributor|RE|Research Firm| |FU|Fund|SB|Subsidiary Branch| |FY|Family Office|ST|Stock Borrowing/Lending| |GV|Govt (Fed/Local/Agency)|SV|Sovereign Wealth Manager| |HF|Hedge Fund Manager|VC|Venture Capital/Pvt Equity| |IA|Investment Adviser| |IB|Investment Banking| . [optional]
            include_parent (bool): Flag to include parent entities in the list of candidates. This parameter does not influence the match result.. [optional] if omitted the server will use the default value of False
            bic (str): Input identifiers for the BICCode - Bank Indentification Code symbol Type.. [optional]
            bbg_ticker (str): Input identifiers for the Bloomberg Listing and Regional Ticker symbol Type. [optional]
            cik (str): Input identifiers for the CIK - Edgar Central Index Keys symbol type. [optional]
            crd (str): Input identifiers for the CRD - Central Registration Depository symbol type. [optional]
            cusip (str): Input identifiers for the CUSIP symbol type. [optional]
            duns (str): Input identifiers for the DUNS - Dun & Bradstreet Data Universal Numbering System symbol type. [optional]
            ein (str): Input identifiers for the EIN - Employer Identification Number symbol type. [optional]
            rssd (str): Input identifiers for the RSSD - Federal Reserve RSSD symbol type. [optional]
            fitch (str): Input identifiers for the Fitch - Fitch Ratings symbol type. [optional]
            isin (str): Input identifiers for the ISIN - International Securities Identification Number symbol type. [optional]
            lei (str): Input identifiers for the LEI - Legal Entity Identifier symbol type. [optional]
            bbg_figi (str): Input identifiers for the Bloomberg Listing/Regional/Security ID symbol type. [optional]
            md (str): Input identifiers for the Moody's Ratings Identifier type. [optional]
            ticker (str): Input identifiers for the Price Ticker symbol type. [optional]
            spr (str): Input identifiers for the S&PRating - S&P Ratings Identifier symbol type. [optional]
            sedol (str): Input identifiers for the SEDOL symbol type. [optional]
            ticker_exchange (str): Input identifiers for the TickerExchange. [optional]
            ticker_region (str): Input identifiers for the TickerRegion.. [optional]
            ukch (str): Input identifiers for the UKCH - UK Company House symbol type. [optional]
            valoren (str): Input identifiers for the Valoren (\"Valor\") symbol type. [optional]
            wkn (str): Input identifiers for the WKN - German Securities symbol type. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityMatchesResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['name'] = \
            name
        return self.get_entity_match_endpoint.call_with_http_info(**kwargs)

    def get_entity_match_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[EntityMatchesResponse]":
        """Get Entity Candidates and Matches for a single name and attributes.  # noqa: E501

        Finds the best candidate entities matching the given entity name. Additional attributes can be supplied to narrow the search, such as State, URL, and Entity Types. <p>**Max of 1 Name permitted in a single GET request.** Use the POST method for /entity-match to fetch up to 25 names. Otherwise, use the \"Entity Match - Bulk\" workflow to submit larger universes of names to be concorded via a file.</p><p>   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            name (str): Name of Entity to match.

        Keyword Args:
            country (str): ISO2 country code corresponding to the entity name that is used when evaluating candidates for a match. For a list of ISO2 Country codes, visit [OA 8754](https://my.apps.factset.com/oa/pages/8754).. [optional]
            state (str): Two-character state code corresponding to the entity name that is used when evaluating candidates for a match. Currently, only US state codes are supported.. [optional]
            url (str): URL corresponding to the entity name that is used when evaluating candidates for a match.. [optional]
            include_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Only candidates with an entity type specified will be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Type Code|Entity Type Description|Entity Type Code|Entity Type Description|   |---|---|---|---|   |ABS|Asset-Backed||MED|Broadcast Call Sign|   |BAS|Business Association (JP)||MUC|Mutual Fd-Closed End|   |CAC|Consolidated Accounting||MUE|Mutual Fd-ETF|   |CMD|Commodity||MUT|Mutual Fd-Open End|   |COL|College/University||NPO|Non-Profit Organization|   |CUR|Currency||OPD|Operating Division|   |ESP|Emp Stk Ownership Plan||OTH|Other|   |EXT|Extinct||PEF|Pension Fund|   |FAF|Family of Fds (VC/Pvt EQ)||PRO|Real Property|   |FND|Foundation/Endowment||PUB|Public Company|   |FNS|Financing Subsidiary/SPE||PVF|Private Eq Fd/Alt Invt|   |FRX|ForEx||PVT|Private Company|   |GOV|Government||SOV|Sovereign Wealth Fund|   |HED|Hedge Fund||SUB|Subsidiary|   |HOL|Holding Company||TRU|Trust/Trustee|   |IDX|Index||UMB|Umbrella Fund|   |VEN|Venture Capital Fund||JVT|Joint Venture| . [optional]
            exclude_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Candidates with an entity type specified will *not* be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Type Code|Entity Type Description|Entity Type Code|Entity Type Description|   |---|---|---|---| |ABS|Asset-Backed||MED|Broadcast Call Sign| |BAS|Business Association (JP)||MUC|Mutual Fd-Closed End| |CAC|Consolidated Accounting||MUE|Mutual Fd-ETF| |CMD|Commodity||MUT|Mutual Fd-Open End| |COL|College/University||NPO|Non-Profit Organization| |CUR|Currency||OPD|Operating Division| |ESP|Emp Stk Ownership Plan||OTH|Other| |EXT|Extinct||PEF|Pension Fund| |FAF|Family of Fds (VC/Pvt EQ)||PRO|Real Property| |FND|Foundation/Endowment||PUB|Public Company| |FNS|Financing Subsidiary/SPE||PVF|Private Eq Fd/Alt Invt| |FRX|ForEx||PVT|Private Company| |GOV|Government||SOV|Sovereign Wealth Fund| |HED|Hedge Fund||SUB|Subsidiary| |HOL|Holding Company||TRU|Trust/Trustee| |IDX|Index||UMB|Umbrella Fund| |VEN|Venture Capital Fund||JVT|Joint Venture| . [optional]
            include_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Only candidates with an entity subtype specified will be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Subtype Code|Entity Subtype Description|Entity Subtype Code|Entity Subtype Description|   |---|---|---|---|   |AR|Arbitrage|IC|Investment Company|   |BM|Bank Investment Division|IN|Insurance Company|   |BR|Broker|MF|Mutual Fund Manager|   |CP|Corporate|ML|Master Ltd Part|   |CU|Custodial|MM|Market Maker|   |FF|Fund of Funds Manager|PB|Private Banking/Wealth Mgmt|   |FH|Fund of Hedge Funds Manager|PF|Pension Fund Manager|   |FO|Foundation/Endowment Manager|PP|Real Estate Manager|   |FS|Fund Distributor|RE|Research Firm|   |FU|Fund|SB|Subsidiary Branch|   |FY|Family Office|ST|Stock Borrowing/Lending|   |GV|Govt (Fed/Local/Agency)|SV|Sovereign Wealth Manager|   |HF|Hedge Fund Manager|VC|Venture Capital/Pvt Equity|   |IA|Investment Adviser|   |IB|Investment Banking| . [optional]
            exclude_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Candidates with an entity subtype specified will not be considered for the final match result. Multiple types can be entered separated by commas. |Entity Subtype Code|Entity Subtype Description|Entity Subtype Code|Entity Subtype Description| |---|---|---|---| |AR|Arbitrage|IC|Investment Company| |BM|Bank Investment Division|IN|Insurance Company| |BR|Broker|MF|Mutual Fund Manager| |CP|Corporate|ML|Master Ltd Part| |CU|Custodial|MM|Market Maker| |FF|Fund of Funds Manager|PB|Private Banking/Wealth Mgmt| |FH|Fund of Hedge Funds Manager|PF|Pension Fund Manager| |FO|Foundation/Endowment Manager|PP|Real Estate Manager| |FS|Fund Distributor|RE|Research Firm| |FU|Fund|SB|Subsidiary Branch| |FY|Family Office|ST|Stock Borrowing/Lending| |GV|Govt (Fed/Local/Agency)|SV|Sovereign Wealth Manager| |HF|Hedge Fund Manager|VC|Venture Capital/Pvt Equity| |IA|Investment Adviser| |IB|Investment Banking| . [optional]
            include_parent (bool): Flag to include parent entities in the list of candidates. This parameter does not influence the match result.. [optional] if omitted the server will use the default value of False
            bic (str): Input identifiers for the BICCode - Bank Indentification Code symbol Type.. [optional]
            bbg_ticker (str): Input identifiers for the Bloomberg Listing and Regional Ticker symbol Type. [optional]
            cik (str): Input identifiers for the CIK - Edgar Central Index Keys symbol type. [optional]
            crd (str): Input identifiers for the CRD - Central Registration Depository symbol type. [optional]
            cusip (str): Input identifiers for the CUSIP symbol type. [optional]
            duns (str): Input identifiers for the DUNS - Dun & Bradstreet Data Universal Numbering System symbol type. [optional]
            ein (str): Input identifiers for the EIN - Employer Identification Number symbol type. [optional]
            rssd (str): Input identifiers for the RSSD - Federal Reserve RSSD symbol type. [optional]
            fitch (str): Input identifiers for the Fitch - Fitch Ratings symbol type. [optional]
            isin (str): Input identifiers for the ISIN - International Securities Identification Number symbol type. [optional]
            lei (str): Input identifiers for the LEI - Legal Entity Identifier symbol type. [optional]
            bbg_figi (str): Input identifiers for the Bloomberg Listing/Regional/Security ID symbol type. [optional]
            md (str): Input identifiers for the Moody's Ratings Identifier type. [optional]
            ticker (str): Input identifiers for the Price Ticker symbol type. [optional]
            spr (str): Input identifiers for the S&PRating - S&P Ratings Identifier symbol type. [optional]
            sedol (str): Input identifiers for the SEDOL symbol type. [optional]
            ticker_exchange (str): Input identifiers for the TickerExchange. [optional]
            ticker_region (str): Input identifiers for the TickerRegion.. [optional]
            ukch (str): Input identifiers for the UKCH - UK Company House symbol type. [optional]
            valoren (str): Input identifiers for the Valoren (\"Valor\") symbol type. [optional]
            wkn (str): Input identifiers for the WKN - German Securities symbol type. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EntityMatchesResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['name'] = \
            name
        return self.get_entity_match_endpoint.call_with_http_info(**kwargs)

    def get_entity_match_with_http_info_async(
        self,
        name,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EntityMatchesResponse, int, typing.MutableMapping]]":
        """Get Entity Candidates and Matches for a single name and attributes.  # noqa: E501

        Finds the best candidate entities matching the given entity name. Additional attributes can be supplied to narrow the search, such as State, URL, and Entity Types. <p>**Max of 1 Name permitted in a single GET request.** Use the POST method for /entity-match to fetch up to 25 names. Otherwise, use the \"Entity Match - Bulk\" workflow to submit larger universes of names to be concorded via a file.</p><p>   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            name (str): Name of Entity to match.

        Keyword Args:
            country (str): ISO2 country code corresponding to the entity name that is used when evaluating candidates for a match. For a list of ISO2 Country codes, visit [OA 8754](https://my.apps.factset.com/oa/pages/8754).. [optional]
            state (str): Two-character state code corresponding to the entity name that is used when evaluating candidates for a match. Currently, only US state codes are supported.. [optional]
            url (str): URL corresponding to the entity name that is used when evaluating candidates for a match.. [optional]
            include_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Only candidates with an entity type specified will be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Type Code|Entity Type Description|Entity Type Code|Entity Type Description|   |---|---|---|---|   |ABS|Asset-Backed||MED|Broadcast Call Sign|   |BAS|Business Association (JP)||MUC|Mutual Fd-Closed End|   |CAC|Consolidated Accounting||MUE|Mutual Fd-ETF|   |CMD|Commodity||MUT|Mutual Fd-Open End|   |COL|College/University||NPO|Non-Profit Organization|   |CUR|Currency||OPD|Operating Division|   |ESP|Emp Stk Ownership Plan||OTH|Other|   |EXT|Extinct||PEF|Pension Fund|   |FAF|Family of Fds (VC/Pvt EQ)||PRO|Real Property|   |FND|Foundation/Endowment||PUB|Public Company|   |FNS|Financing Subsidiary/SPE||PVF|Private Eq Fd/Alt Invt|   |FRX|ForEx||PVT|Private Company|   |GOV|Government||SOV|Sovereign Wealth Fund|   |HED|Hedge Fund||SUB|Subsidiary|   |HOL|Holding Company||TRU|Trust/Trustee|   |IDX|Index||UMB|Umbrella Fund|   |VEN|Venture Capital Fund||JVT|Joint Venture| . [optional]
            exclude_entity_type ([str]): Three-character FactSet entity type code used to filter candidates in order to determine the final match result. Candidates with an entity type specified will *not* be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Type Code|Entity Type Description|Entity Type Code|Entity Type Description|   |---|---|---|---| |ABS|Asset-Backed||MED|Broadcast Call Sign| |BAS|Business Association (JP)||MUC|Mutual Fd-Closed End| |CAC|Consolidated Accounting||MUE|Mutual Fd-ETF| |CMD|Commodity||MUT|Mutual Fd-Open End| |COL|College/University||NPO|Non-Profit Organization| |CUR|Currency||OPD|Operating Division| |ESP|Emp Stk Ownership Plan||OTH|Other| |EXT|Extinct||PEF|Pension Fund| |FAF|Family of Fds (VC/Pvt EQ)||PRO|Real Property| |FND|Foundation/Endowment||PUB|Public Company| |FNS|Financing Subsidiary/SPE||PVF|Private Eq Fd/Alt Invt| |FRX|ForEx||PVT|Private Company| |GOV|Government||SOV|Sovereign Wealth Fund| |HED|Hedge Fund||SUB|Subsidiary| |HOL|Holding Company||TRU|Trust/Trustee| |IDX|Index||UMB|Umbrella Fund| |VEN|Venture Capital Fund||JVT|Joint Venture| . [optional]
            include_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Only candidates with an entity subtype specified will be considered for the final match result. Multiple types can be entered separated by commas.   |Entity Subtype Code|Entity Subtype Description|Entity Subtype Code|Entity Subtype Description|   |---|---|---|---|   |AR|Arbitrage|IC|Investment Company|   |BM|Bank Investment Division|IN|Insurance Company|   |BR|Broker|MF|Mutual Fund Manager|   |CP|Corporate|ML|Master Ltd Part|   |CU|Custodial|MM|Market Maker|   |FF|Fund of Funds Manager|PB|Private Banking/Wealth Mgmt|   |FH|Fund of Hedge Funds Manager|PF|Pension Fund Manager|   |FO|Foundation/Endowment Manager|PP|Real Estate Manager|   |FS|Fund Distributor|RE|Research Firm|   |FU|Fund|SB|Subsidiary Branch|   |FY|Family Office|ST|Stock Borrowing/Lending|   |GV|Govt (Fed/Local/Agency)|SV|Sovereign Wealth Manager|   |HF|Hedge Fund Manager|VC|Venture Capital/Pvt Equity|   |IA|Investment Adviser|   |IB|Investment Banking| . [optional]
            exclude_entity_sub_type ([str]): Two-character FactSet entity subtype code used to filter candidates in order to determine the final match result. Candidates with an entity subtype specified will not be considered for the final match result. Multiple types can be entered separated by commas. |Entity Subtype Code|Entity Subtype Description|Entity Subtype Code|Entity Subtype Description| |---|---|---|---| |AR|Arbitrage|IC|Investment Company| |BM|Bank Investment Division|IN|Insurance Company| |BR|Broker|MF|Mutual Fund Manager| |CP|Corporate|ML|Master Ltd Part| |CU|Custodial|MM|Market Maker| |FF|Fund of Funds Manager|PB|Private Banking/Wealth Mgmt| |FH|Fund of Hedge Funds Manager|PF|Pension Fund Manager| |FO|Foundation/Endowment Manager|PP|Real Estate Manager| |FS|Fund Distributor|RE|Research Firm| |FU|Fund|SB|Subsidiary Branch| |FY|Family Office|ST|Stock Borrowing/Lending| |GV|Govt (Fed/Local/Agency)|SV|Sovereign Wealth Manager| |HF|Hedge Fund Manager|VC|Venture Capital/Pvt Equity| |IA|Investment Adviser| |IB|Investment Banking| . [optional]
            include_parent (bool): Flag to include parent entities in the list of candidates. This parameter does not influence the match result.. [optional] if omitted the server will use the default value of False
            bic (str): Input identifiers for the BICCode - Bank Indentification Code symbol Type.. [optional]
            bbg_ticker (str): Input identifiers for the Bloomberg Listing and Regional Ticker symbol Type. [optional]
            cik (str): Input identifiers for the CIK - Edgar Central Index Keys symbol type. [optional]
            crd (str): Input identifiers for the CRD - Central Registration Depository symbol type. [optional]
            cusip (str): Input identifiers for the CUSIP symbol type. [optional]
            duns (str): Input identifiers for the DUNS - Dun & Bradstreet Data Universal Numbering System symbol type. [optional]
            ein (str): Input identifiers for the EIN - Employer Identification Number symbol type. [optional]
            rssd (str): Input identifiers for the RSSD - Federal Reserve RSSD symbol type. [optional]
            fitch (str): Input identifiers for the Fitch - Fitch Ratings symbol type. [optional]
            isin (str): Input identifiers for the ISIN - International Securities Identification Number symbol type. [optional]
            lei (str): Input identifiers for the LEI - Legal Entity Identifier symbol type. [optional]
            bbg_figi (str): Input identifiers for the Bloomberg Listing/Regional/Security ID symbol type. [optional]
            md (str): Input identifiers for the Moody's Ratings Identifier type. [optional]
            ticker (str): Input identifiers for the Price Ticker symbol type. [optional]
            spr (str): Input identifiers for the S&PRating - S&P Ratings Identifier symbol type. [optional]
            sedol (str): Input identifiers for the SEDOL symbol type. [optional]
            ticker_exchange (str): Input identifiers for the TickerExchange. [optional]
            ticker_region (str): Input identifiers for the TickerRegion.. [optional]
            ukch (str): Input identifiers for the UKCH - UK Company House symbol type. [optional]
            valoren (str): Input identifiers for the Valoren (\"Valor\") symbol type. [optional]
            wkn (str): Input identifiers for the WKN - German Securities symbol type. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EntityMatchesResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['name'] = \
            name
        return self.get_entity_match_endpoint.call_with_http_info(**kwargs)

    def get_entity_match_for_list(
        self,
        entity_match_request,
        **kwargs
    ) -> EntityMatchesResponse:
        """Get a list of Entity Candidates and Matches for a requested list of up to 25 names and attributes.  # noqa: E501

        Finds the best candidate entities matching the given entity name. If a `universeId` is provided, any match for an input including a `clientId` will be saved to that universe. Additional attributes can be supplied to narrow the search, such as State, URL, and Entity Types. Finds the best candidate entities matching the given company name. Additional attributes can be supplied to narrow the search.  <p>**Max of 25 Names inputted.** Use the \"Entity Match - Bulk\" workflow to submit larger universes of names to be concorded via a file.</p><p> Supported types of Entities in which the names can match to include -   * Corporations, Joint Ventures, and Holding Companies   * Fund Managers and various Fund Types (Open-end, Closed End, Hedge, Soverign Wealth, Pension, Exchange Traded, and more).</p>   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            entity_match_request (EntityMatchRequest): A request to match a Entity.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityMatchesResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['entity_match_request'] = \
            entity_match_request
        return self.get_entity_match_for_list_endpoint.call_with_http_info(**kwargs)

    def get_entity_match_for_list_with_http_info(
        self,
        entity_match_request,
        **kwargs
    ) -> typing.Tuple[EntityMatchesResponse, int, typing.MutableMapping]:
        """Get a list of Entity Candidates and Matches for a requested list of up to 25 names and attributes.  # noqa: E501

        Finds the best candidate entities matching the given entity name. If a `universeId` is provided, any match for an input including a `clientId` will be saved to that universe. Additional attributes can be supplied to narrow the search, such as State, URL, and Entity Types. Finds the best candidate entities matching the given company name. Additional attributes can be supplied to narrow the search.  <p>**Max of 25 Names inputted.** Use the \"Entity Match - Bulk\" workflow to submit larger universes of names to be concorded via a file.</p><p> Supported types of Entities in which the names can match to include -   * Corporations, Joint Ventures, and Holding Companies   * Fund Managers and various Fund Types (Open-end, Closed End, Hedge, Soverign Wealth, Pension, Exchange Traded, and more).</p>   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            entity_match_request (EntityMatchRequest): A request to match a Entity.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityMatchesResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['entity_match_request'] = \
            entity_match_request
        return self.get_entity_match_for_list_endpoint.call_with_http_info(**kwargs)

    def get_entity_match_for_list_async(
        self,
        entity_match_request,
        **kwargs
    ) -> "ApplyResult[EntityMatchesResponse]":
        """Get a list of Entity Candidates and Matches for a requested list of up to 25 names and attributes.  # noqa: E501

        Finds the best candidate entities matching the given entity name. If a `universeId` is provided, any match for an input including a `clientId` will be saved to that universe. Additional attributes can be supplied to narrow the search, such as State, URL, and Entity Types. Finds the best candidate entities matching the given company name. Additional attributes can be supplied to narrow the search.  <p>**Max of 25 Names inputted.** Use the \"Entity Match - Bulk\" workflow to submit larger universes of names to be concorded via a file.</p><p> Supported types of Entities in which the names can match to include -   * Corporations, Joint Ventures, and Holding Companies   * Fund Managers and various Fund Types (Open-end, Closed End, Hedge, Soverign Wealth, Pension, Exchange Traded, and more).</p>   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            entity_match_request (EntityMatchRequest): A request to match a Entity.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EntityMatchesResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['entity_match_request'] = \
            entity_match_request
        return self.get_entity_match_for_list_endpoint.call_with_http_info(**kwargs)

    def get_entity_match_for_list_with_http_info_async(
        self,
        entity_match_request,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EntityMatchesResponse, int, typing.MutableMapping]]":
        """Get a list of Entity Candidates and Matches for a requested list of up to 25 names and attributes.  # noqa: E501

        Finds the best candidate entities matching the given entity name. If a `universeId` is provided, any match for an input including a `clientId` will be saved to that universe. Additional attributes can be supplied to narrow the search, such as State, URL, and Entity Types. Finds the best candidate entities matching the given company name. Additional attributes can be supplied to narrow the search.  <p>**Max of 25 Names inputted.** Use the \"Entity Match - Bulk\" workflow to submit larger universes of names to be concorded via a file.</p><p> Supported types of Entities in which the names can match to include -   * Corporations, Joint Ventures, and Holding Companies   * Fund Managers and various Fund Types (Open-end, Closed End, Hedge, Soverign Wealth, Pension, Exchange Traded, and more).</p>   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            entity_match_request (EntityMatchRequest): A request to match a Entity.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EntityMatchesResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['entity_match_request'] = \
            entity_match_request
        return self.get_entity_match_for_list_endpoint.call_with_http_info(**kwargs)

