"""
    FactSet Concordance API

    The FactSet Concordance API provides the ability to programmatically look up several types of entities by their name and other attributes. It attempts to match attributes that you supply for the entity and returns as many match candidates as it can find. The result is a \"concorded\" FactSet Entity Permanent identifier.  The Entity Identifier can then be used as input throughout FactSet's Content soultions, such as Content APIs and Standard DataFeeds.<p> There are two types of workflows supported in the API. The first workflow type follows traditional API conventions in that a request is accepted and a response is returned synchronously. The second workflow type involves a background task. With this workflow, a task is created for uploading a set of queries, and then the client polls for the task to complete. Once the task has completed, the client retrieves the concordance results throught the decisions endpoint.</p>   # noqa: E501

    The version of the OpenAPI document: 2.5.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.FactSetConcordance.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.FactSetConcordance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.FactSetConcordance.exceptions import ApiException
from fds.sdk.FactSetConcordance.model.entity_mapping_delete_request import EntityMappingDeleteRequest
from fds.sdk.FactSetConcordance.model.error_response import ErrorResponse
from fds.sdk.FactSetConcordance.model.people_mapping_delete_response import PeopleMappingDeleteResponse
from fds.sdk.FactSetConcordance.model.people_mapping_request import PeopleMappingRequest
from fds.sdk.FactSetConcordance.model.people_mapping_response import PeopleMappingResponse
from fds.sdk.FactSetConcordance.model.people_universe_request import PeopleUniverseRequest
from fds.sdk.FactSetConcordance.model.people_universe_response import PeopleUniverseResponse





class PeopleMappingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_people_mapping_delete_for_list_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (PeopleMappingDeleteResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/people-mapping-delete',
                'operation_id': 'get_people_mapping_delete_for_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'entity_mapping_delete_request',
                ],
                'required': [
                    'entity_mapping_delete_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'entity_mapping_delete_request':
                        (EntityMappingDeleteRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'entity_mapping_delete_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_people_mapping_for_list_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (PeopleMappingResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/people-mapping',
                'operation_id': 'get_people_mapping_for_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'people_mapping_request',
                ],
                'required': [
                    'people_mapping_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'people_mapping_request':
                        (PeopleMappingRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'people_mapping_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_people_universe_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (PeopleUniverseResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/people-universe',
                'operation_id': 'get_people_universe',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'universe_id',
                    'client_id',
                    'map_status',
                    'offset',
                    'limit',
                    'sort',
                ],
                'required': [
                    'universe_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'map_status',
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                    },
                },
                'allowed_values': {
                    ('map_status',): {

                        "MAPPED": "MAPPED",
                        "UNMAPPED": "UNMAPPED",
                        "INDETERMINATE": "INDETERMINATE"
                    },
                },
                'openapi_types': {
                    'universe_id':
                        (int,),
                    'client_id':
                        ([str],),
                    'map_status':
                        ([str],),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'sort':
                        ([str],),
                },
                'attribute_map': {
                    'universe_id': 'universeId',
                    'client_id': 'clientId',
                    'map_status': 'mapStatus',
                    'offset': 'offset',
                    'limit': 'limit',
                    'sort': 'sort',
                },
                'location_map': {
                    'universe_id': 'query',
                    'client_id': 'query',
                    'map_status': 'query',
                    'offset': 'query',
                    'limit': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'client_id': 'csv',
                    'map_status': 'multi',
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_people_universe_for_list_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (PeopleUniverseResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/people-universe',
                'operation_id': 'get_people_universe_for_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'people_universe_request',
                ],
                'required': [
                    'people_universe_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'people_universe_request':
                        (PeopleUniverseRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'people_universe_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")

    def get_people_mapping_delete_for_list(
        self,
        entity_mapping_delete_request,
        **kwargs
    ) -> PeopleMappingDeleteResponse:
        """Deletes mapping specified by the client.  # noqa: E501

        Delete a Concordance Mapping to the client universe. When making a post, all exiting values are overwritten in the database with the values passed in the request. clientId and universeId are required.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            entity_mapping_delete_request (EntityMappingDeleteRequest): A request to delete people mappings specified by the client

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleMappingDeleteResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['entity_mapping_delete_request'] = \
            entity_mapping_delete_request
        return self.get_people_mapping_delete_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_mapping_delete_for_list_with_http_info(
        self,
        entity_mapping_delete_request,
        **kwargs
    ) -> typing.Tuple[PeopleMappingDeleteResponse, int, typing.MutableMapping]:
        """Deletes mapping specified by the client.  # noqa: E501

        Delete a Concordance Mapping to the client universe. When making a post, all exiting values are overwritten in the database with the values passed in the request. clientId and universeId are required.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            entity_mapping_delete_request (EntityMappingDeleteRequest): A request to delete people mappings specified by the client

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleMappingDeleteResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['entity_mapping_delete_request'] = \
            entity_mapping_delete_request
        return self.get_people_mapping_delete_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_mapping_delete_for_list_async(
        self,
        entity_mapping_delete_request,
        **kwargs
    ) -> "ApplyResult[PeopleMappingDeleteResponse]":
        """Deletes mapping specified by the client.  # noqa: E501

        Delete a Concordance Mapping to the client universe. When making a post, all exiting values are overwritten in the database with the values passed in the request. clientId and universeId are required.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            entity_mapping_delete_request (EntityMappingDeleteRequest): A request to delete people mappings specified by the client

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[PeopleMappingDeleteResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['entity_mapping_delete_request'] = \
            entity_mapping_delete_request
        return self.get_people_mapping_delete_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_mapping_delete_for_list_with_http_info_async(
        self,
        entity_mapping_delete_request,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[PeopleMappingDeleteResponse, int, typing.MutableMapping]]":
        """Deletes mapping specified by the client.  # noqa: E501

        Delete a Concordance Mapping to the client universe. When making a post, all exiting values are overwritten in the database with the values passed in the request. clientId and universeId are required.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            entity_mapping_delete_request (EntityMappingDeleteRequest): A request to delete people mappings specified by the client

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(PeopleMappingDeleteResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['entity_mapping_delete_request'] = \
            entity_mapping_delete_request
        return self.get_people_mapping_delete_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_mapping_for_list(
        self,
        people_mapping_request,
        **kwargs
    ) -> PeopleMappingResponse:
        """Saves a single-mapping specified by the client.  # noqa: E501

        Saves a single Concordance People Mapping to a given universe. When making a post, all exiting values are overwritten in the database with the values passed in the request. clientId and clientName are required.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            people_mapping_request (PeopleMappingRequest): A request to create a single mapping.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleMappingResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['people_mapping_request'] = \
            people_mapping_request
        return self.get_people_mapping_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_mapping_for_list_with_http_info(
        self,
        people_mapping_request,
        **kwargs
    ) -> typing.Tuple[PeopleMappingResponse, int, typing.MutableMapping]:
        """Saves a single-mapping specified by the client.  # noqa: E501

        Saves a single Concordance People Mapping to a given universe. When making a post, all exiting values are overwritten in the database with the values passed in the request. clientId and clientName are required.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            people_mapping_request (PeopleMappingRequest): A request to create a single mapping.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleMappingResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['people_mapping_request'] = \
            people_mapping_request
        return self.get_people_mapping_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_mapping_for_list_async(
        self,
        people_mapping_request,
        **kwargs
    ) -> "ApplyResult[PeopleMappingResponse]":
        """Saves a single-mapping specified by the client.  # noqa: E501

        Saves a single Concordance People Mapping to a given universe. When making a post, all exiting values are overwritten in the database with the values passed in the request. clientId and clientName are required.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            people_mapping_request (PeopleMappingRequest): A request to create a single mapping.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[PeopleMappingResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['people_mapping_request'] = \
            people_mapping_request
        return self.get_people_mapping_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_mapping_for_list_with_http_info_async(
        self,
        people_mapping_request,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[PeopleMappingResponse, int, typing.MutableMapping]]":
        """Saves a single-mapping specified by the client.  # noqa: E501

        Saves a single Concordance People Mapping to a given universe. When making a post, all exiting values are overwritten in the database with the values passed in the request. clientId and clientName are required.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            people_mapping_request (PeopleMappingRequest): A request to create a single mapping.

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(PeopleMappingResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['people_mapping_request'] = \
            people_mapping_request
        return self.get_people_mapping_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_universe(
        self,
        universe_id,
        **kwargs
    ) -> PeopleUniverseResponse:
        """Retrieve all saved mappings within a requested universe  # noqa: E501

        Retrieves all people mappings within a requested universe.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            client_id ([str]): Filter by the clientId(s) created by the user in a previous mapping. . [optional]
            map_status ([str]): Filter by the Entity Decisions that have the specified mapStatus, where -   * MAPPED - The requested Entity Name is successfully mapped to a FactSet Entity Id (-E)   * UNMAPPED - The requested Entity Name is unmapped by FactSet.   * INDETERMINATE - The requested Entity Name was unable to make a mapping. . [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            sort ([str]): Sort clientId, createdTime, updatedTime, clientPersonName, personId fields in ascending or descending order with asc and desc to indicate the order. Example (clientId:asc). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleUniverseResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        return self.get_people_universe_endpoint.call_with_http_info(**kwargs)

    def get_people_universe_with_http_info(
        self,
        universe_id,
        **kwargs
    ) -> typing.Tuple[PeopleUniverseResponse, int, typing.MutableMapping]:
        """Retrieve all saved mappings within a requested universe  # noqa: E501

        Retrieves all people mappings within a requested universe.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            client_id ([str]): Filter by the clientId(s) created by the user in a previous mapping. . [optional]
            map_status ([str]): Filter by the Entity Decisions that have the specified mapStatus, where -   * MAPPED - The requested Entity Name is successfully mapped to a FactSet Entity Id (-E)   * UNMAPPED - The requested Entity Name is unmapped by FactSet.   * INDETERMINATE - The requested Entity Name was unable to make a mapping. . [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            sort ([str]): Sort clientId, createdTime, updatedTime, clientPersonName, personId fields in ascending or descending order with asc and desc to indicate the order. Example (clientId:asc). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleUniverseResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        return self.get_people_universe_endpoint.call_with_http_info(**kwargs)

    def get_people_universe_async(
        self,
        universe_id,
        **kwargs
    ) -> "ApplyResult[PeopleUniverseResponse]":
        """Retrieve all saved mappings within a requested universe  # noqa: E501

        Retrieves all people mappings within a requested universe.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            client_id ([str]): Filter by the clientId(s) created by the user in a previous mapping. . [optional]
            map_status ([str]): Filter by the Entity Decisions that have the specified mapStatus, where -   * MAPPED - The requested Entity Name is successfully mapped to a FactSet Entity Id (-E)   * UNMAPPED - The requested Entity Name is unmapped by FactSet.   * INDETERMINATE - The requested Entity Name was unable to make a mapping. . [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            sort ([str]): Sort clientId, createdTime, updatedTime, clientPersonName, personId fields in ascending or descending order with asc and desc to indicate the order. Example (clientId:asc). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[PeopleUniverseResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        return self.get_people_universe_endpoint.call_with_http_info(**kwargs)

    def get_people_universe_with_http_info_async(
        self,
        universe_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[PeopleUniverseResponse, int, typing.MutableMapping]]":
        """Retrieve all saved mappings within a requested universe  # noqa: E501

        Retrieves all people mappings within a requested universe.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            client_id ([str]): Filter by the clientId(s) created by the user in a previous mapping. . [optional]
            map_status ([str]): Filter by the Entity Decisions that have the specified mapStatus, where -   * MAPPED - The requested Entity Name is successfully mapped to a FactSet Entity Id (-E)   * UNMAPPED - The requested Entity Name is unmapped by FactSet.   * INDETERMINATE - The requested Entity Name was unable to make a mapping. . [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            sort ([str]): Sort clientId, createdTime, updatedTime, clientPersonName, personId fields in ascending or descending order with asc and desc to indicate the order. Example (clientId:asc). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(PeopleUniverseResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        return self.get_people_universe_endpoint.call_with_http_info(**kwargs)

    def get_people_universe_for_list(
        self,
        people_universe_request,
        **kwargs
    ) -> PeopleUniverseResponse:
        """Retrieve all saved mappings within a requested universe or large list of client ids  # noqa: E501

        Retrieves all people mappings that were saved in a given universe. Supports filtering by a large number of `clientId`s   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            people_universe_request (PeopleUniverseRequest): A request to fetch all entities of a given universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleUniverseResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['people_universe_request'] = \
            people_universe_request
        return self.get_people_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_universe_for_list_with_http_info(
        self,
        people_universe_request,
        **kwargs
    ) -> typing.Tuple[PeopleUniverseResponse, int, typing.MutableMapping]:
        """Retrieve all saved mappings within a requested universe or large list of client ids  # noqa: E501

        Retrieves all people mappings that were saved in a given universe. Supports filtering by a large number of `clientId`s   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            people_universe_request (PeopleUniverseRequest): A request to fetch all entities of a given universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleUniverseResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['people_universe_request'] = \
            people_universe_request
        return self.get_people_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_universe_for_list_async(
        self,
        people_universe_request,
        **kwargs
    ) -> "ApplyResult[PeopleUniverseResponse]":
        """Retrieve all saved mappings within a requested universe or large list of client ids  # noqa: E501

        Retrieves all people mappings that were saved in a given universe. Supports filtering by a large number of `clientId`s   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            people_universe_request (PeopleUniverseRequest): A request to fetch all entities of a given universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[PeopleUniverseResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['people_universe_request'] = \
            people_universe_request
        return self.get_people_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_universe_for_list_with_http_info_async(
        self,
        people_universe_request,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[PeopleUniverseResponse, int, typing.MutableMapping]]":
        """Retrieve all saved mappings within a requested universe or large list of client ids  # noqa: E501

        Retrieves all people mappings that were saved in a given universe. Supports filtering by a large number of `clientId`s   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            people_universe_request (PeopleUniverseRequest): A request to fetch all entities of a given universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(PeopleUniverseResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['people_universe_request'] = \
            people_universe_request
        return self.get_people_universe_for_list_endpoint.call_with_http_info(**kwargs)

