"""
    FactSet Concordance API

    The FactSet Concordance API provides the ability to programmatically look up several types of entities by their name and other attributes. It attempts to match attributes that you supply for the entity and returns as many match candidates as it can find. The result is a \"concorded\" FactSet Entity Permanent identifier.  The Entity Identifier can then be used as input throughout FactSet's Content soultions, such as Content APIs and Standard DataFeeds.<p> There are two types of workflows supported in the API. The first workflow type follows traditional API conventions in that a request is accepted and a response is returned synchronously. The second workflow type involves a background task. With this workflow, a task is created for uploading a set of queries, and then the client polls for the task to complete. Once the task has completed, the client retrieves the concordance results throught the decisions endpoint.</p>   # noqa: E501

    The version of the OpenAPI document: 2.5.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.FactSetConcordance.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.FactSetConcordance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.FactSetConcordance.exceptions import ApiException
from fds.sdk.FactSetConcordance.model.error_response import ErrorResponse
from fds.sdk.FactSetConcordance.model.people_decisions_response import PeopleDecisionsResponse
from fds.sdk.FactSetConcordance.model.people_task_response import PeopleTaskResponse
from fds.sdk.FactSetConcordance.model.people_task_status_response import PeopleTaskStatusResponse





class PeopleMatchBulkApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_people_decisions_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (PeopleDecisionsResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/people-decisions',
                'operation_id': 'get_people_decisions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'task_id',
                    'offset',
                    'limit',
                ],
                'required': [
                    'task_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'task_id':
                        (int,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'task_id': 'taskId',
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'task_id': 'query',
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json;charset=utf-8',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_people_task_for_list_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (PeopleTaskResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/people-task',
                'operation_id': 'get_people_task_for_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'universe_id',
                    'task_name',
                    'input_file',
                    'client_id_column',
                    'entity_column',
                    'first_name_column',
                    'last_name_column',
                    'middle_name_column',
                    'person_name_column',
                    'priority_column',
                    'salutation_column',
                    'suffix_column',
                ],
                'required': [
                    'universe_id',
                    'task_name',
                    'input_file',
                    'client_id_column',
                    'entity_column',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'universe_id':
                        (int,),
                    'task_name':
                        (str,),
                    'input_file':
                        (file_type,),
                    'client_id_column':
                        (str,),
                    'entity_column':
                        (str,),
                    'first_name_column':
                        (str,),
                    'last_name_column':
                        (str,),
                    'middle_name_column':
                        (str,),
                    'person_name_column':
                        (str,),
                    'priority_column':
                        (str,),
                    'salutation_column':
                        (str,),
                    'suffix_column':
                        (str,),
                },
                'attribute_map': {
                    'universe_id': 'universeId',
                    'task_name': 'taskName',
                    'input_file': 'inputFile',
                    'client_id_column': 'clientIdColumn',
                    'entity_column': 'entityColumn',
                    'first_name_column': 'firstNameColumn',
                    'last_name_column': 'lastNameColumn',
                    'middle_name_column': 'middleNameColumn',
                    'person_name_column': 'personNameColumn',
                    'priority_column': 'priorityColumn',
                    'salutation_column': 'salutationColumn',
                    'suffix_column': 'suffixColumn',
                },
                'location_map': {
                    'universe_id': 'form',
                    'task_name': 'form',
                    'input_file': 'form',
                    'client_id_column': 'form',
                    'entity_column': 'form',
                    'first_name_column': 'form',
                    'last_name_column': 'form',
                    'middle_name_column': 'form',
                    'person_name_column': 'form',
                    'priority_column': 'form',
                    'salutation_column': 'form',
                    'suffix_column': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json;charset=utf-8',
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.get_people_task_status_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (PeopleTaskStatusResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/people-task-status',
                'operation_id': 'get_people_task_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'task_id',
                    'offset',
                    'limit',
                    'status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "PENDING": "PENDING",
                        "IN_PROGRESS": "IN_PROGRESS",
                        "SUCCESS": "SUCCESS",
                        "FAILURE": "FAILURE",
                        "BAD_REQUEST": "BAD_REQUEST",
                        "ABORTED": "ABORTED"
                    },
                },
                'openapi_types': {
                    'task_id':
                        (int,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'status':
                        ([str],),
                },
                'attribute_map': {
                    'task_id': 'taskId',
                    'offset': 'offset',
                    'limit': 'limit',
                    'status': 'status',
                },
                'location_map': {
                    'task_id': 'query',
                    'offset': 'query',
                    'limit': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                    'status': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json;charset=utf-8',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")

    def get_people_decisions(
        self,
        task_id,
        **kwargs
    ) -> PeopleDecisionsResponse:
        """Get the decisions of matches for the requested taskId.  # noqa: E501

        Retrieves the `Decision` objects for an People Task (taskId). The decisions do not include all candidates, but rather the results of concording the requested list of names included in the input file. Mapped entities will include a FactSet Entity Identifier (-E). Results will be saved to the `universeId` specified in the input file.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            task_id (int): Concordance Task Identifier. The taskId is created in response from the /people-task endpoint.

        Keyword Args:
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleDecisionsResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['task_id'] = \
            task_id
        return self.get_people_decisions_endpoint.call_with_http_info(**kwargs)

    def get_people_decisions_with_http_info(
        self,
        task_id,
        **kwargs
    ) -> typing.Tuple[PeopleDecisionsResponse, int, typing.MutableMapping]:
        """Get the decisions of matches for the requested taskId.  # noqa: E501

        Retrieves the `Decision` objects for an People Task (taskId). The decisions do not include all candidates, but rather the results of concording the requested list of names included in the input file. Mapped entities will include a FactSet Entity Identifier (-E). Results will be saved to the `universeId` specified in the input file.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            task_id (int): Concordance Task Identifier. The taskId is created in response from the /people-task endpoint.

        Keyword Args:
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleDecisionsResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['task_id'] = \
            task_id
        return self.get_people_decisions_endpoint.call_with_http_info(**kwargs)

    def get_people_decisions_async(
        self,
        task_id,
        **kwargs
    ) -> "ApplyResult[PeopleDecisionsResponse]":
        """Get the decisions of matches for the requested taskId.  # noqa: E501

        Retrieves the `Decision` objects for an People Task (taskId). The decisions do not include all candidates, but rather the results of concording the requested list of names included in the input file. Mapped entities will include a FactSet Entity Identifier (-E). Results will be saved to the `universeId` specified in the input file.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            task_id (int): Concordance Task Identifier. The taskId is created in response from the /people-task endpoint.

        Keyword Args:
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[PeopleDecisionsResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['task_id'] = \
            task_id
        return self.get_people_decisions_endpoint.call_with_http_info(**kwargs)

    def get_people_decisions_with_http_info_async(
        self,
        task_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[PeopleDecisionsResponse, int, typing.MutableMapping]]":
        """Get the decisions of matches for the requested taskId.  # noqa: E501

        Retrieves the `Decision` objects for an People Task (taskId). The decisions do not include all candidates, but rather the results of concording the requested list of names included in the input file. Mapped entities will include a FactSet Entity Identifier (-E). Results will be saved to the `universeId` specified in the input file.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            task_id (int): Concordance Task Identifier. The taskId is created in response from the /people-task endpoint.

        Keyword Args:
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(PeopleDecisionsResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['task_id'] = \
            task_id
        return self.get_people_decisions_endpoint.call_with_http_info(**kwargs)

    def get_people_task_for_list(
        self,
        universe_id,
        task_name,
        input_file,
        client_id_column,
        entity_column,
        **kwargs
    ) -> PeopleTaskResponse:
        """Create a People Concordance Task.  # noqa: E501

        The \"Bulk\" workflow allows the user to create a People Concordance Task. Uploading of a Comma-Separated List file (.csv / UTF-8 encoding) with a list of names and attributes and creation of a task id is mandatory to start the process.    The taskId is then used for reference in the /people-task-status and /people-decisions endpoints to receive results once the task is successful.The /people-task-status endpoint is to check the status of the Tasks as per the ids.     A universeId must be included in request. If you do not have a universe created, reference the /universe endpoint.The bulk workflow supports a two way approach for the user.   **The user can use these parameters in the following ways.**     1.Filling all the required fields including the `personNameColumn`.(do not include `firstNameColumn`,`lastNameColumn` & `middleNameColumn`)     2.Filling all the required fields excluding the `personNameColumn`.(Ensure atleast the `lastNameColumn` is filled)   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            universe_id (int): The id of the universe that entities should be mapped to. Reference the `/universe` endpoint to create a universe, or view available universes via `/universes`.
            task_name (str): User defined name for the task that will be used to name the output files.
            input_file (file_type): The UTF-8 encoded CSV File containing the entity names to be concorded to a FactSet Entity Identifier. The files first row **MUST** include headers as defined in the *Column parameters. Be mindful of casing and spacing in column headers. The input file is posted as a file object in the form. For this reason, the mime type of this post request must be multipart/form-data. 
            client_id_column (str): Header Name of the column in the input file that contains a unique identifier supplied by the user referred to as a \\\"clientId\\\". This clientId can be used to create custom mappings or references. 
            entity_column (str): Header name of the column in the input file that contains the Entity Name to be matched. 

        Keyword Args:
            first_name_column (str): First name of the person.**Do not include with `personNameColumn`**.  . [optional]
            last_name_column (str): Lat name of the person.**Do not include with `personNameColumn`**. . [optional]
            middle_name_column (str): Middle name of the person.**Do not include within `personNameColumn`**. . [optional]
            person_name_column (str): Header name of the column in the input file that contains the name of the person to be matched. **Do not include with `firstNameColumn` and `lastNameColumn`.** . [optional]
            priority_column (str): Priority associated to the clientId. Used for manual mapping. . [optional]
            salutation_column (str): The salutation of the person.**Do not include with `personNameColumn`**. . [optional]
            suffix_column (str): A name suffix, that follows a person's full name and provides additional information about the person.**Do not include with `personNameColumn`**. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleTaskResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        kwargs['task_name'] = \
            task_name
        kwargs['input_file'] = \
            input_file
        kwargs['client_id_column'] = \
            client_id_column
        kwargs['entity_column'] = \
            entity_column
        return self.get_people_task_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_task_for_list_with_http_info(
        self,
        universe_id,
        task_name,
        input_file,
        client_id_column,
        entity_column,
        **kwargs
    ) -> typing.Tuple[PeopleTaskResponse, int, typing.MutableMapping]:
        """Create a People Concordance Task.  # noqa: E501

        The \"Bulk\" workflow allows the user to create a People Concordance Task. Uploading of a Comma-Separated List file (.csv / UTF-8 encoding) with a list of names and attributes and creation of a task id is mandatory to start the process.    The taskId is then used for reference in the /people-task-status and /people-decisions endpoints to receive results once the task is successful.The /people-task-status endpoint is to check the status of the Tasks as per the ids.     A universeId must be included in request. If you do not have a universe created, reference the /universe endpoint.The bulk workflow supports a two way approach for the user.   **The user can use these parameters in the following ways.**     1.Filling all the required fields including the `personNameColumn`.(do not include `firstNameColumn`,`lastNameColumn` & `middleNameColumn`)     2.Filling all the required fields excluding the `personNameColumn`.(Ensure atleast the `lastNameColumn` is filled)   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            universe_id (int): The id of the universe that entities should be mapped to. Reference the `/universe` endpoint to create a universe, or view available universes via `/universes`.
            task_name (str): User defined name for the task that will be used to name the output files.
            input_file (file_type): The UTF-8 encoded CSV File containing the entity names to be concorded to a FactSet Entity Identifier. The files first row **MUST** include headers as defined in the *Column parameters. Be mindful of casing and spacing in column headers. The input file is posted as a file object in the form. For this reason, the mime type of this post request must be multipart/form-data. 
            client_id_column (str): Header Name of the column in the input file that contains a unique identifier supplied by the user referred to as a \\\"clientId\\\". This clientId can be used to create custom mappings or references. 
            entity_column (str): Header name of the column in the input file that contains the Entity Name to be matched. 

        Keyword Args:
            first_name_column (str): First name of the person.**Do not include with `personNameColumn`**.  . [optional]
            last_name_column (str): Lat name of the person.**Do not include with `personNameColumn`**. . [optional]
            middle_name_column (str): Middle name of the person.**Do not include within `personNameColumn`**. . [optional]
            person_name_column (str): Header name of the column in the input file that contains the name of the person to be matched. **Do not include with `firstNameColumn` and `lastNameColumn`.** . [optional]
            priority_column (str): Priority associated to the clientId. Used for manual mapping. . [optional]
            salutation_column (str): The salutation of the person.**Do not include with `personNameColumn`**. . [optional]
            suffix_column (str): A name suffix, that follows a person's full name and provides additional information about the person.**Do not include with `personNameColumn`**. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleTaskResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        kwargs['task_name'] = \
            task_name
        kwargs['input_file'] = \
            input_file
        kwargs['client_id_column'] = \
            client_id_column
        kwargs['entity_column'] = \
            entity_column
        return self.get_people_task_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_task_for_list_async(
        self,
        universe_id,
        task_name,
        input_file,
        client_id_column,
        entity_column,
        **kwargs
    ) -> "ApplyResult[PeopleTaskResponse]":
        """Create a People Concordance Task.  # noqa: E501

        The \"Bulk\" workflow allows the user to create a People Concordance Task. Uploading of a Comma-Separated List file (.csv / UTF-8 encoding) with a list of names and attributes and creation of a task id is mandatory to start the process.    The taskId is then used for reference in the /people-task-status and /people-decisions endpoints to receive results once the task is successful.The /people-task-status endpoint is to check the status of the Tasks as per the ids.     A universeId must be included in request. If you do not have a universe created, reference the /universe endpoint.The bulk workflow supports a two way approach for the user.   **The user can use these parameters in the following ways.**     1.Filling all the required fields including the `personNameColumn`.(do not include `firstNameColumn`,`lastNameColumn` & `middleNameColumn`)     2.Filling all the required fields excluding the `personNameColumn`.(Ensure atleast the `lastNameColumn` is filled)   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            universe_id (int): The id of the universe that entities should be mapped to. Reference the `/universe` endpoint to create a universe, or view available universes via `/universes`.
            task_name (str): User defined name for the task that will be used to name the output files.
            input_file (file_type): The UTF-8 encoded CSV File containing the entity names to be concorded to a FactSet Entity Identifier. The files first row **MUST** include headers as defined in the *Column parameters. Be mindful of casing and spacing in column headers. The input file is posted as a file object in the form. For this reason, the mime type of this post request must be multipart/form-data. 
            client_id_column (str): Header Name of the column in the input file that contains a unique identifier supplied by the user referred to as a \\\"clientId\\\". This clientId can be used to create custom mappings or references. 
            entity_column (str): Header name of the column in the input file that contains the Entity Name to be matched. 

        Keyword Args:
            first_name_column (str): First name of the person.**Do not include with `personNameColumn`**.  . [optional]
            last_name_column (str): Lat name of the person.**Do not include with `personNameColumn`**. . [optional]
            middle_name_column (str): Middle name of the person.**Do not include within `personNameColumn`**. . [optional]
            person_name_column (str): Header name of the column in the input file that contains the name of the person to be matched. **Do not include with `firstNameColumn` and `lastNameColumn`.** . [optional]
            priority_column (str): Priority associated to the clientId. Used for manual mapping. . [optional]
            salutation_column (str): The salutation of the person.**Do not include with `personNameColumn`**. . [optional]
            suffix_column (str): A name suffix, that follows a person's full name and provides additional information about the person.**Do not include with `personNameColumn`**. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[PeopleTaskResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        kwargs['task_name'] = \
            task_name
        kwargs['input_file'] = \
            input_file
        kwargs['client_id_column'] = \
            client_id_column
        kwargs['entity_column'] = \
            entity_column
        return self.get_people_task_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_task_for_list_with_http_info_async(
        self,
        universe_id,
        task_name,
        input_file,
        client_id_column,
        entity_column,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[PeopleTaskResponse, int, typing.MutableMapping]]":
        """Create a People Concordance Task.  # noqa: E501

        The \"Bulk\" workflow allows the user to create a People Concordance Task. Uploading of a Comma-Separated List file (.csv / UTF-8 encoding) with a list of names and attributes and creation of a task id is mandatory to start the process.    The taskId is then used for reference in the /people-task-status and /people-decisions endpoints to receive results once the task is successful.The /people-task-status endpoint is to check the status of the Tasks as per the ids.     A universeId must be included in request. If you do not have a universe created, reference the /universe endpoint.The bulk workflow supports a two way approach for the user.   **The user can use these parameters in the following ways.**     1.Filling all the required fields including the `personNameColumn`.(do not include `firstNameColumn`,`lastNameColumn` & `middleNameColumn`)     2.Filling all the required fields excluding the `personNameColumn`.(Ensure atleast the `lastNameColumn` is filled)   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            universe_id (int): The id of the universe that entities should be mapped to. Reference the `/universe` endpoint to create a universe, or view available universes via `/universes`.
            task_name (str): User defined name for the task that will be used to name the output files.
            input_file (file_type): The UTF-8 encoded CSV File containing the entity names to be concorded to a FactSet Entity Identifier. The files first row **MUST** include headers as defined in the *Column parameters. Be mindful of casing and spacing in column headers. The input file is posted as a file object in the form. For this reason, the mime type of this post request must be multipart/form-data. 
            client_id_column (str): Header Name of the column in the input file that contains a unique identifier supplied by the user referred to as a \\\"clientId\\\". This clientId can be used to create custom mappings or references. 
            entity_column (str): Header name of the column in the input file that contains the Entity Name to be matched. 

        Keyword Args:
            first_name_column (str): First name of the person.**Do not include with `personNameColumn`**.  . [optional]
            last_name_column (str): Lat name of the person.**Do not include with `personNameColumn`**. . [optional]
            middle_name_column (str): Middle name of the person.**Do not include within `personNameColumn`**. . [optional]
            person_name_column (str): Header name of the column in the input file that contains the name of the person to be matched. **Do not include with `firstNameColumn` and `lastNameColumn`.** . [optional]
            priority_column (str): Priority associated to the clientId. Used for manual mapping. . [optional]
            salutation_column (str): The salutation of the person.**Do not include with `personNameColumn`**. . [optional]
            suffix_column (str): A name suffix, that follows a person's full name and provides additional information about the person.**Do not include with `personNameColumn`**. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(PeopleTaskResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        kwargs['task_name'] = \
            task_name
        kwargs['input_file'] = \
            input_file
        kwargs['client_id_column'] = \
            client_id_column
        kwargs['entity_column'] = \
            entity_column
        return self.get_people_task_for_list_endpoint.call_with_http_info(**kwargs)

    def get_people_task_status(
        self,
        **kwargs
    ) -> PeopleTaskStatusResponse:
        """Get the Status of the People Tasks.  # noqa: E501

        Pulls the **status** for ALL the People Tasks submitted by a client within the last 30 days, and related details such as task duration and decision rates. Specific Tasks can also be retrieved by using the _taskId_ parameter.<p>Status types include -   * PENDING - The task has not yet started.   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /people-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            task_id (int): Concordance Task Identifier. The taskId is created in response from the /people-task endpoint.. [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            status ([str]): Filter on the status of the Concordance Tasks. Default is no filter.   * PENDING - The task has not yet started   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleTaskStatusResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_people_task_status_endpoint.call_with_http_info(**kwargs)

    def get_people_task_status_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[PeopleTaskStatusResponse, int, typing.MutableMapping]:
        """Get the Status of the People Tasks.  # noqa: E501

        Pulls the **status** for ALL the People Tasks submitted by a client within the last 30 days, and related details such as task duration and decision rates. Specific Tasks can also be retrieved by using the _taskId_ parameter.<p>Status types include -   * PENDING - The task has not yet started.   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /people-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            task_id (int): Concordance Task Identifier. The taskId is created in response from the /people-task endpoint.. [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            status ([str]): Filter on the status of the Concordance Tasks. Default is no filter.   * PENDING - The task has not yet started   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            PeopleTaskStatusResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_people_task_status_endpoint.call_with_http_info(**kwargs)

    def get_people_task_status_async(
        self,
        **kwargs
    ) -> "ApplyResult[PeopleTaskStatusResponse]":
        """Get the Status of the People Tasks.  # noqa: E501

        Pulls the **status** for ALL the People Tasks submitted by a client within the last 30 days, and related details such as task duration and decision rates. Specific Tasks can also be retrieved by using the _taskId_ parameter.<p>Status types include -   * PENDING - The task has not yet started.   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /people-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            task_id (int): Concordance Task Identifier. The taskId is created in response from the /people-task endpoint.. [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            status ([str]): Filter on the status of the Concordance Tasks. Default is no filter.   * PENDING - The task has not yet started   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[PeopleTaskStatusResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_people_task_status_endpoint.call_with_http_info(**kwargs)

    def get_people_task_status_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[PeopleTaskStatusResponse, int, typing.MutableMapping]]":
        """Get the Status of the People Tasks.  # noqa: E501

        Pulls the **status** for ALL the People Tasks submitted by a client within the last 30 days, and related details such as task duration and decision rates. Specific Tasks can also be retrieved by using the _taskId_ parameter.<p>Status types include -   * PENDING - The task has not yet started.   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /people-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            task_id (int): Concordance Task Identifier. The taskId is created in response from the /people-task endpoint.. [optional]
            offset (int): Starting row for records to return or rows to skip.. [optional] if omitted the server will use the default value of 0
            limit (int): Limits the number of records in the response.. [optional]
            status ([str]): Filter on the status of the Concordance Tasks. Default is no filter.   * PENDING - The task has not yet started   * IN_PROGRESS - The task is submitted and decisions are in progress.   * SUCCESS - The task was successful! Move to the /entity-decisions endpoint to retrieve decisions.   * FAILURE - The task failed. Reach out to FactSet Support for assistance.   * BAD_REQUEST - The task creation was unsuccesfull. Typically occurs with an incorrect input file format or column headers.   * ABORTED - The task was aborted. . [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(PeopleTaskStatusResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_people_task_status_endpoint.call_with_http_info(**kwargs)

