"""
    FactSet Concordance API

    The FactSet Concordance API provides the ability to programmatically look up several types of entities by their name and other attributes. It attempts to match attributes that you supply for the entity and returns as many match candidates as it can find. The result is a \"concorded\" FactSet Entity Permanent identifier.  The Entity Identifier can then be used as input throughout FactSet's Content soultions, such as Content APIs and Standard DataFeeds.<p> There are two types of workflows supported in the API. The first workflow type follows traditional API conventions in that a request is accepted and a response is returned synchronously. The second workflow type involves a background task. With this workflow, a task is created for uploading a set of queries, and then the client polls for the task to complete. Once the task has completed, the client retrieves the concordance results throught the decisions endpoint.</p>   # noqa: E501

    The version of the OpenAPI document: 2.5.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.FactSetConcordance.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.FactSetConcordance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.FactSetConcordance.exceptions import ApiException
from fds.sdk.FactSetConcordance.model.create_universe_request import CreateUniverseRequest
from fds.sdk.FactSetConcordance.model.entity_universe_statistics_response import EntityUniverseStatisticsResponse
from fds.sdk.FactSetConcordance.model.error_response import ErrorResponse
from fds.sdk.FactSetConcordance.model.universe_meta_response import UniverseMetaResponse
from fds.sdk.FactSetConcordance.model.universe_statistics_response import UniverseStatisticsResponse
from fds.sdk.FactSetConcordance.model.universes_response import UniversesResponse
from fds.sdk.FactSetConcordance.model.update_universe_request import UpdateUniverseRequest





class UniversesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_entity_universe_statistics_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EntityUniverseStatisticsResponse,), 0: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/entity-universe-statistics',
                'operation_id': 'get_entity_universe_statistics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'universe_id',
                ],
                'required': [
                    'universe_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'universe_id':
                        (int,),
                },
                'attribute_map': {
                    'universe_id': 'universeId',
                },
                'location_map': {
                    'universe_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_universe_for_list_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (UniverseMetaResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,), 0: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/universe',
                'operation_id': 'get_universe_for_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_universe_request',
                ],
                'required': [
                    'create_universe_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_universe_request':
                        (CreateUniverseRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_universe_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_universe_statistics_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (UniverseStatisticsResponse,), 0: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/universe-statistics',
                'operation_id': 'get_universe_statistics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'universe_id',
                ],
                'required': [
                    'universe_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'universe_id':
                        (int,),
                },
                'attribute_map': {
                    'universe_id': 'universeId',
                },
                'location_map': {
                    'universe_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_universes_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (UniversesResponse,), 0: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/universes',
                'operation_id': 'get_universes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'universe_id',
                    'universe_type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'universe_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('universe_type',): {

                        "ENTITY": "ENTITY",
                        "PEOPLE": "PEOPLE"
                    },
                },
                'openapi_types': {
                    'universe_id':
                        (int,),
                    'universe_type':
                        (str,),
                },
                'attribute_map': {
                    'universe_id': 'universeId',
                    'universe_type': 'universeType',
                },
                'location_map': {
                    'universe_id': 'query',
                    'universe_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_update_universe_for_list_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (UniverseMetaResponse,), 400: (ErrorResponse,), 401: (ErrorResponse,), 403: (ErrorResponse,), 415: (ErrorResponse,), 500: (ErrorResponse,), 0: (ErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/factset-concordance/v2/update-universe',
                'operation_id': 'get_update_universe_for_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'update_universe_request',
                ],
                'required': [
                    'update_universe_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'update_universe_request':
                        (UpdateUniverseRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'update_universe_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")

    def get_entity_universe_statistics(
        self,
        universe_id,
        **kwargs
    ) -> EntityUniverseStatisticsResponse:
        """Get statistics on a given universe  # noqa: E501

        Get the total number of mappings in a universe, as well as the number of mapped, unmapped and indeterminate mappings   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityUniverseStatisticsResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        return self.get_entity_universe_statistics_endpoint.call_with_http_info(**kwargs)

    def get_entity_universe_statistics_with_http_info(
        self,
        universe_id,
        **kwargs
    ) -> typing.Tuple[EntityUniverseStatisticsResponse, int, typing.MutableMapping]:
        """Get statistics on a given universe  # noqa: E501

        Get the total number of mappings in a universe, as well as the number of mapped, unmapped and indeterminate mappings   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityUniverseStatisticsResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        return self.get_entity_universe_statistics_endpoint.call_with_http_info(**kwargs)

    def get_entity_universe_statistics_async(
        self,
        universe_id,
        **kwargs
    ) -> "ApplyResult[EntityUniverseStatisticsResponse]":
        """Get statistics on a given universe  # noqa: E501

        Get the total number of mappings in a universe, as well as the number of mapped, unmapped and indeterminate mappings   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EntityUniverseStatisticsResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        return self.get_entity_universe_statistics_endpoint.call_with_http_info(**kwargs)

    def get_entity_universe_statistics_with_http_info_async(
        self,
        universe_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EntityUniverseStatisticsResponse, int, typing.MutableMapping]]":
        """Get statistics on a given universe  # noqa: E501

        Get the total number of mappings in a universe, as well as the number of mapped, unmapped and indeterminate mappings   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EntityUniverseStatisticsResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        return self.get_entity_universe_statistics_endpoint.call_with_http_info(**kwargs)

    def get_universe_for_list(
        self,
        create_universe_request,
        **kwargs
    ) -> UniverseMetaResponse:
        """Create a new universe  # noqa: E501

        Create a new universe that is distinct from any existing universe   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            create_universe_request (CreateUniverseRequest): A request to create a user's universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            UniverseMetaResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['create_universe_request'] = \
            create_universe_request
        return self.get_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_universe_for_list_with_http_info(
        self,
        create_universe_request,
        **kwargs
    ) -> typing.Tuple[UniverseMetaResponse, int, typing.MutableMapping]:
        """Create a new universe  # noqa: E501

        Create a new universe that is distinct from any existing universe   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            create_universe_request (CreateUniverseRequest): A request to create a user's universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            UniverseMetaResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['create_universe_request'] = \
            create_universe_request
        return self.get_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_universe_for_list_async(
        self,
        create_universe_request,
        **kwargs
    ) -> "ApplyResult[UniverseMetaResponse]":
        """Create a new universe  # noqa: E501

        Create a new universe that is distinct from any existing universe   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            create_universe_request (CreateUniverseRequest): A request to create a user's universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[UniverseMetaResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['create_universe_request'] = \
            create_universe_request
        return self.get_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_universe_for_list_with_http_info_async(
        self,
        create_universe_request,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[UniverseMetaResponse, int, typing.MutableMapping]]":
        """Create a new universe  # noqa: E501

        Create a new universe that is distinct from any existing universe   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            create_universe_request (CreateUniverseRequest): A request to create a user's universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(UniverseMetaResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['create_universe_request'] = \
            create_universe_request
        return self.get_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_universe_statistics(
        self,
        universe_id,
        **kwargs
    ) -> UniverseStatisticsResponse:
        """Get statistics on a given universe  # noqa: E501

        Get the total number of mappings in a universe, as well as the number of mapped, unmapped and indeterminate mappings   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            UniverseStatisticsResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        return self.get_universe_statistics_endpoint.call_with_http_info(**kwargs)

    def get_universe_statistics_with_http_info(
        self,
        universe_id,
        **kwargs
    ) -> typing.Tuple[UniverseStatisticsResponse, int, typing.MutableMapping]:
        """Get statistics on a given universe  # noqa: E501

        Get the total number of mappings in a universe, as well as the number of mapped, unmapped and indeterminate mappings   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            UniverseStatisticsResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['universe_id'] = \
            universe_id
        return self.get_universe_statistics_endpoint.call_with_http_info(**kwargs)

    def get_universe_statistics_async(
        self,
        universe_id,
        **kwargs
    ) -> "ApplyResult[UniverseStatisticsResponse]":
        """Get statistics on a given universe  # noqa: E501

        Get the total number of mappings in a universe, as well as the number of mapped, unmapped and indeterminate mappings   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[UniverseStatisticsResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        return self.get_universe_statistics_endpoint.call_with_http_info(**kwargs)

    def get_universe_statistics_with_http_info_async(
        self,
        universe_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[UniverseStatisticsResponse, int, typing.MutableMapping]]":
        """Get statistics on a given universe  # noqa: E501

        Get the total number of mappings in a universe, as well as the number of mapped, unmapped and indeterminate mappings   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(UniverseStatisticsResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['universe_id'] = \
            universe_id
        return self.get_universe_statistics_endpoint.call_with_http_info(**kwargs)

    def get_universes(
        self,
        **kwargs
    ) -> UniversesResponse:
        """Fetch metadata for universes  # noqa: E501

        Fetch information on active universes for the current user. Optionally filter for a specific universe given a `universeId`   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*. [optional]
            universe_type (str): Universe Type.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            UniversesResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_universes_endpoint.call_with_http_info(**kwargs)

    def get_universes_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[UniversesResponse, int, typing.MutableMapping]:
        """Fetch metadata for universes  # noqa: E501

        Fetch information on active universes for the current user. Optionally filter for a specific universe given a `universeId`   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*. [optional]
            universe_type (str): Universe Type.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            UniversesResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_universes_endpoint.call_with_http_info(**kwargs)

    def get_universes_async(
        self,
        **kwargs
    ) -> "ApplyResult[UniversesResponse]":
        """Fetch metadata for universes  # noqa: E501

        Fetch information on active universes for the current user. Optionally filter for a specific universe given a `universeId`   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*. [optional]
            universe_type (str): Universe Type.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[UniversesResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_universes_endpoint.call_with_http_info(**kwargs)

    def get_universes_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[UniversesResponse, int, typing.MutableMapping]]":
        """Fetch metadata for universes  # noqa: E501

        Fetch information on active universes for the current user. Optionally filter for a specific universe given a `universeId`   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            universe_id (int): Universe identifier. *To create a universe, use the `/universe' endpoint.*. [optional]
            universe_type (str): Universe Type.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(UniversesResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_universes_endpoint.call_with_http_info(**kwargs)

    def get_update_universe_for_list(
        self,
        update_universe_request,
        **kwargs
    ) -> UniverseMetaResponse:
        """Update metadata for an existing universe  # noqa: E501

        Update metadata for an existing universe   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            update_universe_request (UpdateUniverseRequest): A request to update a user's universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            UniverseMetaResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['update_universe_request'] = \
            update_universe_request
        return self.get_update_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_update_universe_for_list_with_http_info(
        self,
        update_universe_request,
        **kwargs
    ) -> typing.Tuple[UniverseMetaResponse, int, typing.MutableMapping]:
        """Update metadata for an existing universe  # noqa: E501

        Update metadata for an existing universe   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            update_universe_request (UpdateUniverseRequest): A request to update a user's universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            UniverseMetaResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['update_universe_request'] = \
            update_universe_request
        return self.get_update_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_update_universe_for_list_async(
        self,
        update_universe_request,
        **kwargs
    ) -> "ApplyResult[UniverseMetaResponse]":
        """Update metadata for an existing universe  # noqa: E501

        Update metadata for an existing universe   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            update_universe_request (UpdateUniverseRequest): A request to update a user's universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[UniverseMetaResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['update_universe_request'] = \
            update_universe_request
        return self.get_update_universe_for_list_endpoint.call_with_http_info(**kwargs)

    def get_update_universe_for_list_with_http_info_async(
        self,
        update_universe_request,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[UniverseMetaResponse, int, typing.MutableMapping]]":
        """Update metadata for an existing universe  # noqa: E501

        Update metadata for an existing universe   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            update_universe_request (UpdateUniverseRequest): A request to update a user's universe

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(UniverseMetaResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['update_universe_request'] = \
            update_universe_request
        return self.get_update_universe_for_list_endpoint.call_with_http_info(**kwargs)

