"""
    FactSet Concordance API

    The FactSet Concordance API provides the ability to programmatically look up several types of entities by their name and other attributes. It attempts to match attributes that you supply for the entity and returns as many match candidates as it can find. The result is a \"concorded\" FactSet Entity Permanent identifier.  The Entity Identifier can then be used as input throughout FactSet's Content soultions, such as Content APIs and Standard DataFeeds.<p> There are two types of workflows supported in the API. The first workflow type follows traditional API conventions in that a request is accepted and a response is returned synchronously. The second workflow type involves a background task. With this workflow, a task is created for uploading a set of queries, and then the client polls for the task to complete. Once the task has completed, the client retrieves the concordance results throught the decisions endpoint.</p>   # noqa: E501

    The version of the OpenAPI document: 2.5.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.sdk.FactSetConcordance.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from fds.sdk.FactSetConcordance.exceptions import ApiAttributeError



class EntityMatchRequestInput(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('priority',): {
            'CRITICAL': "CRITICAL",
            'HIGH': "HIGH",
            'MEDIUM': "MEDIUM",
            'LOW': "LOW",
        },
    }

    validations = {
        ('country',): {
            'max_length': 2,
            'min_length': 2,
        },
        ('state',): {
            'max_length': 2,
            'min_length': 2,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'name': (str,),  # noqa: E501
            'client_id': (str,),  # noqa: E501
            'country': (str,),  # noqa: E501
            'state': (str,),  # noqa: E501
            'url': (str,),  # noqa: E501
            'priority': (str,),  # noqa: E501
            'bic': (str,),  # noqa: E501
            'bbg_ticker': (str,),  # noqa: E501
            'cik': (str,),  # noqa: E501
            'crd': (str,),  # noqa: E501
            'cusip': (str,),  # noqa: E501
            'duns': (str,),  # noqa: E501
            'ein': (str,),  # noqa: E501
            'rssd': (str,),  # noqa: E501
            'fitch': (str,),  # noqa: E501
            'isin': (str,),  # noqa: E501
            'lei': (str,),  # noqa: E501
            'bbg_figi': (str,),  # noqa: E501
            'md': (str,),  # noqa: E501
            'ticker': (str,),  # noqa: E501
            'spr': (str,),  # noqa: E501
            'sedol': (str,),  # noqa: E501
            'ticker_exchange': (str,),  # noqa: E501
            'ticker_region': (str,),  # noqa: E501
            'ukch': (str,),  # noqa: E501
            'valoren': (str,),  # noqa: E501
            'wkn': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'name': 'name',  # noqa: E501
        'client_id': 'clientId',  # noqa: E501
        'country': 'country',  # noqa: E501
        'state': 'state',  # noqa: E501
        'url': 'url',  # noqa: E501
        'priority': 'priority',  # noqa: E501
        'bic': 'bic',  # noqa: E501
        'bbg_ticker': 'bbgTicker',  # noqa: E501
        'cik': 'cik',  # noqa: E501
        'crd': 'crd',  # noqa: E501
        'cusip': 'cusip',  # noqa: E501
        'duns': 'duns',  # noqa: E501
        'ein': 'ein',  # noqa: E501
        'rssd': 'rssd',  # noqa: E501
        'fitch': 'fitch',  # noqa: E501
        'isin': 'isin',  # noqa: E501
        'lei': 'lei',  # noqa: E501
        'bbg_figi': 'bbgFigi',  # noqa: E501
        'md': 'md',  # noqa: E501
        'ticker': 'ticker',  # noqa: E501
        'spr': 'spr',  # noqa: E501
        'sedol': 'sedol',  # noqa: E501
        'ticker_exchange': 'tickerExchange',  # noqa: E501
        'ticker_region': 'tickerRegion',  # noqa: E501
        'ukch': 'ukch',  # noqa: E501
        'valoren': 'valoren',  # noqa: E501
        'wkn': 'wkn',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, name, *args, **kwargs):  # noqa: E501
        """EntityMatchRequestInput - a model defined in OpenAPI

        Args:
            name (str): The Name of the entity to match.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            client_id (str): A unique identifier supplied by the user. ClientId is saved to the user's Concordance universe and will be used as the identifier for that entity within the universe. . [optional]  # noqa: E501
            country (str): ISO2 country code corresponding to the entity name that is used when evaluating candidates for a match. For a list of ISO Country codes, visit [OA 8754](https://my.apps.factset.com/oa/pages/8754). . [optional]  # noqa: E501
            state (str): Two-character state code corresponding to the entity name that is used when evaluating candidates for a match. Currently, only US state codes are supported.Two character state or province code to filter on. . [optional]  # noqa: E501
            url (str): URL corresponding to the entity name that is used when evaluating candidates for a match. . [optional]  # noqa: E501
            priority (str): Priority associated to the id.. [optional]  # noqa: E501
            bic (str): Name for type BICCode, bank indentification code. [optional]  # noqa: E501
            bbg_ticker (str): Name for the type Bloomberg Listing and Regional Ticker.. [optional]  # noqa: E501
            cik (str): Name for the type CIK, Edgar Central Index Keys. [optional]  # noqa: E501
            crd (str): Name for the type CRD, Central Registration Depository. [optional]  # noqa: E501
            cusip (str): Name for the type CUSIP.. [optional]  # noqa: E501
            duns (str): Name for the type DUNS, Dun&Bradstreet.. [optional]  # noqa: E501
            ein (str): Name for the type EmployerIdentificationNumber, EIN.. [optional]  # noqa: E501
            rssd (str): Name for the type FederalReserveRSSDIdentifier, RSSD.. [optional]  # noqa: E501
            fitch (str): Name for the type FitchCreditRating, Fitch Ratings Identifier.. [optional]  # noqa: E501
            isin (str): Name for the type ISIN.. [optional]  # noqa: E501
            lei (str): Name for the type LegalEntityIdentifier, LEI.. [optional]  # noqa: E501
            bbg_figi (str): Name for the type Bloomberg Listing/Regional/Security ID.. [optional]  # noqa: E501
            md (str): Name for the type MoodysIssuer, Moody's Ratings Identifier.. [optional]  # noqa: E501
            ticker (str): Name for the type PriceTicker.. [optional]  # noqa: E501
            spr (str): Name for the type S&PRating, S&P Ratings Identifier.. [optional]  # noqa: E501
            sedol (str): Name for the type SEDOL.. [optional]  # noqa: E501
            ticker_exchange (str): Name for the type TickerExch.. [optional]  # noqa: E501
            ticker_region (str): Name for the type TickerRegion. [optional]  # noqa: E501
            ukch (str): Name for the type UKCompanyHouse. [optional]  # noqa: E501
            valoren (str): Name for the type VALOR, Valoren (\"Valor\") Identification.. [optional]  # noqa: E501
            wkn (str): Name for the type WKN, German Securities Identification.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, name, *args, **kwargs):  # noqa: E501
        """EntityMatchRequestInput - a model defined in OpenAPI

        Args:
            name (str): The Name of the entity to match.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            client_id (str): A unique identifier supplied by the user. ClientId is saved to the user's Concordance universe and will be used as the identifier for that entity within the universe. . [optional]  # noqa: E501
            country (str): ISO2 country code corresponding to the entity name that is used when evaluating candidates for a match. For a list of ISO Country codes, visit [OA 8754](https://my.apps.factset.com/oa/pages/8754). . [optional]  # noqa: E501
            state (str): Two-character state code corresponding to the entity name that is used when evaluating candidates for a match. Currently, only US state codes are supported.Two character state or province code to filter on. . [optional]  # noqa: E501
            url (str): URL corresponding to the entity name that is used when evaluating candidates for a match. . [optional]  # noqa: E501
            priority (str): Priority associated to the id.. [optional]  # noqa: E501
            bic (str): Name for type BICCode, bank indentification code. [optional]  # noqa: E501
            bbg_ticker (str): Name for the type Bloomberg Listing and Regional Ticker.. [optional]  # noqa: E501
            cik (str): Name for the type CIK, Edgar Central Index Keys. [optional]  # noqa: E501
            crd (str): Name for the type CRD, Central Registration Depository. [optional]  # noqa: E501
            cusip (str): Name for the type CUSIP.. [optional]  # noqa: E501
            duns (str): Name for the type DUNS, Dun&Bradstreet.. [optional]  # noqa: E501
            ein (str): Name for the type EmployerIdentificationNumber, EIN.. [optional]  # noqa: E501
            rssd (str): Name for the type FederalReserveRSSDIdentifier, RSSD.. [optional]  # noqa: E501
            fitch (str): Name for the type FitchCreditRating, Fitch Ratings Identifier.. [optional]  # noqa: E501
            isin (str): Name for the type ISIN.. [optional]  # noqa: E501
            lei (str): Name for the type LegalEntityIdentifier, LEI.. [optional]  # noqa: E501
            bbg_figi (str): Name for the type Bloomberg Listing/Regional/Security ID.. [optional]  # noqa: E501
            md (str): Name for the type MoodysIssuer, Moody's Ratings Identifier.. [optional]  # noqa: E501
            ticker (str): Name for the type PriceTicker.. [optional]  # noqa: E501
            spr (str): Name for the type S&PRating, S&P Ratings Identifier.. [optional]  # noqa: E501
            sedol (str): Name for the type SEDOL.. [optional]  # noqa: E501
            ticker_exchange (str): Name for the type TickerExch.. [optional]  # noqa: E501
            ticker_region (str): Name for the type TickerRegion. [optional]  # noqa: E501
            ukch (str): Name for the type UKCompanyHouse. [optional]  # noqa: E501
            valoren (str): Name for the type VALOR, Valoren (\"Valor\") Identification.. [optional]  # noqa: E501
            wkn (str): Name for the type WKN, German Securities Identification.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
