# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 evaluation_strategy: pulumi.Input['AlertEvaluationStrategyArgs'],
                 metric: pulumi.Input[str],
                 service_id: pulumi.Input[str],
                 source: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input['AlertDimensionsArgs']] = None,
                 integration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input['AlertEvaluationStrategyArgs'] evaluation_strategy: Criteria on how to alert.
        :param pulumi.Input[str] metric: The metric name to alert on for a specific source: [domains](https://developer.fastly.com/reference/api/metrics-stats/domain-inspector/historical), [origins](https://developer.fastly.com/reference/api/metrics-stats/origin-inspector/historical), or [stats](https://developer.fastly.com/reference/api/metrics-stats/historical-stats).
        :param pulumi.Input[str] service_id: The service which the alert monitors.
        :param pulumi.Input[str] source: The source where the metric comes from. One of: `domains`, `origins`, `stats`.
        :param pulumi.Input[str] description: Additional text that is included in the alert notification.
        :param pulumi.Input['AlertDimensionsArgs'] dimensions: More filters depending on the source type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] integration_ids: List of integrations used to notify when alert fires.
        :param pulumi.Input[str] name: The name of the alert.
        """
        pulumi.set(__self__, "evaluation_strategy", evaluation_strategy)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "service_id", service_id)
        pulumi.set(__self__, "source", source)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if integration_ids is not None:
            pulumi.set(__self__, "integration_ids", integration_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="evaluationStrategy")
    def evaluation_strategy(self) -> pulumi.Input['AlertEvaluationStrategyArgs']:
        """
        Criteria on how to alert.
        """
        return pulumi.get(self, "evaluation_strategy")

    @evaluation_strategy.setter
    def evaluation_strategy(self, value: pulumi.Input['AlertEvaluationStrategyArgs']):
        pulumi.set(self, "evaluation_strategy", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input[str]:
        """
        The metric name to alert on for a specific source: [domains](https://developer.fastly.com/reference/api/metrics-stats/domain-inspector/historical), [origins](https://developer.fastly.com/reference/api/metrics-stats/origin-inspector/historical), or [stats](https://developer.fastly.com/reference/api/metrics-stats/historical-stats).
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The service which the alert monitors.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The source where the metric comes from. One of: `domains`, `origins`, `stats`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Additional text that is included in the alert notification.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input['AlertDimensionsArgs']]:
        """
        More filters depending on the source type.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input['AlertDimensionsArgs']]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="integrationIds")
    def integration_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of integrations used to notify when alert fires.
        """
        return pulumi.get(self, "integration_ids")

    @integration_ids.setter
    def integration_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "integration_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the alert.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input['AlertDimensionsArgs']] = None,
                 evaluation_strategy: Optional[pulumi.Input['AlertEvaluationStrategyArgs']] = None,
                 integration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input[str] description: Additional text that is included in the alert notification.
        :param pulumi.Input['AlertDimensionsArgs'] dimensions: More filters depending on the source type.
        :param pulumi.Input['AlertEvaluationStrategyArgs'] evaluation_strategy: Criteria on how to alert.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] integration_ids: List of integrations used to notify when alert fires.
        :param pulumi.Input[str] metric: The metric name to alert on for a specific source: [domains](https://developer.fastly.com/reference/api/metrics-stats/domain-inspector/historical), [origins](https://developer.fastly.com/reference/api/metrics-stats/origin-inspector/historical), or [stats](https://developer.fastly.com/reference/api/metrics-stats/historical-stats).
        :param pulumi.Input[str] name: The name of the alert.
        :param pulumi.Input[str] service_id: The service which the alert monitors.
        :param pulumi.Input[str] source: The source where the metric comes from. One of: `domains`, `origins`, `stats`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_strategy is not None:
            pulumi.set(__self__, "evaluation_strategy", evaluation_strategy)
        if integration_ids is not None:
            pulumi.set(__self__, "integration_ids", integration_ids)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Additional text that is included in the alert notification.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input['AlertDimensionsArgs']]:
        """
        More filters depending on the source type.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input['AlertDimensionsArgs']]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="evaluationStrategy")
    def evaluation_strategy(self) -> Optional[pulumi.Input['AlertEvaluationStrategyArgs']]:
        """
        Criteria on how to alert.
        """
        return pulumi.get(self, "evaluation_strategy")

    @evaluation_strategy.setter
    def evaluation_strategy(self, value: Optional[pulumi.Input['AlertEvaluationStrategyArgs']]):
        pulumi.set(self, "evaluation_strategy", value)

    @property
    @pulumi.getter(name="integrationIds")
    def integration_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of integrations used to notify when alert fires.
        """
        return pulumi.get(self, "integration_ids")

    @integration_ids.setter
    def integration_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "integration_ids", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        The metric name to alert on for a specific source: [domains](https://developer.fastly.com/reference/api/metrics-stats/domain-inspector/historical), [origins](https://developer.fastly.com/reference/api/metrics-stats/origin-inspector/historical), or [stats](https://developer.fastly.com/reference/api/metrics-stats/historical-stats).
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the alert.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The service which the alert monitors.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source where the metric comes from. One of: `domains`, `origins`, `stats`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[pulumi.InputType['AlertDimensionsArgs']]] = None,
                 evaluation_strategy: Optional[pulumi.Input[pulumi.InputType['AlertEvaluationStrategyArgs']]] = None,
                 integration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Fastly Alert. Alerts send notifications to custom integrations (e.g., Slack channels, PagerDuty, Microsoft Teams and New Relic) when an observed metric either exceeds or falls below a threshold.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example_service_vcl = fastly.ServiceVcl("exampleServiceVcl")
        # ...
        example_alert = fastly.Alert("exampleAlert",
            service_id=example_service_vcl.id,
            source="stats",
            metric="status_5xx",
            evaluation_strategy=fastly.AlertEvaluationStrategyArgs(
                type="above_threshold",
                period="5m",
                threshold=10,
            ))
        ```

        ## Import

        Fastly Alerts can be imported using their ID, e.g.

        ```sh
        $ pulumi import fastly:index/alert:Alert example xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Additional text that is included in the alert notification.
        :param pulumi.Input[pulumi.InputType['AlertDimensionsArgs']] dimensions: More filters depending on the source type.
        :param pulumi.Input[pulumi.InputType['AlertEvaluationStrategyArgs']] evaluation_strategy: Criteria on how to alert.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] integration_ids: List of integrations used to notify when alert fires.
        :param pulumi.Input[str] metric: The metric name to alert on for a specific source: [domains](https://developer.fastly.com/reference/api/metrics-stats/domain-inspector/historical), [origins](https://developer.fastly.com/reference/api/metrics-stats/origin-inspector/historical), or [stats](https://developer.fastly.com/reference/api/metrics-stats/historical-stats).
        :param pulumi.Input[str] name: The name of the alert.
        :param pulumi.Input[str] service_id: The service which the alert monitors.
        :param pulumi.Input[str] source: The source where the metric comes from. One of: `domains`, `origins`, `stats`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Alert. Alerts send notifications to custom integrations (e.g., Slack channels, PagerDuty, Microsoft Teams and New Relic) when an observed metric either exceeds or falls below a threshold.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example_service_vcl = fastly.ServiceVcl("exampleServiceVcl")
        # ...
        example_alert = fastly.Alert("exampleAlert",
            service_id=example_service_vcl.id,
            source="stats",
            metric="status_5xx",
            evaluation_strategy=fastly.AlertEvaluationStrategyArgs(
                type="above_threshold",
                period="5m",
                threshold=10,
            ))
        ```

        ## Import

        Fastly Alerts can be imported using their ID, e.g.

        ```sh
        $ pulumi import fastly:index/alert:Alert example xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[pulumi.InputType['AlertDimensionsArgs']]] = None,
                 evaluation_strategy: Optional[pulumi.Input[pulumi.InputType['AlertEvaluationStrategyArgs']]] = None,
                 integration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["dimensions"] = dimensions
            if evaluation_strategy is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation_strategy'")
            __props__.__dict__["evaluation_strategy"] = evaluation_strategy
            __props__.__dict__["integration_ids"] = integration_ids
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            __props__.__dict__["name"] = name
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
        super(Alert, __self__).__init__(
            'fastly:index/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            dimensions: Optional[pulumi.Input[pulumi.InputType['AlertDimensionsArgs']]] = None,
            evaluation_strategy: Optional[pulumi.Input[pulumi.InputType['AlertEvaluationStrategyArgs']]] = None,
            integration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metric: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Additional text that is included in the alert notification.
        :param pulumi.Input[pulumi.InputType['AlertDimensionsArgs']] dimensions: More filters depending on the source type.
        :param pulumi.Input[pulumi.InputType['AlertEvaluationStrategyArgs']] evaluation_strategy: Criteria on how to alert.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] integration_ids: List of integrations used to notify when alert fires.
        :param pulumi.Input[str] metric: The metric name to alert on for a specific source: [domains](https://developer.fastly.com/reference/api/metrics-stats/domain-inspector/historical), [origins](https://developer.fastly.com/reference/api/metrics-stats/origin-inspector/historical), or [stats](https://developer.fastly.com/reference/api/metrics-stats/historical-stats).
        :param pulumi.Input[str] name: The name of the alert.
        :param pulumi.Input[str] service_id: The service which the alert monitors.
        :param pulumi.Input[str] source: The source where the metric comes from. One of: `domains`, `origins`, `stats`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["evaluation_strategy"] = evaluation_strategy
        __props__.__dict__["integration_ids"] = integration_ids
        __props__.__dict__["metric"] = metric
        __props__.__dict__["name"] = name
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["source"] = source
        return Alert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Additional text that is included in the alert notification.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Optional['outputs.AlertDimensions']]:
        """
        More filters depending on the source type.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationStrategy")
    def evaluation_strategy(self) -> pulumi.Output['outputs.AlertEvaluationStrategy']:
        """
        Criteria on how to alert.
        """
        return pulumi.get(self, "evaluation_strategy")

    @property
    @pulumi.getter(name="integrationIds")
    def integration_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of integrations used to notify when alert fires.
        """
        return pulumi.get(self, "integration_ids")

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Output[str]:
        """
        The metric name to alert on for a specific source: [domains](https://developer.fastly.com/reference/api/metrics-stats/domain-inspector/historical), [origins](https://developer.fastly.com/reference/api/metrics-stats/origin-inspector/historical), or [stats](https://developer.fastly.com/reference/api/metrics-stats/historical-stats).
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the alert.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The service which the alert monitors.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The source where the metric comes from. One of: `domains`, `origins`, `stats`.
        """
        return pulumi.get(self, "source")

