"""
    * SPDX-FileCopyrightText: Copyright 2024 LG Electronics Inc.
    * SPDX-License-Identifier: Apache-2.0
"""
from enum import StrEnum, auto


class Resource(StrEnum):
    AIR_CON_JOB_MODE = auto()
    AIR_FAN_JOB_MODE = auto()
    AIR_FLOW = auto()
    AIR_PURIFIER_JOB_MODE = auto()
    AIR_QUALITY_SENSOR = auto()
    BATTERY = auto()
    BOILER_JOB_MODE = auto()
    COOK = auto()
    COOKING_ZONE = auto()
    DEHUMIDIFIER_JOB_MODE = auto()
    DETERGENT = auto()
    DISH_WASHING_COURSE = auto()
    DISH_WASHING_STATUS = auto()
    DISPLAY = auto()
    DOOR_STATUS = auto()
    ECO_FRIENDLY = auto()
    FILTER_INFO = auto()
    HUMIDIFIER_JOB_MODE = auto()
    HUMIDITY = auto()
    INFO = auto()
    LAMP = auto()
    LIGHT = auto()
    MISC = auto()
    MOOD_LAMP = auto()
    OPERATION = auto()
    POWER = auto()
    POWER_SAVE = auto()
    PREFERENCE = auto()
    RECIPE = auto()
    REFRIGERATION = auto()
    REMOTE_CONTROL_ENABLE = auto()
    ROBOT_CLEANER_JOB_MODE = auto()
    RUN_STATE = auto()
    SABBATH = auto()
    SLEEP_TIMER = auto()
    STICK_CLEANER_JOB_MODE = auto()
    TEMPERATURE = auto()
    TIMER = auto()
    TWO_SET_TEMPERATURE = auto()
    VENTILATION = auto()
    WATER_FILTER_INFO = auto()
    WATER_HEATER_JOB_MODE = auto()
    WATER_INFO = auto()


class Property(StrEnum):
    ABSOLUTE_HOUR_TO_START = auto()
    ABSOLUTE_HOUR_TO_STOP = auto()
    ABSOLUTE_MINUTE_TO_START = auto()
    ABSOLUTE_MINUTE_TO_STOP = auto()
    AIR_CLEAN_OPERATION_MODE = auto()
    AIR_CON_OPERATION_MODE = auto()
    AIR_FAN_OPERATION_MODE = auto()
    AIR_PURIFIER_OPERATION_MODE = auto()
    AUTO_MODE = auto()
    BATTERY_LEVEL = auto()
    BATTERY_PERCENT = auto()
    BEER_REMAIN = auto()
    BOILER_OPERATION_MODE = auto()
    BRIGHTNESS = auto()
    CEILING_FAN_OPERATION_MODE = auto()
    CLEAN_LIGHT_REMINDER = auto()
    CLEAN_OPERATION_MODE = auto()
    COCK_STATE = auto()
    COOK_MODE = auto()
    COOL_MAX_TEMPERATURE = auto()
    COOL_MIN_TEMPERATURE = auto()
    COOL_TARGET_TEMPERATURE = auto()
    CURRENT_DISH_WASHING_COURSE = auto()
    CURRENT_HUMIDITY = auto()
    CURRENT_JOB_MODE = auto()
    CURRENT_STATE = auto()
    CURRENT_TEMPERATURE = auto()
    DAY_TARGET_TEMPERATURE = auto()
    DEHUMIDIFIER_OPERATION_MODE = auto()
    DETERGENT_SETTING = auto()
    DISH_WASHER_OPERATION_MODE = auto()
    DISPLAY_LIGHT = auto()
    DOOR_STATE = auto()
    DRYER_OPERATION_MODE = auto()
    DURATION = auto()
    ECO_FRIENDLY_MODE = auto()
    ELAPSED_DAY_STATE = auto()
    ELAPSED_DAY_TOTAL = auto()
    END_HOUR = auto()
    END_MINUTE = auto()
    EXPRESS_MODE = auto()
    FAN_SPEED = auto()
    FILTER_LIFETIME = auto()
    FLAVOR_INFO = auto()
    FRESH_AIR_FILTER = auto()
    GROWTH_MODE = auto()
    HEAT_MAX_TEMPERATURE = auto()
    HEAT_MIN_TEMPERATURE = auto()
    HEAT_TARGET_TEMPERATURE = auto()
    HOOD_OPERATION_MODE = auto()
    HOP_OIL_INFO = auto()
    HOT_WATER_MODE = auto()
    HUMIDIFIER_OPERATION_MODE = auto()
    HUMIDITY = auto()
    HYGIENE_DRY_MODE = auto()
    LAMP_BRIGHTNESS = auto()
    LIGHT_BRIGHTNESS = auto()
    LIGHT_STATUS = auto()
    MACHINE_CLEAN_REMINDER = auto()
    MONITORING_ENABLED = auto()
    MOOD_LAMP_STATE = auto()
    NIGHT_TARGET_TEMPERATURE = auto()
    ODOR = auto()
    ODOR_LEVEL = auto()
    ONE_TOUCH_FILTER = auto()
    OPERATION_MODE = auto()
    OPTIMAL_HUMIDITY = auto()
    OVEN_OPERATION_MODE = auto()
    OVEN_TYPE = auto()
    PERSONALIZATION_MODE = auto()
    PM1 = auto()
    PM10 = auto()
    PM2 = auto()
    POWER_LEVEL = auto()
    POWER_SAVE_ENABLED = auto()
    RAPID_FREEZE = auto()
    RECIPE_NAME = auto()
    RELATIVE_HOUR_TO_START = auto()
    RELATIVE_HOUR_TO_STOP = auto()
    RELATIVE_MINUTE_TO_START = auto()
    RELATIVE_MINUTE_TO_STOP = auto()
    REMAIN_HOUR = auto()
    REMAIN_MINUTE = auto()
    REMAIN_SECOND = auto()
    REMOTE_CONTROL_ENABLED = auto()
    RINSE_LEVEL = auto()
    RINSE_REFILL = auto()
    RUNNING_HOUR = auto()
    RUNNING_MINUTE = auto()
    SABBATH_MODE = auto()
    SIGNAL_LEVEL = auto()
    SLEEP_MODE = auto()
    SLEEP_TIMER_RELATIVE_HOUR_TO_STOP = auto()
    SLEEP_TIMER_RELATIVE_MINUTE_TO_STOP = auto()
    SOFTENING_LEVEL = auto()
    START_HOUR = auto()
    START_MINUTE = auto()
    STERILIZING_STATE = auto()
    STYLER_OPERATION_MODE = auto()
    TARGET_HOUR = auto()
    TARGET_HUMIDITY = auto()
    TARGET_MINUTE = auto()
    TARGET_SECOND = auto()
    TARGET_TEMPERATURE = auto()
    TARGET_TEMPERATURE_C = auto()
    TARGET_TEMPERATURE_F = auto()
    TEMPERATURE = auto()
    TEMPERATURE_STATE = auto()
    TEMPERATURE_UNIT = auto()
    TIMER_HOUR = auto()
    TIMER_MINUTE = auto()
    TIMER_SECOND = auto()
    TOTAL_HOUR = auto()
    TOTAL_MINUTE = auto()
    TOTAL_POLLUTION = auto()
    TOTAL_POLLUTION_LEVEL = auto()
    TWO_SET_COOL_TARGET_TEMPERATURE = auto()
    TWO_SET_CURRENT_TEMPERATURE = auto()
    TWO_SET_HEAT_TARGET_TEMPERATURE = auto()
    TWO_SET_TEMPERATURE_UNIT = auto()
    USED_TIME = auto()
    UV_NANO = auto()
    WARM_MODE = auto()
    WASHER_OPERATION_MODE = auto()
    WATER_FILTER_INFO_UNIT = auto()
    WATER_HEATER_OPERATION_MODE = auto()
    WATER_TYPE = auto()
    WIND_ANGLE = auto()
    WIND_STEP = auto()
    WIND_STRENGTH = auto()
    WIND_TEMPERATURE = auto()
    WIND_VOLUME = auto()
    WORT_INFO = auto()
    YEAST_INFO = auto()


class Location(StrEnum):
    CENTER = auto()
    CENTER_FRONT = auto()
    CENTER_REAR = auto()
    LEFT_FRONT = auto()
    LEFT_REAR = auto()
    RIGHT_FRONT = auto()
    RIGHT_REAR = auto()
    BURNER_1 = auto()
    BURNER_2 = auto()
    BURNER_3 = auto()
    BURNER_4 = auto()
    BURNER_5 = auto()
    BURNER_6 = auto()
    BURNER_7 = auto()
    BURNER_8 = auto()
    INDUCTION_1 = auto()
    INDUCTION_2 = auto()
    SOUSVIDE_1 = auto()

    TOP = auto()
    MIDDLE = auto()
    BOTTOM = auto()
    LEFT = auto()
    RIGHT = auto()
    SINGLE = auto()

    OVEN = auto()
    UPPER = auto()
    LOWER = auto()

    MAIN = auto()
    MINI = auto()

    FRIDGE = auto()
    FREEZER = auto()
    CONVERTIBLE = auto()

    DRYER = auto()
    WASHER = auto()
