from typing import Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="ExperimentDataset")


@_attrs_define
class ExperimentDataset:
    """
    Attributes:
        dataset_id (Union[None, Unset, str]):
        dataset_version_id (Union[None, Unset, str]):
        name (Union[None, Unset, str]):
        version_index (Union[None, Unset, int]):
    """

    dataset_id: Union[None, Unset, str] = UNSET
    dataset_version_id: Union[None, Unset, str] = UNSET
    name: Union[None, Unset, str] = UNSET
    version_index: Union[None, Unset, int] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        dataset_id: Union[None, Unset, str]
        if isinstance(self.dataset_id, Unset):
            dataset_id = UNSET
        else:
            dataset_id = self.dataset_id

        dataset_version_id: Union[None, Unset, str]
        if isinstance(self.dataset_version_id, Unset):
            dataset_version_id = UNSET
        else:
            dataset_version_id = self.dataset_version_id

        name: Union[None, Unset, str]
        if isinstance(self.name, Unset):
            name = UNSET
        else:
            name = self.name

        version_index: Union[None, Unset, int]
        if isinstance(self.version_index, Unset):
            version_index = UNSET
        else:
            version_index = self.version_index

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if dataset_id is not UNSET:
            field_dict["dataset_id"] = dataset_id
        if dataset_version_id is not UNSET:
            field_dict["dataset_version_id"] = dataset_version_id
        if name is not UNSET:
            field_dict["name"] = name
        if version_index is not UNSET:
            field_dict["version_index"] = version_index

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()

        def _parse_dataset_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        dataset_id = _parse_dataset_id(d.pop("dataset_id", UNSET))

        def _parse_dataset_version_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        dataset_version_id = _parse_dataset_version_id(d.pop("dataset_version_id", UNSET))

        def _parse_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        name = _parse_name(d.pop("name", UNSET))

        def _parse_version_index(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        version_index = _parse_version_index(d.pop("version_index", UNSET))

        experiment_dataset = cls(
            dataset_id=dataset_id, dataset_version_id=dataset_version_id, name=name, version_index=version_index
        )

        experiment_dataset.additional_properties = d
        return experiment_dataset

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
