# 
# Baruwa - Web 2.0 MailScanner front-end.
# Copyright (C) 2010  Andrew Colin Kissa <andrew@topdog.za.net>
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# vim: ai ts=4 sts=4 et sw=4
#

#  Based on: http://www.djangosnippets.org/snippets/73/
#
#  Modified by Sean Reifschneider to be smarter about surrounding page
#  link context.  For usage documentation see:
#
#     http://www.tummy.com/Community/Articles/django-pagination/

from django import template

register = template.Library()

def paginator(context, adjacent_pages=2):
    """
    To be used in conjunction with the object_list generic view.

    Adds pagination context variables for use in displaying first, adjacent and
    last page links in addition to those created by the object_list generic
    view.

    """
    startpage = max(context['page'] - adjacent_pages, 1)
    if startpage <= 3:
        startpage = 1
    endpage = context['page'] + adjacent_pages + 1
    if endpage >= context['pages'] - 1:
        endpage = context['pages'] + 1
    page_numbers = [n for n in range(startpage, endpage) \
            if n > 0 and n <= context['pages']]
    page_obj = context['page_obj']
    local_paginator = context['paginator']

    if not context.has_key('direction'):
        context['direction'] = None

    if not context.has_key('order_by'):
        context['order_by'] = None

    return {
        'page_obj': page_obj,
        'paginator': local_paginator,
        'hits': context['hits'],
        'results_per_page': context['results_per_page'],
        'page': context['page'],
        'pages': context['pages'],
        'page_numbers': page_numbers,
        'next': context['next'],
        'previous': context['previous'],
        'has_next': context['has_next'],
        'has_previous': context['has_previous'],
        'show_first': 1 not in page_numbers,
        'show_last': context['pages'] not in page_numbers,
        'view_type': context['view_type'],
        'order_by': context['order_by'],
        'direction': context['direction'],
        'list_all': context['list_all'],
        'quarantine_type': context['quarantine_type'],
    }

register.inclusion_tag('tags/paginator.html', takes_context=True)(paginator)
