"""
    Securitized Derivatives API For Digital Portals

    Search for securitized derivative instruments, using a criteria-based screener. The API provides also fundamental data, notation-based key figures, list of barrier types, and details regarding the underlyings, their respective barriers and related cash flows, coupon lists and derived basic interest rate information.  The screener is based on securitized derivatives-specific parameters. The result is limited to the notations that satisfy all the selected filters. If more than one notation of an instrument matches the parameters, and no market priority has been specified, only the notation with the highest trading volume, averaged over one month, is considered. All identifier types used as parameters must be valid and application must have permissions for them.  Available search criteria include:  * validation: filter for only active listings, by price quality and latest/previous available price dates * traded markets: filter and indicate a market priority for the validation * life cycle: important dates in and features of the life cycle of the securitized derivatives instruments * filter by issuer, country of registration of the securitized derivatives * underlying and related barriers, including level and distance, and resulting cash flows * coupon data: where applicable, occurrence and frequency of coupon payments, current interest rate range * performance and volatility * product-specific ask-based key figures (not all key figures are available for all product types):     * bonus yield, sideways yield, maximum yield based on the ask price     * agio, discount     * spread     * break even, outperformance point, parity     * delta, weekly theta, vega, implied volatility     * leverage, omega     * intrinsic value, time value         Since some underlyings, e.g. an index or a performance difference of a stock and an index (alpha structure), do not represent a directly tradable asset, they do not have a price in the classical sense. Therefore, the term *level* is used instead of *price*, e.g. underlying level instead of underlying price. The endpoint does not support the search for securitized derivatives with multiple underlyings, thus only securitized derivatives with a single underlying are returned in the result.  The search can be restricted to a specific set of products by using customer-specific instrument or notation lists. Such restriction lists are set up by FactSet upon request.  This API is fully integrated with the corresponding Quotes API, allowing access to detailed price and performance information of instruments, as well as basic security identifier cross-reference. For direct access to price histories, please refer to the Time Series API for Digital Portals.  Similar criteria based screener APIs exist for equity and fixed income instruments: See the Stocks API and the Bonds API for details.  # noqa: E501

    The version of the OpenAPI document: 2
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.exceptions import ApiAttributeError


def lazy_import():
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_country_security_registration import InlineResponse200DataCountrySecurityRegistration
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_exercise import InlineResponse200DataExercise
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_issue import InlineResponse200DataIssue
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_issuer import InlineResponse200DataIssuer
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_life_cycle import InlineResponse200DataLifeCycle
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_nominal import InlineResponse200DataNominal
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_nsin import InlineResponse200DataNsin
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_order_volume import InlineResponse200DataOrderVolume
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_reference_debtor import InlineResponse200DataReferenceDebtor
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_type import InlineResponse200DataType
    globals()['InlineResponse200DataCountrySecurityRegistration'] = InlineResponse200DataCountrySecurityRegistration
    globals()['InlineResponse200DataExercise'] = InlineResponse200DataExercise
    globals()['InlineResponse200DataIssue'] = InlineResponse200DataIssue
    globals()['InlineResponse200DataIssuer'] = InlineResponse200DataIssuer
    globals()['InlineResponse200DataLifeCycle'] = InlineResponse200DataLifeCycle
    globals()['InlineResponse200DataNominal'] = InlineResponse200DataNominal
    globals()['InlineResponse200DataNsin'] = InlineResponse200DataNsin
    globals()['InlineResponse200DataOrderVolume'] = InlineResponse200DataOrderVolume
    globals()['InlineResponse200DataReferenceDebtor'] = InlineResponse200DataReferenceDebtor
    globals()['InlineResponse200DataType'] = InlineResponse200DataType


class InlineResponse200Data(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('settlement',): {
            'CASH': "cash",
            'PHYSICAL': "physical",
            'EITHER': "either",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'isin': (str,),  # noqa: E501
            'nsin': (InlineResponse200DataNsin,),  # noqa: E501
            'is_private_placement': (bool,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'short_name': (str,),  # noqa: E501
            'type': ([InlineResponse200DataType],),  # noqa: E501
            'is_incomplete': (bool,),  # noqa: E501
            'life_cycle': (InlineResponse200DataLifeCycle,),  # noqa: E501
            'country_security_registration': ([InlineResponse200DataCountrySecurityRegistration],),  # noqa: E501
            'reference_debtor': (InlineResponse200DataReferenceDebtor,),  # noqa: E501
            'is_collateralized': (bool,),  # noqa: E501
            'is_quanto': (bool,),  # noqa: E501
            'capital_protection': (float,),  # noqa: E501
            'has_catch_up': (bool,),  # noqa: E501
            'has_automatic_exercise': (bool,),  # noqa: E501
            'order_volume': (InlineResponse200DataOrderVolume,),  # noqa: E501
            'redemption_amount': (float,),  # noqa: E501
            'nominal': (InlineResponse200DataNominal,),  # noqa: E501
            'issuer': (InlineResponse200DataIssuer,),  # noqa: E501
            'issue': (InlineResponse200DataIssue,),  # noqa: E501
            'exercise': (InlineResponse200DataExercise,),  # noqa: E501
            'settlement': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'isin': 'isin',  # noqa: E501
        'nsin': 'nsin',  # noqa: E501
        'is_private_placement': 'isPrivatePlacement',  # noqa: E501
        'name': 'name',  # noqa: E501
        'short_name': 'shortName',  # noqa: E501
        'type': 'type',  # noqa: E501
        'is_incomplete': 'isIncomplete',  # noqa: E501
        'life_cycle': 'lifeCycle',  # noqa: E501
        'country_security_registration': 'countrySecurityRegistration',  # noqa: E501
        'reference_debtor': 'referenceDebtor',  # noqa: E501
        'is_collateralized': 'isCollateralized',  # noqa: E501
        'is_quanto': 'isQuanto',  # noqa: E501
        'capital_protection': 'capitalProtection',  # noqa: E501
        'has_catch_up': 'hasCatchUp',  # noqa: E501
        'has_automatic_exercise': 'hasAutomaticExercise',  # noqa: E501
        'order_volume': 'orderVolume',  # noqa: E501
        'redemption_amount': 'redemptionAmount',  # noqa: E501
        'nominal': 'nominal',  # noqa: E501
        'issuer': 'issuer',  # noqa: E501
        'issue': 'issue',  # noqa: E501
        'exercise': 'exercise',  # noqa: E501
        'settlement': 'settlement',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """InlineResponse200Data - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            isin (str): The International Securities Identification Number (ISIN) of the instrument. The ISIN is a 12-character code of digits and upper-case letters that uniquely identifies an instrument.. [optional]  # noqa: E501
            nsin (InlineResponse200DataNsin): [optional]  # noqa: E501
            is_private_placement (bool): If true, the instrument is part of a private placement and therefore not publicly traded.. [optional]  # noqa: E501
            name (str): Name of the instrument.. [optional]  # noqa: E501
            short_name (str): Short name of the instrument.. [optional]  # noqa: E501
            type ([InlineResponse200DataType]): Instrument type as defined by FactSet Digital Solutions. Instrument types are arranged in a hierarchy, with the first level representing the most coarse granularity and further levels successively refining the granularity (see MDG category system 18). Please refer to endpoint `/category/get` for possible values.. [optional]  # noqa: E501
            is_incomplete (bool): If true, the data supplier has marked the data for this instrument as incomplete.. [optional]  # noqa: E501
            life_cycle (InlineResponse200DataLifeCycle): [optional]  # noqa: E501
            country_security_registration ([InlineResponse200DataCountrySecurityRegistration]): List of countries where the instrument is registered. See endpoint `/basic/region/country/list` for possible values.. [optional]  # noqa: E501
            reference_debtor (InlineResponse200DataReferenceDebtor): [optional]  # noqa: E501
            is_collateralized (bool): If true, this instrument is protected against an issuer default by collateral (e.g. COSI collateralization by SIX Swiss Exchange).. [optional]  # noqa: E501
            is_quanto (bool): If true, the risk of exchange rate fluctuations between the value unit of the underlying (all of them, in case of multiple underlyings) and the value unit of the redemption is hedged.. [optional]  # noqa: E501
            capital_protection (float): Proportion of the nominal amount protected against loss, usually 100%.. [optional]  # noqa: E501
            has_catch_up (bool): If true, the instrument has a so-called \"memory feature\" (also called \"catch up\"). This means that a conditional payment that has not been paid out could be paid on a subsequent payment date if the condition is then satisfied.. [optional]  # noqa: E501
            has_automatic_exercise (bool): If true, the instrument will be automatically exercised at termination (such as maturity, premature call, or premature payout). It prevents such products from becoming worthless, meaning the investor does not have to undertake any steps in order to receive the payable amount.. [optional]  # noqa: E501
            order_volume (InlineResponse200DataOrderVolume): [optional]  # noqa: E501
            redemption_amount (float): Actual redemption amount after expiry (e.g. knock out, maturity etc) for securitized derivatives with a so-called knock-out feature. The currency of the redemption amount is given by `issue.valueUnit` and is always a main currency for securitized derivatives with that feature. . [optional]  # noqa: E501
            nominal (InlineResponse200DataNominal): [optional]  # noqa: E501
            issuer (InlineResponse200DataIssuer): [optional]  # noqa: E501
            issue (InlineResponse200DataIssue): [optional]  # noqa: E501
            exercise (InlineResponse200DataExercise): [optional]  # noqa: E501
            settlement (str): Settlement is the fulfillment of the issuer's contractual obligations arising from the securitized derivative. Depending on the terms, the underlying asset may be delivered physically or its equivalent monetary value may be payed out.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """InlineResponse200Data - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            isin (str): The International Securities Identification Number (ISIN) of the instrument. The ISIN is a 12-character code of digits and upper-case letters that uniquely identifies an instrument.. [optional]  # noqa: E501
            nsin (InlineResponse200DataNsin): [optional]  # noqa: E501
            is_private_placement (bool): If true, the instrument is part of a private placement and therefore not publicly traded.. [optional]  # noqa: E501
            name (str): Name of the instrument.. [optional]  # noqa: E501
            short_name (str): Short name of the instrument.. [optional]  # noqa: E501
            type ([InlineResponse200DataType]): Instrument type as defined by FactSet Digital Solutions. Instrument types are arranged in a hierarchy, with the first level representing the most coarse granularity and further levels successively refining the granularity (see MDG category system 18). Please refer to endpoint `/category/get` for possible values.. [optional]  # noqa: E501
            is_incomplete (bool): If true, the data supplier has marked the data for this instrument as incomplete.. [optional]  # noqa: E501
            life_cycle (InlineResponse200DataLifeCycle): [optional]  # noqa: E501
            country_security_registration ([InlineResponse200DataCountrySecurityRegistration]): List of countries where the instrument is registered. See endpoint `/basic/region/country/list` for possible values.. [optional]  # noqa: E501
            reference_debtor (InlineResponse200DataReferenceDebtor): [optional]  # noqa: E501
            is_collateralized (bool): If true, this instrument is protected against an issuer default by collateral (e.g. COSI collateralization by SIX Swiss Exchange).. [optional]  # noqa: E501
            is_quanto (bool): If true, the risk of exchange rate fluctuations between the value unit of the underlying (all of them, in case of multiple underlyings) and the value unit of the redemption is hedged.. [optional]  # noqa: E501
            capital_protection (float): Proportion of the nominal amount protected against loss, usually 100%.. [optional]  # noqa: E501
            has_catch_up (bool): If true, the instrument has a so-called \"memory feature\" (also called \"catch up\"). This means that a conditional payment that has not been paid out could be paid on a subsequent payment date if the condition is then satisfied.. [optional]  # noqa: E501
            has_automatic_exercise (bool): If true, the instrument will be automatically exercised at termination (such as maturity, premature call, or premature payout). It prevents such products from becoming worthless, meaning the investor does not have to undertake any steps in order to receive the payable amount.. [optional]  # noqa: E501
            order_volume (InlineResponse200DataOrderVolume): [optional]  # noqa: E501
            redemption_amount (float): Actual redemption amount after expiry (e.g. knock out, maturity etc) for securitized derivatives with a so-called knock-out feature. The currency of the redemption amount is given by `issue.valueUnit` and is always a main currency for securitized derivatives with that feature. . [optional]  # noqa: E501
            nominal (InlineResponse200DataNominal): [optional]  # noqa: E501
            issuer (InlineResponse200DataIssuer): [optional]  # noqa: E501
            issue (InlineResponse200DataIssue): [optional]  # noqa: E501
            exercise (InlineResponse200DataExercise): [optional]  # noqa: E501
            settlement (str): Settlement is the fulfillment of the issuer's contractual obligations arising from the securitized derivative. Depending on the terms, the underlying asset may be delivered physically or its equivalent monetary value may be payed out.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
