angular.module("sw.ui.md").run(["$templateCache", function($templateCache) {$templateCache.put("auth.html","<!DOCTYPE html> <html lang=\"en\"> <head> <meta charset=\"UTF-8\"> <title>OAuth 2.0 Callback</title> </head> <script>// from https://github.com/swagger-api/swagger-ui/blob/master/dist/o2c.html\n\n    var qp;\n\n    if (window.location.hash) {\n        qp = location.hash.substring(1).replace(/^\\//, \'\');\n    } else {\n        qp = location.search.substring(1);\n    }\n\n    qp = qp ? JSON.parse(\'{\"\' + qp.replace(/&/g, \'\",\"\').replace(/=/g, \'\":\"\') + \'\"}\',\n        function (key, value) {\n            return key === \'\' ? value : decodeURIComponent(value)\n        }\n    ) : {};\n\n    if (window.opener) {\n        window.opener.onOAuthFinished(qp);\n        window.close();\n    }</script> </html>");
$templateCache.put("hub/index.html","<!doctype html> <html ng-app=\"hub\"> <head> <meta charset=\"utf-8\"> <title>Material Swagger UI Hub</title> <meta name=\"viewport\" content=\"width=device-width,initial-scale=1,maximum-scale=1,user-scalable=no\"/> <link rel=\"stylesheet\" href=\"//fonts.googleapis.com/icon?family=Material+Icons\"> <link rel=\"stylesheet\" href=\"//fonts.googleapis.com/css?family=Roboto:300,400,500,700,400italic\"> <link rel=\"stylesheet\" href=\"//ajax.googleapis.com/ajax/libs/angular_material/1.0.5/angular-material.min.css\"> <style>.ng-cloak {\r\n            display: none;\r\n        }</style> <style>md-toolbar small {\r\n            max-width: 120px;\r\n            text-overflow: ellipsis;\r\n            display: block;\r\n            overflow: hidden;\r\n            white-space: nowrap;\r\n        }\r\n\r\n        a:focus {\r\n            outline: none;\r\n        }\r\n\r\n        .md-errors-spacer {\r\n            display: none;\r\n        }\r\n\r\n        a.md-button {\r\n            font-weight: normal;\r\n        }\r\n\r\n        .tools a.md-button {\r\n            font-weight: 500;\r\n        }\r\n\r\n        .tools .md-button {\r\n            font-weight: 500;\r\n            min-width: 0;\r\n            margin: 3px;\r\n            height: 28px;\r\n            min-height: 28px;\r\n            line-height: 28px;\r\n        }\r\n\r\n        .tools {\r\n            padding: 3px;\r\n            background-color: #fff;\r\n        }\r\n\r\n        .info .md-body-1,\r\n        .info .md-body-2 {\r\n            line-height: 14px;\r\n        }\r\n\r\n        .info {\r\n            padding: 12px;\r\n            margin: 6px;\r\n        }\r\n\r\n        .info md-divider {\r\n            padding: 0;\r\n            margin: 6px 6px;\r\n        }\r\n\r\n        .show-hide {\r\n            transition: all ease-in-out 0.2s;\r\n            max-height: 290px;\r\n            overflow: hidden;\r\n            position: relative;\r\n            top: 0;\r\n            z-index: 1;\r\n        }\r\n\r\n        .show-hide.ng-hide {\r\n            max-height: 0;\r\n            top: -100px;\r\n        }\r\n\r\n        .info a,\r\n        p a,\r\n        ul a {\r\n            color: rgb(61, 90, 254);\r\n            text-decoration: none;\r\n        }\r\n\r\n        .info a:hover,\r\n        p a:hover,\r\n        ul a:hover {\r\n            text-decoration: underline;\r\n        }\r\n\r\n        .info md-icon {\r\n            margin: -5px 0 -5px 5px;\r\n        }\r\n\r\n        .info .md-body-2,\r\n        .info .right {\r\n            text-align: right;\r\n            word-break: break-all;\r\n            padding-left: 24px;\r\n        }\r\n\r\n        .header {\r\n            z-index: 2;\r\n        }\r\n\r\n        md-list-item .md-list-item-inner > md-icon:first-child:not(.md-avatar-icon) {\r\n            margin-right: 12px;\r\n        }\r\n\r\n        badge {\r\n            position: relative;\r\n            top: -1px;\r\n            margin: 0 6px 0 6px;\r\n            display: inline-block;\r\n            background-color: #bbbbbb;\r\n            color: #fff;\r\n            border-radius: 8px;\r\n            line-height: 12px;\r\n            font-size: 12px;\r\n            height: 12px;\r\n            padding: 2px 6px;\r\n            font-weight: 500;\r\n            min-width: 6px;\r\n            text-align: center;\r\n        }\r\n\r\n        .doc {\r\n            line-height: 20px;\r\n        }\r\n\r\n        .doc h2 {\r\n            margin: 6px 0 20px 0;\r\n            padding: 0;\r\n        }\r\n\r\n        p {\r\n            margin: 18px 0 0 0;\r\n            padding: 0 24px 0 0;\r\n        }\r\n\r\n        ul {\r\n            margin: 0;\r\n            padding: 0 24px;\r\n            line-height: 20px;\r\n        }\r\n\r\n        a.flink {\r\n            border-bottom: 1px dotted rgb(61, 90, 254);\r\n        }\r\n\r\n        a.flink:hover {\r\n            text-decoration: none;\r\n            border-bottom: 1px solid rgb(61, 90, 254);\r\n        }</style> <style>toolbar-search input {\r\n            background: transparent;\r\n            border: none;\r\n            width: 120px;\r\n            margin-top: 4px;\r\n            vertical-align: middle;\r\n            margin-left: -6px;\r\n            margin-right: -12px;\r\n            position: relative;\r\n            top: -2px;\r\n        }\r\n\r\n        toolbar-search input:focus {\r\n            outline: none;\r\n        }\r\n\r\n        toolbar-search .input-show-hide {\r\n            -webkit-transition: all ease-out 0.25s;\r\n            transition: all ease-out 0.25s;\r\n        }\r\n\r\n        toolbar-search .input-show-hide.ng-hide {\r\n            -webkit-transition: all ease-in 0.25s;\r\n            transition: all ease-in 0.25s;\r\n            width: 0;\r\n            opacity: 0;\r\n            margin-left: 0;\r\n            margin-right: 0;\r\n        }\r\n\r\n        @media screen and (min-width: 540px) {\r\n            toolbar-search input {\r\n                width: 180px;\r\n            }\r\n        }\r\n\r\n        @media screen and (min-width: 720px) {\r\n            toolbar-search input {\r\n                width: 240px;\r\n            }\r\n        }</style> <style>.no-transform md-tab-item {\r\n            text-transform: none;\r\n        }\r\n\r\n        .bg {\r\n            background-color: #fcfcfc;\r\n        }\r\n\r\n        .short-buttons .md-button {\r\n            min-width: 0;\r\n            width: inherit;\r\n            font-weight: 500;\r\n        }\r\n\r\n        .pre {\r\n            overflow: auto;\r\n            white-space: pre-wrap;\r\n            font-family: monospace;\r\n        }\r\n\r\n        .md {\r\n            overflow: auto;\r\n            white-space: pre-wrap;\r\n        }\r\n\r\n        @media screen and (min-height: 540px) {\r\n            md-menu-content {\r\n                max-height: 384px;\r\n            }\r\n        }</style> </head> <body ng-controller=\"HubCtrl as vm\" layout=\"row\" class=\"ng-cloak\" style=\"overflow: hidden\"> <div layout=\"column\" flex> <md-toolbar md-whiteframe=\"2\" class=\"md-hue-3\" style=\"z-index: 3\" no-ng-style=\"vm.path && vm.apiStyle\"> <div ng-show=\"!vm.path\" class=\"md-toolbar-tools\" ng-style=\"{\'padding-left\': (vm.loading) ? 0 : null}\"> <md-progress-circular ng-show=\"vm.loading\" class=\"md-primary md-hue-2\" md-mode=\"indeterminate\" md-diameter=\"56\"></md-progress-circular> <span ng-show=\"vm.loading\">Loading&hellip;</span> <div hide show-gt-sm ng-hide=\"vm.loading\"> <span style=\"opacity: 0.5\" ng-if=\"vm.apis.length && (vm.count != vm.apis.length)\">{{vm.count}} of</span> <span class=\"md-title\">{{vm.apis.length}} APIs</span> </div> <span flex></span> <toolbar-search ng-hide=\"vm.loading\" ng-model=\"vm.filter.search\"></toolbar-search> <md-button ng-hide=\"vm.loading\" hide show-gt-sm aria-label=\"expand\" ng-click=\"vm.toggle(true)\" class=\"md-icon-button\"> <md-icon>keyboard_arrow_down</md-icon> </md-button> <md-button ng-hide=\"vm.loading\" hide show-gt-sm aria-label=\"collapse\" ng-click=\"vm.toggle(false)\" class=\"md-icon-button\"> <md-icon>keyboard_arrow_up</md-icon> </md-button> <md-button ng-hide=\"vm.loading\" hide show-gt-sm aria-label=\"group\" ng-click=\"vm.group = !vm.group\" class=\"md-icon-button\"> <md-icon ng-bind=\"vm.group ? \'folder\' : \'folder_open\'\"></md-icon> </md-button> <md-menu ng-hide=\"vm.loading\" md-position-mode=\"target-right target\"> <md-button aria-label=\"sort\" ng-click=\"$mdOpenMenu($event)\" class=\"md-icon-button\"> <md-icon>sort</md-icon> </md-button> <md-menu-content width=\"4\"> <md-subheader>Sort by</md-subheader> <md-divider></md-divider> <md-menu-item> <md-button ng-click=\"vm.sort(0)\"> <md-icon ng-bind=\"vm.sortBy == 0 ? \'done\' : \'\'\"></md-icon> Provider </md-button> </md-menu-item> <md-menu-item> <md-button ng-click=\"vm.sort(1)\"> <md-icon ng-bind=\"vm.sortBy == 1 ? \'done\' : \'\'\"></md-icon> Title </md-button> </md-menu-item> <md-menu-item> <md-button ng-click=\"vm.sort(2)\"> <md-icon ng-bind=\"vm.sortBy == 2 ? \'done\' : \'\'\"></md-icon> Last updated </md-button> </md-menu-item> <md-menu-item> <md-button ng-click=\"vm.sort(3)\"> <md-icon ng-bind=\"vm.sortBy == 3 ? \'done\' : \'\'\"></md-icon> Last added </md-button> </md-menu-item> <md-menu-item> <md-button ng-click=\"vm.sort(4)\"> <md-icon ng-bind=\"vm.sortBy == 4 ? \'done\' : \'\'\"></md-icon> Operations </md-button> </md-menu-item> </md-menu-content> </md-menu> <md-button ng-hide=\"vm.loading\" ng-click=\"vm.sidenav = !vm.sidenav\" class=\"md-icon-button\" aria-label=\"filter\"> <md-icon>filter_list</md-icon> </md-button> </div> <div ng-show=\"vm.path\" class=\"md-toolbar-tools\" ng-style=\"{\'padding-left\': (vm.loading || vm.updating) ? 0 : null}\"> <md-progress-circular ng-show=\"vm.loading\" class=\"md-primary md-hue-2\" md-mode=\"indeterminate\" md-diameter=\"56\"></md-progress-circular> <span ng-show=\"vm.loading\">Loading&hellip;</span> <md-button ng-hide=\"vm.loading || vm.updating\" style=\"margin-left: -6px\" ng-click=\"vm.back()\" class=\"md-icon-button\"> <md-icon>keyboard_backspace</md-icon> </md-button> <div ng-hide=\"vm.loading || vm.updating\"> <span class=\"md-title\" ng-bind=\"vm.prefered.info.title || vm.path\"></span> </div> </div> </md-toolbar> <md-progress-linear md-mode=\"indeterminate\" class=\"md-primary\" ng-show=\"vm.updating\" style=\"position: relative; z-index: 59; margin-top: -5px\"></md-progress-linear> <md-content flex ng-show=\"!vm.path\" style=\"overflow-y: scroll\"> <div ng-show=\"!vm.loading\" class=\"doc md-body-1\" layout=\"row\" layout-wrap layout-padding layout-align=\"end\" style=\"margin-top: 2px; padding-bottom: 6px\"> <div flex-xs=\"100\" flex-sm=\"50\" flex-md=\"33\" flex-lg=\"25\" flex-xl=\"20\" style=\"padding: 12px\"> <h2 class=\"md-title\">Intro</h2> <p> This is testing and exploring hub for <a href=\"https://github.com/darosh/angular-swagger-ui-material\">Material Swagger UI</a> demo showing live data from <a href=\"http://APIs.guru\">APIs.guru</a> mixed with additional properties. </p> <p> OAuth2 APIs configured in demo: <a class=\"flink\" href=\"#?search=googleapis.com:blogger\">Blogger</a>, <a class=\"flink\" href=\"#?search=googleapis.com:books\">Books</a>, <a class=\"flink\" href=\"#?search=googleapis.com:calendar\">Calendar</a>, <a class=\"flink\" href=\"#?search=googleapis.com:drive\">Drive</a>, <a class=\"flink\" href=\"#?search=googleapis.com:plus\">Google+</a>. </p> </div> <div flex-xs=\"100\" flex-sm=\"50\" flex-md=\"33\" flex-lg=\"25\" flex-xl=\"20\" style=\"padding: 12px\"> <h2 class=\"md-title\">Search</h2> <ul> <li>Search example: <a class=\"flink\" href=\"#?search=google\">google</a></li> <li>Negative search example: <a class=\"flink\" href=\"#?search=!google\">!google</a> <br>(prefixed with exclamation mark) </li> <li>Other examples: <a class=\"flink\" href=\"#?search=.gov\">.gov</a>, <a class=\"flink\" href=\"#?search=.org\">.org</a>, <a class=\"flink\" href=\"#?search=.com\">.com</a>, <a class=\"flink\" href=\"#?search=city\">city</a>, grouped <a class=\"flink\" href=\"#?search=:&group\">groups only</a> </li> </ul> </div> <div flex style=\"padding: 12px\"> <h2 class=\"md-title\">Filters</h2> <ul> <li>CORS information is grabbed <a href=\"https://github.com/darosh/angular-swagger-ui-material/blob/master/lib/api-models-meta/index.js\">automatically</a> and may be incorrect </li> <li>Security is extracted from global <a href=\"http://swagger.io/specification/#securityDefinitionsObject\">securityDefinitions</a> spec (except <em>local</em> value) </li> <li>Tested filter shows <a href=\"https://github.com/darosh/angular-swagger-ui-material/blob/master/test/manual/manual.json\">manual testing</a> success or fail </li> <li>Recommended examples to try <ul> <li><a class=\"flink\" href=\"#?cors=false&cors=none&security=accessCode&security=apiKey&security=basic&security=implicit&security=local&security=password&tested=false&tested=none\">tested + with CORS + without security</a></li> <li><a class=\"flink\" href=\"#?cors=false&cors=none&security=accessCode&security=none&tested=false&tested=none\">tested + with CORS + without accessCode flow</a></li> </ul> </li> </ul> </div> </div> <md-divider ng-show=\"!vm.loading && vm.count\" style=\"margin: 4px 0 2px 0\"></md-divider> <div ng-show=\"!vm.loading && vm.count\" layout=\"row\" class=\"app-optimized\" layout-wrap layout-padding style=\"margin-top: 2px\"> <div ng-repeat-start=\"api in vm.apisDelayed track by api.key\" ng-if=\"vm.group && api.first\" flex=\"100\"> <md-divider ng-if=\"!$first\" style=\"margin: 6px 3px 16px 3px\"></md-divider> <div class=\"md-headline\" style=\"margin-left: 18px; font-weight: 300\" ng-bind=\"api.info[\'x-providerName\']\"></div> </div> <div ng-repeat-end flex-xs=\"100\" flex-sm=\"50\" flex-md=\"33\" flex-lg=\"25\" flex-xl=\"20\" style=\"padding: 12px\"> <div> <div class=\"header\" ng-class=\"api.open ? \'md-whiteframe-6dp\' : \'md-whiteframe-2dp\'\" ng-style=\"{margin: api.open ? \'0 -2px\' : 0}\" style=\"transition: all linear 0.1s; position: relative\"> <a ng-href=\"{{::api.ui}}\" style=\"background-color: #fff; display: block; text-decoration: none\"> <md-toolbar class=\"md-accent md-hue-1\" style=\"height: auto; max-height: none; min-height: 80px\" ng-style=\"::api.style\"> <div layout=\"row\" layout-padding layout-align=\"start start\" style=\"height: auto; max-height: none; min-height: 64px; padding-bottom: 4px; padding-top: 4px\"> <span class=\"md-title\" flex ng-bind=\"::api.info.title\" style=\"line-height: 28px\"></span> <div layout=\"column\" layout-align=\"start end\" style=\"line-height: 28px; text-align:right; opacity: 0.8\"> <small ng-bind=\"::api.info[\'x-providerName\']\"></small> <small ng-bind=\"::api.info[\'x-serviceName\']\" ng-if=\"::api.info[\'x-serviceName\']\"></small> </div> </div> </md-toolbar> </a> <md-divider></md-divider> <div class=\"tools\" layout=\"row\"> <md-button class=\"md-primary\" ng-href=\"{{::api.ui}}\"> Open </md-button> <md-button class=\"md-primary\" ng-href=\"{{::api.view}}\"> View </md-button> <span flex></span> <md-button ng-click=\"api.open = !api.open\" aria-label=\"toggle\"> <md-icon ng-bind=\"api.open ? \'keyboard_arrow_up\' : \'keyboard_arrow_down\'\"></md-icon> </md-button> </div> </div> <div ng-show=\"api.open\" class=\"show-hide bg\" ng-class=\"api.open ? \'md-whiteframe-1dp\' : \'\'\"> <div layout=\"column\" layout-padding class=\"info\"> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Added</div> <div class=\"md-body-2\" ng-bind=\"::api.added | date\"></div> </div> <md-divider></md-divider> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Updated</div> <div class=\"md-body-2\" ng-bind=\"::api.updated | date\"></div> </div> <md-divider></md-divider> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Version</div> <div class=\"md-body-2\" ng-bind=\"::api.info.version\"></div> </div> <md-divider></md-divider> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Operations</div> <div class=\"md-body-2\" ng-bind=\"::api.meta.operations\"></div> </div> <md-divider></md-divider> <div ng-if=\"::(api.meta.security && api.meta.security.length)\" layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Security</div> <div class=\"md-body-2\" ng-bind=\"::api.meta.security\"></div> </div> <md-divider ng-if=\"::(api.meta.security && api.meta.security.length)\"></md-divider> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">CORS</div> <div class=\"md-body-2\" ng-if=\"::(api.meta.cors === true)\">enabled <md-icon>verified_user</md-icon> </div> <div class=\"md-body-2\" ng-if=\"::(api.meta.cors === false)\">disabled <md-icon>security</md-icon> </div> <div class=\"md-body-2\" ng-if=\"::(api.meta.cors !== true && api.meta.cors !== false)\"> unknown <md-icon>close</md-icon> </div> </div> </div> </div> </div> </div> </div> </md-content> <md-content flex ng-show=\"vm.path && !vm.loading\" layout=\"column\" md-scroll-y> <div layout-gt-sm=\"row\" flex> <div flex=\"100\" flex-gt-sm=\"33\" flex-gt-lg=\"25\" layout=\"column\" style=\"min-width: 360px\"> <md-content md-scroll-y> <div md-whiteframe=\"4\" style=\"margin: 24px\"> <md-subheader class=\"md-accent md-no-sticky\">API</md-subheader> <md-tabs md-border-bottom md-dynamic-height class=\"md-hue-2\"> <md-tab label=\"Info\"> <div layout=\"column\" layout-padding class=\"info\" style=\"padding: 16px\"> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Id</div> <div class=\"md-body-2\" ng-bind=\"vm.path\"></div> </div> <md-divider></md-divider> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Added</div> <div class=\"md-body-2\" ng-bind=\"vm.api.added | date\"></div> </div> <md-divider></md-divider> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Prefered Version</div> <div class=\"md-body-2\" ng-bind=\"vm.api.preferred\"></div> </div> </div> </md-tab> <md-tab label=\"Raw\"> <div class=\"md-padding\"> <pre style=\"margin: 12px\">{{vm.raw | json}}</pre> </div> </md-tab> </md-tabs> </div> <div flex layout=\"column\"> <div md-whiteframe=\"4\" style=\"margin: 0 24px 24px 24px\"> <md-subheader class=\"md-accent md-no-sticky\">Versions</md-subheader> <div style=\"padding-top: 0\" flex> <md-tabs md-dynamic-height md-border-bottom md-selected=\"vm.selectedVersion\" class=\"md-hue-2 no-transform\"> <md-tab ng-repeat=\"k in vm.versions track by $index\" label=\"{{k}}\"> <div layout=\"column\" layout-padding class=\"info\" style=\"padding: 16px 16px\"> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Added</div> <div class=\"md-body-2\" ng-bind=\"vm.api.versions[k].added | date\"></div> </div> <md-divider></md-divider> <div layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Updated</div> <div class=\"md-body-2\" ng-bind=\"vm.api.versions[k].updated | date\"></div> </div> <md-divider ng-if=\"vm.api.versions[k].info[\'x-unofficialSpec\']\"></md-divider> <div ng-if=\"vm.api.versions[k].info[\'x-unofficialSpec\']\" layout=\"row\" layout-align=\"space-between\"> <div class=\"md-body-1\">Unofficial specification</div> <div class=\"md-body-2\" ng-bind=\"vm.api.versions[k].info[\'x-unofficialSpec\']\"></div> </div> <md-divider ng-repeat-start=\"m in vm.meta\" ng-if=\"m[2]\"></md-divider> <div ng-repeat-end layout=\"row\" layout-align=\"space-between\" ng-if=\"m[2]\"> <div class=\"md-body-1\" style=\"white-space: nowrap; margin-right: 24px\"> <md-icon ng-bind=\"m[1]\" style=\"margin-right: 6px\"></md-icon> <span ng-if=\"m[0]\" ng-bind=\"m[0]\">Contact</span> </div> <div ng-if=\"m[0] && !m[3]\" ng-bind=\"m[2]\" class=\"md-body-2\"></div> <div ng-if=\"(m[0] !== \'Validation\') && m[3]\" class=\"md-body-1\" style=\"text-align: right; word-break: break-all\"> <a ng-bind=\"m[2]\" ng-href=\"{{m[3]}}\" ng-click=\"m[4]($event, m[2])\" target=\"_blank\"></a> </div> <div ng-if=\"m[0] === \'Validation\'\"> <a style=\"margin-top: -6px; display: inline-flex; height: 30px\" target=\"_blank\" ng-href=\"{{m[2]}}\"> <img ng-src=\"{{m[3]}}\" style=\"width: 97px; height: 30px\"/> </a> </div> </div> </div> </md-tab> </md-tabs> </div> </div> </div> </md-content> </div> <div flex-gt-sm layout=\"column\" layout-align=\"start stretch\"> <div> <div layout=\"row\" class=\"short-buttons\" style=\"margin-top: 24px\" layout-align=\"space-between start\"> <div flex=\"nogrow\"> <md-subheader class=\"md-accent md-no-sticky\">Version {{vm.versions[vm.selectedVersion]}} </md-subheader> </div> <div layout=\"column\" layout-gt-sm=\"row\" layout-no-wrap-gt-sm layout-align=\"end start\"> <div style=\"height: 46px\"> <md-button class=\"md-primary md-hue-2\" target=\"_blank\" ng-href=\"{{vm.curent.swaggerYamlUrl}}\"> YAML </md-button> </div> <div style=\"height: 46px\"> <md-button class=\"md-primary md-hue-2\" target=\"_blank\" ng-href=\"{{vm.curent.swaggerUrl}}\"> JSON </md-button> </div> <div style=\"height: 46px\"> <md-button class=\"md-primary md-hue-2\" target=\"_blank\" ng-href=\"{{vm.gitHubLink}}\"> GitHub </md-button> </div> <div style=\"height: 46px\" ng-if=\"vm.diffLink\"> <md-button class=\"md-accent\" target=\"_blank\" ng-href=\"{{vm.diffLink}}\"> Diff </md-button> </div> <div style=\"height: 46px\"> <md-button class=\"md-accent\" target=\"_blank\" ng-href=\"http://editor.swagger.io/#/?import={{vm.curent.swaggerUrl}}\"> Edit </md-button> </div> <div style=\"height: 46px\"> <md-button class=\"md-accent\" target=\"_blank\" ng-href=\"http://petstore.swagger.io/?url={{vm.curent.swaggerUrl}}\"> UI </md-button> </div> <div style=\"height:46px; margin-right: 18px\"> <md-button class=\"md-accent\" target=\"_blank\" ng-href=\"../#?url={{vm.curent.swaggerUrl}}\"> Open </md-button> </div> </div> </div> <div> <md-tabs md-selected=\"vm.selectedTab\" md-dynamic-height md-border-bottom class=\"md-hue-2\"> <md-tab label=\"Description\"> <div class=\"md-padding md\" flex ng-bind-html=\"vm.curent.info.description\"></div> </md-tab> <md-tab label=\"Logo\" ng-disabled=\"!vm.curent.info[\'x-logo\']\"> <img ng-src=\"{{vm.curent.info[\'x-logo\'].url}}\" ng-style=\"{\'background-color\': vm.curent.info[\'x-logo\'].backgroundColor}\" style=\"padding: 6px; margin: 24px; max-width: calc(100% - 48px)\" alt=\"logo\"> </md-tab> <md-tab label=\"Raw\"></md-tab> <md-tab label=\"YAML\"></md-tab> <md-tab label=\"JSON\"></md-tab> </md-tabs> </div> </div> <div flex layout=\"row\"> <div ng-if=\"vm.selectedTab === 2\" class=\"md-padding pre\" flex ng-bind=\"vm.curent | json\"></div> <div ng-if=\"vm.selectedTab === 3\" class=\"md-padding pre\" flex ng-bind=\"vm.yaml\"></div> <div ng-if=\"vm.selectedTab === 4\" class=\"md-padding pre\" flex ng-bind=\"vm.json | json\"></div> </div> </div> </div> </md-content> </div> <md-sidenav md-is-open=\"vm.sidenav\" class=\"md-sidenav-right\" layout=\"column\"> <md-toolbar md-whiteframe=\"2\" class=\"md-primary md-hue-3\"> <div class=\"md-toolbar-tools\"> <span>Filters</span> <span flex></span> <md-button ng-click=\"vm.sidenav = !vm.sidenav\" class=\"md-icon-button\"> <md-icon>close</md-icon> </md-button> </div> </md-toolbar> <md-content md-scroll-y flex> <md-list> <md-subheader class=\"md-accent md-no-sticky\">CORS</md-subheader> <md-list-item aria-label=\"switch\" ng-if=\"vm.filter.cors.true\" ng-click=\"vm.filter.cors.true.show = !vm.filter.cors.true.show\"> <md-icon>verified_user</md-icon> <p><span>enabled</span> <badge ng-bind=\"::vm.filter.cors.true.count\"></badge> </p> <md-switch class=\"md-secondary md-primary\" ng-model=\"vm.filter.cors.true.show\"></md-switch> </md-list-item> <md-list-item aria-label=\"switch\" ng-if=\"vm.filter.cors.false\" ng-click=\"vm.filter.cors.false.show = !vm.filter.cors.false.show\"> <md-icon>security</md-icon> <p><span>disabled</span> <badge ng-bind=\"::vm.filter.cors.false.count\"></badge> </p> <md-switch class=\"md-secondary md-primary\" ng-model=\"vm.filter.cors.false.show\"></md-switch> </md-list-item> <md-list-item aria-label=\"switch\" ng-if=\"vm.filter.cors.none\" ng-click=\"vm.filter.cors.none.show = !vm.filter.cors.none.show\"> <md-icon>close</md-icon> <p><span>unknown</span> <badge ng-bind=\"::vm.filter.cors.none.count\"></badge> </p> <md-switch class=\"md-secondary md-primary\" ng-model=\"vm.filter.cors.none.show\"></md-switch> </md-list-item> <md-divider></md-divider> <md-subheader class=\"md-accent md-no-sticky\">Security</md-subheader> <md-list-item aria-label=\"switch\" ng-repeat=\"v in vm.filterArray.security\" ng-click=\"v.show = !v.show; $event.preventDefault()\"> <p><span ng-bind=\"v.name\"></span> <badge ng-bind=\"::v.count\"></badge> </p> <md-switch class=\"md-secondary md-primary\" ng-model=\"v.show\" aria-label=\"switch\"></md-switch> </md-list-item> <md-divider></md-divider> <md-subheader class=\"md-accent md-no-sticky\">Tested</md-subheader> <md-list-item aria-label=\"switch\" ng-repeat=\"v in vm.filterArray.tested\" ng-click=\"v.show = !v.show; $event.preventDefault()\"> <p><span ng-bind=\"v.name\"></span> <badge ng-bind=\"::v.count\"></badge> </p> <md-switch class=\"md-secondary md-primary\" ng-model=\"v.show\" aria-label=\"switch\"></md-switch> </md-list-item> <md-divider></md-divider> <div layout=\"row\" layout-align=\"end\" layout-padding> <md-button ng-click=\"vm.reset()\">Reset Filters</md-button> </div> </md-list> </md-content> </md-sidenav> <script src=\"//ajax.googleapis.com/ajax/libs/angularjs/1.5.0/angular.min.js\"></script> <script src=\"//ajax.googleapis.com/ajax/libs/angularjs/1.5.0/angular-animate.min.js\"></script> <script src=\"//ajax.googleapis.com/ajax/libs/angularjs/1.5.0/angular-aria.min.js\"></script> <script src=\"//ajax.googleapis.com/ajax/libs/angularjs/1.5.0/angular-sanitize.min.js\"></script> <script src=\"//ajax.googleapis.com/ajax/libs/angular_material/1.0.5/angular-material.min.js\"></script> <script type=\"text/javascript\">\'use strict\';\r\n\r\n    angular.module(\'hub\', [\'ngMaterial\', \'ngSanitize\'])\r\n        .config(function ($mdThemingProvider, $logProvider, $windowProvider) {\r\n            $mdThemingProvider\r\n                .theme(\'default\')\r\n                .primaryPalette(\'grey\')\r\n                .accentPalette(\'indigo\')\r\n                .warnPalette(\'amber\');\r\n\r\n            var $window = $windowProvider.$get();\r\n\r\n            if ($window.location.hostname !== \'localhost\') {\r\n                $logProvider.debugEnabled(false);\r\n            }\r\n\r\n            /*if (\'scrollRestoration\' in $window.history) {\r\n             $window.history.scrollRestoration = \'manual\';\r\n             }*/\r\n        })\r\n        // from http://embed.plnkr.co/CaZAVeC90qxQP1E4Z5Fb/preview\r\n        .factory(\'HubCache\', function ($cacheFactory, $window) {\r\n            var cache = $cacheFactory(\'someCache\', {});\r\n            var PREFIX = \'swaggerHub:\';\r\n            var storage = $window.sessionStorage;\r\n\r\n            cache.get = function (key) {\r\n                var lruEntry = storage.getItem(PREFIX + key);\r\n\r\n                if (!lruEntry) {\r\n                    return;\r\n                }\r\n\r\n                lruEntry = JSON.parse(lruEntry);\r\n\r\n                return lruEntry.data;\r\n            };\r\n\r\n            cache.put = function (key, value) {\r\n                if (angular.isFunction(value.then)) {\r\n                    value.then(function (value) {\r\n                        storage.setItem(PREFIX + key, JSON.stringify(value));\r\n                    });\r\n                } else {\r\n                    storage.setItem(PREFIX + key, JSON.stringify(value));\r\n                }\r\n            };\r\n\r\n            return cache;\r\n        })\r\n        .directive(\'toolbarSearch\', function ($timeout) {\r\n            return {\r\n                restrict: \'E\',\r\n                templateUrl: \'toolbar-search.html\',\r\n                scope: {\r\n                    ngModel: \'=\',\r\n                    ngChanged: \'=?\',\r\n                    open: \'=?\'\r\n                },\r\n                link: function (scope, element) {\r\n                    $timeout(function () {\r\n                        scope.init = true;\r\n                    }, 200);\r\n\r\n                    scope.focus = function () {\r\n                        $timeout(function () {\r\n                            element.children()[1].focus();\r\n                        }, 200);\r\n                    };\r\n\r\n                    scope.$watch(\'ngModel\', function () {\r\n                        if (scope.ngModel) {\r\n                            scope.open = true;\r\n                        }\r\n                    });\r\n                }\r\n            };\r\n        })\r\n        .factory(\'Data\', function (HubCache, $q, $log, $http, $timeout) {\r\n            var deferred = $q.defer();\r\n            var self = {\r\n                promise: deferred.promise,\r\n                apis: [],\r\n                list: {},\r\n                details: {},\r\n                colors: {}\r\n            };\r\n\r\n            var data = deferPromise(loadData);\r\n            var list = deferPromise(loadList);\r\n\r\n            list.then(processList);\r\n\r\n            return self;\r\n\r\n            function loadData () {\r\n                return $http({\r\n                    method: \'GET\',\r\n                    url: \'hub.json\',\r\n                    cache: HubCache\r\n                });\r\n            }\r\n\r\n            function loadList () {\r\n                return $http({\r\n                    method: \'GET\',\r\n                    url: \'https://apis-guru.github.io/api-models/api/v1/list.json\',\r\n                    cache: HubCache\r\n                });\r\n            }\r\n\r\n            function processList (response) {\r\n                $log.debug(\'hub:processList\');\r\n\r\n                angular.extend(self.list, response.data);\r\n\r\n                angular.forEach(response.data, function (v, k) {\r\n                    var preferred = angular.copy(v.versions[v.preferred]);\r\n\r\n                    preferred.key = k;\r\n                    preferred.info.title = preferred.info.title.replace(/([^A-Z])([A-Z])/, \'$1\\u200b$2\');\r\n                    preferred.ui = \'../#?url=\' + preferred.swaggerUrl;\r\n                    preferred.updatedValue = (new Date(preferred.updated)).getTime();\r\n                    preferred.addedValue = (new Date(preferred.added)).getTime();\r\n                    preferred.info.titleLowerCase = preferred.info.title.toLowerCase();\r\n                    preferred.keyLowerCase = preferred.key.toLowerCase();\r\n                    preferred.view = \'#\' + preferred.key;\r\n\r\n                    self.details[k] = preferred;\r\n\r\n                    self.apis.push(preferred);\r\n                });\r\n\r\n                self.apis.sort(function (a, b) {\r\n                    return (a.key).localeCompare(b.key);\r\n                });\r\n\r\n                data.then(processData);\r\n            }\r\n\r\n            function processData (response) {\r\n                $log.debug(\'hub:processData\');\r\n\r\n                angular.forEach(self.apis, function (api) {\r\n                    var meta = response.data[api.key];\r\n\r\n                    api.meta = meta = meta || {};\r\n\r\n                    if (!meta.colors || !meta.colors.length) {\r\n                        meta.colors = [[223, 223, 223], [223, 223, 223], [255, 255, 255]];\r\n                    } else if (meta.colors.length === 1) {\r\n                        meta.colors.push([255, 255, 255]);\r\n                    }\r\n\r\n                    var rgb = [];\r\n\r\n                    angular.forEach(meta.colors, function (c) {\r\n                        c[3] = 0.222;\r\n                        rgb.push(\'rgba(\' + c.join(\',\') + \')\');\r\n                    });\r\n\r\n                    api.gradientLight = \'linear-gradient(135deg, \' + rgb.join(\',\') + \')\';\r\n                    api.style = {background: api.gradientLight};\r\n                    self.colors[api.key] = api.style;\r\n                });\r\n\r\n                deferred.resolve();\r\n            }\r\n\r\n            function deferPromise (fnc, time) {\r\n                var deferred = $q.defer();\r\n\r\n                $timeout(function () {\r\n                    fnc().then(function (val) {\r\n                        deferred.resolve(val);\r\n                    });\r\n                }, time);\r\n\r\n                return deferred.promise;\r\n            }\r\n        })\r\n        .controller(\'HubCtrl\', function ($scope, $http, $timeout, $location, $q, $log, $window, $document, Data) {\r\n            var vm = this;\r\n\r\n            vm.loading = true;\r\n            vm.updating = false;\r\n            vm.count = 0;\r\n            vm.sortBy = -1;\r\n            vm.path = \'\';\r\n            vm.group = false;\r\n            vm.api = null;\r\n            vm.apiStyle = null;\r\n            vm.prefered = null;\r\n            vm.curent = null;\r\n            vm.selectedVersion = null;\r\n            vm.detail = null;\r\n            vm.meta = [];\r\n            vm.apis = Data.apis;\r\n            vm.apisFiltered = [];\r\n            vm.apisDelayed = [];\r\n            vm.filterArray = {};\r\n            vm.filter = {\r\n                search: \'\'\r\n            };\r\n\r\n            vm.toggle = defer(toggle, 100);\r\n            vm.sort = defer(sort, 100);\r\n            vm.reset = defer(reset, 100);\r\n            vm.back = back;\r\n\r\n            var unregister;\r\n            var visits = 0;\r\n\r\n            $scope.$on(\'$locationChangeSuccess\', locationUpdated);\r\n            $scope.$watch(function () {\r\n                return vm.selectedVersion;\r\n            }, versionUpdated);\r\n            $scope.$watch(\'vm.group\', defer(groupUpdate, 25));\r\n\r\n            Data.promise.then(function () {\r\n                buildFilters();\r\n                locationUpdated();\r\n                update();\r\n                sort(vm.sortBy);\r\n                vm.loading = false;\r\n                register();\r\n            });\r\n\r\n            function back () {\r\n                if ($document[0].referer || ($window.history.length <= 1) || (visits <= 1)) {\r\n                    $location.path(\'\');\r\n                } else {\r\n                    $window.history.back();\r\n                }\r\n            }\r\n\r\n            function register () {\r\n                unregister = $scope.$watch(\'vm.filter\', defer(safeUpdate, 25), true);\r\n            }\r\n\r\n            function locationUpdated (n) {\r\n                if (n) {\r\n                    visits++;\r\n                }\r\n\r\n                vm.path = $location.path().replace(/^\\//, \'\');\r\n\r\n                $log.debug(\'hub:locationUpdated:visits\', visits);\r\n                $log.debug(\'hub:locationUpdated\', vm.path);\r\n\r\n                var s = $location.search();\r\n\r\n                if (!vm.path) {\r\n                    vm.filter.search = s.search || \'\';\r\n                    vm.group = s.group || false;\r\n                    deserializeFilter(vm.filter.security, s.security);\r\n                    deserializeFilter(vm.filter.cors, s.cors);\r\n                    deserializeFilter(vm.filter.tested, s.tested);\r\n\r\n                    if (unregister) {\r\n                        unregister();\r\n                        register();\r\n                        vm.updating = true;\r\n                        $timeout(function () {\r\n                            Data.promise.then(update);\r\n                        });\r\n                    }\r\n\r\n                    sort(parseInt(s.order || 0));\r\n\r\n                    vm.api = null;\r\n                    vm.prefered = null;\r\n                    vm.apiStyle = null;\r\n                    vm.detail = null;\r\n                    vm.versions = null;\r\n                    vm.selectedVersion = null;\r\n                } else {\r\n                    Data.promise.then(function () {\r\n                        vm.api = Data.list[vm.path];\r\n                        vm.prefered = vm.api.versions[vm.api.preferred];\r\n                        vm.apiStyle = Data.colors[vm.path];\r\n                        vm.detail = Data.details[vm.path];\r\n                        vm.raw = angular.copy(vm.api);\r\n                        delete vm.raw.versions;\r\n\r\n                        vm.versions = [];\r\n\r\n                        angular.forEach(vm.api.versions, function (v, k) {\r\n                            vm.versions.push(k);\r\n                        });\r\n\r\n                        vm.versions.reverse();\r\n\r\n                        vm.selectedVersion = vm.versions.indexOf(vm.api.preferred);\r\n\r\n                        versionUpdated();\r\n                    });\r\n                }\r\n\r\n                $log.debug(\'hub:locationUpdated:end\');\r\n            }\r\n\r\n            function deserializeFilter (f, s) {\r\n                angular.forEach(f, function (i) {\r\n                    i.show = (s || []).indexOf(i.name) === -1;\r\n                });\r\n            }\r\n\r\n            function buildFilters () {\r\n                vm.filter.security = buildFilter(function (api) {\r\n                    return api.meta.security;\r\n                }, []);\r\n\r\n                vm.filterArray.security = filterArray(vm.filter.security);\r\n\r\n                vm.filter.tested = buildFilter(function (api) {\r\n                    return api.meta.tested;\r\n                });\r\n\r\n                vm.filterArray.tested = filterArray(vm.filter.tested);\r\n\r\n                vm.filter.cors = buildFilter(function (api) {\r\n                    return api.meta.cors;\r\n                });\r\n\r\n                vm.filterArray.cors = filterArray(vm.filter.cors);\r\n            }\r\n\r\n            function safeUpdate (n, o) {\r\n                $log.debug(\'hub:safe\', n, o);\r\n\r\n                if (angular.toJson(n) === angular.toJson(o)) {\r\n                    return;\r\n                }\r\n\r\n                $log.debug(\'hub:safeUpdate\');\r\n\r\n                vm.updating = true;\r\n\r\n                $timeout(function () {\r\n                    Data.promise.then(update);\r\n                });\r\n            }\r\n\r\n            function update () {\r\n                $log.debug(\'hub:update\');\r\n\r\n                var search = vm.filter.search || \'\';\r\n                var negative = search.length && (search[0] === \'!\');\r\n                search = negative ? search.substring(1) : search;\r\n                search = search.toLowerCase();\r\n\r\n                vm.apisFiltered = [];\r\n                vm.apisDelayed = [];\r\n                vm.count = 0;\r\n\r\n                angular.forEach(vm.apis, function (a) {\r\n                    var m = a.meta || {};\r\n                    a.hide = false;\r\n\r\n                    if ((m.cors === true) && !vm.filter.cors.true.show) {\r\n                        a.hide = true;\r\n                    } else if ((m.cors === false) && !vm.filter.cors.false.show) {\r\n                        a.hide = true;\r\n                    } else if (((m.cors !== true) && (m.cors !== false)) && !vm.filter.cors.none.show) {\r\n                        a.hide = true;\r\n                    }\r\n\r\n                    a.hide = a.hide ? true : !(isShown(m.security, vm.filter.security, []) && isShown(m.tested, vm.filter.tested));\r\n\r\n                    if (search && !negative) {\r\n                        if ((a.info.titleLowerCase.indexOf(search) === -1) &&\r\n                            (a.keyLowerCase.indexOf(search) === -1)) {\r\n                            a.hide = true;\r\n                        }\r\n                    } else if (search && negative) {\r\n                        if ((a.info.titleLowerCase.indexOf(search) > -1) ||\r\n                            (a.keyLowerCase.indexOf(search) > -1)) {\r\n                            a.hide = true;\r\n                        }\r\n                    }\r\n\r\n                    vm.count += !a.hide;\r\n\r\n                    if (!a.hide) {\r\n                        vm.apisFiltered.push(a);\r\n                    }\r\n                });\r\n\r\n                sort(parseInt($location.search().order || 0));\r\n                group();\r\n\r\n                $location.search(\'search\', vm.filter.search || null);\r\n                $location.search(\'security\', serializeFilter(vm.filterArray.security));\r\n                $location.search(\'cors\', serializeFilter(vm.filterArray.cors));\r\n                $location.search(\'tested\', serializeFilter(vm.filterArray.tested));\r\n\r\n                vm.updating = false;\r\n\r\n                addDelayed();\r\n\r\n                $log.debug(\'hub:updated\');\r\n            }\r\n\r\n            function addDelayed () {\r\n                var i = 0;\r\n                var limit = 10;\r\n\r\n                if (!vm.apisDelayed.length) {\r\n                    limit = 25;\r\n                }\r\n\r\n                while (vm.apisDelayed.length < vm.apisFiltered.length && i < limit) {\r\n                    vm.apisDelayed.push(vm.apisFiltered[vm.apisDelayed.length]);\r\n                    i++;\r\n                }\r\n\r\n                if (vm.apisDelayed.length < vm.apisFiltered.length) {\r\n                    $timeout(addDelayed, 5);\r\n                }\r\n            }\r\n\r\n            function serializeFilter (f) {\r\n                return f.filter(function (i) {\r\n                    return !i.show;\r\n                }).map(function (i) {\r\n                    return i.name;\r\n                });\r\n            }\r\n\r\n            function isShown (value, filter, type) {\r\n                var show = false;\r\n\r\n                var val = value || type;\r\n\r\n                angular.forEach(filter, function (v, k) {\r\n                    if (angular.isArray(type)) {\r\n                        if (v.show && (k === \'none\') && !val.length) {\r\n                            show = true;\r\n                        } else if (v.show && (val.indexOf(k) > -1)) {\r\n                            show = true;\r\n                        }\r\n                    } else {\r\n                        if (v.show && (k === \'none\') && angular.isUndefined(val)) {\r\n                            show = true;\r\n                        } else if (v.show && !angular.isUndefined(val) && (val.toString() === k)) {\r\n                            show = true;\r\n                        }\r\n                    }\r\n                });\r\n\r\n                return show;\r\n            }\r\n\r\n            function sort (by) {\r\n                if ((by === vm.sortBy) || !vm.apis.length) {\r\n                    return\r\n                }\r\n\r\n                $log.debug(\'hub:sort\', by);\r\n\r\n                vm.sortBy = by;\r\n\r\n                var sorters = [\r\n                    function (a, b) {\r\n                        return a.key.localeCompare(b.key);\r\n                    },\r\n                    function (a, b) {\r\n                        return a.info.title.localeCompare(b.info.title);\r\n                    },\r\n                    function (a, b) {\r\n                        return b.updatedValue - a.updatedValue;\r\n                    },\r\n                    function (a, b) {\r\n                        return b.addedValue - a.addedValue;\r\n                    },\r\n                    function (a, b) {\r\n                        return (a.meta.operations || 0) - (b.meta.operations || 0);\r\n                    }\r\n                ];\r\n\r\n                vm.apis.sort(sorters[vm.sortBy]);\r\n                vm.apisFiltered.sort(sorters[vm.sortBy]);\r\n                vm.apisDelayed.sort(sorters[vm.sortBy]);\r\n\r\n                $location.search(\'order\', vm.sortBy || null);\r\n            }\r\n\r\n            function group () {\r\n                $log.debug(\'hub:group\');\r\n\r\n                var previous = null;\r\n\r\n                angular.forEach(vm.apisFiltered, function (api) {\r\n                    if (api.info[\'x-providerName\'] !== previous) {\r\n                        previous = api.info[\'x-providerName\'];\r\n                        api.first = true;\r\n                    } else {\r\n                        api.first = false;\r\n                    }\r\n                });\r\n            }\r\n\r\n            function buildFilter (member, type) {\r\n                var stat = {};\r\n\r\n                angular.forEach(vm.apis, function (api) {\r\n                    var m = member(api);\r\n\r\n                    m = angular.isUndefined(m) ? type : m;\r\n\r\n                    if (angular.isArray(type)) {\r\n                        if (!m.length) {\r\n                            stat[\'none\'] = (stat[\'none\'] || 0) + 1;\r\n                        }\r\n\r\n                        angular.forEach(m, function (sec) {\r\n                            stat[sec] = stat[sec] || 0;\r\n                            stat[sec]++;\r\n                        });\r\n                    } else {\r\n                        var sec = (m === true || m === false) ? m.toString() : \'none\';\r\n\r\n                        stat[sec] = stat[sec] || 0;\r\n                        stat[sec]++;\r\n                    }\r\n                });\r\n\r\n                angular.forEach(stat, function (v, k) {\r\n                    stat[k] = {\r\n                        count: v,\r\n                        show: true\r\n                    };\r\n                });\r\n\r\n                return stat;\r\n            }\r\n\r\n            function filterArray (obj) {\r\n                var arr = [];\r\n\r\n                angular.forEach(obj, function (v, k) {\r\n                    v.name = k;\r\n                    arr.push(v);\r\n                });\r\n\r\n                arr.sort(function (a, b) {\r\n                    return a.name.localeCompare(b.name);\r\n                });\r\n\r\n                return arr;\r\n            }\r\n\r\n            function reset () {\r\n                angular.forEach(vm.filter, function (f) {\r\n                    if (angular.isObject(f)) {\r\n                        angular.forEach(f, function (i) {\r\n                            i.show = true;\r\n                        });\r\n                    }\r\n                });\r\n            }\r\n\r\n            function toggle (open) {\r\n                angular.forEach(vm.apis, function (api) {\r\n                    if (!api.hide) {\r\n                        api.open = open;\r\n                    }\r\n                });\r\n            }\r\n\r\n            function defer (fnc, time) {\r\n                return function () {\r\n                    var args = arguments;\r\n\r\n                    $timeout(function () {\r\n                        fnc.apply(this, args);\r\n                    }, time);\r\n                }\r\n            }\r\n\r\n            function gitHubLink () {\r\n                if (!vm.api) {\r\n                    return;\r\n                }\r\n\r\n                var i = vm.curent.info;\r\n\r\n                return \'https://github.com/APIs-guru/api-models/tree/master/APIs/\' +\r\n                    i[\'x-providerName\'] + \'/\' +\r\n                    (i[\'x-serviceName\'] ? (i[\'x-serviceName\']) + \'/\' : \'\' ) +\r\n                    vm.versions[vm.selectedVersion] + \'/\';\r\n\r\n            }\r\n\r\n            function diffLink () {\r\n                if (vm.curent === vm.prefered || vm.versions.length < 2) {\r\n                    return;\r\n                }\r\n\r\n                return \'https://zallek.github.io/swagger-diff/?\' +\r\n                    \'oldSpecUrl=\' + vm.curent.swaggerUrl +\r\n                    \'&\' +\r\n                    \'newSpecUrl=\' + vm.prefered.swaggerUrl;\r\n            }\r\n\r\n            function meta () {\r\n                var v = vm.api && vm.curent;\r\n\r\n                if (!v) {\r\n                    return;\r\n                }\r\n\r\n                var validatorUrl = \'http://online.swagger.io/validator\';\r\n                var i = v.info;\r\n                i.contact = i.contact || {};\r\n                var validatorDebug = (validatorUrl && v.swaggerUrl) ? (validatorUrl + \'/debug?url=\' + v.swaggerUrl) : null;\r\n                var validatorBadge = validatorUrl + \'?url=\' + v.swaggerUrl;\r\n\r\n                return [\r\n                    [\'Contact\', \'person\', (i.contact.name && !i.contact.email) ? i.contact.name : null, null],\r\n                    [\'Email\', \'email\', i.contact.email ? (i.contact.name || i.contact.email) : null, \'mailto:\' + i.contact.email + \'?subject=\' + i.title],\r\n                    [\'Client registration\', \'assignment_ind\', i[\'x-apiClientRegistration\'] && i[\'x-apiClientRegistration\'].url, i[\'x-apiClientRegistration\'] && i[\'x-apiClientRegistration\'].url],\r\n                    [\'Documentation\', \'help_outline\', v.externalDocs && (v.externalDocs.description || v.externalDocs.url), v.externalDocs && v.externalDocs.url],\r\n                    [\'Origin\', \'cloud_download\', i[\'x-origin\'] && i[\'x-origin\'].url, i[\'x-origin\'] && i[\'x-origin\'].url],\r\n                    [\'Validation\', \'code\', validatorDebug, validatorBadge]\r\n                ];\r\n            }\r\n\r\n            function versionUpdated () {\r\n                $log.debug(\'hub:version:start\');\r\n\r\n                Data.promise.then(function () {\r\n                    if (!vm.api) {\r\n                        return;\r\n                    }\r\n\r\n\r\n                    vm.curent = vm.api.versions[vm.versions[vm.selectedVersion]];\r\n                    vm.gitHubLink = gitHubLink();\r\n                    vm.diffLink = diffLink();\r\n                    vm.meta = meta();\r\n                    vm.json = null;\r\n                    vm.yaml = null;\r\n\r\n                    $http.get(vm.curent.swaggerUrl).then(function (response) {\r\n                        vm.json = response.data;\r\n                    });\r\n\r\n                    $http.get(vm.curent.swaggerYamlUrl).then(function (response) {\r\n                        vm.yaml = response.data;\r\n                    });\r\n                });\r\n            }\r\n\r\n            function groupUpdate () {\r\n                $location.search(\'group\', vm.group || null);\r\n            }\r\n        })\r\n    ;</script> <script type=\"text/ng-template\" id=\"toolbar-search.html\"><md-button ng-click=\"open = true; focus()\" class=\"md-icon-button\">\r\n        <md-icon>search</md-icon>\r\n    </md-button>\r\n    <input ng-show=\"open\" ng-model=\"ngModel\" type=\"text\" class=\"md-input\" ng-class=\"{\'input-show-hide\': init}\"\r\n           ng-model-options=\"{debounce: {default: 200, blur: 0}}\"/>\r\n    <md-button ng-show=\"open\" ng-click=\"ngModel = \'\'; open = false\" class=\"md-icon-button\"\r\n               ng-class=\"{\'input-show-hide\': init}\">\r\n        <md-icon>close</md-icon>\r\n    </md-button></script> </body> </html>");
$templateCache.put("views/app.layout.html","<div flex layout=\"column\"> <div ng-include=\"\'modules/toolbar/toolbar.html\'\"></div> <md-content> <div layout-padding layout=\"column\" style=\"padding-bottom: 0\"> <div ng-if=\"!vm.data.loading && !vm.data.model.groups\">No API found.</div> <div ng-controller=\"DescriptionController as vm\"> <div ng-if=\"vm.description\" ng-bind-html=\"::vm.description\" class=\"markdown-body\"></div> </div> <div style=\"padding: 4px 4px 0 4px\" ng-include=\"\'modules/meta/meta.html\'\"></div> </div> <div ng-controller=\"ContentController as vm\"> <div ng-if=\"vm.data.ui.grouped\" layout=\"row\" layout-wrap layout-padding> <div flex-xs=\"100\" flex-sm=\"{{vm.data.ui.sidenavLocked ? 100 : 50}}\" flex-md=\"{{vm.data.ui.sidenavLocked ? 50 : 33}}\" flex-lg=\"{{vm.data.ui.sidenavLocked ? 33 : 25}}\" flex-xl=\"{{vm.data.ui.sidenavLocked ? 25 : 20}}\" ng-repeat=\"group in vm.data.model.groups track by $index\" ng-if=\"(group.operations | filter:vm.data.model.search:false).length\" style=\"padding: 12px\" ng-include=\"\'modules/group/group.html\'\"></div> </div> <div ng-if=\"!vm.data.ui.grouped\" layout=\"row\" layout-wrap layout-padding style=\"margin-top: 12px\"> <div flex-xs=\"100\" flex-sm=\"{{vm.data.ui.sidenavLocked ? 100 : 50}}\" flex-md=\"{{vm.data.ui.sidenavLocked ? 50 : 33}}\" flex-lg=\"{{vm.data.ui.sidenavLocked ? 33 : 25}}\" flex-xl=\"{{vm.data.ui.sidenavLocked ? 25 : 20}}\" ng-repeat=\"op in vm.data.model.operations | filter:vm.data.model.search:false track by op.id\" style=\"padding-top: 0; padding-bottom: 0\"> <div ng-class=\"{\'sum-selected\': vm.data.model.sop === op}\" ng-include=\"\'modules/operation/operation.html\'\"></div> </div> </div> </div> </md-content> </div> <md-sidenav layout=\"column\" class=\"md-sidenav-right md-whiteframe-z2\" md-is-open=\"vm.data.ui.sidenavOpen\" md-is-locked-open=\"vm.data.ui.sidenavLocked\"> <md-toolbar ng-if=\"vm.sop\" class=\"md-accent\" md-whiteframe=\"2\"> <div class=\"md-toolbar-tools\"> <span flex><span ng-repeat=\"t in vm.sop.tags\">{{t}}<span ng-if=\"!$last\">, </span></span></span> <md-button hide show-gt-xs ng-click=\"vm.data.ui.sidenavLocked = !vm.data.ui.sidenavLocked\" aria-label=\"toggle\" class=\"md-icon-button md-accent md-hue-3\"> <md-icon ng-bind=\"vm.data.ui.sidenavLocked ? \'chevron_right\' : \'chevron_left\'\"></md-icon> </md-button> </div> </md-toolbar> <div ng-if=\"vm.sop\"> <md-subheader class=\"md-warn md-no-sticky\" ng-if=\"vm.sop.deprecated\">Deprecated</md-subheader> <div layout-padding> <div ng-class=\"{\'sum-deprecated\': sop.deprecated}\" layout=\"row\" style=\"word-break: break-all\"> <md-button ng-class=\"vm.theme[vm.sop.httpMethod]\" ng-click=\"vm.utils.method(vm.sop.httpMethod, $event)\" aria-label=\"method\" class=\"sum-http-method md-raised\" ng-bind=\"vm.sop.httpMethod\"> </md-button> <span ng-bind=\"vm.sop.path\" class=\"sum-path-wrap\"></span> </div> <div ng-if=\"vm.sop.summary\" class=\"md-body-2 markdown-body\" ng-bind=\"vm.sop.summary\"></div> </div> </div> <md-tabs class=\"md-hue-2\" flex md-stretch-tabs=\"always\" md-selected=\"vm.sop.tab\" ng-class=\"{\'sum-slide-disabled\': vm.omg}\"> <md-tab label=\"Info\" layout=\"column\"> <div class=\"sum-fade\" ng-hide=\"vm.omg\" ng-include=\"\'modules/detail/request/request.html\'\"></div> </md-tab> <md-tab label=\"Scripts\" layout=\"column\"> <div class=\"sum-fade\" ng-hide=\"vm.omg\" ng-include=\"\'modules/detail/scripts/scripts.html\'\"></div> </md-tab> <md-tab class=\"sum-tab-result\" label=\"Result\" ng-disabled=\"!vm.sop.explorerResult\"> <div class=\"sum-fade\" ng-hide=\"vm.omg\" ng-show=\"vm.sop.explorerResult\" ng-include=\"\'modules/detail/result/result.html\'\"></div> </md-tab> </md-tabs> <div ng-if=\"!vm.sop\" layout-padding> <div>No endpoint method selected.</div> </div> <md-button class=\"md-fab md-fab-bottom-right md-primary md-raised\" ng-disabled=\"vm.sop.loading || !vm.ngForm.explorerForm.$valid\" ng-style=\"{padding: vm.sop.loading ? \'1px 0 0 0\' : null}\" ng-if=\"vm.sop && vm.data.ui.explorer\" ng-click=\"vm.submit(vm.sop)\" ng-class=\"(vm.sop.explorerResult.response.status === -1) ? \'md-warn\' : \'md-primary\'\" aria-label=\"submit\"> <md-icon ng-if=\"!vm.sop.loading\" ng-bind=\"vm.sop.explorerResult ? \'replay\' : \'play_arrow\'\"></md-icon> <md-progress-circular ng-if=\"vm.sop.loading\" md-diameter=\"56\" class=\"md-accent md-hue-1\" md-mode=\"indeterminate\"></md-progress-circular> </md-button> </md-sidenav>");
$templateCache.put("views/info.dialog.html","<md-dialog class=\"sum-dialog\" layout=\"column\"> <md-toolbar ng-class=\"vm.style\"> <div class=\"md-toolbar-tools\"> <h2><span class=\"md-title\" ng-bind=\"vm.title\"></span></h2> <span flex></span> <small style=\"padding-left: 16px; text-align: right\" ng-bind=\"vm.subtitle\"></small> </div> </md-toolbar> <div ng-if=\"vm.meta\" layout=\"row\" layout-padding layout-align=\"space-between start\"> <div class=\"md-body-2\" style=\"line-height: 24px\">Safe <md-icon ng-bind=\"vm.meta[0] ? \'check_box\' : \'check_box_outline_blank\'\"></md-icon> </div> <div class=\"md-body-2\" style=\"line-height: 24px\">Idempotent <md-icon ng-bind=\"vm.meta[1] ? \'check_box\' : \'check_box_outline_blank\'\"></md-icon> </div> <div class=\"md-body-2\" style=\"line-height: 24px\">Cacheable <md-icon ng-bind=\"vm.meta[2] ? \'check_box\' : \'check_box_outline_blank\'\"></md-icon> </div> </div> <md-divider ng-if=\"vm.meta\"></md-divider> <md-dialog-content ng-if=\"vm.header || vm.description\" class=\"md-dialog-content\"> <h3 ng-if=\"vm.header\" class=\"md-title\" ng-bind=\"vm.header\"></h3> <p ng-if=\"vm.description\" class=\"sum-sentence\" ng-bind=\"vm.description\"></p> </md-dialog-content> <md-dialog-actions> <md-button ng-if=\"vm.link\" ng-href=\"{{vm.link}}\" target=\"_blank\" class=\"md-primary\" ng-bind=\"vm.section\" aria-label=\"spec\"></md-button> <md-button ng-click=\"closeDialog()\">Close</md-button> </md-dialog-actions> </md-dialog>");
$templateCache.put("views/proxy.dialog.html","<md-dialog class=\"sum-dialog\" layout=\"column\"> <md-toolbar class=\"md-warn\"> <div class=\"md-toolbar-tools\"> <h2><span class=\"md-title\">Proxy</span></h2> </div> </md-toolbar> <md-dialog-content class=\"md-dialog-content\"> <p><md-icon style=\"line-height: 20px\">warning</md-icon> Use only proxies <b>you trust</b>!</p> <form ng-submit=\"closeDialog()\"> <div layout=\"column\"> <md-input-container class=\"sum-hide-spacer\"> <label>Proxy</label> <input type=\"text\" ng-model=\"vm.options.proxy\"> </md-input-container> </div> </form> </md-dialog-content> <md-dialog-actions> <md-button ng-click=\"closeDialog()\">Close</md-button> </md-dialog-actions> </md-dialog>");
$templateCache.put("views/security.dialog.html","<md-dialog class=\"sum-dialog-wide\" layout=\"column\"> <md-dialog-content ng-class=\"{\'sum-hide-tabs\': vm.singleSecurity}\" style=\"max-width: 800px; max-height: 810px\"> <md-toolbar ng-class=\"style\"> <div class=\"md-toolbar-tools\"> <h2><span class=\"md-title\">Security</span></h2> </div> </md-toolbar> <md-tabs md-no-pagination md-dynamic-height> <md-tab label=\"{{s.flow ? s.flow : s.type}}\" ng-repeat=\"(name, s) in vm.security\"> <div style=\"padding: 24px 24px 0 24px\"> <form ng-submit=\"closeDialog()\"> <h3 ng-if=\"s.type == \'apiKey\'\" class=\"md-title\" style=\"margin-top: 0\">API Key Authentication</h3> <div ng-if=\"s.type == \'apiKey\'\" layout=\"column\"> <p ng-if=\"s.description\" ng-bind-html=\"s.description\" class=\"markdown-body sum-short-md\"></p> <md-input-container class=\"sum-hide-spacer\"> <label>API key</label> <input type=\"text\" ng-model=\"vm.credentials[name].apiKey\"> </md-input-container> </div> <h3 ng-if=\"s.type == \'basic\'\" class=\"md-title\" style=\"margin-top: 0\">Basic HTTP Authentication</h3> <div ng-if=\"s.type == \'basic\'\" layout=\"column\"> <p ng-if=\"s.description\" ng-bind-html=\"s.description\" class=\"markdown-body sum-short-md\"></p> <md-input-container class=\"sum-hide-spacer\"> <label>Username</label> <input type=\"text\" ng-model=\"vm.credentials[name].username\"> </md-input-container> <md-input-container class=\"sum-hide-spacer\"> <label>Password</label> <input type=\"password\" ng-model=\"vm.credentials[name].password\"> </md-input-container> </div> <h3 ng-if=\"s.type == \'oauth2\'\" class=\"md-title\" style=\"margin-top: 0; white-space: nowrap\">OAuth 2.0 Authentication <small style=\"opacity: 0.5\"><span ng-bind=\"s.flow\" style=\"text-transform: uppercase\"></span> </small> </h3> <p ng-if=\"(s.type == \'oauth2\') && s.description\" ng-bind-html=\"s.description\" class=\"markdown-body sum-short-md\"></p> <div ng-if=\"s.type == \'oauth2\'\" layout=\"column\"> <md-input-container class=\"sum-hide-spacer\"> <label>Client id</label> <input type=\"text\" ng-model=\"vm.credentials[s.scopeKey].clientId\"> </md-input-container> </div> <div ng-if=\"(s.type == \'oauth2\') && vm.credentials[s.scopeKey].accessToken\" layout=\"column\"> <md-input-container class=\"sum-hide-spacer\"> <label>Access token</label> <input type=\"text\" readonly=\"readonly\" ng-model=\"vm.credentials[s.scopeKey].accessToken\"> </md-input-container> <md-input-container class=\"sum-hide-spacer\" ng-if=\"vm.credentials[s.scopeKey].expiresIn\"> <label>Expires in</label> <input type=\"text\" readonly=\"readonly\" ng-model=\"s.counter\"> </md-input-container> </div> <div layout=\"column\"> <md-checkbox ng-repeat=\"(k, v) in s.scopes\" ng-model=\"vm.credentials[s.scopeKey].scopes[k]\" aria-label=\"checkbox\"> <span class=\"md-body-1\" ng-bind=\"s.friendlyScopes[k]\"></span>: <span class=\"md-body-2\" ng-bind=\"v\"></span> </md-checkbox> </div> <div ng-if=\"s.type == \'oauth2\'\"> <md-button class=\"md-raised md-primary\" ng-href=\"{{s.link}}\" style=\"margin-left: 0\" ng-click=\"s.clicked($event)\">Authenticate </md-button> </div> </form> </div> </md-tab> </md-tabs> </md-dialog-content> <md-dialog-actions> <md-button ng-click=\"closeDialog()\">Close</md-button> </md-dialog-actions> </md-dialog>");
$templateCache.put("modules/detail/header.html","<div class=\"md-body-1\" style=\"text-indent: -9px; margin-left: 9px\"> <md-button ng-click=\"vm.utils.header(header.name, $event)\" class=\"sum-http-header md-raised\" ng-disabled=\"!vm.style.header(header.name)\" ng-class=\"vm.style.header(header.name)\" style=\"font-weight: bold; top: 0\" aria-label=\"header\" ng-bind=\"header.name\"></md-button> <br> <span style=\"word-wrap: break-word; line-height: 24px\" ng-bind-html=\"header.value\"></span> </div> <md-divider ng-if=\"!$last\" style=\"margin: 4px 0 8px 0\"></md-divider>");
$templateCache.put("modules/detail/response.html","<div class=\"md-body-1\" layout=\"row\"> <md-button ng-click=\"vm.utils.status(resp.code, $event)\" class=\"sum-http-code md-raised\" ng-class=\"vm.theme[resp.code[0]]\" ng-disabled=\"!vm.theme[resp.code[0]]\" aria-label=\"code\" ng-bind=\"resp.code\"></md-button> <span flex style=\"padding-left: 8px; padding-top: 4px; word-wrap: break-word\" ng-bind-html=\"resp.description\"></span> </div> <md-divider ng-if=\"!$last\" style=\"margin: 8px 0 8px 0\"></md-divider>");
$templateCache.put("modules/group/group.html","<div md-whiteframe=\"2\"> <md-toolbar ng-click=\"vm.toggleGroup(group, $event)\" tabindex=\"-1\" ng-class=\"{\'md-whiteframe-2dp\': group.open}\" class=\"md-accent\"> <div class=\"md-toolbar-tools\"> <span class=\"md-title\" flex ng-bind=\"::group.name\"></span> <md-button ng-click=\"toggleApi(group, $event)\" aria-label=\"toggle\" class=\"md-icon-button md-accent md-hue-3\"> <md-icon ng-bind=\"group.open ? \'keyboard_arrow_up\' : \'keyboard_arrow_down\'\"></md-icon> </md-button> </div> </md-toolbar> <div ng-show=\"group.open && group.description\" style=\"padding-bottom: 0\" layout-padding> <div style=\"padding-bottom: 0\" ng-bind-html=\"::group.description\" class=\"sum-short-md markdown-body md-body-2\"></div> </div> <div ng-show=\"group.open\" style=\"padding: 13px\"> <div ng-class=\"{\'sum-selected\': vm.data.model.sop === op}\" ng-repeat=\"op in group.operations | filter:vm.data.model.search:false track by op.id\" ng-include=\"\'modules/operation/operation.html\'\"></div> </div> </div>");
$templateCache.put("modules/meta/meta.html","<div layout=\"row\" layout-wrap ng-if=\"!vm.data.loading\" ng-controller=\"MetaController as vm\"> <div ng-repeat=\"m in vm.meta\" ng-if=\"m[2]\" flex-xs=\"100\" layout=\"row\" flex-sm=\"{{sidenavLockedOpen ? 100 : 50}}\" flex-md=\"{{sidenavLockedOpen ? 50 : 33}}\" flex-lg=\"{{sidenavLockedOpen ? 33 : 25}}\" flex-xl=\"{{sidenavLockedOpen ? 25 : 20}}\"> <md-list flex> <md-list-item class=\"md-2-line\" style=\"overflow: hidden\" layout=\"row\"> <md-icon class=\"md-avatar-icon\" ng-bind=\"m[1]\"></md-icon> <div class=\"md-list-item-text\" flex layout=\"column\"> <span ng-if=\"m[0]\" ng-bind=\"m[0]\">Contact</span> <p style=\"overflow: hidden; text-overflow: ellipsis; line-height: 14px\" ng-if=\"m[0] && !m[3]\" ng-bind=\"m[2]\" flex></p> <p ng-if=\"m[0] && m[3]\" flex> <a style=\"display: block; text-overflow: ellipsis; padding-left: 5px; text-align: left\" class=\"md-button md-primary\" ng-bind=\"m[2]\" ng-href=\"{{m[3]}}\" ng-click=\"m[4]($event, m[2])\" target=\"_blank\"></a> </p> <p ng-if=\"!m[0]\"> <a style=\"margin-top: 4px; display: inline-flex; height: 30px\" target=\"_blank\" ng-href=\"{{m[2]}}\"> <img ng-src=\"{{m[3]}}\" style=\"width: 97px; height: 30px\"/> </a> </p> </div> </md-list-item> </md-list> </div> </div>");
$templateCache.put("modules/operation/operation.html","<md-divider ng-if=\"!vm.data.ui.grouped\"></md-divider> <div id=\"{{op.operationId}}\" ng-style=\"{\'padding-top\': (!vm.data.ui.grouped || (vm.data.ui.descriptions && !$first)) ? \'6px\' : \'0\', \'padding-bottom\': (!vm.data.ui.grouped || (vm.data.ui.descriptions && !$last)) ? \'6px\' : \'0\'}\" ng-class=\"::{\'sum-deprecated\': op.deprecated}\" ng-click=\"vm.selectOperation(op, $event)\" tabindex=\"-1\"> <div layout=\"row\"> <md-button ng-class=\"::vm.theme[op.httpMethod]\" ng-click=\"vm.selectOperation(op, $event);\" aria-label=\"method\" class=\"sum-http-method md-raised\" ng-bind=\"::op.httpMethod\"></md-button> <div flex class=\"sum-path\" ng-bind=\"::op.path\"></div> </div> <div style=\"padding-left: 76px; line-height: 16px\" ng-show=\"vm.data.ui.descriptions\" class=\"md-body-2\" ng-bind=\"::op.summary\"></div> </div> <md-divider ng-if=\"vm.data.ui.grouped && (vm.data.ui.descriptions && !$last)\"></md-divider>");
$templateCache.put("modules/toolbar/toolbar.html","<md-toolbar md-whiteframe=\"2\" ng-controller=\"ToolbarController as vm\" style=\"max-height: 64px\"> <div class=\"md-toolbar-tools\" ng-if=\"vm.loading\" style=\"padding-left: 0\"> <md-progress-circular class=\"md-accent md-hue-1\" md-mode=\"indeterminate\" md-diameter=\"56\"></md-progress-circular> <span flex>Loading&hellip;</span> </div> <div class=\"md-toolbar-tools\" ng-show=\"!vm.loading\"> <toolbar-edit class=\"sum-delay md-toolbar-tools\" ng-model=\"vm.editUrl\" ng-changed=\"vm.editedUrl\" display-title=\"vm.data.model.info.title\" ng-show=\"vm.searchOpened && vm.$mdMedia(\'gt-sm\') || !vm.searchOpened\" flex style=\"padding-left: 0; padding-right: 0\"></toolbar-edit> <span flex ng-show=\"vm.searchOpened\"></span> <toolbar-search ng-show=\"!vm.loading\" ng-model=\"vm.search\" ng-changed=\"vm.searchUpdated\" open=\"vm.searchOpened\"></toolbar-search> <md-button hide show-gt-sm aria-label=\"expand\" ng-if=\"vm.ui.grouped\" ng-click=\"vm.toggleGroups(true)\" class=\"md-icon-button\"> <md-icon>keyboard_arrow_down</md-icon> </md-button> <md-button hide show-gt-sm aria-label=\"collapse\" ng-if=\"vm.ui.grouped\" ng-click=\"vm.toggleGroups(false)\" class=\"md-icon-button\"> <md-icon>keyboard_arrow_up</md-icon> </md-button> <md-button hide show-gt-sm aria-label=\"view\" ng-click=\"vm.ui.grouped = !vm.ui.grouped\" class=\"md-icon-button\"> <md-icon ng-bind=\"vm.ui.grouped ? \'view_comfy\' : \'view_column\'\"></md-icon> </md-button> <md-button hide show-gt-sm aria-label=\"description\" ng-click=\"vm.ui.descriptions = !vm.ui.descriptions\" class=\"md-icon-button\"> <md-icon ng-bind=\"vm.ui.descriptions ? \'speaker_notes_off\' : \'speaker_notes\'\"></md-icon> </md-button> <md-button hide show-gt-sm aria-label=\"proxy\" ng-click=\"vm.showProxy($event)\" ng-class=\"{\'md-warn md-hue-1\': proxy.url}\" class=\"md-icon-button\"> <md-icon>security</md-icon> </md-button> <md-button hide show-gt-sm aria-label=\"security\" ng-click=\"vm.showSecurity($event)\" ng-if=\"vm.data.model.hasSecurity\" class=\"md-icon-button\"> <md-icon>vpn_key</md-icon> </md-button> <md-menu> <md-button hide-gt-sm aria-label=\"menu\" ng-click=\"$mdOpenMenu($event)\" class=\"md-icon-button\"> <md-icon>more_vert</md-icon> </md-button> <md-menu-content> <md-menu-item ng-if=\"grouped\"> <md-button ng-click=\"vm.toggleGroups(true)\"> <md-icon>keyboard_arrow_down</md-icon> Expand </md-button> </md-menu-item> <md-menu-item ng-if=\"grouped\"> <md-button ng-click=\"vm.toggleGroups(false)\"> <md-icon>keyboard_arrow_up</md-icon> Collapse </md-button> </md-menu-item> <md-menu-item> <md-button ng-click=\"vm.ui.grouped = !vm.ui.grouped\"> <md-icon ng-bind=\"vm.ui.grouped ? \'view_comfy\' : \'view_column\'\"></md-icon> Switch view </md-button> </md-menu-item> <md-menu-item> <md-button ng-click=\"vm.ui.descriptions = !vm.ui.descriptions\"> <md-icon ng-bind=\"vm.ui.descriptions ? \'speaker_notes_off\' : \'speaker_notes\'\"></md-icon> Descriptions </md-button> </md-menu-item> <md-menu-item> <md-button ng-click=\"vm.showProxy($event)\" ng-class=\"{\'md-warn\': proxy.url}\"> <md-icon>security</md-icon> Proxy </md-button> </md-menu-item> <md-menu-item> <md-button ng-click=\"vm.showSecurity($event)\" ng-if=\"vm.data.model.hasSecurity\"> <md-icon>vpn_key</md-icon> Security </md-button> </md-menu-item> </md-menu-content> </md-menu> </div> </md-toolbar>");
$templateCache.put("directives/toolbar-edit/toolbar-edit.html","<md-button ng-click=\"toggle()\" class=\"md-icon-button\"> <md-icon>edit</md-icon> </md-button> <form ng-show=\"init && open\" ng-submit=\"blur()\" layout=\"row\" flex><input flex ng-show=\"init && open\" ng-model=\"ngModel\" type=\"text\" class=\"md-input\" ng-blur=\"blur()\"/></form> <span ng-show=\"init && !open\" ng-click=\"toggle()\" ng-bind=\"displayTitle\" tabindex=\"-1\"></span>");
$templateCache.put("directives/toolbar-search/toolbar-search.html","<md-button ng-click=\"open = true; focus()\" class=\"md-icon-button\"> <md-icon>search</md-icon> </md-button> <input ng-show=\"open\" ng-model=\"ngModel\" type=\"text\" class=\"md-input\" ng-class=\"{\'input-show-hide\': init}\" ng-model-options=\"{debounce: {default: 200, blur: 0}}\"/> <md-button ng-show=\"open\" ng-click=\"ngModel = \'\'; open = false\" class=\"md-icon-button\" ng-class=\"{\'input-show-hide\': init}\"> <md-icon>close</md-icon> </md-button>");
$templateCache.put("modules/detail/request/parameter.html","<div layout=\"column\"> <md-input-container ng-if=\"vm.data.ui.explorer && (param.in != \'body\') && (param.subtype == \'file\')\"> <label ng-bind=\"param.name + (param.required ? \' (required)\' : \'\')\"></label> <input type=\"file\" file-input ng-model=\"vm.form[param.name]\" placeholder=\"{{param.required?\'(required)\':\'\'}}\" ng-required=\"param.required\"/> </md-input-container> <md-input-container ng-if=\"vm.data.ui.explorer && (param.in != \'body\') && (param.subtype != \'enum\') && (param.subtype != \'file\')\"> <label ng-bind=\"param.name + (param.required ? \' (required)\' : \'\')\"></label> <input type=\"text\" ng-model=\"vm.form[param.name]\" ng-required=\"param.required\"/> </md-input-container> <md-input-container ng-if=\"vm.data.ui.explorer && (param.in == \'body\')\"> <label ng-bind=\"param.name + (param.required ? \' (required)\' : \'\')\"></label> <textarea ng-model=\"vm.form[param.name]\" ng-required=\"param.required\"></textarea> </md-input-container> <md-input-container ng-if=\"vm.data.ui.explorer && (param.subtype == \'enum\')\"> <label ng-bind=\"param.name + (param.required ? \' (required)\' : \'\')\"></label> <md-select class=\"sum-no-margin\" ng-required=\"param.required\" ng-model=\"vm.form[param.name]\"> <md-option ng-repeat=\"value in param.enum\" value=\"{{value}}\" ng-selected=\"param.default == value\" ng-bind=\"value + (param.default == value ? \' (default)\' : \'\')\"></md-option> </md-select> </md-input-container> <div layout=\"row\" style=\"padding-right: 4px\"> <div class=\"md-body-1 sum-param-info markdown-body\" flex ng-bind-html=\"param.description\" truncate style=\"padding-left: 2px; padding-right: 8px\"></div> <div class=\"md-body-1 sum-param-info\" layout=\"column\"> <div layout=\"row\" layout-align=\"end\"> <div style=\"padding-right: 4px\">in:</div> <div><em ng-bind-html=\"param.in\"></em></div> </div> <div layout=\"row\" ng-if=\"param.type\" layout-align=\"end\"> <div style=\"padding-right: 4px\">type:</div> <div ng-switch=\"param.type\"> <code ng-switch-when=\"array\" ng-bind=\"\'Array[\'+param.items.type+\']\'\"></code> <code ng-switch-default ng-bind=\"param.type\"></code> </div> </div> </div> </div> <div ng-if=\"(param.in == \'body\') || param.schema\" layout=\"row\" class=\"sum-ind\" style=\"margin-top: 8px\"> <md-input-container flex ng-if=\"param.in == \'body\'\" style=\"margin-top: 2px; padding-right: 16px\"> <md-select aria-label=\"parameter type\" ng-model=\"vm.form.contentType\"> <md-option ng-repeat=\"item in vm.sop.consumes track by item\" value=\"{{item}}\" ng-bind=\"::item\"> </md-option> </md-select> </md-input-container> <div class=\"sum-tools-in\" ng-if=\"param.schema\"> <a class=\"md-button md-primary\" ng-click=\"vm.form[param.name] = param.schema.json\">Set</a> <a class=\"md-button md-primary\" ng-click=\"param.schema.display = !param.schema.display + 0\" ng-bind=\"param.schema.display ? \'Model\' : \'Example\'\"></a> </div> </div> <pre class=\"sum-pre sum-wrap sum-no-margin sum-ind\" ng-if=\"param.schema.display == 0 && param.schema.model\" ng-bind-html=\"param.schema.model\"></pre> <pre class=\"sum-pre sum-no-margin sum-ind\" ng-if=\"param.schema.display == 1 && param.schema.json\" ng-bind=\"param.schema.json\"></pre> <div ng-if=\"!vm.data.ui.explorer\"> <div ng-if=\"param.in != \'body\'\"> <div ng-if=\"param.default\"><span ng-bind=\"param.default\"></span> (default)</div> <div ng-if=\"param.enum\"> <span ng-repeat=\"value in param.enum track by $index\">{{value}}<span ng-if=\"!$last\"> or </span></span> </div> <div ng-if=\"param.required\">(required)</div> </div> </div> </div>");
$templateCache.put("modules/detail/request/request.html","<div ng-if=\"vm.sop.description\"> <md-subheader class=\"md-warn md-no-sticky\">Description</md-subheader> <div layout-padding> <div class=\"md-body-1\" truncate ng-bind-html=\"vm.sop.description\"></div> </div> </div> <form role=\"form\" name=\"vm.ngForm.explorerForm\" ng-submit=\"vm.submit(vm.sop)\"> <div ng-if=\"vm.sop.responseClass.schema\" layout=\"row\"> <div flex> <md-subheader class=\"md-warn md-no-sticky\">Response class</md-subheader> </div> <div class=\"sum-tools\" ng-if=\"vm.sop.responseClass.display != -1\"> <a class=\"md-button md-primary\" ng-click=\"vm.sop.responseClass.display = !vm.sop.responseClass.display + 0\" ng-bind=\"vm.sop.responseClass.display ? \'Model\' : \'Example\'\"></a> </div> </div> <div ng-if=\"vm.sop.responseClass.schema && (vm.sop.responseClass.display != -1)\" layout-padding class=\"sum-top\"> <pre class=\"sum-pre sum-wrap sum-no-margin\" ng-if=\"vm.sop.responseClass.display == 0\" ng-bind-html=\"vm.sop.responseClass.schema.model\"></pre> <pre class=\"sum-pre sum-no-margin\" ng-if=\"vm.sop.responseClass.display == 1\" ng-bind-html=\"vm.sop.responseClass.schema.json\"></pre> </div> <div ng-if=\"vm.sop.produces.length\"> <md-subheader class=\"md-warn md-no-sticky\">Response type</md-subheader> <div layout-padding style=\"padding-bottom: 0; top: -8px; position: relative\"> <div layout=\"row\"> <md-input-container flex style=\"min-height: 34px\"> <md-select aria-label=\"response type\" ng-model=\"vm.form.responseType\" ng-disabled=\"vm.sop.produces.length == 1\"> <md-option ng-repeat=\"item in vm.sop.produces track by item\" value=\"{{item}}\" ng-bind=\"::item\"> </md-option> </md-select> </md-input-container> </div> </div> </div> <div ng-if=\"vm.sop.parameters.length\"> <md-subheader class=\"md-warn md-no-sticky\">Parameters</md-subheader> <div layout-padding style=\"padding-top: 8px\" ng-repeat=\"param in vm.sop.parameters track by $index\" ng-include=\"\'modules/detail/request/parameter.html\'\"></div> </div> <div ng-if=\"vm.sop.responseArray.length\" style=\"padding-bottom: 8px\"> <md-subheader class=\"md-warn md-no-sticky\">Response messages</md-subheader> <div layout-padding> <div> <div ng-repeat=\"resp in vm.sop.responseArray track by $index\" ng-include=\"\'modules/detail/response.html\'\"></div> </div> </div> </div> <button hide type=\"submit\">Submit</button> </form>");
$templateCache.put("modules/detail/scripts/scripts.html","<div layout=\"row\"> <div flex> <md-subheader class=\"md-warn md-no-sticky\">AngularJS</md-subheader> </div> <div class=\"sum-tools\" ng-if=\"vm.sop.responseClass.display != -1\"> <a class=\"md-button md-primary\" href=\"https://docs.angularjs.org/api/ng/service/$http\" target=\"_blank\">Reference</a> </div> </div> <div layout-padding class=\"sum-top\"> <pre class=\"sum-pre sum-wrap sum-no-margin\">$http({{vm.sop.mock | json}})\r\n.then(\r\n    function success(response) {\r\n    },\r\n    function error(response) {\r\n    }\r\n)</pre> </div>");
$templateCache.put("modules/detail/result/result.html","<md-subheader class=\"md-warn md-no-sticky\">Request URL</md-subheader> <div layout-padding> <div> <a class=\"md-button sum-link md-primary\" style=\"font-weight: normal; white-space: normal; display: inline; overflow: auto; word-wrap: break-word\" ng-href=\"{{vm.sop.explorerResult.fullUrl}}\" target=\"_blank\" ng-bind=\"vm.sop.explorerResult.fullUrl\"></a> </div> </div> <md-subheader class=\"md-warn md-no-sticky\">Response status</md-subheader> <div layout-padding> <div> <div ng-repeat=\"resp in vm.sop.explorerResult.statusArray track by $index\" ng-include=\"\'modules/detail/response.html\'\"></div> </div> </div> <md-subheader class=\"md-warn md-no-sticky\">Timing</md-subheader> <div layout-padding> <div> <div ng-if=\"t[1]\" ng-repeat=\"t in vm.sop.explorerResult.timing track by $index\"> <span class=\"md-body-1\">{{t[0]}}: </span> <span class=\"md-body-2\">{{t[1] | number:2}} ms</span> </div> </div> </div> <div ng-if=\"vm.sop.explorerResult.headerArray.length\"> <md-subheader class=\"md-warn md-no-sticky\">Response headers</md-subheader> <div layout-padding> <div> <div ng-repeat=\"header in vm.sop.explorerResult.headerArray\" ng-include=\"\'modules/detail/header.html\'\"></div> </div> </div> </div> <div ng-if=\"vm.sop.explorerResult.body\"> <div class=\"sum-subheader\" layout=\"row\"> <div flex> <md-subheader class=\"md-warn md-no-sticky\">Response body</md-subheader> </div> <div class=\"sum-tools\"> <a href=\"#\" target=\"_blank\" class=\"md-button md-primary\" ng-click=\"vm.openFile($event)\">Open</a> </div> </div> <div layout-padding> <pre class=\"sum-pre\" style=\"word-wrap: break-word; overflow-y: auto; overflow-x: hidden; margin-top: 0; margin-bottom: 0\" truncate=\"1728\" ng-bind=\"vm.sop.explorerResult.body\"></pre> </div> </div>");}]);