# Generated by Django 3.2.11 on 2022-01-16 01:51

import datetime
from django.conf import settings
import django.contrib.auth.validators
import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
from django.utils.timezone import utc
import django.utils.timezone
import integreat_cms.cms.models.media.media_file
import integreat_cms.cms.models.users.user


class Migration(migrations.Migration):
    """
    Initial migration
    """

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="last login"
                    ),
                ),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        error_messages={
                            "unique": "A user with that username already exists."
                        },
                        help_text="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.",
                        max_length=150,
                        unique=True,
                        validators=[
                            django.contrib.auth.validators.UnicodeUsernameValidator()
                        ],
                        verbose_name="username",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="first name"
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="last name"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="email address"
                    ),
                ),
                (
                    "is_staff",
                    models.BooleanField(
                        default=False,
                        help_text="Designates whether the user can log into this admin site.",
                        verbose_name="staff status",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this user should be treated as active. Unselect this instead of deleting accounts.",
                        verbose_name="active",
                    ),
                ),
                (
                    "date_joined",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="date joined"
                    ),
                ),
                (
                    "chat_last_visited",
                    models.DateTimeField(
                        default=datetime.datetime(1, 1, 1, 0, 0, tzinfo=utc),
                        help_text="The date and time when the user did read the chat the last time",
                        verbose_name="last chat visit date",
                    ),
                ),
                (
                    "expert_mode",
                    models.BooleanField(
                        default=False,
                        help_text="Enable this option to show up additional features like XLIFF import/export, page filtering, mirrored pages, page-based permissions, Do-Not-Translate-Tag and recurring events",
                        verbose_name="experienced user",
                    ),
                ),
                (
                    "page_tree_tutorial_seen",
                    models.BooleanField(
                        default=False,
                        help_text="Will be set to true once the user dismissed the page tree tutorial",
                        verbose_name="Page tree tutorial seen",
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.Group",
                        verbose_name="groups",
                    ),
                ),
            ],
            options={
                "verbose_name": "user",
                "verbose_name_plural": "users",
                "default_permissions": ("change", "delete", "view"),
            },
            managers=[
                ("objects", integreat_cms.cms.models.users.user.CustomUserManager()),
            ],
        ),
        migrations.CreateModel(
            name="Directory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="name")),
                (
                    "created_date",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="The date and time when the directory was created",
                        verbose_name="creation date",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="subdirectories",
                        to="cms.directory",
                        verbose_name="parent directory",
                    ),
                ),
            ],
            options={
                "verbose_name": "media directory",
                "verbose_name_plural": "media directories",
                "ordering": ["-region", "name"],
            },
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                ("start_date", models.DateField(verbose_name="start date")),
                ("start_time", models.TimeField(blank=True, verbose_name="start time")),
                ("end_date", models.DateField(verbose_name="end date")),
                ("end_time", models.TimeField(blank=True, verbose_name="end time")),
                (
                    "archived",
                    models.BooleanField(default=False, verbose_name="archived"),
                ),
            ],
            options={
                "verbose_name": "event",
                "verbose_name_plural": "events",
                "ordering": ["start_date", "start_time"],
                "permissions": (("publish_event", "Can publish events"),),
                "default_permissions": ("change", "delete", "view"),
                "default_related_name": "events",
            },
        ),
        migrations.CreateModel(
            name="Feedback",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "rating",
                    models.BooleanField(
                        blank=True,
                        choices=[
                            (True, "Positive"),
                            (False, "Negative"),
                            (None, "Not stated"),
                        ],
                        default=None,
                        help_text="Whether the feedback is positive or negative",
                        null=True,
                        verbose_name="rating",
                    ),
                ),
                ("comment", models.TextField(blank=True, verbose_name="comment")),
                (
                    "is_technical",
                    models.BooleanField(
                        help_text="Whether or not the feedback is targeted at the developers",
                        verbose_name="technical",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="creation date"
                    ),
                ),
            ],
            options={
                "verbose_name": "feedback",
                "verbose_name_plural": "feedback",
                "ordering": ["-created_date"],
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.CreateModel(
            name="ImprintPage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                (
                    "explicitly_archived",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the page is explicitly archived",
                        verbose_name="explicitly archived",
                    ),
                ),
            ],
            options={
                "verbose_name": "imprint",
                "verbose_name_plural": "imprints",
                "default_permissions": ("change", "delete", "view"),
                "default_related_name": "imprints",
            },
        ),
        migrations.CreateModel(
            name="Language",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="Unique string identifier used in URLs without spaces and special characters.",
                        max_length=8,
                        unique=True,
                        validators=[django.core.validators.MinLengthValidator(2)],
                        verbose_name="Language Slug",
                    ),
                ),
                (
                    "bcp47_tag",
                    models.SlugField(
                        help_text="Language identifier without spaces and special characters. This field usually contains a combination of subtags from the IANA Subtag Registry.",
                        max_length=35,
                        unique=True,
                        validators=[django.core.validators.MinLengthValidator(2)],
                        verbose_name="BCP47 Tag",
                    ),
                ),
                (
                    "native_name",
                    models.CharField(
                        help_text="The name of the language in this language.",
                        max_length=250,
                        verbose_name="native name",
                    ),
                ),
                (
                    "english_name",
                    models.CharField(
                        help_text="The name of the language in English.",
                        max_length=250,
                        verbose_name="name in English",
                    ),
                ),
                (
                    "text_direction",
                    models.CharField(
                        choices=[
                            ("LEFT_TO_RIGHT", "Left to right"),
                            ("RIGHT_TO_LEFT", "Right to left"),
                        ],
                        default="LEFT_TO_RIGHT",
                        max_length=13,
                        verbose_name="text direction",
                    ),
                ),
                (
                    "primary_country_code",
                    models.CharField(
                        choices=[
                            ("ad", "Andorra"),
                            ("ae", "United Arab Emirates"),
                            ("af", "Afghanistan"),
                            ("al", "Albania"),
                            ("am", "Armenia"),
                            ("ao", "Angola"),
                            ("ar", "Argentina"),
                            ("at", "Austria"),
                            ("au", "Australia"),
                            ("az", "Azerbaijan"),
                            ("ba", "Bosnia and Herzegovina"),
                            ("bd", "Bangladesh"),
                            ("be", "Belgium"),
                            ("bf", "Burkina Faso"),
                            ("bg", "Bulgaria"),
                            ("bh", "Bahrain"),
                            ("bi", "Burundi"),
                            ("bj", "Benin"),
                            ("bm", "Bermuda"),
                            ("bn", "Brunei"),
                            ("bo", "Bolivia"),
                            ("br", "Brazil"),
                            ("bt", "Bhutan"),
                            ("bw", "Botswana"),
                            ("by", "Belarus"),
                            ("ca", "Canada"),
                            ("cd", "Congo (Democratic Republic)"),
                            ("cf", "Central African Republic"),
                            ("cg", "Congo (Republic)"),
                            ("ch", "Switzerland"),
                            ("ci", "Côte d'Ivoire"),
                            ("cl", "Chile"),
                            ("cm", "Cameroon"),
                            ("cn", "China"),
                            ("co", "Colombia"),
                            ("cr", "Costa Rica"),
                            ("cu", "Cuba"),
                            ("cy", "Cyprus"),
                            ("cz", "Czechia"),
                            ("de", "Germany"),
                            ("dj", "Djibouti"),
                            ("dk", "Denmark"),
                            ("dm", "Dominica"),
                            ("do", "Dominican Republic"),
                            ("dz", "Algeria"),
                            ("ec", "Ecuador"),
                            ("ee", "Estonia"),
                            ("eg", "Egypt"),
                            ("er", "Eritrea"),
                            ("es", "Spain"),
                            ("et", "Ethiopia"),
                            ("fi", "Finland"),
                            ("fr", "France"),
                            ("ga", "Gabon"),
                            (
                                "gb",
                                "United Kingdom of Great Britain and Northern Ireland",
                            ),
                            ("gd", "Grenada"),
                            ("ge", "Georgia"),
                            ("gf", "French Guiana"),
                            ("gg", "Guernsey"),
                            ("gh", "Ghana"),
                            ("gi", "Gibraltar"),
                            ("gl", "Greenland"),
                            ("gm", "Gambia"),
                            ("gn", "Guinea"),
                            ("gp", "Guadeloupe"),
                            ("gr", "Greece"),
                            ("gt", "Guatemala"),
                            ("gu", "Guam"),
                            ("gy", "Guyana"),
                            ("hk", "Hong Kong"),
                            ("hn", "Honduras"),
                            ("hr", "Croatia"),
                            ("ht", "Haiti"),
                            ("hu", "Hungary"),
                            ("id", "Indonesia"),
                            ("ie", "Ireland"),
                            ("il", "Israel"),
                            ("in", "India"),
                            ("iq", "Iraq"),
                            ("ir", "Iran"),
                            ("is", "Iceland"),
                            ("it", "Italy"),
                            ("jm", "Jamaica"),
                            ("jo", "Jordan"),
                            ("jp", "Japan"),
                            ("ke", "Kenya"),
                            ("kg", "Kyrgyzstan"),
                            ("kh", "Cambodia"),
                            ("kp", "North Korea"),
                            ("kr", "South Korea"),
                            ("kw", "Kuwait"),
                            ("kz", "Kazakhstan"),
                            ("lb", "Lebanon"),
                            ("li", "Liechtenstein"),
                            ("lr", "Liberia"),
                            ("ls", "Lesotho"),
                            ("lt", "Lithuania"),
                            ("lu", "Luxembourg"),
                            ("lv", "Latvia"),
                            ("ly", "Libya"),
                            ("ma", "Morocco"),
                            ("mc", "Monaco"),
                            ("md", "Moldova"),
                            ("me", "Montenegro"),
                            ("mg", "Madagascar"),
                            ("mk", "North Macedonia"),
                            ("ml", "Mali"),
                            ("mm", "Myanmar"),
                            ("mn", "Mongolia"),
                            ("mr", "Mauritania"),
                            ("mt", "Malta"),
                            ("mu", "Mauritius"),
                            ("mv", "Maldives"),
                            ("mw", "Malawi"),
                            ("mx", "Mexico"),
                            ("my", "Malaysia"),
                            ("mz", "Mozambique"),
                            ("na", "Namibia"),
                            ("ne", "Niger"),
                            ("ng", "Nigeria"),
                            ("ni", "Nicaragua"),
                            ("nl", "Netherlands"),
                            ("no", "Norway"),
                            ("np", "Nepal"),
                            ("nz", "New Zealand"),
                            ("om", "Oman"),
                            ("pa", "Panama"),
                            ("pe", "Peru"),
                            ("pf", "French Polynesia"),
                            ("pg", "Papua New Guinea"),
                            ("ph", "Philippines"),
                            ("pk", "Pakistan"),
                            ("pl", "Poland"),
                            ("ps", "Palestine"),
                            ("pt", "Portugal"),
                            ("py", "Paraguay"),
                            ("qa", "Qatar"),
                            ("ro", "Romania"),
                            ("rs", "Serbia"),
                            ("ru", "Russian Federation"),
                            ("rw", "Rwanda"),
                            ("sa", "Saudi Arabia"),
                            ("sd", "Sudan"),
                            ("se", "Sweden"),
                            ("si", "Slovenia"),
                            ("sk", "Slovakia"),
                            ("sl", "Sierra Leone"),
                            ("sn", "Senegal"),
                            ("so", "Somalia"),
                            ("ss", "South Sudan"),
                            ("sv", "El Salvador"),
                            ("sy", "Syrian Arab Republic"),
                            ("td", "Chad"),
                            ("th", "Thailand"),
                            ("tj", "Tajikistan"),
                            ("tm", "Turkmenistan"),
                            ("tn", "Tunisia"),
                            ("tr", "Turkey"),
                            ("tw", "Taiwan"),
                            ("tz", "Tanzania"),
                            ("ua", "Ukraine"),
                            ("ug", "Uganda"),
                            ("us", "United States of America"),
                            ("uy", "Uruguay"),
                            ("uz", "Uzbekistan"),
                            ("ve", "Venezuela"),
                            ("vn", "Viet Nam"),
                            ("xk", "Kosovo"),
                            ("ye", "Yemen"),
                            ("za", "South Africa"),
                            ("zm", "Zambia"),
                            ("zw", "Zimbabwe"),
                        ],
                        help_text="The country with which this language is mainly associated. This flag is used to represent the language graphically.",
                        max_length=2,
                        verbose_name="primary country flag",
                    ),
                ),
                (
                    "secondary_country_code",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ad", "Andorra"),
                            ("ae", "United Arab Emirates"),
                            ("af", "Afghanistan"),
                            ("al", "Albania"),
                            ("am", "Armenia"),
                            ("ao", "Angola"),
                            ("ar", "Argentina"),
                            ("at", "Austria"),
                            ("au", "Australia"),
                            ("az", "Azerbaijan"),
                            ("ba", "Bosnia and Herzegovina"),
                            ("bd", "Bangladesh"),
                            ("be", "Belgium"),
                            ("bf", "Burkina Faso"),
                            ("bg", "Bulgaria"),
                            ("bh", "Bahrain"),
                            ("bi", "Burundi"),
                            ("bj", "Benin"),
                            ("bm", "Bermuda"),
                            ("bn", "Brunei"),
                            ("bo", "Bolivia"),
                            ("br", "Brazil"),
                            ("bt", "Bhutan"),
                            ("bw", "Botswana"),
                            ("by", "Belarus"),
                            ("ca", "Canada"),
                            ("cd", "Congo (Democratic Republic)"),
                            ("cf", "Central African Republic"),
                            ("cg", "Congo (Republic)"),
                            ("ch", "Switzerland"),
                            ("ci", "Côte d'Ivoire"),
                            ("cl", "Chile"),
                            ("cm", "Cameroon"),
                            ("cn", "China"),
                            ("co", "Colombia"),
                            ("cr", "Costa Rica"),
                            ("cu", "Cuba"),
                            ("cy", "Cyprus"),
                            ("cz", "Czechia"),
                            ("de", "Germany"),
                            ("dj", "Djibouti"),
                            ("dk", "Denmark"),
                            ("dm", "Dominica"),
                            ("do", "Dominican Republic"),
                            ("dz", "Algeria"),
                            ("ec", "Ecuador"),
                            ("ee", "Estonia"),
                            ("eg", "Egypt"),
                            ("er", "Eritrea"),
                            ("es", "Spain"),
                            ("et", "Ethiopia"),
                            ("fi", "Finland"),
                            ("fr", "France"),
                            ("ga", "Gabon"),
                            (
                                "gb",
                                "United Kingdom of Great Britain and Northern Ireland",
                            ),
                            ("gd", "Grenada"),
                            ("ge", "Georgia"),
                            ("gf", "French Guiana"),
                            ("gg", "Guernsey"),
                            ("gh", "Ghana"),
                            ("gi", "Gibraltar"),
                            ("gl", "Greenland"),
                            ("gm", "Gambia"),
                            ("gn", "Guinea"),
                            ("gp", "Guadeloupe"),
                            ("gr", "Greece"),
                            ("gt", "Guatemala"),
                            ("gu", "Guam"),
                            ("gy", "Guyana"),
                            ("hk", "Hong Kong"),
                            ("hn", "Honduras"),
                            ("hr", "Croatia"),
                            ("ht", "Haiti"),
                            ("hu", "Hungary"),
                            ("id", "Indonesia"),
                            ("ie", "Ireland"),
                            ("il", "Israel"),
                            ("in", "India"),
                            ("iq", "Iraq"),
                            ("ir", "Iran"),
                            ("is", "Iceland"),
                            ("it", "Italy"),
                            ("jm", "Jamaica"),
                            ("jo", "Jordan"),
                            ("jp", "Japan"),
                            ("ke", "Kenya"),
                            ("kg", "Kyrgyzstan"),
                            ("kh", "Cambodia"),
                            ("kp", "North Korea"),
                            ("kr", "South Korea"),
                            ("kw", "Kuwait"),
                            ("kz", "Kazakhstan"),
                            ("lb", "Lebanon"),
                            ("li", "Liechtenstein"),
                            ("lr", "Liberia"),
                            ("ls", "Lesotho"),
                            ("lt", "Lithuania"),
                            ("lu", "Luxembourg"),
                            ("lv", "Latvia"),
                            ("ly", "Libya"),
                            ("ma", "Morocco"),
                            ("mc", "Monaco"),
                            ("md", "Moldova"),
                            ("me", "Montenegro"),
                            ("mg", "Madagascar"),
                            ("mk", "North Macedonia"),
                            ("ml", "Mali"),
                            ("mm", "Myanmar"),
                            ("mn", "Mongolia"),
                            ("mr", "Mauritania"),
                            ("mt", "Malta"),
                            ("mu", "Mauritius"),
                            ("mv", "Maldives"),
                            ("mw", "Malawi"),
                            ("mx", "Mexico"),
                            ("my", "Malaysia"),
                            ("mz", "Mozambique"),
                            ("na", "Namibia"),
                            ("ne", "Niger"),
                            ("ng", "Nigeria"),
                            ("ni", "Nicaragua"),
                            ("nl", "Netherlands"),
                            ("no", "Norway"),
                            ("np", "Nepal"),
                            ("nz", "New Zealand"),
                            ("om", "Oman"),
                            ("pa", "Panama"),
                            ("pe", "Peru"),
                            ("pf", "French Polynesia"),
                            ("pg", "Papua New Guinea"),
                            ("ph", "Philippines"),
                            ("pk", "Pakistan"),
                            ("pl", "Poland"),
                            ("ps", "Palestine"),
                            ("pt", "Portugal"),
                            ("py", "Paraguay"),
                            ("qa", "Qatar"),
                            ("ro", "Romania"),
                            ("rs", "Serbia"),
                            ("ru", "Russian Federation"),
                            ("rw", "Rwanda"),
                            ("sa", "Saudi Arabia"),
                            ("sd", "Sudan"),
                            ("se", "Sweden"),
                            ("si", "Slovenia"),
                            ("sk", "Slovakia"),
                            ("sl", "Sierra Leone"),
                            ("sn", "Senegal"),
                            ("so", "Somalia"),
                            ("ss", "South Sudan"),
                            ("sv", "El Salvador"),
                            ("sy", "Syrian Arab Republic"),
                            ("td", "Chad"),
                            ("th", "Thailand"),
                            ("tj", "Tajikistan"),
                            ("tm", "Turkmenistan"),
                            ("tn", "Tunisia"),
                            ("tr", "Turkey"),
                            ("tw", "Taiwan"),
                            ("tz", "Tanzania"),
                            ("ua", "Ukraine"),
                            ("ug", "Uganda"),
                            ("us", "United States of America"),
                            ("uy", "Uruguay"),
                            ("uz", "Uzbekistan"),
                            ("ve", "Venezuela"),
                            ("vn", "Viet Nam"),
                            ("xk", "Kosovo"),
                            ("ye", "Yemen"),
                            ("za", "South Africa"),
                            ("zm", "Zambia"),
                            ("zw", "Zimbabwe"),
                        ],
                        help_text="Another country with which this language is also associated. This flag is used in the language switcher.",
                        max_length=2,
                        verbose_name="secondary country flag",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "table_of_contents",
                    models.CharField(
                        help_text='The native name for "Table of contents" in this language. This is used in exported PDFs.',
                        max_length=250,
                        verbose_name='"Table of contents" in this language',
                    ),
                ),
            ],
            options={
                "verbose_name": "language",
                "verbose_name_plural": "languages",
                "ordering": ["bcp47_tag"],
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.CreateModel(
            name="MediaFile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "file",
                    models.FileField(
                        max_length=512,
                        upload_to=integreat_cms.cms.models.media.media_file.upload_path,
                        verbose_name="file",
                    ),
                ),
                (
                    "thumbnail",
                    models.FileField(
                        max_length=512,
                        upload_to=integreat_cms.cms.models.media.media_file.upload_path_thumbnail,
                        verbose_name="thumbnail file",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("image/png", "PNG image"),
                            ("image/jpeg", "JPEG image"),
                            ("application/pdf", "PDF document"),
                            ("image/svg+xml", "SVG image"),
                            ("image/gif", "GIF image"),
                            ("application/msword", "DOC document"),
                            (
                                "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
                                "DOCX document",
                            ),
                            ("application/vnd.ms-excel", "XLS document"),
                            (
                                "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
                                "XLSX document",
                            ),
                            ("application/vnd.ms-powerpoint", "PPT document"),
                            (
                                "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
                                "PPTX document",
                            ),
                        ],
                        max_length=128,
                        verbose_name="file type",
                    ),
                ),
                ("name", models.CharField(max_length=512, verbose_name="name")),
                (
                    "alt_text",
                    models.CharField(
                        blank=True, max_length=512, verbose_name="description"
                    ),
                ),
                (
                    "uploaded_date",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="The date and time when the media file was uploaded",
                        verbose_name="uploaded date",
                    ),
                ),
                (
                    "parent_directory",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="files",
                        to="cms.directory",
                        verbose_name="parent directory",
                    ),
                ),
            ],
            options={
                "verbose_name": "media file",
                "verbose_name_plural": "media files",
                "ordering": ["-region", "name"],
                "permissions": (
                    ("upload_mediafile", "Can upload media file"),
                    ("replace_mediafile", "Can replace media file"),
                ),
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.CreateModel(
            name="OfferTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=250, verbose_name="name")),
                (
                    "slug",
                    models.SlugField(
                        help_text="String identifier without spaces and special characters. Unique per region and language. Leave blank to generate unique parameter from name",
                        max_length=60,
                        unique=True,
                        verbose_name="slug",
                    ),
                ),
                (
                    "thumbnail",
                    models.URLField(max_length=250, verbose_name="thumbnail URL"),
                ),
                (
                    "url",
                    models.URLField(
                        help_text="This will be an external API endpoint in most cases.",
                        max_length=250,
                        verbose_name="URL",
                    ),
                ),
                (
                    "post_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Additional POST data for retrieving the URL. Specify as JSON.",
                        max_length=250,
                        verbose_name="POST parameter",
                    ),
                ),
                (
                    "use_postal_code",
                    models.CharField(
                        choices=[
                            ("NONE", "Do not use postcode"),
                            ("GET", "Append postal code to URL"),
                            ("POST", "Add postal code to post parameters"),
                        ],
                        default="NONE",
                        help_text="Whether and how to insert the postcode of the region into the URL or POST data",
                        max_length=4,
                        verbose_name="use postal code",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
            ],
            options={
                "verbose_name": "offer template",
                "verbose_name_plural": "offer templates",
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.CreateModel(
            name="Organization",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200, verbose_name="name")),
                (
                    "slug",
                    models.SlugField(
                        allow_unicode=True,
                        help_text="Unique string identifier without spaces and special characters.",
                        max_length=200,
                        unique=True,
                        verbose_name="slug",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "icon",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="icon_organizations",
                        to="cms.mediafile",
                        verbose_name="logo",
                    ),
                ),
            ],
            options={
                "verbose_name": "organization",
                "verbose_name_plural": "organizations",
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.CreateModel(
            name="Page",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                (
                    "explicitly_archived",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the page is explicitly archived",
                        verbose_name="explicitly archived",
                    ),
                ),
                ("lft", models.PositiveIntegerField(db_index=True)),
                ("rgt", models.PositiveIntegerField(db_index=True)),
                ("tree_id", models.PositiveIntegerField(db_index=True)),
                ("depth", models.PositiveIntegerField(db_index=True)),
                (
                    "mirrored_page_first",
                    models.BooleanField(
                        blank=True,
                        default=True,
                        help_text="If a mirrored page is set, this field determines whether the live content is embedded before the content of this page or after.",
                        null=True,
                        verbose_name="Position of mirrored page",
                    ),
                ),
                (
                    "editors",
                    models.ManyToManyField(
                        blank=True,
                        help_text="A list of users who have the permission to edit this specific page. Only has effect if these users do not have the permission to edit pages anyway.",
                        related_name="editable_pages",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="editors",
                    ),
                ),
                (
                    "icon",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="pages",
                        to="cms.mediafile",
                        verbose_name="icon",
                    ),
                ),
                (
                    "mirrored_page",
                    models.ForeignKey(
                        blank=True,
                        help_text="If the page embeds live content from another page, it is referenced here.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="mirroring_pages",
                        to="cms.page",
                        verbose_name="mirrored page",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        help_text="This allows all members of the organization to edit and publish this page.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="pages",
                        to="cms.organization",
                        verbose_name="responsible organization",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="children",
                        to="cms.page",
                        verbose_name="parent",
                    ),
                ),
                (
                    "publishers",
                    models.ManyToManyField(
                        blank=True,
                        help_text="A list of users who have the permission to publish this specific page. Only has effect if these users do not have the permission to publish pages anyway.",
                        related_name="publishable_pages",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="publishers",
                    ),
                ),
            ],
            options={
                "verbose_name": "page",
                "verbose_name_plural": "pages",
                "permissions": (
                    ("publish_page", "Can publish page"),
                    ("grant_page_permissions", "Can grant page permission"),
                ),
                "default_permissions": ("change", "delete", "view"),
                "default_related_name": "pages",
            },
        ),
        migrations.CreateModel(
            name="POI",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                (
                    "address",
                    models.CharField(
                        max_length=250, verbose_name="street and house number"
                    ),
                ),
                (
                    "postcode",
                    models.CharField(max_length=10, verbose_name="postal code"),
                ),
                ("city", models.CharField(max_length=250, verbose_name="city")),
                ("country", models.CharField(max_length=250, verbose_name="country")),
                (
                    "latitude",
                    models.FloatField(
                        help_text="The latitude coordinate", verbose_name="latitude"
                    ),
                ),
                (
                    "longitude",
                    models.FloatField(
                        help_text="The longitude coordinate", verbose_name="longitude"
                    ),
                ),
                (
                    "location_not_on_map",
                    models.BooleanField(
                        default=False,
                        help_text="Tick if you do not show this location on map",
                        verbose_name="Do not show this location on map",
                    ),
                ),
                (
                    "archived",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the location is read-only and hidden in the API.",
                        verbose_name="archived",
                    ),
                ),
                (
                    "icon",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="pois",
                        to="cms.mediafile",
                        verbose_name="icon",
                    ),
                ),
            ],
            options={
                "verbose_name": "location",
                "verbose_name_plural": "locations",
                "default_permissions": ("change", "delete", "view"),
                "default_related_name": "pois",
            },
        ),
        migrations.CreateModel(
            name="RecurrenceRule",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "frequency",
                    models.CharField(
                        choices=[
                            ("DAILY", "Daily"),
                            ("WEEKLY", "Weekly"),
                            ("MONTHLY", "Monthly"),
                            ("YEARLY", "Yearly"),
                        ],
                        default="WEEKLY",
                        help_text="How often the event recurs",
                        max_length=7,
                        verbose_name="frequency",
                    ),
                ),
                (
                    "interval",
                    models.IntegerField(
                        default=1,
                        help_text="The interval in which the event recurs.",
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Repeat every ... time(s)",
                    ),
                ),
                (
                    "weekdays_for_weekly",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.IntegerField(
                            choices=[
                                (0, "Monday"),
                                (1, "Tuesday"),
                                (2, "Wednesday"),
                                (3, "Thursday"),
                                (4, "Friday"),
                                (5, "Saturday"),
                                (6, "Sunday"),
                            ]
                        ),
                        blank=True,
                        help_text="If the frequency is weekly, this field determines on which days the event takes place",
                        size=None,
                        verbose_name="weekdays",
                    ),
                ),
                (
                    "weekday_for_monthly",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Monday"),
                            (1, "Tuesday"),
                            (2, "Wednesday"),
                            (3, "Thursday"),
                            (4, "Friday"),
                            (5, "Saturday"),
                            (6, "Sunday"),
                        ],
                        help_text="If the frequency is monthly, this field determines on which days the event takes place",
                        null=True,
                        verbose_name="weekday",
                    ),
                ),
                (
                    "week_for_monthly",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (1, "First week"),
                            (2, "Second week"),
                            (3, "Third week"),
                            (4, "Fourth week"),
                        ],
                        help_text="If the frequency is monthly, this field determines on which week of the month the event takes place",
                        null=True,
                        verbose_name="week",
                    ),
                ),
                (
                    "recurrence_end_date",
                    models.DateField(
                        blank=True,
                        help_text="If the recurrence is not for an indefinite period, this field contains the end date",
                        null=True,
                        verbose_name="recurrence end date",
                    ),
                ),
            ],
            options={
                "verbose_name": "recurrence rule",
                "verbose_name_plural": "recurrence rules",
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="EventListFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
            ],
            options={
                "verbose_name": "event list feedback",
                "verbose_name_plural": "event list feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="ImprintPageFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
            ],
            options={
                "verbose_name": "imprint feedback",
                "verbose_name_plural": "imprint feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="MapFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
            ],
            options={
                "verbose_name": "map feedback",
                "verbose_name_plural": "map feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="OfferListFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
            ],
            options={
                "verbose_name": "offer list feedback",
                "verbose_name_plural": "offer list feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="RegionFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
            ],
            options={
                "verbose_name": "region feedback",
                "verbose_name_plural": "region feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="SearchResultFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
                (
                    "search_query",
                    models.CharField(max_length=1000, verbose_name="search term"),
                ),
            ],
            options={
                "verbose_name": "search result feedback",
                "verbose_name_plural": "search result feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="Role",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        choices=[
                            ("MANAGEMENT", "Management"),
                            ("EDITOR", "Editor"),
                            ("EVENT_MANAGER", "Event manager"),
                            ("MUNICIPALITY_TEAM", "Municipality team"),
                            ("CMS_TEAM", "CMS team"),
                            ("APP_TEAM", "App team"),
                            ("MARKETING_TEAM", "Marketing team"),
                        ],
                        max_length=50,
                        verbose_name="name",
                    ),
                ),
                (
                    "staff_role",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not this role is designed for staff members",
                        verbose_name="staff role",
                    ),
                ),
                (
                    "group",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="role",
                        to="auth.group",
                        verbose_name="Django auth group",
                    ),
                ),
            ],
            options={
                "verbose_name": "role",
                "verbose_name_plural": "roles",
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Region",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200, verbose_name="name")),
                (
                    "common_id",
                    models.CharField(
                        blank=True,
                        help_text="Number sequence for identifying politically independent administrative units",
                        max_length=48,
                        verbose_name="community identification number",
                    ),
                ),
                (
                    "slug",
                    models.SlugField(
                        allow_unicode=True,
                        help_text="Unique string identifier without spaces and special characters. Leave blank to generate unique parameter from name",
                        max_length=200,
                        unique=True,
                        verbose_name="URL parameter",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("ACTIVE", "Active"),
                            ("HIDDEN", "Hidden"),
                            ("ARCHIVED", "Archived"),
                        ],
                        default="HIDDEN",
                        max_length=8,
                        verbose_name="status",
                    ),
                ),
                (
                    "administrative_division",
                    models.CharField(
                        choices=[
                            ("CITY", "City"),
                            ("DISTRICT", "District"),
                            ("RURAL_DISTRICT", "Rural district"),
                            ("REGION", "Region"),
                            ("CITY_AND_DISTRICT", "City and district"),
                            ("URBAN_DISTRICT", "Urban district"),
                            ("GOVERNMENTAL_DISTRICT", "Governmental district"),
                            ("CITY_STATE", "City state"),
                            ("AREA_STATE", "Area state"),
                            ("FREE_STATE", "Free state"),
                            ("FEDERAL_STATE", "Federal state"),
                            ("MUNICIPALITY", "Municipality"),
                            ("COLLECTIVE_MUNICIPALITY", "Collective municipality"),
                            ("INITIAL_RECEPTION_CENTER", "Initial reception center"),
                        ],
                        default="RURAL_DISTRICT",
                        max_length=24,
                        verbose_name="administrative division",
                    ),
                ),
                (
                    "aliases",
                    models.TextField(
                        blank=True,
                        help_text="E.g. smaller municipalities in that area. If empty, the CMS will try to fill this automatically. Specify as JSON.",
                        verbose_name="aliases",
                    ),
                ),
                (
                    "events_enabled",
                    models.BooleanField(
                        default=True,
                        help_text="Whether or not events are enabled in the region",
                        verbose_name="activate events",
                    ),
                ),
                (
                    "push_notifications_enabled",
                    models.BooleanField(
                        default=True,
                        help_text="Whether or not push notifications are enabled in the region",
                        verbose_name="activate push notifications",
                    ),
                ),
                (
                    "latitude",
                    models.FloatField(
                        help_text="The latitude coordinate of an approximate center of the region",
                        null=True,
                        verbose_name="latitude",
                    ),
                ),
                (
                    "longitude",
                    models.FloatField(
                        help_text="The longitude coordinate of an approximate center of the region",
                        null=True,
                        verbose_name="longitude",
                    ),
                ),
                (
                    "postal_code",
                    models.CharField(max_length=10, verbose_name="postal code"),
                ),
                (
                    "admin_mail",
                    models.EmailField(
                        max_length=254,
                        verbose_name="email address of the administrator",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "statistics_enabled",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not statistics are enabled for the region",
                        verbose_name="activate statistics",
                    ),
                ),
                (
                    "matomo_id",
                    models.PositiveSmallIntegerField(
                        blank=True,
                        help_text="The Matomo ID of this region. Will be automatically derived from the Matomo access token.",
                        null=True,
                        verbose_name="Matomo ID",
                    ),
                ),
                (
                    "matomo_token",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The secret Matomo access token of the region is used to authenticate in API requests",
                        max_length=150,
                        verbose_name="Matomo authentication token",
                    ),
                ),
                (
                    "page_permissions_enabled",
                    models.BooleanField(
                        default=False,
                        help_text="This allows individual users to be granted the right to edit or publish a specific page.",
                        verbose_name="activate page-specific permissions",
                    ),
                ),
                (
                    "chat_enabled",
                    models.BooleanField(
                        default=True,
                        help_text="This gives all users of this region access to the cross-regional author chat.",
                        verbose_name="activate author chat",
                    ),
                ),
                (
                    "administrative_division_included",
                    models.BooleanField(
                        default=False,
                        help_text="Determines whether the administrative division is displayed next to the region name. Sorting is always based on the name, independently from the administrative division.",
                        verbose_name="include administrative division into name",
                    ),
                ),
                (
                    "short_urls_enabled",
                    models.BooleanField(
                        default=False,
                        help_text="Please check the box if you want to use short urls.",
                        verbose_name="Activate short urls",
                    ),
                ),
                (
                    "icon",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="icon_regions",
                        to="cms.mediafile",
                        verbose_name="logo",
                    ),
                ),
                (
                    "offers",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Integreat offers are extended features apart from pages and events and are usually offered by a third party. In most cases, the url is an external API endpoint which the frontend apps can query and render the results inside the Integreat app.",
                        related_name="regions",
                        to="cms.OfferTemplate",
                        verbose_name="offers",
                    ),
                ),
            ],
            options={
                "verbose_name": "region",
                "verbose_name_plural": "regions",
                "ordering": ["name"],
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.CreateModel(
            name="PushNotification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "channel",
                    models.CharField(
                        choices=[("News", "News")],
                        max_length=60,
                        verbose_name="channel",
                    ),
                ),
                (
                    "draft",
                    models.BooleanField(
                        default=True,
                        help_text="Whether or not the push notification is a draft (drafts cannot be sent)",
                        verbose_name="draft",
                    ),
                ),
                (
                    "sent_date",
                    models.DateTimeField(
                        blank=True,
                        help_text="The date and time when the push notification was sent.",
                        null=True,
                        verbose_name="sent date",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="creation date"
                    ),
                ),
                (
                    "mode",
                    models.CharField(
                        choices=[
                            ("ONLY_AVAILABLE", "Only send available translations"),
                            (
                                "USE_MAIN_LANGUAGE",
                                "Use main language if no translation is available",
                            ),
                        ],
                        help_text="Sets behavior for dealing with not existing push notification translations",
                        max_length=128,
                        verbose_name="mode",
                    ),
                ),
                (
                    "region",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="push_notifications",
                        to="cms.region",
                        verbose_name="region",
                    ),
                ),
            ],
            options={
                "verbose_name": "push notification",
                "verbose_name_plural": "push notifications",
                "permissions": (
                    ("send_push_notification", "Can send push notification"),
                ),
                "default_permissions": ("change", "delete", "view"),
            },
        ),
        migrations.CreateModel(
            name="POITranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=1024, verbose_name="title")),
                (
                    "slug",
                    models.SlugField(
                        allow_unicode=True,
                        help_text="String identifier without spaces and special characters. Unique per region and language. Leave blank to generate unique parameter from title.",
                        max_length=1024,
                        verbose_name="link",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("DRAFT", "Draft"),
                            ("REVIEW", "Pending Review"),
                            ("PUBLIC", "Published"),
                            ("AUTO_SAVE", "Auto Save"),
                        ],
                        default="DRAFT",
                        max_length=9,
                        verbose_name="status",
                    ),
                ),
                ("content", models.TextField(blank=True, verbose_name="content")),
                (
                    "currently_in_translation",
                    models.BooleanField(
                        default=False,
                        help_text="Flag to indicate a translation is being updated by an external translator",
                        verbose_name="currently in translation",
                    ),
                ),
                (
                    "version",
                    models.PositiveIntegerField(default=0, verbose_name="revision"),
                ),
                (
                    "minor_edit",
                    models.BooleanField(
                        default=False,
                        help_text="Tick if this change does not require an update of translations in other languages.",
                        verbose_name="minor edit",
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "short_description",
                    models.CharField(max_length=2048, verbose_name="short description"),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="poi_translations",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="creator",
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="poi_translations",
                        to="cms.language",
                        verbose_name="language",
                    ),
                ),
                (
                    "poi",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="cms.poi",
                        verbose_name="location",
                    ),
                ),
            ],
            options={
                "verbose_name": "location translation",
                "verbose_name_plural": "location translations",
                "ordering": ["poi__pk", "-version"],
                "default_permissions": (),
                "default_related_name": "poi_translations",
            },
        ),
        migrations.AddField(
            model_name="poi",
            name="region",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="pois",
                to="cms.region",
                verbose_name="region",
            ),
        ),
        migrations.CreateModel(
            name="PageTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=1024, verbose_name="title")),
                (
                    "slug",
                    models.SlugField(
                        allow_unicode=True,
                        help_text="String identifier without spaces and special characters. Unique per region and language. Leave blank to generate unique parameter from title.",
                        max_length=1024,
                        verbose_name="link",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("DRAFT", "Draft"),
                            ("REVIEW", "Pending Review"),
                            ("PUBLIC", "Published"),
                            ("AUTO_SAVE", "Auto Save"),
                        ],
                        default="DRAFT",
                        max_length=9,
                        verbose_name="status",
                    ),
                ),
                ("content", models.TextField(blank=True, verbose_name="content")),
                (
                    "currently_in_translation",
                    models.BooleanField(
                        default=False,
                        help_text="Flag to indicate a translation is being updated by an external translator",
                        verbose_name="currently in translation",
                    ),
                ),
                (
                    "version",
                    models.PositiveIntegerField(default=0, verbose_name="revision"),
                ),
                (
                    "minor_edit",
                    models.BooleanField(
                        default=False,
                        help_text="Tick if this change does not require an update of translations in other languages.",
                        verbose_name="minor edit",
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="page_translations",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="creator",
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="page_translations",
                        to="cms.language",
                        verbose_name="language",
                    ),
                ),
                (
                    "page",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="cms.page",
                        verbose_name="page",
                    ),
                ),
            ],
            options={
                "verbose_name": "page translation",
                "verbose_name_plural": "page translations",
                "ordering": ["page__pk", "-version"],
                "default_permissions": (),
                "default_related_name": "page_translations",
            },
        ),
        migrations.AddField(
            model_name="page",
            name="region",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="pages",
                to="cms.region",
                verbose_name="region",
            ),
        ),
        migrations.AddField(
            model_name="mediafile",
            name="region",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="files",
                to="cms.region",
                verbose_name="region",
            ),
        ),
        migrations.CreateModel(
            name="ImprintPageTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=1024, verbose_name="title")),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("DRAFT", "Draft"),
                            ("REVIEW", "Pending Review"),
                            ("PUBLIC", "Published"),
                            ("AUTO_SAVE", "Auto Save"),
                        ],
                        default="DRAFT",
                        max_length=9,
                        verbose_name="status",
                    ),
                ),
                ("content", models.TextField(blank=True, verbose_name="content")),
                (
                    "currently_in_translation",
                    models.BooleanField(
                        default=False,
                        help_text="Flag to indicate a translation is being updated by an external translator",
                        verbose_name="currently in translation",
                    ),
                ),
                (
                    "version",
                    models.PositiveIntegerField(default=0, verbose_name="revision"),
                ),
                (
                    "minor_edit",
                    models.BooleanField(
                        default=False,
                        help_text="Tick if this change does not require an update of translations in other languages.",
                        verbose_name="minor edit",
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="imprint_translations",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="creator",
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="imprint_translations",
                        to="cms.language",
                        verbose_name="language",
                    ),
                ),
                (
                    "page",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="cms.imprintpage",
                        verbose_name="imprint",
                    ),
                ),
            ],
            options={
                "verbose_name": "imprint translation",
                "verbose_name_plural": "imprint translations",
                "ordering": ["page", "-version"],
                "default_permissions": (),
                "default_related_name": "imprint_translations",
            },
        ),
        migrations.AddField(
            model_name="imprintpage",
            name="region",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="imprints",
                to="cms.region",
                verbose_name="region",
            ),
        ),
        migrations.AddField(
            model_name="feedback",
            name="language",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="feedback",
                to="cms.language",
                verbose_name="language",
            ),
        ),
        migrations.AddField(
            model_name="feedback",
            name="polymorphic_ctype",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="polymorphic_cms.feedback_set+",
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AddField(
            model_name="feedback",
            name="read_by",
            field=models.ForeignKey(
                blank=True,
                help_text="The user who marked this feedback as read. If the feedback is unread, this field is empty.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="feedback",
                to=settings.AUTH_USER_MODEL,
                verbose_name="marked as read by",
            ),
        ),
        migrations.AddField(
            model_name="feedback",
            name="region",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="feedback",
                to="cms.region",
                verbose_name="region",
            ),
        ),
        migrations.CreateModel(
            name="EventTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=1024, verbose_name="title")),
                (
                    "slug",
                    models.SlugField(
                        allow_unicode=True,
                        help_text="String identifier without spaces and special characters. Unique per region and language. Leave blank to generate unique parameter from title.",
                        max_length=1024,
                        verbose_name="link",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("DRAFT", "Draft"),
                            ("REVIEW", "Pending Review"),
                            ("PUBLIC", "Published"),
                            ("AUTO_SAVE", "Auto Save"),
                        ],
                        default="DRAFT",
                        max_length=9,
                        verbose_name="status",
                    ),
                ),
                ("content", models.TextField(blank=True, verbose_name="content")),
                (
                    "currently_in_translation",
                    models.BooleanField(
                        default=False,
                        help_text="Flag to indicate a translation is being updated by an external translator",
                        verbose_name="currently in translation",
                    ),
                ),
                (
                    "version",
                    models.PositiveIntegerField(default=0, verbose_name="revision"),
                ),
                (
                    "minor_edit",
                    models.BooleanField(
                        default=False,
                        help_text="Tick if this change does not require an update of translations in other languages.",
                        verbose_name="minor edit",
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="event_translations",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="creator",
                    ),
                ),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="cms.event",
                        verbose_name="event",
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="event_translations",
                        to="cms.language",
                        verbose_name="language",
                    ),
                ),
            ],
            options={
                "verbose_name": "event translation",
                "verbose_name_plural": "event translations",
                "ordering": ["event__pk", "-version"],
                "default_permissions": (),
                "default_related_name": "event_translations",
            },
        ),
        migrations.AddField(
            model_name="event",
            name="icon",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="events",
                to="cms.mediafile",
                verbose_name="icon",
            ),
        ),
        migrations.AddField(
            model_name="event",
            name="location",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="events",
                to="cms.poi",
                verbose_name="location",
            ),
        ),
        migrations.AddField(
            model_name="event",
            name="recurrence_rule",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="event",
                to="cms.recurrencerule",
                verbose_name="recurrence rule",
            ),
        ),
        migrations.AddField(
            model_name="event",
            name="region",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="events",
                to="cms.region",
                verbose_name="region",
            ),
        ),
        migrations.AddField(
            model_name="directory",
            name="region",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="media_directories",
                to="cms.region",
                verbose_name="region",
            ),
        ),
        migrations.CreateModel(
            name="ChatMessage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("text", models.TextField(verbose_name="content")),
                (
                    "sent_datetime",
                    models.DateTimeField(auto_now_add=True, verbose_name="sent date"),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="chat_messages",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="sender",
                    ),
                ),
            ],
            options={
                "verbose_name": "chat message",
                "verbose_name_plural": "chat messages",
                "ordering": ["-sent_datetime"],
                "default_permissions": ("delete",),
            },
        ),
        migrations.AddField(
            model_name="user",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                help_text="This allows the user to edit and publish all pages for which the organisation is registered as the responsible organisation",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="members",
                to="cms.organization",
                verbose_name="organization",
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="regions",
            field=models.ManyToManyField(
                blank=True,
                help_text="The regions to which the user has access",
                related_name="users",
                to="cms.Region",
                verbose_name="regions",
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="user_permissions",
            field=models.ManyToManyField(
                blank=True,
                help_text="Specific permissions for this user.",
                related_name="user_set",
                related_query_name="user",
                to="auth.Permission",
                verbose_name="user permissions",
            ),
        ),
        migrations.CreateModel(
            name="UserMfaKey",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200, verbose_name="key name")),
                (
                    "key_id",
                    models.BinaryField(max_length=255, verbose_name="WebAuthn ID"),
                ),
                (
                    "public_key",
                    models.BinaryField(
                        max_length=255,
                        verbose_name="multi-factor-authentication public key",
                    ),
                ),
                (
                    "sign_count",
                    models.IntegerField(
                        help_text="Token to prevent replay attacks.",
                        verbose_name="sign count",
                    ),
                ),
                (
                    "last_usage",
                    models.DateTimeField(null=True, verbose_name="last date of use"),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="creation date"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="mfa_keys",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "multi-factor authentication key",
                "verbose_name_plural": "multi-factor authentication keys",
                "default_permissions": (),
                "unique_together": {("user", "name")},
            },
        ),
        migrations.CreateModel(
            name="PushNotificationTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    models.CharField(blank=True, max_length=250, verbose_name="title"),
                ),
                (
                    "text",
                    models.TextField(
                        blank=True, max_length=250, verbose_name="content"
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="push_notification_translations",
                        to="cms.language",
                        verbose_name="language",
                    ),
                ),
                (
                    "push_notification",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="cms.pushnotification",
                        verbose_name="push notification",
                    ),
                ),
            ],
            options={
                "verbose_name": "push notification translation",
                "verbose_name_plural": "push notification translations",
                "ordering": ["push_notification", "language"],
                "default_permissions": (),
                "unique_together": {("push_notification", "language")},
            },
        ),
        migrations.CreateModel(
            name="POIFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
                (
                    "poi_translation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="feedback",
                        to="cms.poitranslation",
                        verbose_name="location translation",
                    ),
                ),
            ],
            options={
                "verbose_name": "location feedback",
                "verbose_name_plural": "location feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="PageFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
                (
                    "page_translation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="feedback",
                        to="cms.pagetranslation",
                        verbose_name="page translation",
                    ),
                ),
            ],
            options={
                "verbose_name": "page feedback",
                "verbose_name_plural": "page feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="OfferFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
                (
                    "offer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="feedback",
                        to="cms.offertemplate",
                        verbose_name="offer",
                    ),
                ),
            ],
            options={
                "verbose_name": "offer feedback",
                "verbose_name_plural": "offer feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
        migrations.CreateModel(
            name="LanguageTreeNode",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("lft", models.PositiveIntegerField(db_index=True)),
                ("rgt", models.PositiveIntegerField(db_index=True)),
                ("tree_id", models.PositiveIntegerField(db_index=True)),
                ("depth", models.PositiveIntegerField(db_index=True)),
                (
                    "visible",
                    models.BooleanField(
                        default=True,
                        help_text="Defined if this language should be delivered via the API",
                        verbose_name="visible",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Defined if content in this language can be created or edited",
                        verbose_name="active",
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="creation date"
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True, verbose_name="modification date"
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="language_tree_nodes",
                        to="cms.language",
                        verbose_name="language",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="children",
                        to="cms.languagetreenode",
                        verbose_name="parent",
                    ),
                ),
                (
                    "region",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="language_tree_nodes",
                        to="cms.region",
                        verbose_name="region",
                    ),
                ),
            ],
            options={
                "verbose_name": "language tree node",
                "verbose_name_plural": "language tree nodes",
                "default_permissions": ("change", "delete", "view"),
                "default_related_name": "language_tree_nodes",
                "unique_together": {("language", "region")},
            },
        ),
        migrations.CreateModel(
            name="EventFeedback",
            fields=[
                (
                    "feedback_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cms.feedback",
                    ),
                ),
                (
                    "event_translation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="feedback",
                        to="cms.eventtranslation",
                        verbose_name="event translation",
                    ),
                ),
            ],
            options={
                "verbose_name": "event feedback",
                "verbose_name_plural": "event feedback",
                "default_permissions": (),
            },
            bases=("cms.feedback",),
        ),
    ]
