# Generated by Django 3.2.16 on 2022-11-06 10:53

from django.core.management.sql import emit_post_migrate_signal
from django.db import migrations
from ..constants import roles


# pylint: disable=unused-argument
def update_roles(apps, schema_editor):
    """
    Update analytics permissions

    :param apps: The configuration of installed applications
    :type apps: ~django.apps.registry.Apps

    :param schema_editor: The database abstraction layer that creates actual SQL code
    :type schema_editor: ~django.db.backends.base.schema.BaseDatabaseSchemaEditor
    """
    Group = apps.get_model("auth", "Group")
    Permission = apps.get_model("auth", "Permission")

    # Emit post-migrate signal to make sure the Permission objects are created before they can be assigned
    emit_post_migrate_signal(2, False, "default")

    # Clear and update permissions according to new constants
    for role_name in dict(roles.CHOICES):
        group, _ = Group.objects.get_or_create(name=role_name)
        # Clear permissions
        group.permissions.clear()
        # Set permissions
        group.permissions.add(
            *Permission.objects.filter(codename__in=roles.PERMISSIONS[role_name])
        )


class Migration(migrations.Migration):
    """
    Add perissions for analytics contents
    """

    dependencies = [
        ("cms", "0043_update_organization_permissions"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="user",
            options={
                "default_permissions": ("change", "delete", "view"),
                "ordering": ["username"],
                "permissions": (
                    ("view_translation_report", "view_translation_report"),
                    ("view_broken_links", "view_broken_links"),
                    ("view_statistics", "view_statistics"),
                ),
                "verbose_name": "user",
                "verbose_name_plural": "users",
            },
        ),
        migrations.RunPython(update_roles, migrations.RunPython.noop),
    ]
