# -*- coding: utf-8 -*-
# pylint: skip-file
# fmt: off
import numba as nb
import numpy as np

I = 1.j
Z0 = 0.
Z1 = 1.
HF = Z1/2
C1 = 4*Z1/3
C2 = Z1/3

FCT = np.array([1,1,2,6,24]) # FCT(0:4) -> no index shift
SGN = np.array([1,-1,1,-1,1]) # SGN(0:4) -> no index shift

S1 = np.full((4,4),np.nan) # S1(4,4) -> shift both first and second by -1

S1[1-1,1-1] = 1.64493_40668_482e0
S1[1-1,2-1] = 1.20205_69031_596e0
S1[1-1,3-1] = 1.08232_32337_111e0
S1[1-1,4-1] = 1.03692_77551_434e0
S1[2-1,1-1] = 1.20205_69031_596e0
S1[2-1,2-1] = 2.70580_80842_778e-1
S1[2-1,3-1] = 9.65511_59989_444e-2
S1[3-1,1-1] = 1.08232_32337_111e0
S1[3-1,2-1] = 9.65511_59989_444e-2
S1[4-1,1-1] = 1.03692_77551_434e0

C = np.full((4,4),np.nan) # C(4,4) -> shift both first and second by -1

C[1-1,1-1] =  1.64493_40668_482e0
C[1-1,2-1] =  1.20205_69031_596e0
C[1-1,3-1] =  1.08232_32337_111e0
C[1-1,4-1] =  1.03692_77551_434e0
C[2-1,1-1] =  0.00000_00000_000e0
C[2-1,2-1] = -1.89406_56589_945e0
C[2-1,3-1] = -3.01423_21054_407e0
C[3-1,1-1] =  1.89406_56589_945e0
C[3-1,2-1] =  3.01423_21054_407e0
C[4-1,1-1] =  0.00000_00000_000e0

INDEX = np.array([1,2,3,4]+6*[0]+[5,6,7]+7*[0]+[8,9]+8*[0]+[10]) # INDEX(31), shift index by -1

NC = np.array([24,26,28,30,22,24,26,19,22,17]) # NC(10), shift index by -1

A = np.full((31,10),np.nan) # A(0:30,10), so keep first but shift second index by -1

A[ 0,1-1] =  .96753_21504_3498e0
A[ 1,1-1] =  .16607_30329_2785e0
A[ 2,1-1] =  .02487_93229_2423e0
A[ 3,1-1] =  .00468_63619_5945e0
A[ 4,1-1] =  .00100_16274_9616e0
A[ 5,1-1] =  .00023_20021_9609e0
A[ 6,1-1] =  .00005_68178_2272e0
A[ 7,1-1] =  .00001_44963_0056e0
A[ 8,1-1] =  .00000_38163_2946e0
A[ 9,1-1] =  .00000_10299_0426e0
A[10,1-1] =  .00000_02835_7538e0
A[11,1-1] =  .00000_00793_8705e0
A[12,1-1] =  .00000_00225_3670e0
A[13,1-1] =  .00000_00064_7434e0
A[14,1-1] =  .00000_00018_7912e0
A[15,1-1] =  .00000_00005_5029e0
A[16,1-1] =  .00000_00001_6242e0
A[17,1-1] =  .00000_00000_4827e0
A[18,1-1] =  .00000_00000_1444e0
A[19,1-1] =  .00000_00000_0434e0
A[20,1-1] =  .00000_00000_0131e0
A[21,1-1] =  .00000_00000_0040e0
A[22,1-1] =  .00000_00000_0012e0
A[23,1-1] =  .00000_00000_0004e0
A[24,1-1] =  .00000_00000_0001e0

A[ 0,2-1] =  .95180_88912_7832e0
A[ 1,2-1] =  .43131_13184_6532e0
A[ 2,2-1] =  .10002_25071_4905e0
A[ 3,2-1] =  .02442_41559_5220e0
A[ 4,2-1] =  .00622_51246_3724e0
A[ 5,2-1] =  .00164_07883_1235e0
A[ 6,2-1] =  .00044_40792_0265e0
A[ 7,2-1] =  .00012_27749_4168e0
A[ 8,2-1] =  .00003_45398_1284e0
A[ 9,2-1] =  .00000_98586_9565e0
A[10,2-1] =  .00000_28485_6995e0
A[11,2-1] =  .00000_08317_0847e0
A[12,2-1] =  .00000_02450_3950e0
A[13,2-1] =  .00000_00727_6496e0
A[14,2-1] =  .00000_00217_5802e0
A[15,2-1] =  .00000_00065_4616e0
A[16,2-1] =  .00000_00019_8033e0
A[17,2-1] =  .00000_00006_0204e0
A[18,2-1] =  .00000_00001_8385e0
A[19,2-1] =  .00000_00000_5637e0
A[20,2-1] =  .00000_00000_1735e0
A[21,2-1] =  .00000_00000_0536e0
A[22,2-1] =  .00000_00000_0166e0
A[23,2-1] =  .00000_00000_0052e0
A[24,2-1] =  .00000_00000_0016e0
A[25,2-1] =  .00000_00000_0005e0
A[26,2-1] =  .00000_00000_0002e0

A[ 0,3-1] =  .98161_02799_1365e0
A[ 1,3-1] =  .72926_80632_0726e0
A[ 2,3-1] =  .22774_71490_9321e0
A[ 3,3-1] =  .06809_08329_6197e0
A[ 4,3-1] =  .02013_70118_3064e0
A[ 5,3-1] =  .00595_47848_0197e0
A[ 6,3-1] =  .00176_76901_3959e0
A[ 7,3-1] =  .00052_74821_8502e0
A[ 8,3-1] =  .00015_82746_1460e0
A[ 9,3-1] =  .00004_77492_2076e0
A[10,3-1] =  .00001_44792_0408e0
A[11,3-1] =  .00000_44115_4886e0
A[12,3-1] =  .00000_13500_3870e0
A[13,3-1] =  .00000_04148_1779e0
A[14,3-1] =  .00000_01279_3307e0
A[15,3-1] =  .00000_00395_9070e0
A[16,3-1] =  .00000_00122_9055e0
A[17,3-1] =  .00000_00038_2658e0
A[18,3-1] =  .00000_00011_9459e0
A[19,3-1] =  .00000_00003_7386e0
A[20,3-1] =  .00000_00001_1727e0
A[21,3-1] =  .00000_00000_3687e0
A[22,3-1] =  .00000_00000_1161e0
A[23,3-1] =  .00000_00000_0366e0
A[24,3-1] =  .00000_00000_0116e0
A[25,3-1] =  .00000_00000_0037e0
A[26,3-1] =  .00000_00000_0012e0
A[27,3-1] =  .00000_00000_0004e0
A[28,3-1] =  .00000_00000_0001e0

A[ 0,4-1] = 1.06405_21184_614e0
A[ 1,4-1] = 1.06917_20744_981e0
A[ 2,4-1] =  .41527_19325_1768e0
A[ 3,4-1] =  .14610_33293_6222e0
A[ 4,4-1] =  .04904_73264_8784e0
A[ 5,4-1] =  .01606_34086_0396e0
A[ 6,4-1] =  .00518_88935_0790e0
A[ 7,4-1] =  .00166_29871_7324e0
A[ 8,4-1] =  .00053_05827_9969e0
A[ 9,4-1] =  .00016_88702_9251e0
A[10,4-1] =  .00005_36832_8059e0
A[11,4-1] =  .00001_70592_3313e0
A[12,4-1] =  .00000_54217_4374e0
A[13,4-1] =  .00000_17239_4082e0
A[14,4-1] =  .00000_05485_3275e0
A[15,4-1] =  .00000_01746_7795e0
A[16,4-1] =  .00000_00556_7550e0
A[17,4-1] =  .00000_00177_6234e0
A[18,4-1] =  .00000_00056_7224e0
A[19,4-1] =  .00000_00018_1313e0
A[20,4-1] =  .00000_00005_8012e0
A[21,4-1] =  .00000_00001_8579e0
A[22,4-1] =  .00000_00000_5955e0
A[23,4-1] =  .00000_00000_1911e0
A[24,4-1] =  .00000_00000_0614e0
A[25,4-1] =  .00000_00000_0197e0
A[26,4-1] =  .00000_00000_0063e0
A[27,4-1] =  .00000_00000_0020e0
A[28,4-1] =  .00000_00000_0007e0
A[29,4-1] =  .00000_00000_0002e0
A[30,4-1] =  .00000_00000_0001e0

A[ 0,5-1] =  .97920_86066_9175e0
A[ 1,5-1] =  .08518_81314_8683e0
A[ 2,5-1] =  .00855_98522_2013e0
A[ 3,5-1] =  .00121_17721_4413e0
A[ 4,5-1] =  .00020_72276_8531e0
A[ 5,5-1] =  .00003_99695_8691e0
A[ 6,5-1] =  .00000_83806_4065e0
A[ 7,5-1] =  .00000_18684_8945e0
A[ 8,5-1] =  .00000_04366_6087e0
A[ 9,5-1] =  .00000_01059_1733e0
A[10,5-1] =  .00000_00264_7892e0
A[11,5-1] =  .00000_00067_8700e0
A[12,5-1] =  .00000_00017_7654e0
A[13,5-1] =  .00000_00004_7342e0
A[14,5-1] =  .00000_00001_2812e0
A[15,5-1] =  .00000_00000_3514e0
A[16,5-1] =  .00000_00000_0975e0
A[17,5-1] =  .00000_00000_0274e0
A[18,5-1] =  .00000_00000_0077e0
A[19,5-1] =  .00000_00000_0022e0
A[20,5-1] =  .00000_00000_0006e0
A[21,5-1] =  .00000_00000_0002e0
A[22,5-1] =  .00000_00000_0001e0

A[ 0,6-1] =  .95021_85196_3952e0
A[ 1,6-1] =  .29052_52916_1433e0
A[ 2,6-1] =  .05081_77406_1716e0
A[ 3,6-1] =  .00995_54376_7280e0
A[ 4,6-1] =  .00211_73389_5031e0
A[ 5,6-1] =  .00047_85947_0550e0
A[ 6,6-1] =  .00011_33432_1308e0
A[ 7,6-1] =  .00002_78473_3104e0
A[ 8,6-1] =  .00000_70478_8108e0
A[ 9,6-1] =  .00000_18278_8740e0
A[10,6-1] =  .00000_04838_7492e0
A[11,6-1] =  .00000_01303_3842e0
A[12,6-1] =  .00000_00356_3769e0
A[13,6-1] =  .00000_00098_7174e0
A[14,6-1] =  .00000_00027_6586e0
A[15,6-1] =  .00000_00007_8279e0
A[16,6-1] =  .00000_00002_2354e0
A[17,6-1] =  .00000_00000_6435e0
A[18,6-1] =  .00000_00000_1866e0
A[19,6-1] =  .00000_00000_0545e0
A[20,6-1] =  .00000_00000_0160e0
A[21,6-1] =  .00000_00000_0047e0
A[22,6-1] =  .00000_00000_0014e0
A[23,6-1] =  .00000_00000_0004e0
A[24,6-1] =  .00000_00000_0001e0

A[ 0,7-1] =  .95064_03218_6777e0
A[ 1,7-1] =  .54138_28546_5171e0
A[ 2,7-1] =  .13649_97959_0321e0
A[ 3,7-1] =  .03417_94232_8207e0
A[ 4,7-1] =  .00869_02788_3583e0
A[ 5,7-1] =  .00225_28408_4155e0
A[ 6,7-1] =  .00059_51608_9806e0
A[ 7,7-1] =  .00015_99561_7766e0
A[ 8,7-1] =  .00004_36521_3096e0
A[ 9,7-1] =  .00001_20747_4688e0
A[10,7-1] =  .00000_33801_8176e0
A[11,7-1] =  .00000_09563_2476e0
A[12,7-1] =  .00000_02731_3129e0
A[13,7-1] =  .00000_00786_6968e0
A[14,7-1] =  .00000_00228_3195e0
A[15,7-1] =  .00000_00066_7205e0
A[16,7-1] =  .00000_00019_6191e0
A[17,7-1] =  .00000_00005_8018e0
A[18,7-1] =  .00000_00001_7246e0
A[19,7-1] =  .00000_00000_5151e0
A[20,7-1] =  .00000_00000_1545e0
A[21,7-1] =  .00000_00000_0465e0
A[22,7-1] =  .00000_00000_0141e0
A[23,7-1] =  .00000_00000_0043e0
A[24,7-1] =  .00000_00000_0013e0
A[25,7-1] =  .00000_00000_0004e0
A[26,7-1] =  .00000_00000_0001e0

A[ 0,8-1] =  .98800_01167_2229e0
A[ 1,8-1] =  .04364_06760_9601e0
A[ 2,8-1] =  .00295_09117_8278e0
A[ 3,8-1] =  .00031_47780_9720e0
A[ 4,8-1] =  .00004_31484_6029e0
A[ 5,8-1] =  .00000_69381_8230e0
A[ 6,8-1] =  .00000_12464_0350e0
A[ 7,8-1] =  .00000_02429_3628e0
A[ 8,8-1] =  .00000_00504_0827e0
A[ 9,8-1] =  .00000_00109_9075e0
A[10,8-1] =  .00000_00024_9467e0
A[11,8-1] =  .00000_00005_8540e0
A[12,8-1] =  .00000_00001_4127e0
A[13,8-1] =  .00000_00000_3492e0
A[14,8-1] =  .00000_00000_0881e0
A[15,8-1] =  .00000_00000_0226e0
A[16,8-1] =  .00000_00000_0059e0
A[17,8-1] =  .00000_00000_0016e0
A[18,8-1] =  .00000_00000_0004e0
A[19,8-1] =  .00000_00000_0001e0

A[ 0,9-1] =  .95768_50654_6350e0
A[ 1,9-1] =  .19725_24967_9534e0
A[ 2,9-1] =  .02603_37031_3918e0
A[ 3,9-1] =  .00409_38216_8261e0
A[ 4,9-1] =  .00072_68170_7110e0
A[ 5,9-1] =  .00014_09187_9261e0
A[ 6,9-1] =  .00002_92045_8914e0
A[ 7,9-1] =  .00000_63763_1144e0
A[ 8,9-1] =  .00000_14516_7850e0
A[ 9,9-1] =  .00000_03420_5281e0
A[10,9-1] =  .00000_00829_4302e0
A[11,9-1] =  .00000_00206_0784e0
A[12,9-1] =  .00000_00052_2823e0
A[13,9-1] =  .00000_00013_5066e0
A[14,9-1] =  .00000_00003_5451e0
A[15,9-1] =  .00000_00000_9436e0
A[16,9-1] =  .00000_00000_2543e0
A[17,9-1] =  .00000_00000_0693e0
A[18,9-1] =  .00000_00000_0191e0
A[19,9-1] =  .00000_00000_0053e0
A[20,9-1] =  .00000_00000_0015e0
A[21,9-1] =  .00000_00000_0004e0
A[22,9-1] =  .00000_00000_0001e0

A[ 0,10-1] =  .99343_65167_1347e0
A[ 1,10-1] =  .02225_77012_6826e0
A[ 2,10-1] =  .00101_47557_4703e0
A[ 3,10-1] =  .00008_17515_6250e0
A[ 4,10-1] =  .00000_89997_3547e0
A[ 5,10-1] =  .00000_12082_3987e0
A[ 6,10-1] =  .00000_01861_6913e0
A[ 7,10-1] =  .00000_00317_4723e0
A[ 8,10-1] =  .00000_00058_5215e0
A[ 9,10-1] =  .00000_00011_4739e0
A[10,10-1] =  .00000_00002_3652e0
A[11,10-1] =  .00000_00000_5082e0
A[12,10-1] =  .00000_00000_1131e0
A[13,10-1] =  .00000_00000_0259e0
A[14,10-1] =  .00000_00000_0061e0
A[15,10-1] =  .00000_00000_0015e0
A[16,10-1] =  .00000_00000_0004e0
A[17,10-1] =  .00000_00000_0001e0

@nb.njit("c16(i8,i8,f8)", cache=True)
def nielsen(N, M, X):
    """Compute Nielsen's Generalized Polylogarithm.

    Reimplementation of CGPLG (C321) from CERNlib :cite:`cernlib`.

    Parameters
    ----------
    N : int
        first index
    M : int
        second index
    X : complex
        argument

    Returns
    -------
    complex
        :math:`S_{n,m}(x)`

    """
    U = np.full(5,np.nan*1j) # U(0:4), so keep indices
    V = np.full(6,np.nan*1j) # V(0:5), so keep indices

    if N < 1 or N > 4 or M < 1 or M > 4 or N+M > 5:
        raise ValueError("ILLEGAL VALUES N,M")
    if X==1.:
        return S1[N-1,M-1]
    if X > 2. or X < -1.:
        X1=1./X
        H=C1*X1+C2
        ALFA=H+H
        V[0]=1.
        V[1]=np.log(-X+I*Z0)
        for L in range(2,N+M+1):
            V[L]=V[1]*V[L-1]/L
        SK=0.
        for K in range(0,M-1+1):
            M1=M-K
            R=X1**M1/(FCT[M1]*FCT[N-1])
            SJ=0.
            for J in range(0,K+1):
                N1=N+K-J
                L=INDEX[10*N1+M1-10-1]
                B1=0.
                B2=0.
                for IT in range(NC[L-1],0-1,-1):
                    B0=A[IT,L-1]+ALFA*B1-B2
                    B2=B1
                    B1=B0
                Q=(FCT[N1-1]/FCT[K-J])*(B0-H*B2)*R/M1**N1
                SJ=SJ+V[J]*Q
            SK=SK+SGN[K]*SJ
        SJ=0.
        for J in range(0,N-1+1):
            SJ=SJ+V[J]*C[N-J-1,M-1]
        return SGN[N]*SK+SGN[M]*(SJ+V[N+M])
    if X > HF:
        X1=1.-X
        H=C1*X1+C2
        ALFA=H+H
        V[0]=1.
        U[0]=1.
        V[1]=np.log(X1+I*Z0)
        U[1]=np.log(X)
        for L in range (2,M+1):
            V[L]=V[1]*V[L-1]/L
        for L in range(2,N+1):
            U[L]=U[1]*U[L-1]/L
        SK=0.
        for K in range (0,N-1+1):
            M1=N-K
            R=X1**M1/FCT[M1]
            SJ=0.
            for J in range(0,M-1+1):
                N1=M-J
                L=INDEX[10*N1+M1-10-1]
                B1=0.
                B2=0.
                for IT in range(NC[L-1],0-1,-1):
                    B0=A[IT,L-1]+ALFA*B1-B2
                    B2=B1
                    B1=B0
                Q=SGN[J]*(B0-H*B2)*R/M1**N1
                SJ=SJ+V[J]*Q
            SK=SK+U[K]*(S1[M1-1,M-1]-SJ)
        return SK+SGN[M]*U[N]*V[M]
    # else
    L=INDEX[10*N+M-10-1]
    H=C1*X+C2
    ALFA=H+H
    B1=0.
    B2=0.
    for IT in range(NC[L-1],0-1,-1):
        B0=A[IT,L-1]+ALFA*B1-B2
        B2=B1
        B1=B0
    return (B0-H*B2)*X**M/(FCT[M]*M**N)
