# coding: utf-8

"""
    endoflife.date

    Documentation for the endoflife.date API. The API is currently in Alpha. Additional information about the API can be found on the [endoflife.date wiki](https://github.com/endoflife-date/endoflife.date/wiki)

    The version of the OpenAPI document: 0.0.1
    Contact: blah@cliffano.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field

class Cycle(BaseModel):
    """
    Details of a single release cycle of a given product. There might be some slight variations to this depending on the product.
    """
    cycle: Optional[Any] = Field(None, description="Release Cycle")
    release_date: Optional[Any] = Field(None, alias="releaseDate", description="Release Date for the first release in this cycle")
    eol: Optional[Any] = Field(None, description="End of Life Date for this release cycle")
    latest: Optional[Any] = Field(None, description="Latest release in this cycle")
    link: Optional[Any] = Field(None, description="Link to changelog for the latest release, if available")
    lts: Optional[Any] = Field(None, description="Whether this release cycle has long-term-support (LTS). Can be a date instead in YYYY-MM-DD format as well if the release enters LTS status on a given date. ")
    support: Optional[Any] = Field(None, description="Whether this release cycle has active support")
    discontinued: Optional[Any] = Field(None, description="Whether this cycle is now discontinued.")
    __properties = ["cycle", "releaseDate", "eol", "latest", "link", "lts", "support", "discontinued"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Cycle:
        """Create an instance of Cycle from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if cycle (nullable) is None
        # and __fields_set__ contains the field
        if self.cycle is None and "cycle" in self.__fields_set__:
            _dict['cycle'] = None

        # set to None if release_date (nullable) is None
        # and __fields_set__ contains the field
        if self.release_date is None and "release_date" in self.__fields_set__:
            _dict['releaseDate'] = None

        # set to None if eol (nullable) is None
        # and __fields_set__ contains the field
        if self.eol is None and "eol" in self.__fields_set__:
            _dict['eol'] = None

        # set to None if latest (nullable) is None
        # and __fields_set__ contains the field
        if self.latest is None and "latest" in self.__fields_set__:
            _dict['latest'] = None

        # set to None if link (nullable) is None
        # and __fields_set__ contains the field
        if self.link is None and "link" in self.__fields_set__:
            _dict['link'] = None

        # set to None if lts (nullable) is None
        # and __fields_set__ contains the field
        if self.lts is None and "lts" in self.__fields_set__:
            _dict['lts'] = None

        # set to None if support (nullable) is None
        # and __fields_set__ contains the field
        if self.support is None and "support" in self.__fields_set__:
            _dict['support'] = None

        # set to None if discontinued (nullable) is None
        # and __fields_set__ contains the field
        if self.discontinued is None and "discontinued" in self.__fields_set__:
            _dict['discontinued'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Cycle:
        """Create an instance of Cycle from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Cycle.parse_obj(obj)

        _obj = Cycle.parse_obj({
            "cycle": obj.get("cycle"),
            "release_date": obj.get("releaseDate"),
            "eol": obj.get("eol"),
            "latest": obj.get("latest"),
            "link": obj.get("link"),
            "lts": obj.get("lts"),
            "support": obj.get("support"),
            "discontinued": obj.get("discontinued")
        })
        return _obj


