# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAnnouncementSubscriptionResult',
    'AwaitableGetAnnouncementSubscriptionResult',
    'get_announcement_subscription',
    'get_announcement_subscription_output',
]

@pulumi.output_type
class GetAnnouncementSubscriptionResult:
    """
    A collection of values returned by getAnnouncementSubscription.
    """
    def __init__(__self__, announcement_subscription_id=None, compartment_id=None, defined_tags=None, description=None, display_name=None, filter_groups=None, freeform_tags=None, id=None, lifecycle_details=None, ons_topic_id=None, preferred_language=None, preferred_time_zone=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if announcement_subscription_id and not isinstance(announcement_subscription_id, str):
            raise TypeError("Expected argument 'announcement_subscription_id' to be a str")
        pulumi.set(__self__, "announcement_subscription_id", announcement_subscription_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filter_groups and not isinstance(filter_groups, list):
            raise TypeError("Expected argument 'filter_groups' to be a list")
        pulumi.set(__self__, "filter_groups", filter_groups)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ons_topic_id and not isinstance(ons_topic_id, str):
            raise TypeError("Expected argument 'ons_topic_id' to be a str")
        pulumi.set(__self__, "ons_topic_id", ons_topic_id)
        if preferred_language and not isinstance(preferred_language, str):
            raise TypeError("Expected argument 'preferred_language' to be a str")
        pulumi.set(__self__, "preferred_language", preferred_language)
        if preferred_time_zone and not isinstance(preferred_time_zone, str):
            raise TypeError("Expected argument 'preferred_time_zone' to be a str")
        pulumi.set(__self__, "preferred_time_zone", preferred_time_zone)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="announcementSubscriptionId")
    def announcement_subscription_id(self) -> str:
        return pulumi.get(self, "announcement_subscription_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the announcement subscription.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the announcement subscription. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the announcement subscription. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterGroups")
    def filter_groups(self) -> Sequence['outputs.GetAnnouncementSubscriptionFilterGroupResult']:
        """
        A list of filter groups for the announcement subscription. A filter group is a combination of multiple filters applied to announcements for matching purposes.
        """
        return pulumi.get(self, "filter_groups")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the announcement subscription.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current lifecycle state in more detail. For example, details might provide required or recommended actions for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> str:
        """
        The OCID of the Notifications service topic that is the target for publishing announcements that match the configured announcement subscription.
        """
        return pulumi.get(self, "ons_topic_id")

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> str:
        """
        (For announcement subscriptions with Oracle Fusion Applications configured as the service only) The language in which the user prefers to receive emailed announcements. Specify the preference with a value that uses the language tag format (x-obmcs-human-language). For example fr-FR.
        """
        return pulumi.get(self, "preferred_language")

    @property
    @pulumi.getter(name="preferredTimeZone")
    def preferred_time_zone(self) -> str:
        """
        The time zone that the user prefers for announcement time stamps. Specify the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example America/Los_Angeles.
        """
        return pulumi.get(self, "preferred_time_zone")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the announcement subscription.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the announcement subscription was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time that the announcement subscription was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAnnouncementSubscriptionResult(GetAnnouncementSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnnouncementSubscriptionResult(
            announcement_subscription_id=self.announcement_subscription_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            filter_groups=self.filter_groups,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            ons_topic_id=self.ons_topic_id,
            preferred_language=self.preferred_language,
            preferred_time_zone=self.preferred_time_zone,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_announcement_subscription(announcement_subscription_id: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnnouncementSubscriptionResult:
    """
    This data source provides details about a specific Announcement Subscription resource in Oracle Cloud Infrastructure Announcements Service service.

    Gets the specified announcement subscription.

    This call is subject to an Announcements limit that applies to the total number of requests across all read or write operations. Announcements might throttle this call to reject an otherwise valid request when the total rate of operations exceeds 20 requests per second for a given user. The service might also throttle this call to reject an otherwise valid request when the total rate of operations exceeds 100 requests per second for a given tenancy.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_announcement_subscription = oci.AnnouncementsService.get_announcement_subscription(announcement_subscription_id=oci_announcements_service_announcement_subscription["test_announcement_subscription"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str announcement_subscription_id: The OCID of the announcement subscription.
    """
    __args__ = dict()
    __args__['announcementSubscriptionId'] = announcement_subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AnnouncementsService/getAnnouncementSubscription:getAnnouncementSubscription', __args__, opts=opts, typ=GetAnnouncementSubscriptionResult).value

    return AwaitableGetAnnouncementSubscriptionResult(
        announcement_subscription_id=pulumi.get(__ret__, 'announcement_subscription_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filter_groups=pulumi.get(__ret__, 'filter_groups'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        ons_topic_id=pulumi.get(__ret__, 'ons_topic_id'),
        preferred_language=pulumi.get(__ret__, 'preferred_language'),
        preferred_time_zone=pulumi.get(__ret__, 'preferred_time_zone'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_announcement_subscription)
def get_announcement_subscription_output(announcement_subscription_id: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAnnouncementSubscriptionResult]:
    """
    This data source provides details about a specific Announcement Subscription resource in Oracle Cloud Infrastructure Announcements Service service.

    Gets the specified announcement subscription.

    This call is subject to an Announcements limit that applies to the total number of requests across all read or write operations. Announcements might throttle this call to reject an otherwise valid request when the total rate of operations exceeds 20 requests per second for a given user. The service might also throttle this call to reject an otherwise valid request when the total rate of operations exceeds 100 requests per second for a given tenancy.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_announcement_subscription = oci.AnnouncementsService.get_announcement_subscription(announcement_subscription_id=oci_announcements_service_announcement_subscription["test_announcement_subscription"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str announcement_subscription_id: The OCID of the announcement subscription.
    """
    ...
