# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAgentDependencyResult',
    'AwaitableGetAgentDependencyResult',
    'get_agent_dependency',
    'get_agent_dependency_output',
]

@pulumi.output_type
class GetAgentDependencyResult:
    """
    A collection of values returned by getAgentDependency.
    """
    def __init__(__self__, agent_dependency_id=None, bucket=None, checksum=None, compartment_id=None, defined_tags=None, dependency_name=None, dependency_version=None, description=None, display_name=None, e_tag=None, freeform_tags=None, id=None, lifecycle_details=None, namespace=None, object=None, state=None, system_tags=None, time_created=None):
        if agent_dependency_id and not isinstance(agent_dependency_id, str):
            raise TypeError("Expected argument 'agent_dependency_id' to be a str")
        pulumi.set(__self__, "agent_dependency_id", agent_dependency_id)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if checksum and not isinstance(checksum, str):
            raise TypeError("Expected argument 'checksum' to be a str")
        pulumi.set(__self__, "checksum", checksum)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if dependency_name and not isinstance(dependency_name, str):
            raise TypeError("Expected argument 'dependency_name' to be a str")
        pulumi.set(__self__, "dependency_name", dependency_name)
        if dependency_version and not isinstance(dependency_version, str):
            raise TypeError("Expected argument 'dependency_version' to be a str")
        pulumi.set(__self__, "dependency_version", dependency_version)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if e_tag and not isinstance(e_tag, str):
            raise TypeError("Expected argument 'e_tag' to be a str")
        pulumi.set(__self__, "e_tag", e_tag)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if object and not isinstance(object, str):
            raise TypeError("Expected argument 'object' to be a str")
        pulumi.set(__self__, "object", object)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="agentDependencyId")
    def agent_dependency_id(self) -> str:
        return pulumi.get(self, "agent_dependency_id")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object storage bucket where the Agent dependency is uploaded.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        The checksum associated with the dependency object returned by Object Storage.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="dependencyName")
    def dependency_name(self) -> str:
        """
        Name of the dependency type. This should match the whitelisted enum of dependency names.
        """
        return pulumi.get(self, "dependency_name")

    @property
    @pulumi.getter(name="dependencyVersion")
    def dependency_version(self) -> str:
        """
        Version of the Agent dependency.
        """
        return pulumi.get(self, "dependency_version")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description about the Agent dependency.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the Agent dependency.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> str:
        """
        The eTag associated with the dependency object returned by Object Storage.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace associated with the customer's tenancy.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the dependency object uploaded by the customer.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of AgentDependency.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the AgentDependency was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetAgentDependencyResult(GetAgentDependencyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentDependencyResult(
            agent_dependency_id=self.agent_dependency_id,
            bucket=self.bucket,
            checksum=self.checksum,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            dependency_name=self.dependency_name,
            dependency_version=self.dependency_version,
            description=self.description,
            display_name=self.display_name,
            e_tag=self.e_tag,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            namespace=self.namespace,
            object=self.object,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created)


def get_agent_dependency(agent_dependency_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentDependencyResult:
    """
    This data source provides details about a specific Agent Dependency resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets an AgentDependency by identifier.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent_dependency = oci.CloudBridge.get_agent_dependency(agent_dependency_id=oci_cloud_bridge_agent_dependency["test_agent_dependency"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str agent_dependency_id: A unique AgentDependency identifier.
    """
    __args__ = dict()
    __args__['agentDependencyId'] = agent_dependency_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudBridge/getAgentDependency:getAgentDependency', __args__, opts=opts, typ=GetAgentDependencyResult).value

    return AwaitableGetAgentDependencyResult(
        agent_dependency_id=pulumi.get(__ret__, 'agent_dependency_id'),
        bucket=pulumi.get(__ret__, 'bucket'),
        checksum=pulumi.get(__ret__, 'checksum'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        dependency_name=pulumi.get(__ret__, 'dependency_name'),
        dependency_version=pulumi.get(__ret__, 'dependency_version'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        e_tag=pulumi.get(__ret__, 'e_tag'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        namespace=pulumi.get(__ret__, 'namespace'),
        object=pulumi.get(__ret__, 'object'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_agent_dependency)
def get_agent_dependency_output(agent_dependency_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAgentDependencyResult]:
    """
    This data source provides details about a specific Agent Dependency resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets an AgentDependency by identifier.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent_dependency = oci.CloudBridge.get_agent_dependency(agent_dependency_id=oci_cloud_bridge_agent_dependency["test_agent_dependency"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str agent_dependency_id: A unique AgentDependency identifier.
    """
    ...
