# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 memory_in_mbs: pulumi.Input[str],
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_digest: Optional[pulumi.Input[str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']] = None,
                 source_details: Optional[pulumi.Input['FunctionSourceDetailsArgs']] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 trace_config: Optional[pulumi.Input['FunctionTraceConfigArgs']] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[str] application_id: The OCID of the application this function belongs to.
        :param pulumi.Input[str] display_name: The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        :param pulumi.Input[str] memory_in_mbs: (Updatable) Maximum usable memory for the function (MiB).
        :param pulumi.Input[Mapping[str, Any]] config: (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
               
               The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image: (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param pulumi.Input[str] image_digest: (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param pulumi.Input['FunctionProvisionedConcurrencyConfigArgs'] provisioned_concurrency_config: (Updatable) Define the strategy for provisioned concurrency for the function.
        :param pulumi.Input['FunctionSourceDetailsArgs'] source_details: The source details for the Function. The function can be created from various sources.
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Timeout for executions of the function. Value in seconds.
        :param pulumi.Input['FunctionTraceConfigArgs'] trace_config: (Updatable) Define the tracing configuration for a function.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_digest is not None:
            pulumi.set(__self__, "image_digest", image_digest)
        if provisioned_concurrency_config is not None:
            pulumi.set(__self__, "provisioned_concurrency_config", provisioned_concurrency_config)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if trace_config is not None:
            pulumi.set(__self__, "trace_config", trace_config)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        The OCID of the application this function belongs to.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> pulumi.Input[str]:
        """
        (Updatable) Maximum usable memory for the function (MiB).
        """
        return pulumi.get(self, "memory_in_mbs")

    @memory_in_mbs.setter
    def memory_in_mbs(self, value: pulumi.Input[str]):
        pulumi.set(self, "memory_in_mbs", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`

        The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        """
        return pulumi.get(self, "image_digest")

    @image_digest.setter
    def image_digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_digest", value)

    @property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']]:
        """
        (Updatable) Define the strategy for provisioned concurrency for the function.
        """
        return pulumi.get(self, "provisioned_concurrency_config")

    @provisioned_concurrency_config.setter
    def provisioned_concurrency_config(self, value: Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']]):
        pulumi.set(self, "provisioned_concurrency_config", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['FunctionSourceDetailsArgs']]:
        """
        The source details for the Function. The function can be created from various sources.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['FunctionSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Timeout for executions of the function. Value in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="traceConfig")
    def trace_config(self) -> Optional[pulumi.Input['FunctionTraceConfigArgs']]:
        """
        (Updatable) Define the tracing configuration for a function.
        """
        return pulumi.get(self, "trace_config")

    @trace_config.setter
    def trace_config(self, value: Optional[pulumi.Input['FunctionTraceConfigArgs']]):
        pulumi.set(self, "trace_config", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_digest: Optional[pulumi.Input[str]] = None,
                 invoke_endpoint: Optional[pulumi.Input[str]] = None,
                 memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 source_details: Optional[pulumi.Input['FunctionSourceDetailsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 trace_config: Optional[pulumi.Input['FunctionTraceConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[str] application_id: The OCID of the application this function belongs to.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the function.
        :param pulumi.Input[Mapping[str, Any]] config: (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
               
               The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image: (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param pulumi.Input[str] image_digest: (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param pulumi.Input[str] invoke_endpoint: The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        :param pulumi.Input[str] memory_in_mbs: (Updatable) Maximum usable memory for the function (MiB).
        :param pulumi.Input['FunctionProvisionedConcurrencyConfigArgs'] provisioned_concurrency_config: (Updatable) Define the strategy for provisioned concurrency for the function.
        :param pulumi.Input[str] shape: The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        :param pulumi.Input['FunctionSourceDetailsArgs'] source_details: The source details for the Function. The function can be created from various sources.
        :param pulumi.Input[str] state: The current state of the function.
        :param pulumi.Input[str] time_created: The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Timeout for executions of the function. Value in seconds.
        :param pulumi.Input['FunctionTraceConfigArgs'] trace_config: (Updatable) Define the tracing configuration for a function.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_digest is not None:
            pulumi.set(__self__, "image_digest", image_digest)
        if invoke_endpoint is not None:
            pulumi.set(__self__, "invoke_endpoint", invoke_endpoint)
        if memory_in_mbs is not None:
            pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        if provisioned_concurrency_config is not None:
            pulumi.set(__self__, "provisioned_concurrency_config", provisioned_concurrency_config)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if trace_config is not None:
            pulumi.set(__self__, "trace_config", trace_config)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the application this function belongs to.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that contains the function.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`

        The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        """
        return pulumi.get(self, "image_digest")

    @image_digest.setter
    def image_digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_digest", value)

    @property
    @pulumi.getter(name="invokeEndpoint")
    def invoke_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        """
        return pulumi.get(self, "invoke_endpoint")

    @invoke_endpoint.setter
    def invoke_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_endpoint", value)

    @property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Maximum usable memory for the function (MiB).
        """
        return pulumi.get(self, "memory_in_mbs")

    @memory_in_mbs.setter
    def memory_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory_in_mbs", value)

    @property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']]:
        """
        (Updatable) Define the strategy for provisioned concurrency for the function.
        """
        return pulumi.get(self, "provisioned_concurrency_config")

    @provisioned_concurrency_config.setter
    def provisioned_concurrency_config(self, value: Optional[pulumi.Input['FunctionProvisionedConcurrencyConfigArgs']]):
        pulumi.set(self, "provisioned_concurrency_config", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['FunctionSourceDetailsArgs']]:
        """
        The source details for the Function. The function can be created from various sources.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['FunctionSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the function.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Timeout for executions of the function. Value in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="traceConfig")
    def trace_config(self) -> Optional[pulumi.Input['FunctionTraceConfigArgs']]:
        """
        (Updatable) Define the tracing configuration for a function.
        """
        return pulumi.get(self, "trace_config")

    @trace_config.setter
    def trace_config(self, value: Optional[pulumi.Input['FunctionTraceConfigArgs']]):
        pulumi.set(self, "trace_config", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_digest: Optional[pulumi.Input[str]] = None,
                 memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input[pulumi.InputType['FunctionProvisionedConcurrencyConfigArgs']]] = None,
                 source_details: Optional[pulumi.Input[pulumi.InputType['FunctionSourceDetailsArgs']]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 trace_config: Optional[pulumi.Input[pulumi.InputType['FunctionTraceConfigArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Function resource in Oracle Cloud Infrastructure Functions service.

        Creates a new function.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_function = oci.functions.Function("testFunction",
            application_id=oci_functions_application["test_application"]["id"],
            display_name=var["function_display_name"],
            memory_in_mbs=var["function_memory_in_mbs"],
            config=var["function_config"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            image=var["function_image"],
            image_digest=var["function_image_digest"],
            provisioned_concurrency_config=oci.functions.FunctionProvisionedConcurrencyConfigArgs(
                strategy=var["function_provisioned_concurrency_config_strategy"],
                count=var["function_provisioned_concurrency_config_count"],
            ),
            source_details=oci.functions.FunctionSourceDetailsArgs(
                pbf_listing_id=oci_functions_pbf_listing["test_pbf_listing"]["id"],
                source_type=var["function_source_details_source_type"],
            ),
            timeout_in_seconds=var["function_timeout_in_seconds"],
            trace_config=oci.functions.FunctionTraceConfigArgs(
                is_enabled=var["function_trace_config_is_enabled"],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Functions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Functions/function:Function test_function "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The OCID of the application this function belongs to.
        :param pulumi.Input[Mapping[str, Any]] config: (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
               
               The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image: (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param pulumi.Input[str] image_digest: (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param pulumi.Input[str] memory_in_mbs: (Updatable) Maximum usable memory for the function (MiB).
        :param pulumi.Input[pulumi.InputType['FunctionProvisionedConcurrencyConfigArgs']] provisioned_concurrency_config: (Updatable) Define the strategy for provisioned concurrency for the function.
        :param pulumi.Input[pulumi.InputType['FunctionSourceDetailsArgs']] source_details: The source details for the Function. The function can be created from various sources.
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Timeout for executions of the function. Value in seconds.
        :param pulumi.Input[pulumi.InputType['FunctionTraceConfigArgs']] trace_config: (Updatable) Define the tracing configuration for a function.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Function resource in Oracle Cloud Infrastructure Functions service.

        Creates a new function.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_function = oci.functions.Function("testFunction",
            application_id=oci_functions_application["test_application"]["id"],
            display_name=var["function_display_name"],
            memory_in_mbs=var["function_memory_in_mbs"],
            config=var["function_config"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            image=var["function_image"],
            image_digest=var["function_image_digest"],
            provisioned_concurrency_config=oci.functions.FunctionProvisionedConcurrencyConfigArgs(
                strategy=var["function_provisioned_concurrency_config_strategy"],
                count=var["function_provisioned_concurrency_config_count"],
            ),
            source_details=oci.functions.FunctionSourceDetailsArgs(
                pbf_listing_id=oci_functions_pbf_listing["test_pbf_listing"]["id"],
                source_type=var["function_source_details_source_type"],
            ),
            timeout_in_seconds=var["function_timeout_in_seconds"],
            trace_config=oci.functions.FunctionTraceConfigArgs(
                is_enabled=var["function_trace_config_is_enabled"],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Functions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Functions/function:Function test_function "id"
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_digest: Optional[pulumi.Input[str]] = None,
                 memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 provisioned_concurrency_config: Optional[pulumi.Input[pulumi.InputType['FunctionProvisionedConcurrencyConfigArgs']]] = None,
                 source_details: Optional[pulumi.Input[pulumi.InputType['FunctionSourceDetailsArgs']]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 trace_config: Optional[pulumi.Input[pulumi.InputType['FunctionTraceConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["config"] = config
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["image"] = image
            __props__.__dict__["image_digest"] = image_digest
            if memory_in_mbs is None and not opts.urn:
                raise TypeError("Missing required property 'memory_in_mbs'")
            __props__.__dict__["memory_in_mbs"] = memory_in_mbs
            __props__.__dict__["provisioned_concurrency_config"] = provisioned_concurrency_config
            __props__.__dict__["source_details"] = source_details
            __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
            __props__.__dict__["trace_config"] = trace_config
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["invoke_endpoint"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Function, __self__).__init__(
            'oci:Functions/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            image: Optional[pulumi.Input[str]] = None,
            image_digest: Optional[pulumi.Input[str]] = None,
            invoke_endpoint: Optional[pulumi.Input[str]] = None,
            memory_in_mbs: Optional[pulumi.Input[str]] = None,
            provisioned_concurrency_config: Optional[pulumi.Input[pulumi.InputType['FunctionProvisionedConcurrencyConfigArgs']]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            source_details: Optional[pulumi.Input[pulumi.InputType['FunctionSourceDetailsArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            timeout_in_seconds: Optional[pulumi.Input[int]] = None,
            trace_config: Optional[pulumi.Input[pulumi.InputType['FunctionTraceConfigArgs']]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The OCID of the application this function belongs to.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the function.
        :param pulumi.Input[Mapping[str, Any]] config: (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
               
               The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] image: (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param pulumi.Input[str] image_digest: (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param pulumi.Input[str] invoke_endpoint: The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        :param pulumi.Input[str] memory_in_mbs: (Updatable) Maximum usable memory for the function (MiB).
        :param pulumi.Input[pulumi.InputType['FunctionProvisionedConcurrencyConfigArgs']] provisioned_concurrency_config: (Updatable) Define the strategy for provisioned concurrency for the function.
        :param pulumi.Input[str] shape: The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        :param pulumi.Input[pulumi.InputType['FunctionSourceDetailsArgs']] source_details: The source details for the Function. The function can be created from various sources.
        :param pulumi.Input[str] state: The current state of the function.
        :param pulumi.Input[str] time_created: The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Timeout for executions of the function. Value in seconds.
        :param pulumi.Input[pulumi.InputType['FunctionTraceConfigArgs']] trace_config: (Updatable) Define the tracing configuration for a function.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config"] = config
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image"] = image
        __props__.__dict__["image_digest"] = image_digest
        __props__.__dict__["invoke_endpoint"] = invoke_endpoint
        __props__.__dict__["memory_in_mbs"] = memory_in_mbs
        __props__.__dict__["provisioned_concurrency_config"] = provisioned_concurrency_config
        __props__.__dict__["shape"] = shape
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
        __props__.__dict__["trace_config"] = trace_config
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        The OCID of the application this function belongs to.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment that contains the function.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Function configuration. These values are passed on to the function as environment variables, this overrides application configuration values. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`

        The maximum size for all configuration keys and values is limited to 4KB. This is measured as the sum of octets necessary to represent each key and value in UTF-8.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the function. The display name must be unique within the application containing the function. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[str]:
        """
        (Updatable) The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. This field must be updated if image_digest is updated. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> pulumi.Output[str]:
        """
        (Updatable) The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. This field must be updated if image is updated. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        """
        return pulumi.get(self, "image_digest")

    @property
    @pulumi.getter(name="invokeEndpoint")
    def invoke_endpoint(self) -> pulumi.Output[str]:
        """
        The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        """
        return pulumi.get(self, "invoke_endpoint")

    @property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> pulumi.Output[str]:
        """
        (Updatable) Maximum usable memory for the function (MiB).
        """
        return pulumi.get(self, "memory_in_mbs")

    @property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> pulumi.Output['outputs.FunctionProvisionedConcurrencyConfig']:
        """
        (Updatable) Define the strategy for provisioned concurrency for the function.
        """
        return pulumi.get(self, "provisioned_concurrency_config")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output['outputs.FunctionSourceDetails']:
        """
        The source details for the Function. The function can be created from various sources.
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the function.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) Timeout for executions of the function. Value in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="traceConfig")
    def trace_config(self) -> pulumi.Output['outputs.FunctionTraceConfig']:
        """
        (Updatable) Define the tracing configuration for a function.
        """
        return pulumi.get(self, "trace_config")

