# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetPerformanceTuningAnalysisResultsResult',
    'AwaitableGetFleetPerformanceTuningAnalysisResultsResult',
    'get_fleet_performance_tuning_analysis_results',
    'get_fleet_performance_tuning_analysis_results_output',
]

@pulumi.output_type
class GetFleetPerformanceTuningAnalysisResultsResult:
    """
    A collection of values returned by getFleetPerformanceTuningAnalysisResults.
    """
    def __init__(__self__, application_id=None, filters=None, fleet_id=None, id=None, managed_instance_id=None, performance_tuning_analysis_result_collections=None, time_end=None, time_start=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if performance_tuning_analysis_result_collections and not isinstance(performance_tuning_analysis_result_collections, list):
            raise TypeError("Expected argument 'performance_tuning_analysis_result_collections' to be a list")
        pulumi.set(__self__, "performance_tuning_analysis_result_collections", performance_tuning_analysis_result_collections)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        The OCID of the application for which the report has been generated.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetPerformanceTuningAnalysisResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        """
        The fleet OCID.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[str]:
        """
        The managed instance OCID.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="performanceTuningAnalysisResultCollections")
    def performance_tuning_analysis_result_collections(self) -> Sequence['outputs.GetFleetPerformanceTuningAnalysisResultsPerformanceTuningAnalysisResultCollectionResult']:
        """
        The list of performance_tuning_analysis_result_collection.
        """
        return pulumi.get(self, "performance_tuning_analysis_result_collections")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[str]:
        return pulumi.get(self, "time_start")


class AwaitableGetFleetPerformanceTuningAnalysisResultsResult(GetFleetPerformanceTuningAnalysisResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetPerformanceTuningAnalysisResultsResult(
            application_id=self.application_id,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            performance_tuning_analysis_result_collections=self.performance_tuning_analysis_result_collections,
            time_end=self.time_end,
            time_start=self.time_start)


def get_fleet_performance_tuning_analysis_results(application_id: Optional[str] = None,
                                                  filters: Optional[Sequence[pulumi.InputType['GetFleetPerformanceTuningAnalysisResultsFilterArgs']]] = None,
                                                  fleet_id: Optional[str] = None,
                                                  managed_instance_id: Optional[str] = None,
                                                  time_end: Optional[str] = None,
                                                  time_start: Optional[str] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetPerformanceTuningAnalysisResultsResult:
    """
    This data source provides the list of Fleet Performance Tuning Analysis Results in Oracle Cloud Infrastructure Jms service.

    List Performance Tuning Analysis results.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_performance_tuning_analysis_results = oci.Jms.get_fleet_performance_tuning_analysis_results(fleet_id=oci_jms_fleet["test_fleet"]["id"],
        application_id=oci_dataflow_application["test_application"]["id"],
        managed_instance_id=oci_osmanagement_managed_instance["test_managed_instance"]["id"],
        time_end=var["fleet_performance_tuning_analysis_result_time_end"],
        time_start=var["fleet_performance_tuning_analysis_result_time_start"])
    ```
    <!--End PulumiCodeChooser -->


    :param str application_id: The Fleet-unique identifier of the related application.
    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetPerformanceTuningAnalysisResults:getFleetPerformanceTuningAnalysisResults', __args__, opts=opts, typ=GetFleetPerformanceTuningAnalysisResultsResult).value

    return AwaitableGetFleetPerformanceTuningAnalysisResultsResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        performance_tuning_analysis_result_collections=pulumi.get(__ret__, 'performance_tuning_analysis_result_collections'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_fleet_performance_tuning_analysis_results)
def get_fleet_performance_tuning_analysis_results_output(application_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                         filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetFleetPerformanceTuningAnalysisResultsFilterArgs']]]]] = None,
                                                         fleet_id: Optional[pulumi.Input[str]] = None,
                                                         managed_instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                         time_end: Optional[pulumi.Input[Optional[str]]] = None,
                                                         time_start: Optional[pulumi.Input[Optional[str]]] = None,
                                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetPerformanceTuningAnalysisResultsResult]:
    """
    This data source provides the list of Fleet Performance Tuning Analysis Results in Oracle Cloud Infrastructure Jms service.

    List Performance Tuning Analysis results.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_performance_tuning_analysis_results = oci.Jms.get_fleet_performance_tuning_analysis_results(fleet_id=oci_jms_fleet["test_fleet"]["id"],
        application_id=oci_dataflow_application["test_application"]["id"],
        managed_instance_id=oci_osmanagement_managed_instance["test_managed_instance"]["id"],
        time_end=var["fleet_performance_tuning_analysis_result_time_end"],
        time_start=var["fleet_performance_tuning_analysis_result_time_start"])
    ```
    <!--End PulumiCodeChooser -->


    :param str application_id: The Fleet-unique identifier of the related application.
    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    ...
