# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAverageCarbonEmissionResult',
    'AwaitableGetAverageCarbonEmissionResult',
    'get_average_carbon_emission',
    'get_average_carbon_emission_output',
]

@pulumi.output_type
class GetAverageCarbonEmissionResult:
    """
    A collection of values returned by getAverageCarbonEmission.
    """
    def __init__(__self__, average_carbon_emission=None, id=None, sku_part_number=None):
        if average_carbon_emission and not isinstance(average_carbon_emission, float):
            raise TypeError("Expected argument 'average_carbon_emission' to be a float")
        pulumi.set(__self__, "average_carbon_emission", average_carbon_emission)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sku_part_number and not isinstance(sku_part_number, str):
            raise TypeError("Expected argument 'sku_part_number' to be a str")
        pulumi.set(__self__, "sku_part_number", sku_part_number)

    @property
    @pulumi.getter(name="averageCarbonEmission")
    def average_carbon_emission(self) -> float:
        """
        The average carbon emissions by SKU.
        """
        return pulumi.get(self, "average_carbon_emission")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="skuPartNumber")
    def sku_part_number(self) -> str:
        """
        The sku part number.
        """
        return pulumi.get(self, "sku_part_number")


class AwaitableGetAverageCarbonEmissionResult(GetAverageCarbonEmissionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAverageCarbonEmissionResult(
            average_carbon_emission=self.average_carbon_emission,
            id=self.id,
            sku_part_number=self.sku_part_number)


def get_average_carbon_emission(sku_part_number: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAverageCarbonEmissionResult:
    """
    This data source provides details about a specific Average Carbon Emission resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the average carbon emissions summary by SKU.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_average_carbon_emission = oci.MeteringComputation.get_average_carbon_emission(sku_part_number=var["average_carbon_emission_sku_part_number"])
    ```
    <!--End PulumiCodeChooser -->


    :param str sku_part_number: The SKU part number.
    """
    __args__ = dict()
    __args__['skuPartNumber'] = sku_part_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getAverageCarbonEmission:getAverageCarbonEmission', __args__, opts=opts, typ=GetAverageCarbonEmissionResult).value

    return AwaitableGetAverageCarbonEmissionResult(
        average_carbon_emission=pulumi.get(__ret__, 'average_carbon_emission'),
        id=pulumi.get(__ret__, 'id'),
        sku_part_number=pulumi.get(__ret__, 'sku_part_number'))


@_utilities.lift_output_func(get_average_carbon_emission)
def get_average_carbon_emission_output(sku_part_number: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAverageCarbonEmissionResult]:
    """
    This data source provides details about a specific Average Carbon Emission resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the average carbon emissions summary by SKU.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_average_carbon_emission = oci.MeteringComputation.get_average_carbon_emission(sku_part_number=var["average_carbon_emission_sku_part_number"])
    ```
    <!--End PulumiCodeChooser -->


    :param str sku_part_number: The SKU part number.
    """
    ...
