# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProfilesResult',
    'AwaitableGetProfilesResult',
    'get_profiles',
    'get_profiles_output',
]

@pulumi.output_type
class GetProfilesResult:
    """
    A collection of values returned by getProfiles.
    """
    def __init__(__self__, arch_type=None, compartment_id=None, display_name_contains=None, display_names=None, filters=None, id=None, os_family=None, profile_collections=None, profile_id=None, profile_types=None, state=None, vendor_name=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if profile_collections and not isinstance(profile_collections, list):
            raise TypeError("Expected argument 'profile_collections' to be a list")
        pulumi.set(__self__, "profile_collections", profile_collections)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if profile_types and not isinstance(profile_types, list):
            raise TypeError("Expected argument 'profile_types' to be a list")
        pulumi.set(__self__, "profile_types", profile_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[str]:
        """
        The architecture type.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the tenancy containing the registration profile.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[str]]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProfilesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[str]:
        """
        The operating system family.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="profileCollections")
    def profile_collections(self) -> Sequence['outputs.GetProfilesProfileCollectionResult']:
        """
        The list of profile_collection.
        """
        return pulumi.get(self, "profile_collections")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[str]:
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter(name="profileTypes")
    def profile_types(self) -> Optional[Sequence[str]]:
        """
        The type of Profile. One of SOFTWARESOURCE, GROUP or LIFECYCLE.
        """
        return pulumi.get(self, "profile_types")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the registration profile.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[str]:
        """
        The software source vendor name.
        """
        return pulumi.get(self, "vendor_name")


class AwaitableGetProfilesResult(GetProfilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfilesResult(
            arch_type=self.arch_type,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            os_family=self.os_family,
            profile_collections=self.profile_collections,
            profile_id=self.profile_id,
            profile_types=self.profile_types,
            state=self.state,
            vendor_name=self.vendor_name)


def get_profiles(arch_type: Optional[str] = None,
                 compartment_id: Optional[str] = None,
                 display_name_contains: Optional[str] = None,
                 display_names: Optional[Sequence[str]] = None,
                 filters: Optional[Sequence[pulumi.InputType['GetProfilesFilterArgs']]] = None,
                 os_family: Optional[str] = None,
                 profile_id: Optional[str] = None,
                 profile_types: Optional[Sequence[str]] = None,
                 state: Optional[str] = None,
                 vendor_name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfilesResult:
    """
    This data source provides the list of Profiles in Oracle Cloud Infrastructure Os Management Hub service.

    Lists registration profiles that match the specified compartment or profile OCID. Filter the list against a
    variety of criteria including but not limited to its name, status, vendor name, and architecture type.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_profiles = oci.OsManagementHub.get_profiles(arch_type=var["profile_arch_type"],
        compartment_id=var["compartment_id"],
        display_names=var["profile_display_name"],
        display_name_contains=var["profile_display_name_contains"],
        os_family=var["profile_os_family"],
        profile_id=oci_os_management_hub_profile["test_profile"]["id"],
        profile_types=var["profile_profile_type"],
        state=var["profile_state"],
        vendor_name=var["profile_vendor_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str arch_type: A filter to return only profiles that match the given archType.
    :param str compartment_id: The OCID of the compartment that contains the resources to list.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str os_family: A filter to return only profiles that match the given osFamily.
    :param str profile_id: The OCID of the registration profile.
    :param Sequence[str] profile_types: A filter to return registration profiles that match the given profileType.
    :param str state: A filter to return only registration profile whose lifecycleState matches the given lifecycleState.
    :param str vendor_name: A filter to return only profiles that match the given vendorName.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['osFamily'] = os_family
    __args__['profileId'] = profile_id
    __args__['profileTypes'] = profile_types
    __args__['state'] = state
    __args__['vendorName'] = vendor_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getProfiles:getProfiles', __args__, opts=opts, typ=GetProfilesResult).value

    return AwaitableGetProfilesResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        os_family=pulumi.get(__ret__, 'os_family'),
        profile_collections=pulumi.get(__ret__, 'profile_collections'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        profile_types=pulumi.get(__ret__, 'profile_types'),
        state=pulumi.get(__ret__, 'state'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'))


@_utilities.lift_output_func(get_profiles)
def get_profiles_output(arch_type: Optional[pulumi.Input[Optional[str]]] = None,
                        compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                        display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                        display_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetProfilesFilterArgs']]]]] = None,
                        os_family: Optional[pulumi.Input[Optional[str]]] = None,
                        profile_id: Optional[pulumi.Input[Optional[str]]] = None,
                        profile_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        state: Optional[pulumi.Input[Optional[str]]] = None,
                        vendor_name: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProfilesResult]:
    """
    This data source provides the list of Profiles in Oracle Cloud Infrastructure Os Management Hub service.

    Lists registration profiles that match the specified compartment or profile OCID. Filter the list against a
    variety of criteria including but not limited to its name, status, vendor name, and architecture type.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_profiles = oci.OsManagementHub.get_profiles(arch_type=var["profile_arch_type"],
        compartment_id=var["compartment_id"],
        display_names=var["profile_display_name"],
        display_name_contains=var["profile_display_name_contains"],
        os_family=var["profile_os_family"],
        profile_id=oci_os_management_hub_profile["test_profile"]["id"],
        profile_types=var["profile_profile_type"],
        state=var["profile_state"],
        vendor_name=var["profile_vendor_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str arch_type: A filter to return only profiles that match the given archType.
    :param str compartment_id: The OCID of the compartment that contains the resources to list.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str os_family: A filter to return only profiles that match the given osFamily.
    :param str profile_id: The OCID of the registration profile.
    :param Sequence[str] profile_types: A filter to return registration profiles that match the given profileType.
    :param str state: A filter to return only registration profile whose lifecycleState matches the given lifecycleState.
    :param str vendor_name: A filter to return only profiles that match the given vendorName.
    """
    ...
