from urllib3.poolmanager import PoolManager as PoolManager_, SSL_KEYWORDS

from .connection import HTTPConnectionPool, HTTPSConnectionPool


pool_classes_by_scheme = {
    'http': HTTPConnectionPool,
    'https': HTTPSConnectionPool,
}


class PoolManager(PoolManager_):
    def _new_pool(self, scheme, host, port):
        """
        Create a new :class:`ConnectionPool` based on host, port and scheme.
        This method is used to actually create the connection pools handed out
        by :meth:`connection_from_url` and companion methods. It is intended
        to be overridden for customization.
        """

        pool_cls = pool_classes_by_scheme[scheme]
        kwargs = self.connection_pool_kw

        if scheme == 'http':
            kwargs = self.connection_pool_kw.copy()

            for kw in SSL_KEYWORDS:
                kwargs.pop(kw, None)

        return pool_cls(host, port, **kwargs)
