# generated by datamodel-codegen:
#   filename:  DatasetSampleFormats.json

from __future__ import annotations
from typing import Annotated, Any, Dict, List, Optional
from uuid import UUID
from .base import DtoBaseModel
from pydantic import Field, RootModel


class SampleMetadata(DtoBaseModel):
    created_at: int
    external_data: Optional[Any] = None
    id: UUID
    model_id: Optional[UUID] = None


class TurnTuple(RootModel[List]):
    root: Annotated[List, Field(max_length=2, min_length=2)]


class DatasetMetricSample(DtoBaseModel):
    completion: TurnTuple
    metadata: SampleMetadata
    metrics: Dict[str, float]
    prompt: List[TurnTuple]


class DatasetPreferenceSample(DtoBaseModel):
    bad_completion: TurnTuple
    good_completion: TurnTuple
    metadata: SampleMetadata
    prompt: List[TurnTuple]


class DatasetPromptSample(DtoBaseModel):
    metadata: SampleMetadata
    prompt: List[TurnTuple]


class DatasetSample(DtoBaseModel):
    completion: TurnTuple
    metadata: SampleMetadata
    prompt: List[TurnTuple]


class DatasetSampleFormats(DtoBaseModel):
    completion: DatasetSample
    metric: DatasetMetricSample
    preference: DatasetPreferenceSample
    prompt: DatasetPromptSample
