/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import com.google.gson.JsonObject;
import hex.ModelCategory;
import hex.genmodel.ModelMojoFactory;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import hex.genmodel.descriptor.ModelDescriptorBuilder;
import hex.genmodel.utils.DistributionFamily;
import hex.genmodel.utils.LinkFunctionType;
import hex.genmodel.utils.ParseUtils;
import hex.genmodel.utils.StringEscapeUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelMojoReader<M extends MojoModel> {
    protected M _model;
    protected MojoReaderBackend _reader;
    private Map<String, Object> _lkv;

    public static MojoModel readFrom(MojoReaderBackend reader) throws IOException {
        return ModelMojoReader.readFrom(reader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MojoModel readFrom(MojoReaderBackend reader, boolean readModelMetadata) throws IOException {
        try {
            Map<String, Object> info = ModelMojoReader.parseModelInfo(reader);
            if (!info.containsKey("algorithm")) {
                throw new IllegalStateException("Unable to find information about the model's algorithm.");
            }
            String algo = String.valueOf(info.get("algorithm"));
            ModelMojoReader mmr = ModelMojoFactory.INSTANCE.getMojoReader(algo);
            mmr._lkv = info;
            mmr._reader = reader;
            mmr.readAll(readModelMetadata);
            Object m = mmr._model;
            return m;
        }
        finally {
            if (reader instanceof Closeable) {
                ((Closeable)((Object)reader)).close();
            }
        }
    }

    public abstract String getModelName();

    protected abstract void readModelData() throws IOException;

    protected abstract M makeModel(String[] var1, String[][] var2, String var3);

    public abstract String mojoVersion();

    protected <T> T readkv(String key) {
        return this.readkv(key, null);
    }

    protected <T> T readkv(String key, T defVal) {
        Object val = this._lkv.get(key);
        if (!(val instanceof RawValue)) {
            return (T)(val != null ? val : defVal);
        }
        return ((RawValue)val).parse(defVal);
    }

    protected byte[] readblob(String name) throws IOException {
        return this.getMojoReaderBackend().getBinaryFile(name);
    }

    protected boolean exists(String name) {
        return this.getMojoReaderBackend().exists(name);
    }

    protected Iterable<String> readtext(String name) throws IOException {
        return this.readtext(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<String> readtext(String name, boolean unescapeNewlines) throws IOException {
        ArrayList<String> res = new ArrayList<String>(50);
        BufferedReader br = this.getMojoReaderBackend().getTextFile(name);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (unescapeNewlines) {
                    line = StringEscapeUtils.unescapeNewlines(line);
                }
                res.add(line.trim());
            }
            br.close();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return res;
    }

    protected String[] readStringArray(String name, int size) throws IOException {
        String[] array = new String[size];
        int i = 0;
        for (String line : this.readtext(name, true)) {
            array[i++] = line;
        }
        return array;
    }

    protected double[][] readRectangularDoubleArray(String title, int firstSize, int secondSize) throws IOException {
        assert (null != title);
        double[][] row = new double[firstSize][secondSize];
        ByteBuffer bb = ByteBuffer.wrap(this.readblob(title));
        for (int i = 0; i < firstSize; ++i) {
            for (int j = 0; j < secondSize; ++j) {
                row[i][j] = bb.getDouble();
            }
        }
        return row;
    }

    protected double[][] readRectangularDoubleArray(String title) throws IOException {
        assert (null != title);
        int size1 = (Integer)this.readkv(title + "_size1");
        int size2 = (Integer)this.readkv(title + "_size2");
        return this.readRectangularDoubleArray(title, size1, size2);
    }

    private void readAll(boolean readModelMetadata) throws IOException {
        String[] columns = (String[])this._lkv.get("[columns]");
        String[][] domains = this.parseModelDomains(columns.length);
        boolean isSupervised = (Boolean)this.readkv("supervised");
        this._model = this.makeModel(columns, domains, isSupervised ? columns[columns.length - 1] : null);
        ((MojoModel)this._model)._uuid = (String)this.readkv("uuid");
        ((MojoModel)this._model)._algoName = (String)this.readkv("algo");
        ((MojoModel)this._model)._h2oVersion = this.readkv("h2o_version", "unknown");
        ((MojoModel)this._model)._category = ModelCategory.valueOf((String)this.readkv("category"));
        ((MojoModel)this._model)._supervised = isSupervised;
        ((MojoModel)this._model)._nfeatures = (Integer)this.readkv("n_features");
        ((MojoModel)this._model)._nclasses = (Integer)this.readkv("n_classes");
        ((MojoModel)this._model)._balanceClasses = (Boolean)this.readkv("balance_classes");
        ((MojoModel)this._model)._defaultThreshold = (Double)this.readkv("default_threshold");
        ((MojoModel)this._model)._priorClassDistrib = (double[])this.readkv("prior_class_distrib");
        ((MojoModel)this._model)._modelClassDistrib = (double[])this.readkv("model_class_distrib");
        ((MojoModel)this._model)._offsetColumn = (String)this.readkv("offset_column");
        ((MojoModel)this._model)._mojo_version = ((Number)this.readkv("mojo_version")).doubleValue();
        this.checkMaxSupportedMojoVersion();
        this.readModelData();
        if (readModelMetadata) {
            String algoFullName = (String)this.readkv("algorithm");
            ((MojoModel)this._model)._modelDescriptor = ModelDescriptorBuilder.makeDescriptor(this._model, algoFullName);
            ((MojoModel)this._model)._modelAttributes = this.readModelSpecificAttributes();
        }
        ((MojoModel)this._model)._reproducibilityInformation = this.readReproducibilityInformation();
    }

    protected Table[] readReproducibilityInformation() {
        JsonObject modelJson = ModelJsonReader.parseModelJson(this._reader);
        if (modelJson != null && modelJson.get("output") != null) {
            return ModelJsonReader.readTableArray(modelJson, "output.reproducibility_information_table");
        }
        return null;
    }

    protected ModelAttributes readModelSpecificAttributes() {
        JsonObject modelJson = ModelJsonReader.parseModelJson(this._reader);
        if (modelJson != null) {
            return new ModelAttributes((MojoModel)this._model, modelJson);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> parseModelInfo(MojoReaderBackend reader) throws IOException {
        HashMap<String, Object> info = new HashMap<String, Object>();
        BufferedReader br = reader.getTextFile("model.ini");
        try {
            String line;
            int section = 0;
            int ic = 0;
            String[] columns = new String[]{};
            HashMap<Integer, String> domains = new HashMap<Integer, String>();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                if (line.equals("[info]")) {
                    section = 1;
                    continue;
                }
                if (line.equals("[columns]")) {
                    section = 2;
                    if (!info.containsKey("n_columns")) {
                        throw new IOException("`n_columns` variable is missing in the model info.");
                    }
                    int n_columns = Integer.parseInt(((RawValue)info.get("n_columns"))._val);
                    columns = new String[n_columns];
                    info.put("[columns]", columns);
                    continue;
                }
                if (line.equals("[domains]")) {
                    section = 3;
                    info.put("[domains]", domains);
                    continue;
                }
                if (section == 1) {
                    String[] res = line.split("\\s*=\\s*", 2);
                    info.put(res[0], res[0].equals("uuid") ? res[1] : new RawValue(res[1]));
                    continue;
                }
                if (section == 2) {
                    if (ic >= columns.length) {
                        throw new IOException("`n_columns` variable is too small.");
                    }
                    columns[ic++] = line;
                    continue;
                }
                if (section != 3) continue;
                String[] res = line.split(":\\s*", 2);
                int col_index = Integer.parseInt(res[0]);
                domains.put(col_index, res[1]);
            }
            br.close();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return info;
    }

    private String[][] parseModelDomains(int n_columns) throws IOException {
        boolean escapeDomainValues = Boolean.TRUE.equals(this.readkv("escape_domain_values"));
        String[][] domains = new String[n_columns][];
        Map domass = (Map)this._lkv.get("[domains]");
        for (Map.Entry e : domass.entrySet()) {
            int col_index = (Integer)e.getKey();
            if (col_index >= n_columns) continue;
            String[] info = ((String)e.getValue()).split(" ", 2);
            int n_elements = Integer.parseInt(info[0]);
            String domfile = info[1];
            String[] domain = new String[n_elements];
            try (BufferedReader br = this.getMojoReaderBackend().getTextFile("domains/" + domfile);){
                String line;
                int id = 0;
                while ((line = br.readLine()) != null) {
                    if (escapeDomainValues) {
                        line = StringEscapeUtils.unescapeNewlines(line);
                    }
                    domain[id++] = line;
                }
                if (id != n_elements) {
                    throw new IOException("Not enough elements in the domain file");
                }
            }
            domains[col_index] = domain;
        }
        return domains;
    }

    private void checkMaxSupportedMojoVersion() throws IOException {
        if (((MojoModel)this._model)._mojo_version > Double.parseDouble(this.mojoVersion())) {
            throw new IOException(String.format("MOJO version incompatibility - the model MOJO version (%.2f) is higher than the current H2O version (%s) supports. Please, use a newer version of H2O to load MOJO model.", ((MojoModel)this._model)._mojo_version, this.mojoVersion()));
        }
    }

    public static LinkFunctionType readLinkFunction(String linkFunctionTypeName, DistributionFamily family) {
        if (linkFunctionTypeName != null) {
            return LinkFunctionType.valueOf(linkFunctionTypeName);
        }
        return ModelMojoReader.defaultLinkFunction(family);
    }

    public static LinkFunctionType defaultLinkFunction(DistributionFamily family) {
        switch (family) {
            case bernoulli: 
            case fractionalbinomial: 
            case quasibinomial: 
            case modified_huber: 
            case ordinal: {
                return LinkFunctionType.logit;
            }
            case multinomial: 
            case poisson: 
            case gamma: 
            case tweedie: {
                return LinkFunctionType.log;
            }
        }
        return LinkFunctionType.identity;
    }

    protected MojoReaderBackend getMojoReaderBackend() {
        return this._reader;
    }

    private static class RawValue {
        private final String _val;

        RawValue(String val) {
            this._val = val;
        }

        <T> T parse(T defVal) {
            return (T)ParseUtils.tryParse(this._val, defVal);
        }

        public String toString() {
            return this._val;
        }
    }
}

