/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.ConverterFactoryProvidingModel;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.gam.GamRowToRawDataConverter;
import hex.genmodel.algos.gam.GamUtilsCubicRegression;
import hex.genmodel.algos.gam.GamUtilsThinPlateRegression;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.RowToRawDataConverter;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import hex.genmodel.utils.LinkFunctionType;
import java.util.Map;

public abstract class GamMojoModelBase
extends MojoModel
implements ConverterFactoryProvidingModel,
Cloneable {
    public LinkFunctionType _link_function;
    boolean _useAllFactorLevels;
    int _cats;
    int[] _catNAFills;
    int[] _catOffsets;
    int _nums;
    int _numsCenter;
    double[] _numNAFillsCenter;
    boolean _meanImputation;
    double[] _beta;
    double[] _beta_no_center;
    double[] _beta_center;
    double[][] _beta_multinomial;
    double[][] _beta_multinomial_no_center;
    double[][] _beta_multinomial_center;
    DistributionFamily _family;
    String[][] _gam_columns;
    String[][] _gam_columns_sorted;
    int[] _d;
    int[] _m;
    int[] _M;
    int[] _gamPredSize;
    int _num_gam_columns;
    int[] _bs;
    int[] _bs_sorted;
    int[] _num_knots;
    int[] _num_knots_sorted;
    int[] _num_knots_sorted_minus1;
    int[] _num_knots_TP;
    double[][][] _knots;
    double[][][] _binvD;
    double[][][] _zTranspose;
    double[][][] _zTransposeCS;
    String[][] _gamColNames;
    String[][] _gamColNamesCenter;
    String[] _names_no_centering;
    int _totFeatureSize;
    int _betaSizePerClass;
    int _betaCenterSizePerClass;
    double _tweedieLinkPower;
    double[][] _basisVals;
    double[][] _basisValsCenter;
    double[][] _hj;
    int _numExpandedGamCols;
    int _numExpandedGamColsCenter;
    int _lastClass;
    int[][][] _allPolyBasisList;
    int _num_TP_col;
    int _num_CS_col;
    double[][] _tpRowVals;
    double[][] _tpDistance;
    double[][] _tpDistzCS;
    double[][] _tpPoly;
    double[][] _tpDistzCSPoly;
    double[][] _tpDistzCSPolyzT;
    boolean[] _dEven;
    double[] _constantTerms;
    double[][] _gamColMeansRaw;
    double[][] _oneOGamColStd;
    boolean _standardize;

    GamMojoModelBase(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        if (this._meanImputation) {
            this.imputeMissingWithMeans(row);
        }
        return this.gamScore0(row, preds);
    }

    void init() {
        int index;
        this._num_knots_sorted_minus1 = new int[this._num_knots_sorted.length];
        for (index = 0; index < this._num_knots_sorted.length; ++index) {
            this._num_knots_sorted_minus1[index] = this._num_knots_sorted[index] - 1;
        }
        if (this._num_CS_col > 0) {
            this._basisVals = new double[this._num_CS_col][];
            this._basisValsCenter = new double[this._num_CS_col][];
            this._hj = new double[this._num_CS_col][];
            for (int ind = 0; ind < this._num_CS_col; ++ind) {
                this._basisVals[ind] = new double[this._num_knots_sorted[ind]];
                this._basisValsCenter[ind] = new double[this._num_knots_sorted_minus1[ind]];
                this._hj[ind] = ArrayUtils.eleDiff(this._knots[ind][0]);
            }
        }
        if (this._num_TP_col > 0) {
            this._tpRowVals = new double[this._num_TP_col][];
            this._tpDistance = new double[this._num_TP_col][];
            this._tpDistzCS = new double[this._num_TP_col][];
            this._tpPoly = new double[this._num_TP_col][];
            this._tpDistzCSPoly = new double[this._num_TP_col][];
            this._tpDistzCSPolyzT = new double[this._num_TP_col][];
            this._dEven = new boolean[this._num_TP_col];
            this._constantTerms = new double[this._num_TP_col];
            for (index = 0; index < this._num_TP_col; ++index) {
                int absIndex = index + this._num_CS_col;
                this._tpRowVals[index] = new double[this._d[absIndex]];
                this._tpDistance[index] = new double[this._num_knots_sorted[absIndex]];
                this._tpDistzCS[index] = new double[this._num_knots_sorted[absIndex] - this._M[index]];
                this._tpPoly[index] = new double[this._M[index]];
                this._tpDistzCSPoly[index] = new double[this._num_knots_sorted[absIndex]];
                this._tpDistzCSPolyzT[index] = new double[this._num_knots_sorted[absIndex] - 1];
                this._dEven[index] = this._d[absIndex] % 2 == 0;
                this._constantTerms[index] = GamUtilsThinPlateRegression.calTPConstantTerm(this._m[index], this._d[absIndex], this._dEven[index]);
            }
        }
        this._lastClass = this._nclasses - 1;
    }

    @Override
    public GenModel internal_threadSafeInstance() {
        try {
            GamMojoModelBase clonedMojo = (GamMojoModelBase)this.clone();
            clonedMojo.init();
            return clonedMojo;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    abstract double[] gamScore0(double[] var1, double[] var2);

    private void imputeMissingWithMeans(double[] data) {
        int ind;
        for (ind = 0; ind < this._cats; ++ind) {
            if (!Double.isNaN(data[ind])) continue;
            data[ind] = this._catNAFills[ind];
        }
        for (ind = 0; ind < this._numsCenter; ++ind) {
            if (!Double.isNaN(data[ind + this._cats])) continue;
            data[ind + this._cats] = this._numNAFillsCenter[ind];
        }
    }

    double evalLink(double val) {
        switch (this._link_function) {
            case identity: {
                return GenModel.GLM_identityInv(val);
            }
            case logit: {
                return GenModel.GLM_logitInv(val);
            }
            case log: {
                return GenModel.GLM_logInv(val);
            }
            case inverse: {
                return GenModel.GLM_inverseInv(val);
            }
            case tweedie: {
                return GenModel.GLM_tweedieInv(val, this._tweedieLinkPower);
            }
        }
        throw new UnsupportedOperationException("Unexpected link function " + (Object)((Object)this._link_function));
    }

    int readCatVal(double data, int dataIndex) {
        int ival;
        int n = ival = this._useAllFactorLevels ? (int)data : (int)data - 1;
        if (ival < 0) {
            return -1;
        }
        return ival += this._catOffsets[dataIndex];
    }

    double generateEta(double[] beta, double[] data) {
        double eta = 0.0;
        int catOffsetLength = this._catOffsets.length - 1;
        for (int i = 0; i < catOffsetLength; ++i) {
            int ival = this.readCatVal(data[i], i);
            if (ival >= this._catOffsets[i + 1] || ival < 0) continue;
            eta += beta[ival];
        }
        int noff = this._catOffsets[this._cats] - this._cats;
        int numColLen = beta.length - 1 - noff;
        for (int i = this._cats; i < numColLen; ++i) {
            eta += beta[noff + i] * data[i];
        }
        return eta += beta[beta.length - 1];
    }

    private boolean gamificationNeeded(double[] rawData, int gamColStart) {
        for (int cind = gamColStart; cind < rawData.length; ++cind) {
            if (Double.isNaN(rawData[cind])) continue;
            return false;
        }
        return true;
    }

    double[] addExpandGamCols(double[] rawData, RowData rowData) {
        int dataIndEnd = this._nfeatures - this._numExpandedGamColsCenter;
        if (!this.gamificationNeeded(rawData, dataIndEnd)) {
            return rawData;
        }
        double[] dataWithGamifiedColumns = ArrayUtils.nanArray(this._nfeatures);
        System.arraycopy(rawData, 0, dataWithGamifiedColumns, 0, dataIndEnd);
        int tpCounter = 0;
        for (int cind = 0; cind < this._num_gam_columns; ++cind) {
            if (this._bs_sorted[cind] == 0) {
                Object dataObject = rowData.get(this._gam_columns_sorted[cind][0]);
                double gam_col_data = Double.NaN;
                if (dataObject == null) {
                    dataIndEnd += this._num_knots_sorted_minus1[cind];
                    continue;
                }
                gam_col_data = dataObject instanceof String ? Double.parseDouble((String)dataObject) : (Double)dataObject;
                GamUtilsCubicRegression.expandOneGamCol(gam_col_data, this._binvD[cind], this._basisVals[cind], this._hj[cind], this._knots[cind][0]);
                ArrayUtils.multArray(this._basisVals[cind], this._zTranspose[cind], this._basisValsCenter[cind]);
                System.arraycopy(this._basisValsCenter[cind], 0, dataWithGamifiedColumns, dataIndEnd, this._num_knots_sorted_minus1[cind]);
            } else if (this._bs_sorted[cind] == 1) {
                String[] gamCols = this._gam_columns_sorted[cind];
                int relIndex = cind - this._num_CS_col;
                double[] gamPred = this.grabPredictorVals(gamCols, rowData, this._tpRowVals[relIndex]);
                if (gamPred == null) {
                    dataIndEnd += this._num_knots_sorted_minus1[cind];
                    continue;
                }
                GamUtilsThinPlateRegression.calculateDistance(this._tpDistance[tpCounter], gamPred, this._num_knots_sorted[cind], this._knots[cind], this._d[cind], this._m[tpCounter], this._dEven[tpCounter], this._constantTerms[tpCounter], this._oneOGamColStd[tpCounter], this._standardize);
                ArrayUtils.multArray(this._tpDistance[tpCounter], this._zTransposeCS[tpCounter], this._tpDistzCS[tpCounter]);
                GamUtilsThinPlateRegression.calculatePolynomialBasis(this._tpPoly[tpCounter], gamPred, this._d[cind], this._M[tpCounter], this._allPolyBasisList[tpCounter], this._gamColMeansRaw[tpCounter], this._oneOGamColStd[tpCounter], this._standardize);
                System.arraycopy(this._tpDistzCS[tpCounter], 0, this._tpDistzCSPoly[tpCounter], 0, this._tpDistzCS[tpCounter].length);
                System.arraycopy(this._tpPoly[tpCounter], 0, this._tpDistzCSPoly[tpCounter], this._tpDistzCS[tpCounter].length, this._M[tpCounter]);
                ArrayUtils.multArray(this._tpDistzCSPoly[tpCounter], this._zTranspose[cind], this._tpDistzCSPolyzT[tpCounter]);
                System.arraycopy(this._tpDistzCSPolyzT[tpCounter], 0, dataWithGamifiedColumns, dataIndEnd, this._tpDistzCSPolyzT[tpCounter].length);
                ++tpCounter;
            } else {
                throw new IllegalArgumentException("spline type not implemented!");
            }
            dataIndEnd += this._num_knots_sorted_minus1[cind];
        }
        return dataWithGamifiedColumns;
    }

    double[] grabPredictorVals(String[] gamCols, RowData rowData, double[] predVals) {
        int numCol = gamCols.length;
        for (int index = 0; index < numCol; ++index) {
            Object data = rowData.get(gamCols[index]);
            if (data == null) {
                return null;
            }
            predVals[index] = data instanceof String ? Double.parseDouble((String)data) : (Double)data;
        }
        return predVals;
    }

    @Override
    public RowToRawDataConverter makeConverterFactory(Map<String, Integer> modelColumnNameToIndexMap, Map<Integer, CategoricalEncoder> domainMap, EasyPredictModelWrapper.ErrorConsumer errorConsumer, EasyPredictModelWrapper.Config config) {
        return new GamRowToRawDataConverter(this, modelColumnNameToIndexMap, domainMap, errorConsumer, config);
    }
}

