/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.pipeline;

import hex.genmodel.MojoModel;
import hex.genmodel.MultiModelMojoReader;
import hex.genmodel.algos.pipeline.MojoPipeline;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MojoPipelineReader
extends MultiModelMojoReader<MojoPipeline> {
    @Override
    public String getModelName() {
        return "MOJO Pipeline";
    }

    @Override
    protected void readParentModelData() {
        String mainModelAlias = (String)this.readkv("main_model");
        String[] generatedColumns = this.readGeneratedColumns();
        ((MojoPipeline)this._model)._mainModel = this.getModel(mainModelAlias);
        ((MojoPipeline)this._model)._generatedColumnCount = generatedColumns.length;
        ((MojoPipeline)this._model)._targetMainModelRowIndices = new int[((MojoPipeline)this._model)._mainModel._nfeatures - generatedColumns.length];
        ((MojoPipeline)this._model)._sourceRowIndices = MojoPipelineReader.findIndices(((MojoPipeline)this._model)._names, ((MojoPipeline)this._model)._mainModel._names, ((MojoPipeline)this._model)._mainModel._nfeatures, ((MojoPipeline)this._model)._targetMainModelRowIndices, generatedColumns);
        Map<String, List<Integer>> m2idxs = this.readModel2GeneratedColumnIndex();
        ((MojoPipeline)this._model)._models = new MojoPipeline.PipelineSubModel[this.getSubModels().size() - 1];
        int modelsCnt = 0;
        int genColsCnt = 0;
        for (Map.Entry<String, MojoModel> subModel : this.getSubModels().entrySet()) {
            if (mainModelAlias.equals(subModel.getKey())) continue;
            MojoModel m = subModel.getValue();
            List<Integer> generatedColsIdxs = m2idxs.get(subModel.getKey());
            int n = modelsCnt++;
            MojoPipeline.PipelineSubModel pipelineSubModel = new MojoPipeline.PipelineSubModel();
            ((MojoPipeline)this._model)._models[n] = pipelineSubModel;
            MojoPipeline.PipelineSubModel psm = pipelineSubModel;
            psm._mojoModel = m;
            psm._inputMapping = this.mapModelColumns(m);
            psm._predsSize = m.getPredsSize(m.getModelCategory());
            psm._sourcePredsIndices = new int[generatedColsIdxs.size()];
            String[] targetColNames = new String[generatedColsIdxs.size()];
            int t = 0;
            for (int i : generatedColsIdxs) {
                psm._sourcePredsIndices[t] = this.readkv("generated_column_index_" + i, 0);
                targetColNames[t] = this.readkv("generated_column_name_" + i, "");
                ++t;
            }
            psm._targetRowIndices = MojoPipelineReader.findIndices(((MojoPipeline)this._model)._mainModel._names, targetColNames);
            genColsCnt += t;
        }
        assert (modelsCnt == ((MojoPipeline)this._model)._models.length);
        assert (genColsCnt == ((MojoPipeline)this._model)._generatedColumnCount);
    }

    private Map<String, List<Integer>> readModel2GeneratedColumnIndex() {
        int cnt = this.readkv("generated_column_count", 0);
        HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>(cnt);
        for (int i = 0; i < cnt; ++i) {
            String alias = (String)this.readkv("generated_column_model_" + i);
            if (!map.containsKey(alias)) {
                map.put(alias, new LinkedList());
            }
            List indices = (List)map.get(alias);
            indices.add(i);
        }
        return map;
    }

    private String[] readGeneratedColumns() {
        int cnt = this.readkv("generated_column_count", 0);
        String[] names = new String[cnt];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.readkv("generated_column_name_" + i, "");
        }
        return names;
    }

    @Override
    protected MojoPipeline makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new MojoPipeline(columns, domains, responseColumn);
    }

    private int[] mapModelColumns(MojoModel subModel) {
        return MojoPipelineReader.findIndices(((MojoPipeline)this._model)._names, subModel._names, subModel._nfeatures, null, new String[0]);
    }

    private static int[] findIndices(String[] strings, String[] subset) {
        return MojoPipelineReader.findIndices(strings, subset, subset.length, null, new String[0]);
    }

    private static int[] findIndices(String[] strings, String[] subset, int firstN, int[] outSubsetIdxs, String[] ignored) {
        int[] idx = new int[firstN - ignored.length];
        assert (outSubsetIdxs == null || outSubsetIdxs.length == idx.length);
        int cnt = 0;
        block0: for (int i = 0; i < firstN; ++i) {
            String s = subset[i];
            assert (s != null);
            for (String si : ignored) {
                if (s.equals(si)) continue block0;
            }
            for (int j = 0; j < strings.length; ++j) {
                if (!s.equals(strings[j])) continue;
                if (outSubsetIdxs != null) {
                    outSubsetIdxs[cnt] = i;
                }
                idx[cnt++] = j;
                continue block0;
            }
            throw new IllegalStateException("Pipeline doesn't have input column '" + subset[i] + "'.");
        }
        assert (cnt == idx.length);
        return idx;
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

