/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import hex.genmodel.MojoModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.jpmml.h2o.Converter;
import org.jpmml.h2o.ConverterFactory;
import org.jpmml.h2o.MojoModelUtil;
import org.jpmml.model.metro.MetroJAXBUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--mojo-input"}, description="MOJO input file", required=true)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        long end;
        PMML pmml;
        long begin;
        MojoModel mojoModel;
        try {
            logger.info("Loading MOJO..");
            long begin2 = System.currentTimeMillis();
            mojoModel = MojoModelUtil.readFrom(this.input, false);
            long end2 = System.currentTimeMillis();
            logger.info("Loaded MOJO in {} ms.", (Object)(end2 - begin2));
        }
        catch (Exception e) {
            logger.error("Failed to load MOJO", (Throwable)e);
            throw e;
        }
        try {
            logger.info("Converting MOJO to PMML..");
            ConverterFactory converterFactory = ConverterFactory.newConverterFactory();
            Converter<? extends MojoModel> converter = converterFactory.newConverter(mojoModel);
            begin = System.currentTimeMillis();
            pmml = converter.encodePMML();
            end = System.currentTimeMillis();
            logger.info("Converted MOJO to PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert MOJO to PMML", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            begin = System.currentTimeMillis();
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            end = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }
}

