/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;
import sklearn.Step;
import sklearn.StepUtil;
import sklearn.Transformer;

public abstract class Composite
extends Step {
    public Composite(String module, String name) {
        super(module, name);
    }

    public abstract boolean hasTransformers();

    public abstract List<? extends Transformer> getTransformers();

    public abstract boolean hasFinalEstimator();

    public abstract Estimator getFinalEstimator();

    @Override
    public int getNumberOfFeatures() {
        if (this.hasTransformers()) {
            List<? extends Transformer> transformers = this.getTransformers();
            return StepUtil.getNumberOfFeatures(transformers);
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getNumberOfFeatures();
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        List<? extends Transformer> transformers;
        Iterator<? extends Transformer> iterator;
        if (this.hasTransformers() && (iterator = (transformers = this.getTransformers()).iterator()).hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getOpType();
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getOpType();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType() {
        List<? extends Transformer> transformers;
        Iterator<? extends Transformer> iterator;
        if (this.hasTransformers() && (iterator = (transformers = this.getTransformers()).iterator()).hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getDataType();
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getDataType();
        }
        throw new UnsupportedOperationException();
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        if (!this.hasTransformers()) {
            return features;
        }
        List<? extends Transformer> transformers = this.getTransformers();
        for (Transformer transformer : transformers) {
            features = transformer.encode(features, encoder);
        }
        return features;
    }

    public Model encodeModel(Schema schema) {
        SkLearnEncoder encoder = (SkLearnEncoder)schema.getEncoder();
        Label label = schema.getLabel();
        List<Feature> features = schema.getFeatures();
        if (this.hasTransformers()) {
            features = this.encodeFeatures(features, encoder);
            schema = new Schema((PMMLEncoder)encoder, label, features);
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.encode(schema);
        }
        throw new UnsupportedOperationException();
    }
}

