/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.LabelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.lightgbm.ObjectiveFunction;

public abstract class Classification
extends ObjectiveFunction {
    private int num_class_;

    public Classification(String name, boolean average_output, int num_class) {
        super(name, average_output);
        this.num_class_ = num_class;
    }

    @Override
    public Label encodeLabel(FieldName targetField, List<?> targetCategories, PMMLEncoder encoder) {
        DataField dataField;
        if (targetCategories == null) {
            targetCategories = LabelUtil.createTargetCategories((int)this.num_class_);
            dataField = encoder.createDataField(targetField, OpType.CATEGORICAL, DataType.INTEGER, targetCategories);
        } else {
            if (targetCategories.size() != this.num_class_) {
                throw new IllegalArgumentException("Expected " + this.num_class_ + " target categories, got " + targetCategories.size() + " target categories");
            }
            dataField = encoder.createDataField(targetField, OpType.CATEGORICAL, DataType.STRING, targetCategories);
        }
        return new CategoricalLabel((Field)dataField);
    }

    public int getNumClass() {
        return this.num_class_;
    }
}

