/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.transformations;

import java.util.Objects;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.transformations.AbstractTransformation;

public class FunctionTransformation
extends AbstractTransformation {
    private String function = null;

    public FunctionTransformation(String function) {
        this.setFunction(function);
    }

    @Override
    public FieldName getName(FieldName name) {
        String function = this.getFunction();
        return FieldNameUtil.create(function, name);
    }

    @Override
    public Expression createExpression(FieldRef fieldRef) {
        String function = this.getFunction();
        return PMMLUtil.createApply(function, new Expression[]{fieldRef});
    }

    public String getFunction() {
        return this.function;
    }

    private void setFunction(String function) {
        this.function = Objects.requireNonNull(function);
    }
}

