/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent.ast;

import net.razorvine.serpent.ast.INode;
import net.razorvine.serpent.ast.INodeVisitor;

public abstract class PrimitiveNode<T>
implements INode,
Comparable<T> {
    public T value;

    public PrimitiveNode(T value) {
        this.value = value;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PrimitiveNode && this.value.equals(((PrimitiveNode)obj).value);
    }

    @Override
    public int compareTo(T other) {
        return 0;
    }

    public boolean equals(PrimitiveNode<T> other) {
        return this.value.equals(other.value);
    }

    @Override
    public String toString() {
        if (this.value instanceof String) {
            StringBuilder sb = new StringBuilder();
            sb.append("'");
            String strValue = (String)this.value;
            block9: for (char c : strValue.toCharArray()) {
                switch (c) {
                    case '\\': {
                        sb.append("\\\\");
                        continue block9;
                    }
                    case '\'': {
                        sb.append("\\'");
                        continue block9;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block9;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            sb.append("'");
            return sb.toString();
        }
        if (this.value instanceof Boolean) {
            return this.value.equals(Boolean.TRUE) ? "True" : "False";
        }
        if (this.value instanceof Float || this.value instanceof Double) {
            String d = this.value.toString();
            if (d.indexOf(46) <= 0 && d.indexOf(101) <= 0 && d.indexOf(69) <= 0) {
                d = d + ".0";
            }
            return d;
        }
        return this.value.toString();
    }

    @Override
    public abstract void accept(INodeVisitor var1);
}

