# SyftBox Installer

A beautifully simple Python interface for installing and managing [SyftBox](https://syftbox.net).

## Installation

```bash
pip install syft-installer
```

## Quick Start

```python
import syft_installer as si

# Install and run SyftBox with one line
si.run()
```

That's it! This single command:
- ✅ Downloads SyftBox 
- ✅ Handles authentication (email + OTP)
- ✅ Creates necessary directories
- ✅ Starts the background daemon
- ✅ Shows you the status

## Simple API

```python
import syft_installer as si

si.run()              # Install (if needed) and start
si.status()           # Show current status
si.stop()             # Stop the daemon
si.restart()          # Restart the daemon
si.start_if_stopped() # Start only if not running
si.uninstall()        # Remove everything

# Quick checks
si.is_installed()  # -> True/False
si.is_running()    # -> True/False
```

## Examples

- [**Jupyter Notebook Quickstart**](examples/quickstart.ipynb) - Interactive tutorial
- [**CLI Quickstart**](examples/cli_quickstart.py) - Command-line example

## Advanced Usage

For more control, you can use the underlying installer classes:

```python
import syft_installer as si

# Simple installer
installer = si.SimpleInstaller(email="user@example.com")
installer.step1_download_and_request_otp()
installer.step2_verify_otp("ABCD1234")

# Or use the full installer
installer = si.Installer()
installer.install()
```

## Documentation

See the [`docs/`](docs/) directory for:
- [Simple API Guide](docs/README_SIMPLE.md)
- [Daemon Manager](docs/DAEMON_MANAGER.md)
- [Installation Details](docs/INSTALL_SH_COMPARISON_REPORT.md)

## License

MIT License - see [LICENSE](LICENSE) file.