from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkCommonTransforms
import vtkmodules.vtkFiltersGeometry

VTK_BSPLINE_EDGE:int
VTK_BSPLINE_ZERO:int
VTK_BSPLINE_ZERO_AT_BORDER:int
VTK_CELL_MODE:int
VTK_COLOR_MODE_LINEAR_256:int
VTK_COLOR_MODE_LUT:int
VTK_ERROR_ABSOLUTE:int
VTK_ERROR_NUMBER_OF_TRIANGLES:int
VTK_ERROR_RELATIVE:int
VTK_ERROR_SPECIFIED_REDUCTION:int
VTK_GRID_CUBIC:int
VTK_GRID_LINEAR:int
VTK_GRID_NEAREST:int
VTK_STYLE_PIXELIZE:int
VTK_STYLE_POLYGONALIZE:int
VTK_STYLE_RUN_LENGTH:int
VTK_VOXEL_MODE:int

class vtkAdaptiveDataSetSurfaceFilter(vtkmodules.vtkFiltersGeometry.vtkGeometryFilter):
    bb_selection:'getset_descriptor'
    circle_selection:'getset_descriptor'
    dynamic_decimate_level_max:'getset_descriptor'
    fixed_level_max:'getset_descriptor'
    m_time:'getset_descriptor'
    renderer:'getset_descriptor'
    scale:'getset_descriptor'
    view_point_depend:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBBSelection(self) -> bool: ...
    def GetCircleSelection(self) -> bool: ...
    def GetDynamicDecimateLevelMax(self) -> int: ...
    def GetFixedLevelMax(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetScale(self) -> int: ...
    def GetViewPointDepend(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAdaptiveDataSetSurfaceFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAdaptiveDataSetSurfaceFilter': ...
    def SetBBSelection(self, _arg:bool) -> None: ...
    def SetCircleSelection(self, _arg:bool) -> None: ...
    def SetDynamicDecimateLevelMax(self, _arg:int) -> None: ...
    def SetFixedLevelMax(self, _arg:int) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetScale(self, _arg:float) -> None: ...
    def SetViewPointDepend(self, _arg:bool) -> None: ...

class vtkBSplineTransform(vtkmodules.vtkCommonTransforms.vtkWarpTransform):
    border_mode:'getset_descriptor'
    coefficient_connection:'getset_descriptor'
    coefficient_data:'getset_descriptor'
    displacement_scale:'getset_descriptor'
    m_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBorderMode(self) -> int: ...
    def GetBorderModeAsString(self) -> str: ...
    def GetBorderModeMaxValue(self) -> int: ...
    def GetBorderModeMinValue(self) -> int: ...
    def GetCoefficientData(self) -> 'vtkImageData': ...
    def GetDisplacementScale(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeTransform(self) -> 'vtkAbstractTransform': ...
    def NewInstance(self) -> 'vtkBSplineTransform': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBSplineTransform': ...
    def SetBorderMode(self, _arg:int) -> None: ...
    def SetBorderModeToEdge(self) -> None: ...
    def SetBorderModeToZero(self) -> None: ...
    def SetBorderModeToZeroAtBorder(self) -> None: ...
    def SetCoefficientConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetCoefficientData(self, __a:'vtkImageData') -> None: ...
    def SetDisplacementScale(self, _arg:float) -> None: ...

class vtkDSPFilterDefinition(vtkmodules.vtkCommonCore.vtkObject):
    input_variable_name:'getset_descriptor'
    num_denominator_weights:'getset_descriptor'
    num_forward_numerator_weights:'getset_descriptor'
    num_numerator_weights:'getset_descriptor'
    output_variable_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clear(self) -> None: ...
    def Copy(self, other:'vtkDSPFilterDefinition') -> None: ...
    def GetDenominatorWeight(self, a_which:int) -> float: ...
    def GetForwardNumeratorWeight(self, a_which:int) -> float: ...
    def GetInputVariableName(self) -> str: ...
    def GetNumDenominatorWeights(self) -> int: ...
    def GetNumForwardNumeratorWeights(self) -> int: ...
    def GetNumNumeratorWeights(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumeratorWeight(self, a_which:int) -> float: ...
    def GetOutputVariableName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsThisInputVariableInstanceNeeded(self, a_timestep:int, a_outputTimestep:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDSPFilterDefinition': ...
    def PushBackDenominatorWeight(self, a_value:float) -> None: ...
    def PushBackForwardNumeratorWeight(self, a_value:float) -> None: ...
    def PushBackNumeratorWeight(self, a_value:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDSPFilterDefinition': ...
    def SetInputVariableName(self, a_value:str) -> None: ...
    def SetOutputVariableName(self, a_value:str) -> None: ...

class vtkDSPFilterGroup(vtkmodules.vtkCommonCore.vtkObject):
    num_filters:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddFilter(self, filter:'vtkDSPFilterDefinition') -> None: ...
    def AddInputVariableInstance(self, a_name:str, a_timestep:int, a_data:'vtkFloatArray') -> None: ...
    def Copy(self, other:'vtkDSPFilterGroup') -> None: ...
    def GetCachedInput(self, a_whichFilter:int, a_whichTimestep:int) -> 'vtkFloatArray': ...
    def GetCachedOutput(self, a_whichFilter:int, a_whichTimestep:int) -> 'vtkFloatArray': ...
    def GetFilter(self, a_whichFilter:int) -> 'vtkDSPFilterDefinition': ...
    def GetInputVariableName(self, a_whichFilter:int) -> str: ...
    def GetNumFilters(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self, a_whichFilter:int, a_whichTimestep:int, a_instancesCalculated:int) -> 'vtkFloatArray': ...
    def IsA(self, type:str) -> int: ...
    def IsThisInputVariableInstanceCached(self, a_name:str, a_timestep:int) -> bool: ...
    def IsThisInputVariableInstanceNeeded(self, a_name:str, a_timestep:int, a_outputTimestep:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDSPFilterGroup': ...
    def RemoveFilter(self, a_outputVariableName:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDSPFilterGroup': ...

class vtkDepthSortPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class Directions(int): ...
    class SortMode(int): ...
    VTK_DIRECTION_BACK_TO_FRONT:'Directions'
    VTK_DIRECTION_FRONT_TO_BACK:'Directions'
    VTK_DIRECTION_SPECIFIED_VECTOR:'Directions'
    VTK_SORT_BOUNDS_CENTER:'SortMode'
    VTK_SORT_FIRST_POINT:'SortMode'
    VTK_SORT_PARAMETRIC_CENTER:'SortMode'
    camera:'getset_descriptor'
    depth_sort_mode:'getset_descriptor'
    direction:'getset_descriptor'
    m_time:'getset_descriptor'
    origin:'getset_descriptor'
    prop3d:'getset_descriptor'
    sort_scalars:'getset_descriptor'
    vector:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetDepthSortMode(self) -> int: ...
    def GetDirection(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetProp3D(self) -> 'vtkProp3D': ...
    def GetSortScalars(self) -> int: ...
    def GetVector(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDepthSortPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDepthSortPolyData': ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def SetDepthSortMode(self, _arg:int) -> None: ...
    def SetDepthSortModeToBoundsCenter(self) -> None: ...
    def SetDepthSortModeToFirstPoint(self) -> None: ...
    def SetDepthSortModeToParametricCenter(self) -> None: ...
    def SetDirection(self, _arg:int) -> None: ...
    def SetDirectionToBackToFront(self) -> None: ...
    def SetDirectionToFrontToBack(self) -> None: ...
    def SetDirectionToSpecifiedVector(self) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetProp3D(self, __a:'vtkProp3D') -> None: ...
    def SetSortScalars(self, _arg:int) -> None: ...
    @overload
    def SetVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetVector(self, _arg:Sequence[float]) -> None: ...
    def SortScalarsOff(self) -> None: ...
    def SortScalarsOn(self) -> None: ...

class vtkEarthSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    on_ratio:'getset_descriptor'
    outline:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOnRatio(self) -> int: ...
    def GetOnRatioMaxValue(self) -> int: ...
    def GetOnRatioMinValue(self) -> int: ...
    def GetOutline(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEarthSource': ...
    def OutlineOff(self) -> None: ...
    def OutlineOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEarthSource': ...
    def SetOnRatio(self, _arg:int) -> None: ...
    def SetOutline(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkFacetReader(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    file_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CanReadFile(filename:str) -> int: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFacetReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFacetReader': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkForceTime(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    forced_time:'getset_descriptor'
    ignore_pipeline_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetForcedTime(self) -> float: ...
    def GetIgnorePipelineTime(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IgnorePipelineTimeOff(self) -> None: ...
    def IgnorePipelineTimeOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkForceTime': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkForceTime': ...
    def SetForcedTime(self, _arg:float) -> None: ...
    def SetIgnorePipelineTime(self, _arg:bool) -> None: ...

class vtkGenerateTimeSteps(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    number_of_time_steps:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddTimeStepValue(self, timeStepValue:float) -> None: ...
    def ClearTimeStepValues(self) -> None: ...
    def GenerateTimeStepValues(self, begin:float, end:float, step:float) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    def GetTimeStepValues(self, timeStepValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenerateTimeSteps': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenerateTimeSteps': ...
    def SetTimeStepValues(self, count:int, timeStepValues:Sequence[float]) -> None: ...

class vtkGreedyTerrainDecimation(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    absolute_error:'getset_descriptor'
    boundary_vertex_deletion:'getset_descriptor'
    compute_normals:'getset_descriptor'
    error_measure:'getset_descriptor'
    number_of_triangles:'getset_descriptor'
    number_of_triangles_max_value:'getset_descriptor'
    number_of_triangles_min_value:'getset_descriptor'
    reduction:'getset_descriptor'
    relative_error:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BoundaryVertexDeletionOff(self) -> None: ...
    def BoundaryVertexDeletionOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetAbsoluteError(self) -> float: ...
    def GetAbsoluteErrorMaxValue(self) -> float: ...
    def GetAbsoluteErrorMinValue(self) -> float: ...
    def GetBoundaryVertexDeletion(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetErrorMeasure(self) -> int: ...
    def GetErrorMeasureMaxValue(self) -> int: ...
    def GetErrorMeasureMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTriangles(self) -> int: ...
    def GetNumberOfTrianglesMaxValue(self) -> int: ...
    def GetNumberOfTrianglesMinValue(self) -> int: ...
    def GetReduction(self) -> float: ...
    def GetReductionMaxValue(self) -> float: ...
    def GetReductionMinValue(self) -> float: ...
    def GetRelativeError(self) -> float: ...
    def GetRelativeErrorMaxValue(self) -> float: ...
    def GetRelativeErrorMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGreedyTerrainDecimation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGreedyTerrainDecimation': ...
    def SetAbsoluteError(self, _arg:float) -> None: ...
    def SetBoundaryVertexDeletion(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetErrorMeasure(self, _arg:int) -> None: ...
    def SetErrorMeasureToAbsoluteError(self) -> None: ...
    def SetErrorMeasureToNumberOfTriangles(self) -> None: ...
    def SetErrorMeasureToRelativeError(self) -> None: ...
    def SetErrorMeasureToSpecifiedReduction(self) -> None: ...
    def SetNumberOfTriangles(self, _arg:int) -> None: ...
    def SetReduction(self, _arg:float) -> None: ...
    def SetRelativeError(self, _arg:float) -> None: ...

class vtkGridTransform(vtkmodules.vtkCommonTransforms.vtkWarpTransform):
    displacement_grid:'getset_descriptor'
    displacement_grid_connection:'getset_descriptor'
    displacement_grid_data:'getset_descriptor'
    displacement_scale:'getset_descriptor'
    displacement_shift:'getset_descriptor'
    interpolation_mode:'getset_descriptor'
    m_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDisplacementGrid(self) -> 'vtkImageData': ...
    def GetDisplacementScale(self) -> float: ...
    def GetDisplacementShift(self) -> float: ...
    def GetInterpolationMode(self) -> int: ...
    def GetInterpolationModeAsString(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeTransform(self) -> 'vtkAbstractTransform': ...
    def NewInstance(self) -> 'vtkGridTransform': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGridTransform': ...
    def SetDisplacementGridConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetDisplacementGridData(self, __a:'vtkImageData') -> None: ...
    def SetDisplacementScale(self, _arg:float) -> None: ...
    def SetDisplacementShift(self, _arg:float) -> None: ...
    def SetInterpolationMode(self, mode:int) -> None: ...
    def SetInterpolationModeToCubic(self) -> None: ...
    def SetInterpolationModeToLinear(self) -> None: ...
    def SetInterpolationModeToNearestNeighbor(self) -> None: ...

class vtkImageToPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    color_mode:'getset_descriptor'
    decimation:'getset_descriptor'
    decimation_error:'getset_descriptor'
    error:'getset_descriptor'
    lookup_table:'getset_descriptor'
    number_of_smoothing_iterations:'getset_descriptor'
    number_of_smoothing_iterations_max_value:'getset_descriptor'
    number_of_smoothing_iterations_min_value:'getset_descriptor'
    output_style:'getset_descriptor'
    smoothing:'getset_descriptor'
    sub_image_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DecimationOff(self) -> None: ...
    def DecimationOn(self) -> None: ...
    def GetColorMode(self) -> int: ...
    def GetColorModeMaxValue(self) -> int: ...
    def GetColorModeMinValue(self) -> int: ...
    def GetDecimation(self) -> int: ...
    def GetDecimationError(self) -> float: ...
    def GetDecimationErrorMaxValue(self) -> float: ...
    def GetDecimationErrorMinValue(self) -> float: ...
    def GetError(self) -> int: ...
    def GetErrorMaxValue(self) -> int: ...
    def GetErrorMinValue(self) -> int: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSmoothingIterations(self) -> int: ...
    def GetNumberOfSmoothingIterationsMaxValue(self) -> int: ...
    def GetNumberOfSmoothingIterationsMinValue(self) -> int: ...
    def GetOutputStyle(self) -> int: ...
    def GetOutputStyleMaxValue(self) -> int: ...
    def GetOutputStyleMinValue(self) -> int: ...
    def GetSmoothing(self) -> int: ...
    def GetSubImageSize(self) -> int: ...
    def GetSubImageSizeMaxValue(self) -> int: ...
    def GetSubImageSizeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageToPolyDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageToPolyDataFilter': ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToLUT(self) -> None: ...
    def SetColorModeToLinear256(self) -> None: ...
    def SetDecimation(self, _arg:int) -> None: ...
    def SetDecimationError(self, _arg:float) -> None: ...
    def SetError(self, _arg:int) -> None: ...
    def SetLookupTable(self, __a:'vtkScalarsToColors') -> None: ...
    def SetNumberOfSmoothingIterations(self, _arg:int) -> None: ...
    def SetOutputStyle(self, _arg:int) -> None: ...
    def SetOutputStyleToPixelize(self) -> None: ...
    def SetOutputStyleToPolygonalize(self) -> None: ...
    def SetOutputStyleToRunLength(self) -> None: ...
    def SetSmoothing(self, _arg:int) -> None: ...
    def SetSubImageSize(self, _arg:int) -> None: ...
    def SmoothingOff(self) -> None: ...
    def SmoothingOn(self) -> None: ...

class vtkImplicitModeller(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    adjust_bounds:'getset_descriptor'
    adjust_distance:'getset_descriptor'
    cap_value:'getset_descriptor'
    capping:'getset_descriptor'
    locator_max_level:'getset_descriptor'
    maximum_distance:'getset_descriptor'
    model_bounds:'getset_descriptor'
    number_of_threads:'getset_descriptor'
    number_of_threads_max_value:'getset_descriptor'
    number_of_threads_min_value:'getset_descriptor'
    output_scalar_type:'getset_descriptor'
    process_mode:'getset_descriptor'
    sample_dimensions:'getset_descriptor'
    scale_to_maximum_distance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AdjustBoundsOff(self) -> None: ...
    def AdjustBoundsOn(self) -> None: ...
    def Append(self, input:'vtkDataSet') -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def ComputeModelBounds(self, input:'vtkDataSet'=...) -> float: ...
    def EndAppend(self) -> None: ...
    def GetAdjustBounds(self) -> int: ...
    def GetAdjustDistance(self) -> float: ...
    def GetAdjustDistanceMaxValue(self) -> float: ...
    def GetAdjustDistanceMinValue(self) -> float: ...
    def GetCapValue(self) -> float: ...
    def GetCapping(self) -> int: ...
    def GetLocatorMaxLevel(self) -> int: ...
    def GetMaximumDistance(self) -> float: ...
    def GetMaximumDistanceMaxValue(self) -> float: ...
    def GetMaximumDistanceMinValue(self) -> float: ...
    def GetModelBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreads(self) -> int: ...
    def GetNumberOfThreadsMaxValue(self) -> int: ...
    def GetNumberOfThreadsMinValue(self) -> int: ...
    def GetOutputScalarType(self) -> int: ...
    def GetProcessMode(self) -> int: ...
    def GetProcessModeAsString(self) -> str: ...
    def GetProcessModeMaxValue(self) -> int: ...
    def GetProcessModeMinValue(self) -> int: ...
    def GetSampleDimensions(self) -> Tuple[int, int, int]: ...
    def GetScaleToMaximumDistance(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitModeller': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitModeller': ...
    def ScaleToMaximumDistanceOff(self) -> None: ...
    def ScaleToMaximumDistanceOn(self) -> None: ...
    def SetAdjustBounds(self, _arg:int) -> None: ...
    def SetAdjustDistance(self, _arg:float) -> None: ...
    def SetCapValue(self, value:float) -> None: ...
    def SetCapping(self, _arg:int) -> None: ...
    def SetLocatorMaxLevel(self, _arg:int) -> None: ...
    def SetMaximumDistance(self, _arg:float) -> None: ...
    @overload
    def SetModelBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetModelBounds(self, _arg:Sequence[float]) -> None: ...
    def SetNumberOfThreads(self, _arg:int) -> None: ...
    def SetOutputScalarType(self, type:int) -> None: ...
    def SetOutputScalarTypeToChar(self) -> None: ...
    def SetOutputScalarTypeToDouble(self) -> None: ...
    def SetOutputScalarTypeToFloat(self) -> None: ...
    def SetOutputScalarTypeToInt(self) -> None: ...
    def SetOutputScalarTypeToLong(self) -> None: ...
    def SetOutputScalarTypeToShort(self) -> None: ...
    def SetOutputScalarTypeToUnsignedChar(self) -> None: ...
    def SetOutputScalarTypeToUnsignedInt(self) -> None: ...
    def SetOutputScalarTypeToUnsignedLong(self) -> None: ...
    def SetOutputScalarTypeToUnsignedShort(self) -> None: ...
    def SetProcessMode(self, _arg:int) -> None: ...
    def SetProcessModeToPerCell(self) -> None: ...
    def SetProcessModeToPerVoxel(self) -> None: ...
    @overload
    def SetSampleDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetSampleDimensions(self, dim:MutableSequence[int]) -> None: ...
    def SetScaleToMaximumDistance(self, _arg:int) -> None: ...
    def StartAppend(self) -> None: ...

class vtkPCAAnalysisFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    evals:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetEvals(self) -> 'vtkFloatArray': ...
    def GetModesRequiredFor(self, proportion:float) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParameterisedShape(self, b:'vtkFloatArray', shape:'vtkPointSet') -> None: ...
    def GetShapeParameters(self, shape:'vtkPointSet', b:'vtkFloatArray', bsize:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPCAAnalysisFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPCAAnalysisFilter': ...

class vtkPolyDataSilhouette(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class Directions(int): ...
    VTK_DIRECTION_CAMERA_ORIGIN:'Directions'
    VTK_DIRECTION_CAMERA_VECTOR:'Directions'
    VTK_DIRECTION_SPECIFIED_ORIGIN:'Directions'
    VTK_DIRECTION_SPECIFIED_VECTOR:'Directions'
    border_edges:'getset_descriptor'
    camera:'getset_descriptor'
    direction:'getset_descriptor'
    enable_feature_angle:'getset_descriptor'
    feature_angle:'getset_descriptor'
    m_time:'getset_descriptor'
    origin:'getset_descriptor'
    piece_invariant:'getset_descriptor'
    prop3d:'getset_descriptor'
    vector:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BorderEdgesOff(self) -> None: ...
    def BorderEdgesOn(self) -> None: ...
    def GetBorderEdges(self) -> int: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetDirection(self) -> int: ...
    def GetEnableFeatureAngle(self) -> int: ...
    def GetFeatureAngle(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetPieceInvariant(self) -> int: ...
    def GetProp3D(self) -> 'vtkProp3D': ...
    def GetVector(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataSilhouette': ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataSilhouette': ...
    def SetBorderEdges(self, _arg:int) -> None: ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def SetDirection(self, _arg:int) -> None: ...
    def SetDirectionToCameraOrigin(self) -> None: ...
    def SetDirectionToCameraVector(self) -> None: ...
    def SetDirectionToSpecifiedOrigin(self) -> None: ...
    def SetDirectionToSpecifiedVector(self) -> None: ...
    def SetEnableFeatureAngle(self, _arg:int) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...
    def SetProp3D(self, __a:'vtkProp3D') -> None: ...
    @overload
    def SetVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetVector(self, _arg:Sequence[float]) -> None: ...

class vtkProcrustesAlignmentFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    landmark_transform:'getset_descriptor'
    mean_points:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    start_from_centroid:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLandmarkTransform(self) -> 'vtkLandmarkTransform': ...
    def GetMeanPoints(self) -> 'vtkPoints': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetStartFromCentroid(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProcrustesAlignmentFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProcrustesAlignmentFilter': ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetStartFromCentroid(self, _arg:bool) -> None: ...
    def StartFromCentroidOff(self) -> None: ...
    def StartFromCentroidOn(self) -> None: ...

class vtkProjectedTerrainPath(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    HUG_PROJECTION:int
    NONOCCLUDED_PROJECTION:int
    SIMPLE_PROJECTION:int
    height_offset:'getset_descriptor'
    height_tolerance:'getset_descriptor'
    maximum_number_of_lines:'getset_descriptor'
    projection_mode:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetHeightOffset(self) -> float: ...
    def GetHeightTolerance(self) -> float: ...
    def GetHeightToleranceMaxValue(self) -> float: ...
    def GetHeightToleranceMinValue(self) -> float: ...
    def GetMaximumNumberOfLines(self) -> int: ...
    def GetMaximumNumberOfLinesMaxValue(self) -> int: ...
    def GetMaximumNumberOfLinesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProjectionMode(self) -> int: ...
    def GetProjectionModeMaxValue(self) -> int: ...
    def GetProjectionModeMinValue(self) -> int: ...
    def GetSource(self) -> 'vtkImageData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProjectedTerrainPath': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProjectedTerrainPath': ...
    def SetHeightOffset(self, _arg:float) -> None: ...
    def SetHeightTolerance(self, _arg:float) -> None: ...
    def SetMaximumNumberOfLines(self, _arg:int) -> None: ...
    def SetProjectionMode(self, _arg:int) -> None: ...
    def SetProjectionModeToHug(self) -> None: ...
    def SetProjectionModeToNonOccluded(self) -> None: ...
    def SetProjectionModeToSimple(self) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkImageData') -> None: ...

class vtkRenderLargeImage(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    input:'getset_descriptor'
    magnification:'getset_descriptor'
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetInput(self) -> 'vtkRenderer': ...
    def GetMagnification(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkImageData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderLargeImage': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderLargeImage': ...
    def SetInput(self, __a:'vtkRenderer') -> None: ...
    def SetMagnification(self, _arg:int) -> None: ...

class vtkTemporalArrayOperatorFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiTimeStepAlgorithm):
    class OperatorType(int): ...
    ADD:'OperatorType'
    DIV:'OperatorType'
    MUL:'OperatorType'
    SUB:'OperatorType'
    first_time_step_index:'getset_descriptor'
    operator:'getset_descriptor'
    output_array_name_suffix:'getset_descriptor'
    relative_mode:'getset_descriptor'
    second_time_step_index:'getset_descriptor'
    time_step_shift:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFirstTimeStepIndex(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOperator(self) -> int: ...
    def GetOutputArrayNameSuffix(self) -> str: ...
    def GetRelativeMode(self) -> bool: ...
    def GetSecondTimeStepIndex(self) -> int: ...
    def GetTimeStepShift(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalArrayOperatorFilter': ...
    def RelativeModeOff(self) -> None: ...
    def RelativeModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalArrayOperatorFilter': ...
    def SetFirstTimeStepIndex(self, _arg:int) -> None: ...
    def SetOperator(self, _arg:int) -> None: ...
    def SetOutputArrayNameSuffix(self, _arg:str) -> None: ...
    def SetRelativeMode(self, _arg:bool) -> None: ...
    def SetSecondTimeStepIndex(self, _arg:int) -> None: ...
    def SetTimeStepShift(self, _arg:int) -> None: ...

class vtkTemporalDataSetCache(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    cache_in_memkind:'getset_descriptor'
    cache_size:'getset_descriptor'
    is_a_source:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CacheInMemkindOff(self) -> None: ...
    def CacheInMemkindOn(self) -> None: ...
    def GetCacheInMemkind(self) -> bool: ...
    def GetCacheSize(self) -> int: ...
    def GetIsASource(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsASourceOff(self) -> None: ...
    def IsASourceOn(self) -> None: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalDataSetCache': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalDataSetCache': ...
    def SetCacheInMemkind(self, _arg:bool) -> None: ...
    def SetCacheSize(self, size:int) -> None: ...
    def SetIsASource(self, _arg:bool) -> None: ...

class vtkTemporalFractal(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    adaptive_subdivision:'getset_descriptor'
    asymmetric:'getset_descriptor'
    dimensions:'getset_descriptor'
    discrete_time_steps:'getset_descriptor'
    fractal_value:'getset_descriptor'
    generate_rectilinear_grids:'getset_descriptor'
    ghost_levels:'getset_descriptor'
    maximum_level:'getset_descriptor'
    two_dimensional:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AdaptiveSubdivisionOff(self) -> None: ...
    def AdaptiveSubdivisionOn(self) -> None: ...
    def DiscreteTimeStepsOff(self) -> None: ...
    def DiscreteTimeStepsOn(self) -> None: ...
    def GenerateRectilinearGridsOff(self) -> None: ...
    def GenerateRectilinearGridsOn(self) -> None: ...
    def GetAdaptiveSubdivision(self) -> int: ...
    def GetAsymmetric(self) -> int: ...
    def GetDimensions(self) -> int: ...
    def GetDiscreteTimeSteps(self) -> int: ...
    def GetFractalValue(self) -> float: ...
    def GetGenerateRectilinearGrids(self) -> int: ...
    def GetGhostLevels(self) -> int: ...
    def GetMaximumLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTwoDimensional(self) -> int: ...
    def GhostLevelsOff(self) -> None: ...
    def GhostLevelsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalFractal': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalFractal': ...
    def SetAdaptiveSubdivision(self, _arg:int) -> None: ...
    def SetAsymmetric(self, _arg:int) -> None: ...
    def SetDimensions(self, _arg:int) -> None: ...
    def SetDiscreteTimeSteps(self, _arg:int) -> None: ...
    def SetFractalValue(self, _arg:float) -> None: ...
    def SetGenerateRectilinearGrids(self, _arg:int) -> None: ...
    def SetGhostLevels(self, _arg:int) -> None: ...
    def SetMaximumLevel(self, _arg:int) -> None: ...
    def SetTwoDimensional(self, _arg:int) -> None: ...
    def TwoDimensionalOff(self) -> None: ...
    def TwoDimensionalOn(self) -> None: ...

class vtkTemporalInterpolator(vtkmodules.vtkCommonExecutionModel.vtkMultiTimeStepAlgorithm):
    cache_data:'getset_descriptor'
    discrete_time_step_interval:'getset_descriptor'
    resample_factor:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCacheData(self) -> bool: ...
    def GetDiscreteTimeStepInterval(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResampleFactor(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalInterpolator': ...
    def SetCacheData(self, _arg:bool) -> None: ...
    def SetDiscreteTimeStepInterval(self, _arg:float) -> None: ...
    def SetResampleFactor(self, _arg:int) -> None: ...

class vtkTemporalShiftScale(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    maximum_number_of_periods:'getset_descriptor'
    periodic:'getset_descriptor'
    periodic_end_correction:'getset_descriptor'
    post_shift:'getset_descriptor'
    pre_shift:'getset_descriptor'
    scale:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMaximumNumberOfPeriods(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPeriodic(self) -> int: ...
    def GetPeriodicEndCorrection(self) -> int: ...
    def GetPostShift(self) -> float: ...
    def GetPreShift(self) -> float: ...
    def GetScale(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalShiftScale': ...
    def PeriodicEndCorrectionOff(self) -> None: ...
    def PeriodicEndCorrectionOn(self) -> None: ...
    def PeriodicOff(self) -> None: ...
    def PeriodicOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalShiftScale': ...
    def SetMaximumNumberOfPeriods(self, _arg:float) -> None: ...
    def SetPeriodic(self, _arg:int) -> None: ...
    def SetPeriodicEndCorrection(self, _arg:int) -> None: ...
    def SetPostShift(self, _arg:float) -> None: ...
    def SetPreShift(self, _arg:float) -> None: ...
    def SetScale(self, _arg:float) -> None: ...

class vtkTemporalSnapToTimeStep(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    VTK_SNAP_NEAREST:int
    VTK_SNAP_NEXTABOVE_OR_EQUAL:int
    VTK_SNAP_NEXTBELOW_OR_EQUAL:int
    snap_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSnapMode(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalSnapToTimeStep': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalSnapToTimeStep': ...
    def SetSnapMode(self, _arg:int) -> None: ...
    def SetSnapModeToNearest(self) -> None: ...
    def SetSnapModeToNextAboveOrEqual(self) -> None: ...
    def SetSnapModeToNextBelowOrEqual(self) -> None: ...

class vtkTransformToGrid(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    displacement_scale:'getset_descriptor'
    displacement_shift:'getset_descriptor'
    grid_extent:'getset_descriptor'
    grid_origin:'getset_descriptor'
    grid_scalar_type:'getset_descriptor'
    grid_spacing:'getset_descriptor'
    input:'getset_descriptor'
    output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDisplacementScale(self) -> float: ...
    def GetDisplacementShift(self) -> float: ...
    def GetGridExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetGridOrigin(self) -> Tuple[float, float, float]: ...
    def GetGridScalarType(self) -> int: ...
    def GetGridSpacing(self) -> Tuple[float, float, float]: ...
    def GetInput(self) -> 'vtkAbstractTransform': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkImageData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransformToGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransformToGrid': ...
    @overload
    def SetGridExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetGridExtent(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetGridOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetGridOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetGridScalarType(self, _arg:int) -> None: ...
    def SetGridScalarTypeToChar(self) -> None: ...
    def SetGridScalarTypeToDouble(self) -> None: ...
    def SetGridScalarTypeToFloat(self) -> None: ...
    def SetGridScalarTypeToShort(self) -> None: ...
    def SetGridScalarTypeToUnsignedChar(self) -> None: ...
    def SetGridScalarTypeToUnsignedShort(self) -> None: ...
    @overload
    def SetGridSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetGridSpacing(self, _arg:Sequence[float]) -> None: ...
    def SetInput(self, __a:'vtkAbstractTransform') -> None: ...

class vtkWeightedTransformFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    add_input_values:'getset_descriptor'
    cell_data_transform_index_array:'getset_descriptor'
    cell_data_weight_array:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_transforms:'getset_descriptor'
    transform_index_array:'getset_descriptor'
    weight_array:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddInputValuesOff(self) -> None: ...
    def AddInputValuesOn(self) -> None: ...
    def GetAddInputValues(self) -> int: ...
    def GetCellDataTransformIndexArray(self) -> str: ...
    def GetCellDataWeightArray(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTransforms(self) -> int: ...
    def GetTransform(self, num:int) -> 'vtkAbstractTransform': ...
    def GetTransformIndexArray(self) -> str: ...
    def GetWeightArray(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWeightedTransformFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWeightedTransformFilter': ...
    def SetAddInputValues(self, _arg:int) -> None: ...
    def SetCellDataTransformIndexArray(self, _arg:str) -> None: ...
    def SetCellDataWeightArray(self, _arg:str) -> None: ...
    def SetNumberOfTransforms(self, num:int) -> None: ...
    def SetTransform(self, transform:'vtkAbstractTransform', num:int) -> None: ...
    def SetTransformIndexArray(self, _arg:str) -> None: ...
    def SetWeightArray(self, _arg:str) -> None: ...

